/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.jCharts.Chart;
import org.jCharts.chartData.interfaces.IAxisPlotDataSet;
import org.jCharts.chartData.interfaces.IData;
import org.jCharts.chartData.interfaces.IDataSeries;
import org.jCharts.chartData.interfaces.IDataSet;
import org.jCharts.chartData.interfaces.IPieChartDataSet;
import org.jCharts.chartData.processors.TextProcessor;
import org.jCharts.properties.LegendProperties;
import org.jCharts.test.HTMLGenerator;
import org.jCharts.test.HTMLTestable;

public final class Legend
implements HTMLTestable,
Serializable {
    private Chart chart;
    private LegendProperties legendProperties;
    private float iconSide;
    private float widestLabelAndColumnPadding;
    private int numColumns;
    private int numRows;
    private TextProcessor textProcessor;
    private float widthNeeded = 0.0f;
    private float heightNeeded = 0.0f;
    private ArrayList labels;
    private ArrayList paints;

    public Legend(Chart chart) {
        this.chart = chart;
    }

    public Legend(Chart chart, LegendProperties legendProperties) {
        this.chart = chart;
        this.legendProperties = legendProperties;
    }

    private void processData(IDataSeries iDataSeries) {
        this.textProcessor = new TextProcessor(iDataSeries.getTotalNumberOfDataSets());
        Iterator iterator = iDataSeries.getIAxisChartDataSetIterator();
        while (iterator.hasNext()) {
            this.processLegendLabels((IAxisPlotDataSet)iterator.next());
        }
    }

    private void processData(IPieChartDataSet iPieChartDataSet) {
        this.textProcessor = new TextProcessor(iPieChartDataSet.getNumberOfLegendLabels());
        this.processLegendLabels(iPieChartDataSet);
    }

    private void processLegendLabels(IDataSet iDataSet) {
        int n = 0;
        while (n < iDataSet.getNumberOfLegendLabels()) {
            if (iDataSet.getLegendLabel(n) != null) {
                this.textProcessor.processLabel(iDataSet.getLegendLabel(n), this.legendProperties.getFont(), this.chart.getGraphics2D().getFontRenderContext());
                this.labels.add(iDataSet.getLegendLabel(n));
                this.paints.add(iDataSet.getPaint(n));
            }
            ++n;
        }
    }

    public LegendProperties getLegendProperties() {
        return this.legendProperties;
    }

    public void calculateDrawingValues(IData iData) {
        int n;
        this.labels = new ArrayList();
        this.paints = new ArrayList();
        if (iData instanceof IDataSeries) {
            IDataSeries iDataSeries = (IDataSeries)iData;
            this.processData(iDataSeries);
            n = iDataSeries.getTotalNumberOfDataSets();
        } else {
            IPieChartDataSet iPieChartDataSet = (IPieChartDataSet)iData;
            this.processData(iPieChartDataSet);
            n = iPieChartDataSet.getNumberOfLegendLabels();
        }
        this.iconSide = 0.5f * this.textProcessor.getTallestLabel();
        this.determineWidthAndHeight(n);
    }

    public float getWidthNeeded() {
        return this.widthNeeded;
    }

    public int getHeightNeeded() {
        return (int)Math.ceil(this.heightNeeded);
    }

    private void determineWidthAndHeight(int n) {
        this.heightNeeded = this.widthNeeded = this.legendProperties.getEdgePadding() * 2.0f;
        if (this.legendProperties.getNumColumns() == 0 || this.legendProperties.getNumColumns() >= n) {
            this.numColumns = n;
            this.widthNeeded += this.textProcessor.getTotalLabelWidths();
            this.numRows = 1;
        } else {
            this.widestLabelAndColumnPadding = this.textProcessor.getWidestLabel() + (float)this.legendProperties.getColumnPadding();
            this.numColumns = this.legendProperties.getNumColumns();
            this.widthNeeded += this.textProcessor.getWidestLabel() * (float)this.numColumns;
            this.numRows = (int)Math.ceil((double)n / (double)this.numColumns);
        }
        this.widthNeeded += (this.iconSide + (float)this.legendProperties.getIconPadding()) * (float)this.numColumns;
        this.widthNeeded += (float)(this.legendProperties.getColumnPadding() * (this.numColumns - 1));
        this.heightNeeded += this.textProcessor.getTallestLabel() * (float)this.numRows;
        this.heightNeeded += (float)(this.legendProperties.getRowPadding() * (this.numRows - 1));
    }

    public void render(float f, float f2) {
        Graphics2D graphics2D = this.chart.getGraphics2D();
        Rectangle2D.Float float_ = new Rectangle2D.Float(f, f2, this.widthNeeded - 1.0f, this.heightNeeded - 1.0f);
        if (this.legendProperties.getBackgroundPaint() != null) {
            graphics2D.setPaint(this.legendProperties.getBackgroundPaint());
            graphics2D.fill(float_);
        }
        if (this.legendProperties.getBorderStroke() != null) {
            graphics2D.setStroke(this.legendProperties.getBorderStroke());
            graphics2D.setPaint(this.legendProperties.getBorderPaint());
            graphics2D.draw(float_);
        }
        graphics2D.setFont(this.legendProperties.getFont());
        float_.y += this.legendProperties.getEdgePadding() + this.textProcessor.getTallestLabel() / 2.0f - this.iconSide / 2.0f;
        float_.width = this.iconSide;
        float_.height = this.iconSide;
        float f3 = f + this.legendProperties.getEdgePadding();
        float f4 = float_.y + float_.height;
        float f5 = this.textProcessor.getTallestLabel() + (float)this.legendProperties.getRowPadding();
        float f6 = this.iconSide + (float)this.legendProperties.getIconPadding();
        int n = 0;
        int n2 = 0;
        while (n2 < this.numRows) {
            int n3 = 0;
            while (n3 < this.numColumns) {
                float_.x = f3;
                graphics2D.setPaint((Paint)this.paints.get(n));
                graphics2D.fill(float_);
                if (this.legendProperties.getIconBorderStroke() != null) {
                    graphics2D.setStroke(this.legendProperties.getIconBorderStroke());
                    graphics2D.setPaint(this.legendProperties.getIconBorderPaint());
                    graphics2D.draw(float_);
                }
                graphics2D.setPaint(this.legendProperties.getFontPaint());
                graphics2D.drawString((String)this.labels.get(n), f3 += f6, f4);
                f3 = this.legendProperties.getNumColumns() == 0 || this.legendProperties.getNumColumns() >= this.labels.size() ? (f3 += this.textProcessor.getLabelWidth(n) + (float)this.legendProperties.getColumnPadding()) : (f3 += this.widestLabelAndColumnPadding);
                if (++n == this.labels.size()) break;
                ++n3;
            }
            f3 = f + this.legendProperties.getEdgePadding();
            f4 += f5;
            float_.y += f5;
            ++n2;
        }
    }

    public void toHTML(HTMLGenerator hTMLGenerator) {
        hTMLGenerator.legendTableStart();
        hTMLGenerator.addTableRow("Width", Float.toString(this.widthNeeded));
        hTMLGenerator.addTableRow("Height", Float.toString(this.heightNeeded));
        hTMLGenerator.addTableRow("Icon Side", Float.toString(this.iconSide));
        hTMLGenerator.legendTableRowStart();
        this.legendProperties.toHTML(hTMLGenerator);
        hTMLGenerator.legendTableRowEnd();
        hTMLGenerator.legendTableEnd();
    }
}

