/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.axisChart;

import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Line2D;
import java.lang.reflect.Field;
import java.text.NumberFormat;
import org.jCharts.axisChart.Axis;
import org.jCharts.axisChart.AxisChart;
import org.jCharts.chartData.processors.AxisChartDataProcessor;
import org.jCharts.properties.AxisProperties;
import org.jCharts.test.HTMLGenerator;
import org.jCharts.test.HTMLTestable;

final class YAxis
extends Axis
implements HTMLTestable {
    private double minValue;
    private double maxValue;
    private double increment;
    private String[] formattedLabels;
    private float[] labelWidths;
    private double oneUnitPixelSize;
    private float zeroLineCoordinate;

    public YAxis(AxisChart axisChart) {
        super(axisChart);
    }

    void computeScaleIncrement(AxisChartDataProcessor axisChartDataProcessor) {
        AxisProperties axisProperties = super.getAxisChart().getAxisProperties();
        int n = axisProperties.getYAxisNumItems();
        double d = Math.pow(10.0, Math.abs((double)super.getAxisChart().getAxisProperties().getYAxisRoundValuesToNearest()));
        if (axisProperties.hasUserDefinedScale()) {
            this.increment = this.round(axisProperties.getUserDefinedYAxisIncrement(), d);
            if (this.increment == 0.0) {
                this.increment = d;
            }
            this.minValue = this.round(axisProperties.getUserDefinedYAxisMinimum(), d);
            this.maxValue = this.minValue + this.increment * (double)n;
        } else if (axisChartDataProcessor.getMinValue() >= 0.0 || axisChartDataProcessor.getMaxValue() < 0.0) {
            double d2 = Math.max(axisChartDataProcessor.getMaxValue(), -axisChartDataProcessor.getMinValue());
            this.increment = d2 / (double)n;
            this.roundTheIncrement(d);
            if (axisChartDataProcessor.getMinValue() >= 0.0) {
                this.minValue = 0.0;
                this.maxValue = this.increment * (double)n;
            } else {
                this.maxValue = 0.0;
                this.minValue = -(this.increment * (double)n);
            }
        } else {
            this.minValue = this.round(axisChartDataProcessor.getMinValue(), d);
            this.minValue = super.getAxisChart().getAxisProperties().getYAxisRoundValuesToNearest() > 0 ? (this.minValue -= d) : (this.minValue -= 1.0 / d);
            double d3 = axisChartDataProcessor.getMaxValue() - this.minValue;
            this.increment = d3 / (double)n;
            this.roundTheIncrement(d);
            this.maxValue = this.minValue + this.increment * (double)n;
        }
    }

    private double round(double d, double d2) {
        if (super.getAxisChart().getAxisProperties().getYAxisRoundValuesToNearest() > 0) {
            return (double)Math.round(d / d2) * d2;
        }
        if (super.getAxisChart().getAxisProperties().getYAxisRoundValuesToNearest() < 0) {
            return (double)Math.round(d * d2) / d2;
        }
        return Math.round(d);
    }

    private void roundTheIncrement(double d) {
        this.increment = this.round(this.increment, d);
        this.increment = super.getAxisChart().getAxisProperties().getYAxisRoundValuesToNearest() > 0 ? (this.increment += d) : (this.increment += 1.0 / d);
    }

    void computeMinimumWidthNeeded(String string) {
        float f = super.getWidestLabel();
        if (super.getAxisChart().getAxisProperties().getShowTicks(1) != 0) {
            f += super.getAxisChart().getAxisProperties().getPaddingBetweenLabelsAndTicks(1);
            f += super.getAxisChart().getAxisProperties().getAxisTickMarkPixelLength(1);
        } else {
            f += super.getAxisChart().getAxisProperties().getPaddingBetweenAxisAndLabels(1);
        }
        if (string != null) {
            super.computeAxisTitleDimensions(string);
            f += super.getTitleHeight();
            f += super.getAxisChart().getAxisProperties().getPaddingBetweenAxisTitleAndLabels(1);
        }
        super.setMinimumWidthNeeded(f);
    }

    void computeScalePixelWidth() {
        super.setScalePixelWidth(super.getPixelLength() / (float)super.getAxisChart().getAxisProperties().getYAxisNumItems());
        this.oneUnitPixelSize = (double)super.getScalePixelWidth() / this.increment;
    }

    float computeAxisCoordinate(double d) {
        double d2 = (double)super.getOrigin() - (d - this.getMinValue()) * this.getOneUnitPixelSize();
        return (float)d2;
    }

    public float getZeroLineCoordinate() {
        return this.zeroLineCoordinate;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getOneUnitPixelSize() {
        return this.oneUnitPixelSize;
    }

    void formatLabelsForDisplay() {
        TextLayout textLayout = null;
        AxisProperties axisProperties = super.getAxisChart().getAxisProperties();
        FontRenderContext fontRenderContext = super.getAxisChart().getGraphics2D().getFontRenderContext();
        this.labelWidths = new float[super.getAxisChart().getAxisProperties().getYAxisNumItems() + 1];
        this.formattedLabels = new String[super.getAxisChart().getAxisProperties().getYAxisNumItems() + 1];
        double d = this.minValue;
        NumberFormat numberFormat = axisProperties.getYAxisUseDollarSigns() ? NumberFormat.getCurrencyInstance() : NumberFormat.getInstance();
        if (axisProperties.getYAxisUseCommas()) {
            numberFormat.setGroupingUsed(true);
        } else {
            numberFormat.setGroupingUsed(false);
        }
        if (axisProperties.getYAxisRoundValuesToNearest() >= 0) {
            numberFormat.setMaximumFractionDigits(0);
            numberFormat.setMinimumFractionDigits(0);
        } else {
            numberFormat.setMaximumFractionDigits(-axisProperties.getYAxisRoundValuesToNearest());
            numberFormat.setMinimumFractionDigits(-axisProperties.getYAxisRoundValuesToNearest());
        }
        int n = 0;
        while (n <= super.getAxisChart().getAxisProperties().getYAxisNumItems()) {
            float f;
            this.formattedLabels[n] = numberFormat.format(d);
            textLayout = new TextLayout(this.formattedLabels[n], super.getAxisChart().getAxisProperties().getScaleFont(), fontRenderContext);
            this.labelWidths[n] = f = textLayout.getAdvance();
            if (f > super.getWidestLabel()) {
                super.setWidestLabel(f);
            }
            d += this.increment;
            ++n;
        }
        super.setTallestLabel(textLayout.getAscent() + textLayout.getDescent());
    }

    void render(Graphics2D graphics2D, AxisProperties axisProperties, String string) {
        float f;
        if (string != null) {
            float f2 = super.getAxisChart().getChartProperties().getEdgePadding() + super.getTitleHeight();
            f = super.getAxisChart().getChartProperties().getEdgePadding();
            f = super.getTitleWidth() > super.getPixelLength() ? (f += super.getTitleWidth()) : (f += this.getOrigin() - (super.getPixelLength() - super.getTitleWidth()) / 2.0f);
            graphics2D.setFont(axisProperties.getAxisTitleFont().deriveFont(Axis.VERTICAL_LABEL_ROTATION));
            graphics2D.setPaint(axisProperties.getAxisTitleColor());
            graphics2D.drawString(string, f2, f);
        }
        Line2D.Float float_ = new Line2D.Float(0.0f, super.getOrigin(), 0.0f, super.getOrigin());
        f = super.getAxisChart().getXAxis().getOrigin() - super.getAxisChart().getAxisProperties().getAxisTickMarkPixelLength(1);
        float f3 = super.getAxisChart().getXAxis().getOrigin();
        float f4 = super.getAxisChart().getXAxis().getOrigin() + 1.0f;
        float f5 = super.getAxisChart().getXAxis().getOrigin() + super.getAxisChart().getXAxis().getPixelLength();
        float f6 = super.getAxisChart().getXAxis().getOrigin() - super.getAxisChart().getAxisProperties().getPaddingBetweenLabelsAndTicks(1) - super.getAxisChart().getAxisProperties().getAxisTickMarkPixelLength(1);
        float f7 = super.getOrigin() + super.getTallestLabel() / 4.0f;
        graphics2D.setFont(axisProperties.getScaleFont());
        int n = 0;
        while (n <= axisProperties.getYAxisNumItems()) {
            if (axisProperties.getShowGridLine(1) != 0 && n != 0) {
                float_.x1 = f4;
                float_.x2 = f5;
                if (n < axisProperties.getYAxisNumItems() || n == axisProperties.getYAxisNumItems() && !axisProperties.getShowTopBorder()) {
                    graphics2D.setStroke(axisProperties.getGridLineStroke(0));
                    graphics2D.setPaint(axisProperties.getGridLineColor(0));
                    graphics2D.draw(float_);
                } else {
                    graphics2D.setStroke(axisProperties.getAxisStroke(0));
                    graphics2D.setPaint(axisProperties.getAxisColor(0));
                    graphics2D.draw(float_);
                }
            }
            if (axisProperties.getShowTicks(1) != 0) {
                float_.x1 = f;
                float_.x2 = f3;
                graphics2D.setStroke(axisProperties.getTickStroke(1));
                graphics2D.setPaint(axisProperties.getTickColor(1));
                graphics2D.draw(float_);
            }
            float_.y1 -= super.getScalePixelWidth();
            float_.y2 = float_.y1;
            graphics2D.setPaint(axisProperties.getScaleFontColor());
            graphics2D.drawString(this.formattedLabels[n], f6 - this.labelWidths[n], f7);
            f7 -= super.getScalePixelWidth();
            ++n;
        }
        if (axisProperties.getShowTopBorder()) {
            float_.x1 = f4;
            float_.x2 = f5 + 1.0f;
            float_.y1 += super.getScalePixelWidth();
            float_.y2 = float_.y1;
            graphics2D.setStroke(axisProperties.getAxisStroke(0));
            graphics2D.setPaint(axisProperties.getAxisColor(0));
            graphics2D.draw(float_);
        }
        float_.x2 = float_.x1 = super.getAxisChart().getXAxis().getOrigin();
        float_.y1 = super.getOrigin() - super.getPixelLength();
        float_.y2 = super.getOrigin();
        graphics2D.setStroke(axisProperties.getAxisStroke(1));
        graphics2D.setPaint(axisProperties.getAxisColor(1));
        graphics2D.draw(float_);
        this.zeroLineCoordinate = (float)((double)super.getOrigin() - (double)super.getScalePixelWidth() * -this.minValue / this.increment);
        if (axisProperties.getShowZeroLine() && this.minValue < 0.0 && this.maxValue > 0.0) {
            float_.y2 = float_.y1 = this.zeroLineCoordinate;
            float_.x1 = super.getAxisChart().getXAxis().getOrigin();
            float_.x2 = super.getAxisChart().getXAxis().getOrigin() + super.getAxisChart().getXAxis().getPixelLength();
            graphics2D.setStroke(axisProperties.getZeroLineStroke());
            graphics2D.setPaint(axisProperties.getZeroLinePaint());
            graphics2D.draw(float_);
        }
    }

    public void toHTML(HTMLGenerator hTMLGenerator) {
        hTMLGenerator.propertiesTableStart(this.getClass().getName());
        super.toHTML(hTMLGenerator);
        Field[] fieldArray = this.getClass().getDeclaredFields();
        int n = 0;
        while (n < fieldArray.length) {
            try {
                hTMLGenerator.addField(fieldArray[n].getName(), fieldArray[n].get(this));
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            ++n;
        }
        hTMLGenerator.propertiesTableEnd();
    }
}

