/*
 * Decompiled with CFR 0.152.
 */
package org.compiere;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.net.InetAddress;
import java.net.URL;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import org.compiere.db.CConnection;
import org.compiere.framework.ModelValidationEngine;
import org.compiere.model.MClient;
import org.compiere.model.MSystem;
import org.compiere.plaf.CompierePLAF;
import org.compiere.plaf.CompiereTheme;
import org.compiere.util.CLogFile;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Login;
import org.compiere.util.SecureEngine;
import org.compiere.util.Splash;
import org.compiere.util.Util;

public final class Compiere {
    public static final String MAIN_VERSION = "Release 3.0.0";
    public static final String DATE_VERSION = "2007-11-26";
    public static final String DB_VERSION = "2007-11-26";
    public static final String NAME = "Compiere\u00ae";
    public static final String URL = "www.compiere.org";
    private static final String s_File16x16 = "images/C16.png";
    private static final String s_file32x32 = "images/C32.png";
    private static final String s_fileMedium = "images/Compiere120x30.png";
    private static final String s_fileSmall = "images/Compiere.png";
    private static final String s_fileHR = "images/CompiereHR.png";
    private static String s_supportEmail = "";
    public static final String SUB_TITLE = " Smart ERP & CRM ";
    public static final String COMPIERE_R = "Compiere\u00ae";
    public static final String COPYRIGHT = "\u00a9 1999-2007 Compiere \u00ae";
    private static String s_ImplementationVersion = null;
    private static String s_ImplementationVendor = null;
    private static Image s_image16;
    private static Image s_image48x15;
    private static Image s_imageLogo;
    private static ImageIcon s_imageIcon32;
    private static ImageIcon s_imageIconLogo;
    private static CLogger log;

    public static String getName() {
        return "Compiere\u00ae";
    }

    public static String getVersion() {
        return "Release 3.0.0 - 2007-11-26";
    }

    public static String getSum() {
        StringBuffer sb = new StringBuffer();
        sb.append("Compiere\u00ae").append(" ").append(MAIN_VERSION).append(SUB_TITLE);
        return sb.toString();
    }

    public static String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append("Compiere\u00ae").append(" ").append(MAIN_VERSION).append("_").append("2007-11-26").append(" -").append(SUB_TITLE).append("- ").append(COPYRIGHT).append("; Implementation: ").append(Compiere.getImplementationVersion()).append(" - ").append(Compiere.getImplementationVendor());
        return sb.toString();
    }

    private static void setPackageInfo() {
        if (s_ImplementationVendor != null) {
            return;
        }
        Package compierePackage = Package.getPackage("org.compiere");
        s_ImplementationVendor = compierePackage.getImplementationVendor();
        s_ImplementationVersion = compierePackage.getImplementationVersion();
        if (s_ImplementationVendor == null) {
            s_ImplementationVendor = "not supported";
            s_ImplementationVersion = "unknown";
        }
    }

    public static String getImplementationVersion() {
        if (s_ImplementationVersion == null) {
            Compiere.setPackageInfo();
        }
        return s_ImplementationVersion;
    }

    public static String getImplementationVendor() {
        if (s_ImplementationVendor == null) {
            Compiere.setPackageInfo();
        }
        return s_ImplementationVendor;
    }

    public static int getCheckSum() {
        return Compiere.getSum().hashCode();
    }

    public static String getSummaryAscii() {
        String retValue = Compiere.getSummary();
        retValue = Util.replace(retValue, "\u00ae", "(r)");
        retValue = Util.replace(retValue, "\u2122", "(tm)");
        retValue = Util.replace(retValue, "\u00a9", "(c)");
        retValue = Util.replace(retValue, Env.NL, " ");
        retValue = Util.replace(retValue, "\n", " ");
        return retValue;
    }

    public static String getEnvInfo(boolean isClient, String info) {
        StringBuffer sb = new StringBuffer();
        if (info != null && info.length() > 0) {
            sb.append(info).append(" ");
        } else if (isClient) {
            sb.append("Client ");
        } else {
            sb.append("Server ");
        }
        try {
            InetAddress local = InetAddress.getLocalHost();
            sb.append(local).append(": ");
        }
        catch (Exception exception) {
            // empty catch block
        }
        sb.append(Compiere.getCompiereHome()).append(" - ").append(Compiere.getJavaInfo()).append(" - ").append(Compiere.getOSInfo());
        return sb.toString();
    }

    public static String getJavaInfo() {
        return System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version");
    }

    public static String getOSInfo() {
        return System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("sun.os.patch.level");
    }

    public static String getURL() {
        return "http://www.compiere.org";
    }

    public static String getSubtitle() {
        return SUB_TITLE;
    }

    public static Image getImage16() {
        if (s_image16 == null) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            URL url = Compiere.class.getResource(s_File16x16);
            if (url == null) {
                return null;
            }
            s_image16 = tk.getImage(url);
        }
        return s_image16;
    }

    public static Image getImageLogoSmall(boolean hr) {
        if (s_image48x15 == null) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            URL url = null;
            url = hr ? Compiere.class.getResource(s_fileHR) : Compiere.class.getResource(s_fileSmall);
            if (url == null) {
                return null;
            }
            s_image48x15 = tk.getImage(url);
        }
        return s_image48x15;
    }

    public static Image getImageLogo() {
        if (s_imageLogo == null) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            URL url = Compiere.class.getResource(s_fileMedium);
            if (url == null) {
                return null;
            }
            s_imageLogo = tk.getImage(url);
        }
        return s_imageLogo;
    }

    public static ImageIcon getImageIcon32() {
        if (s_imageIcon32 == null) {
            URL url = Compiere.class.getResource(s_file32x32);
            if (url == null) {
                return null;
            }
            s_imageIcon32 = new ImageIcon(url);
        }
        return s_imageIcon32;
    }

    public static ImageIcon getImageIconLogo() {
        if (s_imageIconLogo == null) {
            URL url = Compiere.class.getResource(s_fileMedium);
            if (url == null) {
                return null;
            }
            s_imageIconLogo = new ImageIcon(url);
        }
        return s_imageIconLogo;
    }

    public static String getCompiereHome() {
        String retValue = Ini.getCompiereHome();
        if (retValue == null && System.getProperty("user.dir").indexOf("Compiere2") != -1) {
            retValue = System.getProperty("user.dir");
            int pos = retValue.indexOf("Compiere2");
            retValue = retValue.substring(pos + 9);
        }
        if (retValue == null) {
            retValue = File.separator + "Compiere2";
        }
        return retValue;
    }

    public static String getSupportEMail() {
        return s_supportEmail;
    }

    public static void setSupportEMail(String email) {
        s_supportEmail = email;
    }

    public static synchronized boolean startup(boolean isClient) {
        return Compiere.startup(isClient, null);
    }

    public static synchronized boolean startupEnvironment(boolean isClient) {
        return Compiere.startupEnvironment(isClient, null);
    }

    public static synchronized boolean startup(boolean isClient, String info) {
        if (log != null) {
            return true;
        }
        if (!Login.isJavaOK(isClient) && isClient) {
            System.exit(1);
        }
        CLogMgt.initialize(isClient);
        Ini.setClient(isClient);
        log = CLogger.getCLogger(Compiere.class);
        log.info(Compiere.getSummaryAscii());
        log.info(Compiere.getEnvInfo(isClient, info));
        Ini.loadProperties(false);
        CLogMgt.setLevel(Ini.getProperty("TraceLevel"));
        if (isClient && Ini.isPropertyBool("TraceFile") && CLogFile.get(false, null, isClient) == null) {
            System.out.println("Adding log handler: " + Ini.findCompiereHome());
            CLogMgt.addHandler(CLogFile.get(true, Ini.findCompiereHome(), isClient));
        }
        if (isClient) {
            if (CLogMgt.isLevelAll()) {
                log.log(Level.FINEST, System.getProperties().toString());
            }
            CompiereTheme.load();
            CompierePLAF.setPLAF(null);
        }
        DB.setDBTarget(CConnection.get());
        if (isClient) {
            return false;
        }
        return Compiere.startupEnvironment(isClient, info);
    }

    public static boolean startupEnvironment(boolean isClient, String info) {
        String className;
        Compiere.startup(isClient, info);
        if (!DB.isConnected()) {
            log.severe("No Database");
            return false;
        }
        MSystem system = MSystem.get(Env.getCtx());
        if (system == null) {
            return false;
        }
        ModelValidationEngine.get();
        try {
            className = system.getEncryptionKey();
            if (!(className != null && className.length() != 0 || (className = System.getProperty("COMPIERE_SECURE")) == null || className.length() <= 0 || className.equals("org.compiere.util.Secure"))) {
                SecureEngine.init(className);
                system.setEncryptionKey(className);
                system.save();
            }
            SecureEngine.init(className);
            if (isClient) {
                MClient.get(Env.getCtx(), 0);
            } else {
                MClient.getAll(Env.getCtx());
            }
        }
        catch (Exception e) {
            log.warning("Environment problems: " + e.toString());
        }
        className = null;
        try {
            className = "org.compiere.wf.DocWorkflowManager";
            Class.forName(className);
            className = "org.compiere.print.ArchiveEngine";
            Class.forName(className);
        }
        catch (Exception e) {
            log.warning("Not started: " + className + " - " + e.getMessage());
        }
        if (!isClient) {
            DB.updateMail();
        }
        return true;
    }

    public static void main(String[] args) {
        Splash.getSplash();
        Compiere.startup(true, null);
        String className = "org.compiere.apps.AMenu";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-debug")) continue;
            className = args[i];
            break;
        }
        try {
            Class<?> startClass = Class.forName(className);
            startClass.newInstance();
        }
        catch (Exception e) {
            System.err.println("Compiere starting: " + className + " - " + e.toString());
            e.printStackTrace();
        }
    }

    static {
        log = null;
    }
}

