/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.controller;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.logging.Level;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MLookupInfo;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.vos.FieldVO;

public class GridFieldVO
extends FieldVO
implements Serializable {
    public String Callout = "";
    static final long serialVersionUID = 4385061125114436797L;
    public Ctx ctx = null;
    public MLookupInfo lookupInfo = null;

    public static String getSQL(Ctx ctx, int AD_UserDef_Win_ID) {
        String sql = "SELECT * FROM AD_Field_v WHERE AD_Tab_ID=?";
        if (!Env.isBaseLanguage(ctx, "AD_Tab")) {
            sql = "SELECT * FROM AD_Field_vt WHERE AD_Tab_ID=? AND AD_Language='" + Env.getAD_Language(ctx) + "'";
        }
        if (AD_UserDef_Win_ID != 0) {
            sql = sql + " AND AD_UserDef_Win_ID=" + AD_UserDef_Win_ID;
        }
        sql = sql + " ORDER BY IsDisplayed DESC, SeqNo";
        return sql;
    }

    public static GridFieldVO create(Ctx ctx, int WindowNo, int TabNo, int AD_Window_ID, int AD_Tab_ID, boolean readOnly, ResultSet rs) {
        GridFieldVO vo = new GridFieldVO(ctx, WindowNo, TabNo, AD_Window_ID, AD_Tab_ID, readOnly);
        String columnName = "ColumnName";
        try {
            vo.ColumnName = rs.getString("ColumnName");
            if (vo.ColumnName == null) {
                return null;
            }
            CLogger.get().fine(vo.ColumnName);
            ResultSetMetaData rsmd = rs.getMetaData();
            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                columnName = rsmd.getColumnName(i);
                if (columnName.equalsIgnoreCase("Name")) {
                    vo.Header = rs.getString(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("AD_Reference_ID")) {
                    vo.displayType = rs.getInt(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("AD_Column_ID")) {
                    vo.AD_Column_ID = rs.getInt(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("AD_Table_ID")) {
                    vo.AD_Table_ID = rs.getInt(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("DisplayLength")) {
                    vo.DisplayLength = rs.getInt(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("IsSameLine")) {
                    vo.IsSameLine = "Y".equals(rs.getString(i));
                    continue;
                }
                if (columnName.equalsIgnoreCase("IsDisplayed")) {
                    vo.IsDisplayed = "Y".equals(rs.getString(i));
                    continue;
                }
                if (columnName.equalsIgnoreCase("DisplayLogic")) {
                    vo.DisplayLogic = rs.getString(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("DefaultValue")) {
                    vo.DefaultValue = rs.getString(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("IsMandatoryUI")) {
                    vo.IsMandatoryUI = "Y".equals(rs.getString(i));
                    continue;
                }
                if (columnName.equalsIgnoreCase("IsReadOnly")) {
                    vo.IsReadOnly = "Y".equals(rs.getString(i));
                    continue;
                }
                if (columnName.equalsIgnoreCase("IsUpdateable")) {
                    vo.IsUpdateable = "Y".equals(rs.getString(i));
                    continue;
                }
                if (columnName.equalsIgnoreCase("IsAlwaysUpdateable")) {
                    vo.IsAlwaysUpdateable = "Y".equals(rs.getString(i));
                    continue;
                }
                if (columnName.equalsIgnoreCase("IsHeading")) {
                    vo.IsHeading = "Y".equals(rs.getString(i));
                    continue;
                }
                if (columnName.equalsIgnoreCase("IsFieldOnly")) {
                    vo.IsFieldOnly = "Y".equals(rs.getString(i));
                    continue;
                }
                if (columnName.equalsIgnoreCase("IsEncryptedField")) {
                    vo.IsEncryptedField = "Y".equals(rs.getString(i));
                    continue;
                }
                if (columnName.equalsIgnoreCase("IsEncryptedColumn")) {
                    vo.IsEncryptedColumn = "Y".equals(rs.getString(i));
                    continue;
                }
                if (columnName.equalsIgnoreCase("IsSelectionColumn")) {
                    vo.IsSelectionColumn = "Y".equals(rs.getString(i));
                    continue;
                }
                if (columnName.equalsIgnoreCase("SortNo")) {
                    vo.SortNo = rs.getInt(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("FieldLength")) {
                    vo.FieldLength = rs.getInt(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("VFormat")) {
                    vo.VFormat = rs.getString(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("ValueMin")) {
                    vo.ValueMin = rs.getString(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("ValueMax")) {
                    vo.ValueMax = rs.getString(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("FieldGroup")) {
                    vo.FieldGroup = rs.getString(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("IsKey")) {
                    vo.IsKey = "Y".equals(rs.getString(i));
                    continue;
                }
                if (columnName.equalsIgnoreCase("IsParent")) {
                    vo.IsParent = "Y".equals(rs.getString(i));
                    continue;
                }
                if (columnName.equalsIgnoreCase("Description")) {
                    vo.Description = rs.getString(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("Help")) {
                    vo.Help = rs.getString(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("Callout")) {
                    vo.Callout = rs.getString(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("AD_Process_ID")) {
                    vo.AD_Process_ID = rs.getInt(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("ReadOnlyLogic")) {
                    vo.ReadOnlyLogic = rs.getString(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("ObscureType")) {
                    vo.ObscureType = rs.getString(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("IsDefaultFocus")) {
                    vo.IsDefaultFocus = "Y".equals(rs.getString(i));
                    continue;
                }
                if (columnName.equalsIgnoreCase("AD_Reference_Value_ID")) {
                    vo.AD_Reference_Value_ID = rs.getInt(i);
                    continue;
                }
                if (columnName.equalsIgnoreCase("ValidationCode")) {
                    vo.ValidationCode = rs.getString(i);
                    continue;
                }
                if (!columnName.equalsIgnoreCase("ColumnSQL")) continue;
                vo.ColumnSQL = rs.getString(i);
            }
            if (vo.Header == null) {
                vo.Header = vo.ColumnName;
            }
        }
        catch (SQLException e) {
            CLogger.get().log(Level.SEVERE, "ColumnName=" + columnName, e);
            return null;
        }
        vo.initFinish();
        return vo;
    }

    public static GridFieldVO createParameter(Ctx ctx, int WindowNo, ResultSet rs) {
        GridFieldVO vo = new GridFieldVO(ctx, WindowNo, 0, 0, 0, false);
        vo.isProcess = true;
        vo.IsDisplayed = true;
        vo.IsReadOnly = false;
        vo.IsUpdateable = true;
        try {
            vo.AD_Table_ID = 0;
            vo.AD_Column_ID = rs.getInt("AD_Process_Para_ID");
            vo.ColumnName = rs.getString("ColumnName");
            vo.Header = rs.getString("Name");
            vo.Description = rs.getString("Description");
            vo.Help = rs.getString("Help");
            vo.displayType = rs.getInt("AD_Reference_ID");
            vo.AD_Reference_ID = rs.getInt("AD_Reference_ID");
            vo.IsMandatoryUI = rs.getString("IsMandatoryUI").equals("Y");
            vo.DisplayLength = vo.FieldLength = rs.getInt("FieldLength");
            vo.DefaultValue = rs.getString("DefaultValue");
            vo.DefaultValue2 = rs.getString("DefaultValue2");
            vo.VFormat = rs.getString("VFormat");
            vo.ValueMin = rs.getString("ValueMin");
            vo.ValueMax = rs.getString("ValueMax");
            vo.isRange = rs.getString("IsRange").equals("Y");
            vo.AD_Reference_Value_ID = rs.getInt("AD_Reference_Value_ID");
            vo.ValidationCode = rs.getString("ValidationCode");
        }
        catch (SQLException e) {
            CLogger.get().log(Level.SEVERE, "createParameter", e);
        }
        vo.initFinish();
        if (vo.DefaultValue2 == null) {
            vo.DefaultValue2 = "";
        }
        return vo;
    }

    public static GridFieldVO createParameter(GridFieldVO voF) {
        GridFieldVO voT = new GridFieldVO(voF.ctx, voF.WindowNo, voF.TabNo, voF.AD_Window_ID, voF.AD_Tab_ID, voF.tabReadOnly);
        voT.isProcess = true;
        voT.IsDisplayed = true;
        voT.IsReadOnly = false;
        voT.IsUpdateable = true;
        voT.AD_Table_ID = voF.AD_Table_ID;
        voT.AD_Column_ID = voF.AD_Column_ID;
        voT.ColumnName = voF.ColumnName;
        voT.Header = voF.Header;
        voT.Description = voF.Description;
        voT.Help = voF.Help;
        voT.displayType = voF.displayType;
        voT.IsMandatoryUI = voF.IsMandatoryUI;
        voT.FieldLength = voF.FieldLength;
        voT.DisplayLength = voF.FieldLength;
        voT.DefaultValue = voF.DefaultValue2;
        voT.VFormat = voF.VFormat;
        voT.ValueMin = voF.ValueMin;
        voT.ValueMax = voF.ValueMax;
        voT.isRange = voF.isRange;
        return voT;
    }

    public static GridFieldVO createStdField(Ctx ctx, int WindowNo, int TabNo, int AD_Window_ID, int AD_Tab_ID, boolean tabReadOnly, boolean isCreated, boolean isTimestamp) {
        GridFieldVO vo = new GridFieldVO(ctx, WindowNo, TabNo, AD_Window_ID, AD_Tab_ID, tabReadOnly);
        String string = vo.ColumnName = isCreated ? "Created" : "Updated";
        if (!isTimestamp) {
            vo.ColumnName = vo.ColumnName + "By";
        }
        int n = vo.displayType = isTimestamp ? 16 : 18;
        if (!isTimestamp) {
            vo.AD_Reference_Value_ID = 110;
        }
        vo.IsDisplayed = false;
        vo.IsMandatoryUI = false;
        vo.IsReadOnly = false;
        vo.IsUpdateable = true;
        vo.initFinish();
        return vo;
    }

    private GridFieldVO(Ctx newCtx, int windowNo, int tabNo, int ad_Window_ID, int ad_Tab_ID, boolean TabReadOnly) {
        this.ctx = newCtx;
        this.WindowNo = windowNo;
        this.TabNo = tabNo;
        this.AD_Window_ID = ad_Window_ID;
        this.AD_Tab_ID = ad_Tab_ID;
        this.tabReadOnly = TabReadOnly;
    }

    public GridFieldVO(Ctx newCtx, FieldVO f) {
        GridFieldVO vo = this;
        this.ctx = newCtx;
        vo.isProcess = true;
        vo.IsDisplayed = true;
        vo.IsReadOnly = false;
        vo.IsUpdateable = true;
        vo.AD_Table_ID = 0;
        vo.AD_Column_ID = 0;
        vo.ColumnName = f.ColumnName;
        vo.Header = "";
        vo.Description = f.Description;
        vo.Help = f.Help;
        vo.displayType = f.displayType;
        vo.IsMandatoryUI = f.IsMandatoryUI;
        vo.FieldLength = f.FieldLength;
        vo.DisplayLength = f.DisplayLength;
        vo.DefaultValue = f.DefaultValue;
        vo.DefaultValue2 = f.DefaultValue2;
        vo.VFormat = f.VFormat;
        vo.ValueMin = f.ValueMin;
        vo.ValueMax = f.ValueMax;
        vo.isRange = f.isRange;
        vo.AD_Reference_Value_ID = f.AD_Reference_Value_ID;
        vo.ValidationCode = f.ValidationCode;
        vo.initFinish();
        if (vo.DefaultValue2 == null) {
            vo.DefaultValue2 = "";
        }
    }

    public void setCtx(Ctx newCtx) {
        this.ctx = newCtx;
    }

    protected void initFinish() {
        if (this.DisplayLogic == null) {
            this.DisplayLogic = "";
        }
        if (this.DefaultValue == null) {
            this.DefaultValue = "";
        }
        if (this.FieldGroup == null) {
            this.FieldGroup = "";
        }
        if (this.Description == null) {
            this.Description = "";
        }
        if (this.Help == null) {
            this.Help = "";
        }
        if (this.Callout == null) {
            this.Callout = "";
        }
        if (this.ReadOnlyLogic == null) {
            this.ReadOnlyLogic = "";
        }
        if (DisplayType.isLookup((int)this.displayType)) {
            try {
                this.lookupInfo = MLookupFactory.getLookupInfo(this.ctx, this.WindowNo, this.displayType, this.AD_Column_ID, Env.getLanguage(this.ctx), this.ColumnName, this.AD_Reference_Value_ID, this.IsParent, this.ValidationCode);
            }
            catch (Exception e) {
                CLogger.get().log(Level.SEVERE, "No LookupInfo for " + this.ColumnName, e);
                this.displayType = 13;
            }
        }
    }

    protected GridFieldVO clone(Ctx Ctx2, int windowNo, int tabNo, int ad_Window_ID, int ad_Tab_ID, boolean TabReadOnly) {
        GridFieldVO clone = new GridFieldVO(Ctx2, windowNo, tabNo, ad_Window_ID, ad_Tab_ID, TabReadOnly);
        clone.isProcess = false;
        clone.ColumnName = this.ColumnName;
        clone.ColumnSQL = this.ColumnSQL;
        clone.Header = this.Header;
        clone.displayType = this.displayType;
        clone.AD_Table_ID = this.AD_Table_ID;
        clone.AD_Column_ID = this.AD_Column_ID;
        clone.DisplayLength = this.DisplayLength;
        clone.IsSameLine = this.IsSameLine;
        clone.IsDisplayed = this.IsDisplayed;
        clone.DisplayLogic = this.DisplayLogic;
        clone.DefaultValue = this.DefaultValue;
        clone.IsMandatoryUI = this.IsMandatoryUI;
        clone.IsReadOnly = this.IsReadOnly;
        clone.IsUpdateable = this.IsUpdateable;
        clone.IsAlwaysUpdateable = this.IsAlwaysUpdateable;
        clone.IsHeading = this.IsHeading;
        clone.IsFieldOnly = this.IsFieldOnly;
        clone.IsEncryptedField = this.IsEncryptedField;
        clone.IsEncryptedColumn = this.IsEncryptedColumn;
        clone.IsSelectionColumn = this.IsSelectionColumn;
        clone.SortNo = this.SortNo;
        clone.FieldLength = this.FieldLength;
        clone.VFormat = this.VFormat;
        clone.ValueMin = this.ValueMin;
        clone.ValueMax = this.ValueMax;
        clone.FieldGroup = this.FieldGroup;
        clone.IsKey = this.IsKey;
        clone.IsParent = this.IsParent;
        clone.Callout = this.Callout;
        clone.AD_Process_ID = this.AD_Process_ID;
        clone.Description = this.Description;
        clone.Help = this.Help;
        clone.ReadOnlyLogic = this.ReadOnlyLogic;
        clone.ObscureType = this.ObscureType;
        clone.IsDefaultFocus = this.IsDefaultFocus;
        clone.ValidationCode = this.ValidationCode;
        clone.AD_Reference_Value_ID = this.AD_Reference_Value_ID;
        clone.lookupInfo = this.lookupInfo;
        clone.isRange = this.isRange;
        clone.DefaultValue2 = this.DefaultValue2;
        return clone;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MFieldVO[");
        sb.append(this.AD_Column_ID).append("-").append(this.ColumnName).append("]");
        return sb.toString();
    }
}

