/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.controller;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.controller.GridFieldVO;
import org.compiere.model.GridWindowVO;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Evaluatee;

public class GridTabVO
implements Evaluatee,
Serializable {
    static final long serialVersionUID = 9160212869277319305L;
    public Ctx ctx;
    public int WindowNo;
    public int AD_Window_ID;
    public int TabNo;
    public int AD_Tab_ID;
    public int Referenced_Tab_ID;
    public String Name = "";
    public String Description = "";
    public String Help = "";
    public boolean IsSingleRow = false;
    public boolean IsReadOnly = false;
    public boolean IsInsertRecord = true;
    public boolean HasTree = false;
    public int AD_Table_ID;
    public int AD_Column_ID = 0;
    public String TableName;
    public boolean IsView = false;
    public String AccessLevel;
    public boolean IsSecurityEnabled = false;
    public boolean IsDeleteable = false;
    public boolean IsHighVolume = false;
    public int AD_Process_ID = 0;
    public String CommitWarning;
    public String WhereClause;
    public String OrderByClause;
    public String ReadOnlyLogic;
    public String DisplayLogic;
    public int TabLevel = 0;
    public int AD_Image_ID = 0;
    public int Included_Tab_ID = 0;
    public String ReplicationType = "L";
    public boolean IsSortTab = false;
    public int AD_ColumnSortOrder_ID = 0;
    public int AD_ColumnSortYesNo_ID = 0;
    public int onlyCurrentDays = 0;
    public ArrayList<GridFieldVO> Fields = null;

    public static GridTabVO create(GridWindowVO wVO, int TabNo, ResultSet rs, boolean isRO, int onlyCurrentDays, int AD_UserDef_Win_ID) {
        CLogger.get().config("#" + TabNo);
        GridTabVO vo = new GridTabVO(wVO.ctx, wVO.WindowNo);
        vo.AD_Window_ID = wVO.AD_Window_ID;
        vo.TabNo = TabNo;
        if (!GridTabVO.loadTabDetails(vo, rs)) {
            return null;
        }
        if (isRO) {
            CLogger.get().fine("Tab is ReadOnly");
            vo.IsReadOnly = true;
        }
        vo.onlyCurrentDays = onlyCurrentDays;
        if (vo.IsSortTab) {
            vo.Fields = new ArrayList();
        } else {
            GridTabVO.createFields(vo, AD_UserDef_Win_ID);
            if (vo.Fields == null || vo.Fields.size() == 0) {
                CLogger.get().log(Level.SEVERE, vo.Name + ": No Fields");
                return null;
            }
        }
        return vo;
    }

    private static boolean loadTabDetails(GridTabVO vo, ResultSet rs) {
        MRole role = MRole.getDefault(vo.ctx, false);
        boolean showTrl = "Y".equals(vo.ctx.getContext("#ShowTrl"));
        boolean showAcct = "Y".equals(vo.ctx.getContext("#ShowAcct"));
        boolean showAdvanced = "Y".equals(vo.ctx.getContext("#ShowAdvanced"));
        try {
            vo.AD_Tab_ID = rs.getInt("AD_Tab_ID");
            vo.Referenced_Tab_ID = rs.getInt("Referenced_Tab_ID");
            vo.ctx.setContext(vo.WindowNo, vo.TabNo, "AD_Tab_ID", String.valueOf(vo.AD_Tab_ID));
            vo.Name = rs.getString("Name");
            vo.ctx.setContext(vo.WindowNo, vo.TabNo, "Name", vo.Name);
            if (rs.getString("IsTranslationTab").equals("Y")) {
                vo.TableName = rs.getString("TableName");
                if (!Env.isBaseTranslation(vo.TableName) && !Env.isMultiLingualDocument(vo.ctx)) {
                    showTrl = false;
                }
                if (!showTrl) {
                    CLogger.get().config("TrlTab Not displayed - AD_Tab_ID=" + vo.AD_Tab_ID + "=" + vo.Name + ", Table=" + vo.TableName + ", BaseTrl=" + Env.isBaseTranslation(vo.TableName) + ", MultiLingual=" + Env.isMultiLingualDocument(vo.ctx));
                    return false;
                }
            }
            if (!showAdvanced && rs.getString("IsAdvancedTab").equals("Y")) {
                CLogger.get().config("AdvancedTab Not displayed - AD_Tab_ID=" + vo.AD_Tab_ID + " " + vo.Name);
                return false;
            }
            if (!showAcct && rs.getString("IsInfoTab").equals("Y")) {
                CLogger.get().fine("AcctTab Not displayed - AD_Tab_ID=" + vo.AD_Tab_ID + " " + vo.Name);
                return false;
            }
            vo.DisplayLogic = rs.getString("DisplayLogic");
            vo.AccessLevel = rs.getString("AccessLevel");
            if (!role.canView(vo.ctx, vo.AccessLevel)) {
                CLogger.get().fine("No Role Access - AD_Tab_ID=" + vo.AD_Tab_ID + " " + vo.Name);
                return false;
            }
            vo.ctx.setContext(vo.WindowNo, vo.TabNo, "AccessLevel", vo.AccessLevel);
            vo.AD_Table_ID = rs.getInt("AD_Table_ID");
            vo.ctx.setContext(vo.WindowNo, vo.TabNo, "AD_Table_ID", String.valueOf(vo.AD_Table_ID));
            if (!role.isTableAccess(vo.AD_Table_ID, true)) {
                CLogger.get().config("No Table Access - AD_Tab_ID=" + vo.AD_Tab_ID + " " + vo.Name);
                return false;
            }
            if (rs.getString("IsReadOnly").equals("Y")) {
                vo.IsReadOnly = true;
            }
            vo.ReadOnlyLogic = rs.getString("ReadOnlyLogic");
            if (rs.getString("IsInsertRecord").equals("N")) {
                vo.IsInsertRecord = false;
            }
            vo.Description = rs.getString("Description");
            if (vo.Description == null) {
                vo.Description = "";
            }
            vo.Help = rs.getString("Help");
            if (vo.Help == null) {
                vo.Help = "";
            }
            if (rs.getString("IsSingleRow").equals("Y")) {
                vo.IsSingleRow = true;
            }
            if (rs.getString("HasTree").equals("Y")) {
                vo.HasTree = true;
            }
            vo.AD_Table_ID = rs.getInt("AD_Table_ID");
            vo.TableName = rs.getString("TableName");
            if (rs.getString("IsView").equals("Y")) {
                vo.IsView = true;
            }
            vo.AD_Column_ID = rs.getInt("AD_Column_ID");
            if (rs.getString("IsSecurityEnabled").equals("Y")) {
                vo.IsSecurityEnabled = true;
            }
            if (rs.getString("IsDeleteable").equals("Y")) {
                vo.IsDeleteable = true;
            }
            if (rs.getString("IsHighVolume").equals("Y")) {
                vo.IsHighVolume = true;
            }
            vo.CommitWarning = rs.getString("CommitWarning");
            if (vo.CommitWarning == null) {
                vo.CommitWarning = "";
            }
            vo.WhereClause = rs.getString("WhereClause");
            if (vo.WhereClause == null) {
                vo.WhereClause = "";
            }
            vo.OrderByClause = rs.getString("OrderByClause");
            if (vo.OrderByClause == null) {
                vo.OrderByClause = "";
            }
            vo.AD_Process_ID = rs.getInt("AD_Process_ID");
            if (rs.wasNull()) {
                vo.AD_Process_ID = 0;
            }
            vo.AD_Image_ID = rs.getInt("AD_Image_ID");
            if (rs.wasNull()) {
                vo.AD_Image_ID = 0;
            }
            vo.Included_Tab_ID = rs.getInt("Included_Tab_ID");
            if (rs.wasNull()) {
                vo.Included_Tab_ID = 0;
            }
            vo.TabLevel = rs.getInt("TabLevel");
            if (rs.wasNull()) {
                vo.TabLevel = 0;
            }
            vo.IsSortTab = rs.getString("IsSortTab").equals("Y");
            if (vo.IsSortTab) {
                vo.AD_ColumnSortOrder_ID = rs.getInt("AD_ColumnSortOrder_ID");
                vo.AD_ColumnSortYesNo_ID = rs.getInt("AD_ColumnSortYesNo_ID");
            }
            try {
                int index = rs.findColumn("ReplicationType");
                vo.ReplicationType = rs.getString(index);
                if ("R".equals(vo.ReplicationType)) {
                    vo.IsReadOnly = true;
                }
            }
            catch (Exception e) {}
        }
        catch (SQLException ex) {
            CLogger.get().log(Level.SEVERE, "", ex);
            return false;
        }
        return true;
    }

    private static boolean createFields(GridTabVO mTabVO, int AD_UserDef_Win_ID) {
        mTabVO.Fields = new ArrayList();
        String sql = GridFieldVO.getSQL(mTabVO.ctx, AD_UserDef_Win_ID);
        int AD_Tab_ID = mTabVO.Referenced_Tab_ID;
        if (AD_Tab_ID == 0) {
            AD_Tab_ID = mTabVO.AD_Tab_ID;
        }
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Tab_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                GridFieldVO voF = GridFieldVO.create(mTabVO.ctx, mTabVO.WindowNo, mTabVO.TabNo, mTabVO.AD_Window_ID, AD_Tab_ID, mTabVO.IsReadOnly, rs);
                if (voF == null) continue;
                mTabVO.Fields.add(voF);
            }
            rs.close();
            pstmt.close();
        }
        catch (Exception e) {
            CLogger.get().log(Level.SEVERE, sql, e);
            return false;
        }
        return mTabVO.Fields.size() != 0;
    }

    public static String getSQL(Ctx ctx, int AD_UserDef_Win_ID) {
        String sql = "SELECT * FROM AD_Tab_v WHERE AD_Window_ID=?";
        if (!Env.isBaseLanguage(ctx, "AD_Window")) {
            sql = "SELECT * FROM AD_Tab_vt WHERE AD_Window_ID=? AND AD_Language='" + Env.getAD_Language(ctx) + "'";
        }
        if (AD_UserDef_Win_ID != 0) {
            sql = sql + " AND AD_UserDef_Win_ID=" + AD_UserDef_Win_ID;
        }
        sql = sql + " ORDER BY SeqNo";
        return sql;
    }

    private GridTabVO(Ctx newCtx, int windowNo) {
        this.ctx = newCtx;
        this.WindowNo = windowNo;
    }

    public void setCtx(Ctx newCtx) {
        this.ctx = newCtx;
        for (int i = 0; i < this.Fields.size(); ++i) {
            GridFieldVO field = this.Fields.get(i);
            field.setCtx(newCtx);
        }
    }

    public String get_ValueAsString(String variableName) {
        return this.ctx.getContext(this.WindowNo, variableName, false);
    }

    public GridTabVO clone(Ctx myCtx, int windowNo) {
        GridTabVO clone = new GridTabVO(myCtx, windowNo);
        clone.AD_Window_ID = this.AD_Window_ID;
        clone.TabNo = this.TabNo;
        myCtx.setContext(windowNo, clone.TabNo, "AD_Tab_ID", String.valueOf(clone.AD_Tab_ID));
        clone.AD_Tab_ID = this.AD_Tab_ID;
        clone.Referenced_Tab_ID = this.Referenced_Tab_ID;
        clone.Name = this.Name;
        myCtx.setContext(windowNo, clone.TabNo, "Name", clone.Name);
        clone.Description = this.Description;
        clone.Help = this.Help;
        clone.IsSingleRow = this.IsSingleRow;
        clone.IsReadOnly = this.IsReadOnly;
        clone.IsInsertRecord = this.IsInsertRecord;
        clone.HasTree = this.HasTree;
        clone.AD_Table_ID = this.AD_Table_ID;
        clone.AD_Column_ID = this.AD_Column_ID;
        clone.TableName = this.TableName;
        clone.IsView = this.IsView;
        clone.AccessLevel = this.AccessLevel;
        clone.IsSecurityEnabled = this.IsSecurityEnabled;
        clone.IsDeleteable = this.IsDeleteable;
        clone.IsHighVolume = this.IsHighVolume;
        clone.AD_Process_ID = this.AD_Process_ID;
        clone.CommitWarning = this.CommitWarning;
        clone.WhereClause = this.WhereClause;
        clone.OrderByClause = this.OrderByClause;
        clone.ReadOnlyLogic = this.ReadOnlyLogic;
        clone.DisplayLogic = this.DisplayLogic;
        clone.TabLevel = this.TabLevel;
        clone.AD_Image_ID = this.AD_Image_ID;
        clone.Included_Tab_ID = this.Included_Tab_ID;
        clone.ReplicationType = this.ReplicationType;
        myCtx.setContext(windowNo, clone.TabNo, "AccessLevel", clone.AccessLevel);
        myCtx.setContext(windowNo, clone.TabNo, "AD_Table_ID", String.valueOf(clone.AD_Table_ID));
        clone.IsSortTab = this.IsSortTab;
        clone.AD_ColumnSortOrder_ID = this.AD_ColumnSortOrder_ID;
        clone.AD_ColumnSortYesNo_ID = this.AD_ColumnSortYesNo_ID;
        clone.onlyCurrentDays = 0;
        clone.Fields = new ArrayList();
        for (int i = 0; i < this.Fields.size(); ++i) {
            GridFieldVO field = this.Fields.get(i);
            GridFieldVO cloneField = field.clone(myCtx, windowNo, this.TabNo, this.AD_Window_ID, this.AD_Tab_ID, this.IsReadOnly);
            if (cloneField == null) {
                return null;
            }
            clone.Fields.add(cloneField);
        }
        return clone;
    }
}

