/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.controller;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.compiere.controller.UIFieldVO;
import org.compiere.controller.UITab;
import org.compiere.framework.Lookup;
import org.compiere.model.MAccountLookup;
import org.compiere.model.MLocationLookup;
import org.compiere.model.MLocatorLookup;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MLookupInfo;
import org.compiere.model.MPAttributeLookup;
import org.compiere.model.MRole;
import org.compiere.util.CContext;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Evaluatee;
import org.compiere.util.Evaluator;
import org.compiere.util.NamePair;
import org.compiere.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIField
extends UIFieldVO {
    private static CLogger log = CLogger.getCLogger(UIField.class);
    private boolean m_error = false;
    private Boolean m_parentValue = null;
    private ArrayList<String> m_dependsOnUI = new ArrayList();
    private ArrayList<String> m_dependsOnValue = new ArrayList();
    private ArrayList<String> m_impactsUI = new ArrayList();
    private ArrayList<String> m_impactsValue = new ArrayList();
    private boolean m_impactsUITab = false;
    private char m_mnemonic = '\u0000';
    private Lookup m_lookup = null;
    private MLookupInfo m_lookupInfo = null;

    public UIField(UIFieldVO vo) {
        super(vo);
    }

    public int getSortNoAsInt() {
        String value = this.get("SortNo");
        if (value == null) {
            return 0;
        }
        return Integer.parseInt(value);
    }

    public boolean isVirtualColumn() {
        String s = this.getColumnSQL();
        return s != null && s.length() > 0;
    }

    public boolean isMandatory(CContext ctx, int WindowNo) {
        if (this.isVirtualColumn()) {
            return false;
        }
        String logic = this.getMandatoryLogic();
        if (!(super.isMandatoryUI() || logic != null && logic.length() != 0)) {
            return false;
        }
        String columnName = this.getColumnName();
        if (this.isKey() && columnName.endsWith("_ID") || columnName.startsWith("Created") || columnName.startsWith("Updated") || columnName.equals("Value") || columnName.equals("DocumentNo") || columnName.equals("M_AttributeSetInstance_ID")) {
            return false;
        }
        if (logic != null && logic.length() > 0 && Evaluator.evaluateLogic((Evaluatee)ctx.getCtx(WindowNo), (String)logic)) {
            return true;
        }
        return this.isDisplayed(ctx, WindowNo);
    }

    public boolean isDisplayed(CContext ctx, int WindowNo) {
        if (!this.isDisplayed()) {
            return false;
        }
        String logic = this.getDisplayLogic();
        if (logic == null || logic.equals("")) {
            return true;
        }
        if (ctx != null) {
            boolean retValue = Evaluator.evaluateLogic((Evaluatee)ctx.getCtx(WindowNo), (String)logic);
            log.finest(this.getColumnName() + " (" + logic + ") => " + retValue);
            return retValue;
        }
        return true;
    }

    public boolean isEditable(CContext ctx, int WindowNo, UITab tab, boolean inserting) {
        if (this.isVirtualColumn()) {
            return false;
        }
        String columnName = this.getColumnName();
        int displayType = this.getAD_Reference_ID();
        if (columnName.equals("Posted") || columnName.equals("Record_ID") && displayType == 28) {
            return true;
        }
        if (this.isAlwaysUpdateable()) {
            return true;
        }
        if (tab.isReadOnly() || this.isReadOnly()) {
            log.finest(columnName + " NO - TabRO=" + tab.isReadOnly() + ", FieldRO=" + this.isReadOnly());
            return false;
        }
        if (!this.isUpdateable() && !inserting) {
            log.finest(columnName + " NO - FieldUpdateable=" + this.isUpdateable());
            return false;
        }
        String linkColumn = tab.getLinkColumnName();
        if (columnName.equals(linkColumn)) {
            log.finest(columnName + " NO - LinkColumn");
            return false;
        }
        if (ctx != null) {
            int AD_Client_ID = ctx.getAD_Client_ID(WindowNo);
            int AD_Org_ID = ctx.getAD_Org_ID(WindowNo);
            String keyColumn = tab.getKeyColumnName();
            if ("EntityType".equals(keyColumn)) {
                keyColumn = "AD_EntityType_ID";
            }
            if (!keyColumn.endsWith("_ID")) {
                keyColumn = keyColumn + "_ID";
            }
            int Record_ID = ctx.getContextAsInt(keyColumn);
            int AD_Table_ID = this.getAD_Table_ID();
            MRole role = MRole.getDefault(ctx, false);
            if (!role.canUpdate(AD_Client_ID, AD_Org_ID, AD_Table_ID, Record_ID, false)) {
                return false;
            }
            if (!role.isColumnAccess(AD_Table_ID, this.getAD_Column_ID(), false)) {
                return false;
            }
        }
        String logic = this.getReadOnlyLogic();
        if (ctx != null && logic != null && logic.length() > 0) {
            boolean retValue = !Evaluator.evaluateLogic((Evaluatee)ctx.getCtx(WindowNo), (String)logic);
            log.finest(columnName + " R/O(" + logic + ") => R/W-" + retValue);
            if (!retValue) {
                return false;
            }
        }
        if (columnName.equals("Processing") || columnName.equals("DocAction") || columnName.equals("GenerateTo")) {
            return true;
        }
        if (ctx != null && (ctx.isProcessed(WindowNo) || ctx.isProcessing(WindowNo))) {
            return false;
        }
        if (columnName.equals("IsActive")) {
            return true;
        }
        if (ctx != null && !ctx.isActive(WindowNo)) {
            return false;
        }
        return this.isDisplayed(ctx, WindowNo);
    }

    public boolean isColumnAccess(Ctx ctx) {
        MRole role = MRole.getDefault(ctx, false);
        return role.isColumnAccess(this.getAD_Table_ID(), this.getAD_Column_ID(), false);
    }

    public boolean isLookup() {
        boolean retValue = false;
        int displayType = this.getAD_Reference_ID();
        if (this.isKey()) {
            retValue = false;
        } else if (DisplayType.isLookup((int)displayType)) {
            retValue = true;
        } else if (displayType == 21 || displayType == 31 || displayType == 25 || displayType == 35) {
            retValue = true;
        }
        return retValue;
    }

    public boolean initialize(CContext ctx, int WindowNo) {
        boolean retValue = this.createLookup(ctx, WindowNo);
        this.createDependsOnLists();
        log.finer(this.toString());
        return retValue;
    }

    private boolean createLookup(CContext ctx, int WindowNo) {
        if (!this.isLookup()) {
            return false;
        }
        String columnName = this.getColumnName();
        int displayType = this.getAD_Reference_ID();
        log.config("(" + columnName + ")");
        if (DisplayType.isLookup((int)displayType)) {
            MLookup ml = new MLookup(ctx, WindowNo, displayType);
            MLookupInfo lookupInfo = MLookupFactory.getLookupInfo(ml, this.getAD_Column_ID(), Env.getLanguage(ctx), columnName, this.getAD_Reference_Value_ID(), this.isParent(), this.getValidationCode());
            if (lookupInfo == null) {
                log.warning("(" + columnName + ") - No LookupInfo");
                return false;
            }
            if (displayType == 18 && (columnName.equals("CreatedBy") || columnName.equals("UpdatedBy"))) {
                lookupInfo.IsCreadedUpdatedBy = true;
                ml.setDisplayType(30);
            }
            lookupInfo.IsKey = this.isKey();
            this.m_lookupInfo = lookupInfo;
            this.m_lookup = ml.initialize(lookupInfo);
        } else if (displayType == 21) {
            MLocationLookup ml = new MLocationLookup(ctx, WindowNo);
            this.m_lookup = ml;
        } else if (displayType == 31) {
            MLookupInfo lookupInfo;
            MLocatorLookup ml = new MLocatorLookup(ctx, WindowNo);
            this.m_lookupInfo = lookupInfo = MLookupFactory.getLookupInfo(ml, this.getAD_Column_ID(), Env.getLanguage(ctx), columnName, this.getAD_Reference_Value_ID(), this.isParent(), this.getValidationCode());
            this.m_lookup = ml;
        } else if (displayType == 25) {
            MAccountLookup ma = new MAccountLookup(ctx, WindowNo);
            this.m_lookup = ma;
        } else if (displayType == 35) {
            MPAttributeLookup pa = new MPAttributeLookup(ctx, WindowNo);
            this.m_lookup = pa;
        }
        return this.m_lookup != null;
    }

    private void createDependsOnLists() {
        String displayLogic = this.getDisplayLogic();
        String readOnlyLogic = this.getReadOnlyLogic();
        String mandatoryLogic = this.getMandatoryLogic();
        String columnName = this.getColumnName();
        if (columnName.equals("M_AttributeSetInstance_ID")) {
            this.m_dependsOnValue.add("M_Product_ID");
        } else if (columnName.equals("M_Locator_ID") || columnName.equals("M_LocatorTo_ID")) {
            this.m_dependsOnValue.add("M_Product_ID");
            this.m_dependsOnValue.add("M_Warehouse_ID");
        }
        if (this.m_lookup != null) {
            Evaluator.parseDepends(this.m_dependsOnValue, (String)this.m_lookup.getValidation());
        }
        Evaluator.parseDepends(this.m_dependsOnUI, (String)displayLogic);
        Evaluator.parseDepends(this.m_dependsOnUI, (String)readOnlyLogic);
        Evaluator.parseDepends(this.m_dependsOnUI, (String)mandatoryLogic);
        if (CLogMgt.isLevelFiner()) {
            if (this.m_dependsOnValue.size() > 0) {
                log.finer("(" + columnName + ") Value " + this.m_dependsOnValue.toString());
            }
            if (this.m_dependsOnUI.size() > 0) {
                log.finer("(" + columnName + ") UI - " + this.m_dependsOnUI.toString());
            }
        }
    }

    public void lookupLoadComplete() {
        if (this.m_lookup == null) {
            return;
        }
        this.m_lookup.loadComplete();
    }

    public ArrayList<NamePair> getLookupData(Ctx ctx, int windowNo, boolean refresh) {
        if (this.m_lookup == null) {
            return null;
        }
        boolean onlyValidated = true;
        boolean onlyActive = true;
        boolean temporary = true;
        this.m_lookup.setContext(ctx, windowNo);
        if (refresh) {
            this.m_lookup.refresh();
        }
        this.m_lookup.fillComboBox(this.isMandatory(), onlyValidated, onlyActive, temporary);
        ArrayList<Object> list = this.m_lookup.getData(this.isMandatory(), onlyValidated, onlyActive, temporary);
        if (list == null) {
            log.warning("No Values: " + this.getColumnName());
            list = new ArrayList();
        } else {
            log.finest("#" + list.size());
        }
        return list;
    }

    public Lookup getLookup() {
        return this.m_lookup;
    }

    public MLookupInfo getLookupInfo() {
        return this.m_lookupInfo;
    }

    public String getLookupDisplay(CContext ctx, int windowNo, String key) {
        return this.getLookupDisplay(ctx, windowNo, key, true);
    }

    public String getLookupDisplay(CContext ctx, int windowNo, String key, boolean cache) {
        if (this.m_lookup == null) {
            return null;
        }
        Object lookupKey = key;
        if (key == null || key.length() == 0) {
            return null;
        }
        if (this.getColumnName().endsWith("_ID")) {
            lookupKey = new Integer(key);
        }
        this.m_lookup.setContext(ctx, windowNo);
        NamePair pp = this.m_lookup.getDirect(lookupKey, false, cache);
        if (pp != null) {
            return pp.getName();
        }
        return null;
    }

    public Object getDefault(CContext ctx, int WindowNo, UITab tab) {
        int AD_Window_ID;
        int displayType = this.getAD_Reference_ID();
        String DefaultValue = this.getDefaultValue();
        String ColumnName = this.getColumnName();
        if (this.isKey() || displayType == 26 || DisplayType.isLOB((int)displayType)) {
            return null;
        }
        if (this.isParentValue(tab) && (DefaultValue == null || DefaultValue.length() == 0)) {
            String parent = ctx.getContext(WindowNo, ColumnName);
            log.fine("[Parent] " + ColumnName + "=" + parent);
            return this.createDefault(ColumnName, parent);
        }
        if (ColumnName.equals("IsActive")) {
            log.fine("[IsActive] " + ColumnName + "=Y");
            return "Y";
        }
        String AccessLevel = tab.getAccessLevel();
        if ("4".equals(AccessLevel) && (ColumnName.equals("AD_Client_ID") || ColumnName.equals("AD_Org_ID"))) {
            log.fine("[SystemAccess] " + ColumnName + "=0");
            return new Integer(0);
        }
        if ("6".equals(AccessLevel) && ColumnName.equals("AD_Org_ID")) {
            log.fine("[ClientAccess] " + ColumnName + "=0");
            return new Integer(0);
        }
        String defStr = "";
        if (DefaultValue.startsWith("@SQL=")) {
            String sql0 = DefaultValue.substring(5);
            String sql = Env.parseContext(ctx, WindowNo, sql0, false, true);
            String sqlTest = sql.toUpperCase();
            if (sqlTest.indexOf("DELETE ") != -1 && sqlTest.indexOf("UPDATE ") != -1 && sqlTest.indexOf("DROP ") != -1) {
                sql = "";
            }
            if (sql.equals("")) {
                log.log(Level.WARNING, "(" + ColumnName + ") - Default SQL variable parse failed: " + DefaultValue);
            } else {
                try {
                    CPreparedStatement stmt = DB.prepareStatement(sql, null);
                    ResultSet rs = stmt.executeQuery();
                    if (rs.next()) {
                        defStr = rs.getString(1);
                    } else {
                        log.log(Level.WARNING, "(" + ColumnName + ") - no Result: " + sql);
                    }
                    rs.close();
                    stmt.close();
                }
                catch (SQLException e) {
                    if (sql.endsWith("=")) {
                        log.log(Level.SEVERE, "(" + ColumnName + ") " + sql0, e);
                    }
                    log.log(Level.WARNING, "(" + ColumnName + ") " + sql, e);
                }
            }
            if (defStr != null && defStr.length() > 0) {
                log.fine("[SQL] " + ColumnName + "=" + defStr);
                return this.createDefault("", defStr);
            }
        }
        if (!DefaultValue.equals("") && !DefaultValue.startsWith("@SQL=")) {
            defStr = "";
            StringTokenizer st = new StringTokenizer(DefaultValue, ",;", false);
            while (st.hasMoreTokens()) {
                String variable = st.nextToken().trim();
                if (variable.equals("@SysDate@")) {
                    return new Timestamp(System.currentTimeMillis());
                }
                defStr = variable.indexOf(64) != -1 ? ctx.getContext(WindowNo, variable.replace('@', ' ').trim()) : (defStr.indexOf("'") != -1 ? variable.replace('\'', ' ').trim() : variable);
                if (defStr.length() <= 0) continue;
                log.fine("[DefaultValue] " + ColumnName + "=" + defStr);
                return this.createDefault(variable, defStr);
            }
        }
        if (!(defStr = Env.getPreference(ctx, AD_Window_ID = tab.getAD_Window_ID(), ColumnName, false)).equals("")) {
            log.fine("[UserPreference] " + ColumnName + "=" + defStr);
            return this.createDefault("", defStr);
        }
        defStr = Env.getPreference(ctx, AD_Window_ID, ColumnName, true);
        if (!defStr.equals("")) {
            log.fine("[SystemPreference] " + ColumnName + "=" + defStr);
            return this.createDefault("", defStr);
        }
        if (displayType == 28 && !ColumnName.endsWith("_ID")) {
            log.fine("[Button=N] " + ColumnName);
            return "N";
        }
        if (displayType == 20) {
            log.fine("[YesNo=N] " + ColumnName);
            return "N";
        }
        if (ColumnName.endsWith("_ID")) {
            log.fine("[ID=null] " + ColumnName);
            return null;
        }
        if (DisplayType.isNumeric((int)displayType)) {
            log.fine("[Number=0] " + ColumnName);
            return this.createDefault("", "0");
        }
        log.fine("[NONE] " + ColumnName);
        return null;
    }

    /*
     * Exception decompiling
     */
    private Object createDefault(String variable, String value) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getDefaultAsString(CContext ctx, int WindowNo, UITab tab) {
        Object retValue = this.getDefault(ctx, WindowNo, tab);
        return this.convertToString(retValue);
    }

    public BigDecimal convertToBigDecimal(String stringValue) {
        if (stringValue == null) {
            return null;
        }
        int displayType = this.getAD_Reference_ID();
        if (!DisplayType.isNumeric((int)displayType)) {
            log.warning(this.getColumnName() + " not BigDecimal (" + stringValue + ")");
            return null;
        }
        try {
            return new BigDecimal(stringValue);
        }
        catch (Exception e) {
            log.warning(this.getColumnName() + ": " + stringValue + " - " + e.toString());
            return null;
        }
    }

    public int convertToInteger(String stringValue) {
        if (stringValue == null) {
            return 0;
        }
        int displayType = this.getAD_Reference_ID();
        if (!DisplayType.isID((int)displayType) && displayType != 11) {
            log.warning(this.getColumnName() + " not Integer (" + stringValue + ")");
            return 0;
        }
        try {
            return Integer.parseInt(stringValue);
        }
        catch (Exception e) {
            log.warning(this.getColumnName() + ": " + stringValue + " - " + e.toString());
            return 0;
        }
    }

    public Timestamp convertToTimestamp(String stringValue) {
        if (stringValue == null) {
            return null;
        }
        int displayType = this.getAD_Reference_ID();
        if (!DisplayType.isDate((int)displayType)) {
            log.warning(this.getColumnName() + " not Date (" + stringValue + ")");
            return null;
        }
        try {
            long time = Long.parseLong(stringValue);
            return new Timestamp(time);
        }
        catch (Exception e) {
            try {
                return Timestamp.valueOf(stringValue);
            }
            catch (Exception e2) {
                log.warning(this.getColumnName() + ": " + stringValue + " - " + e2.toString());
                return null;
            }
        }
    }

    public String convertToString(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Date) {
            long time = ((Date)value).getTime();
            return String.valueOf(time);
        }
        if (value instanceof Boolean) {
            if (value.equals(Boolean.FALSE)) {
                return "N";
            }
            return "Y";
        }
        return value.toString();
    }

    public boolean isParentValue(UITab tab) {
        if (this.m_parentValue != null) {
            return this.m_parentValue;
        }
        if (!DisplayType.isID((int)this.getAD_Reference_ID()) || tab.getTabNo() == 0) {
            this.m_parentValue = Boolean.FALSE;
        } else {
            String LinkColumnName = tab.getLinkColumnName();
            String ColumnName = this.getColumnName();
            this.m_parentValue = LinkColumnName.length() == 0 ? Boolean.FALSE : new Boolean(ColumnName.equals(LinkColumnName));
        }
        return this.m_parentValue;
    }

    public ArrayList<String> getDependsOnUI() {
        return this.m_dependsOnUI;
    }

    public ArrayList<String> getDependsOnValue() {
        return this.m_dependsOnValue;
    }

    public boolean isDependentUI() {
        return this.m_dependsOnUI.size() > 0;
    }

    public boolean isDependentValue() {
        return this.m_dependsOnValue.size() > 0;
    }

    protected void addImpactsUIColumn(String columnName) {
        if (columnName != null && columnName.length() > 0 && !this.m_impactsUI.contains(columnName)) {
            this.m_impactsUI.add(columnName);
        }
    }

    public ArrayList<String> getImpactsUI() {
        return this.m_impactsUI;
    }

    protected void addImpactsValueColumn(String columnName) {
        if (columnName != null && columnName.length() > 0 && !this.m_impactsValue.contains(columnName)) {
            this.m_impactsValue.add(columnName);
        }
    }

    public ArrayList<String> getImpactsValue() {
        return this.m_impactsValue;
    }

    protected void setImpactsUITab(boolean impacts) {
        this.m_impactsUITab = impacts;
    }

    public boolean isImpactsUITab() {
        return this.m_impactsUITab;
    }

    public boolean isImpactsValue() {
        String callOut = this.getCallout();
        return this.m_impactsValue.size() > 0 || this.isCallout() || callOut != null && callOut.length() > 0;
    }

    public boolean isImpactsUI() {
        return this.m_impactsUI.size() > 0;
    }

    public String validateValueAsString(String oldValue, String newValue) {
        if (newValue == null && this.isMandatoryUI() && oldValue != null) {
            return oldValue;
        }
        if (newValue == null) {
            return null;
        }
        return newValue;
    }

    public String getLabel() {
        String s = this.getName();
        s = Util.cleanMnemonic(s);
        return s;
    }

    protected boolean isCreateMnemonic() {
        String columnName = this.getColumnName();
        return !this.isReadOnly() && !columnName.equals("AD_Client_ID") && !columnName.equals("AD_Org_ID") && !columnName.equals("DocumentNo");
    }

    public char getMnemonic() {
        return this.m_mnemonic;
    }

    protected void setMnemonic(char mnemonic) {
        this.m_mnemonic = mnemonic;
    }

    public void setError(boolean error) {
        this.m_error = error;
    }

    public boolean isError() {
        return this.m_error;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("UIField[").append(this.getAD_Field_ID()).append("-").append(this.getColumnName());
        if (this.m_lookup != null) {
            sb.append(";").append(this.m_lookup.toString());
        }
        if (this.isKey()) {
            sb.append("(Key)");
        }
        if (this.m_parentValue != null && this.m_parentValue.booleanValue()) {
            sb.append("(Parent)");
        }
        sb.append("]");
        return sb.toString();
    }
}

