/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.controller;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.compiere.api.CalloutInterface;
import org.compiere.common.ChangeVO;
import org.compiere.common.QueryRestrictionVO;
import org.compiere.common.QueryVO;
import org.compiere.common.constants.Build;
import org.compiere.controller.UIField;
import org.compiere.controller.UITabVO;
import org.compiere.framework.Lookup;
import org.compiere.framework.PO;
import org.compiere.framework.Query;
import org.compiere.framework.QueryRestriction;
import org.compiere.model.MLocatorLookup;
import org.compiere.model.MRole;
import org.compiere.model.MSession;
import org.compiere.model.MTable;
import org.compiere.model.MUserQuery;
import org.compiere.util.CContext;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Evaluator;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.ValueNamePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UITab
extends UITabVO {
    private int m_tabNo = 0;
    private String[] m_columnNames = null;
    private ArrayList<String> m_keyColumns = null;
    private int m_keyColumnPos = -1;
    private ArrayList<String> m_parentColumns = null;
    private ArrayList<String> m_identifierColumns = null;
    private ArrayList<String> m_selectionColumns = null;
    private ArrayList<String> m_summaryColumns = null;
    private String[] m_orderBys = new String[3];
    private ArrayList<String> m_dependsOnUI = new ArrayList();
    private ArrayList<Character> m_mnemonics = new ArrayList(30);
    private boolean m_isSOTrx = true;
    private static CLogger log = CLogger.getCLogger(UITab.class);
    HashMap<String, ArrayList<String>> m_allDependents = new HashMap();

    public UITab(UITabVO vo) {
        super(vo);
    }

    public int getTabNo() {
        return this.m_tabNo;
    }

    public ArrayList<String> getSavedQueryNames(int AD_Client_ID) {
        return MUserQuery.getSavedQueryNames(AD_Client_ID, this.getAD_Tab_ID());
    }

    public ArrayList<String> getSavedQueryNamesForUser(int AD_User_ID) {
        return MUserQuery.getSavedQueryNamesForUser(AD_User_ID, this.getAD_Tab_ID());
    }

    protected void initialize(ArrayList<UIField> fields, ArrayList<UITab> previousTabs, CContext ctx, int windowNo, int tabNo, boolean isSOTrx) {
        log.fine(this.toString());
        this.m_columnNames = null;
        this.m_tabNo = tabNo;
        this.m_isSOTrx = isSOTrx;
        if (fields == null) {
            this.p_vos = null;
        } else {
            this.p_vos = new ArrayList(fields.size());
            ctx.setIsSOTrx(windowNo, isSOTrx);
            for (int i = 0; i < fields.size(); ++i) {
                UIField field = fields.get(i);
                field.initialize(ctx, windowNo);
                field.getLookupData(ctx, windowNo, false);
                this.p_vos.add(field);
            }
        }
        this.createColumnLists();
        this.createFieldMnemonics();
        if (this.isDetailTab()) {
            String linkColumnName = this.getLinkColumnName();
            if (linkColumnName == null || linkColumnName.length() == 0) {
                ArrayList<String> parents = this.getParentColumnNames();
                if (parents.size() == 1) {
                    linkColumnName = parents.get(0);
                    this.setLinkColumnName(linkColumnName);
                } else {
                    block1: for (int i = 0; i < previousTabs.size(); ++i) {
                        UITab previousTab = previousTabs.get(i);
                        String previousKeyColumn = previousTab.getKeyColumnName();
                        if (previousTab.getTabLevel() >= this.getTabLevel()) continue;
                        for (int j = 0; j < parents.size(); ++j) {
                            String parentColumnName = parents.get(j);
                            if (!parentColumnName.equals(previousKeyColumn)) continue;
                            linkColumnName = parents.get(j);
                            this.setLinkColumnName(linkColumnName);
                            continue block1;
                        }
                    }
                }
            }
            if (linkColumnName == null || linkColumnName.length() == 0) {
                log.warning("No Link Column: " + this.toString());
            } else {
                log.fine("LinkColumnName=" + linkColumnName);
            }
        }
        this.createDependencyRelations();
    }

    private void createDependencyRelations() {
        UIField field;
        int i;
        Evaluator.parseDepends(this.m_dependsOnUI, (String)this.getDisplayLogic());
        Evaluator.parseDepends(this.m_dependsOnUI, (String)this.getReadOnlyLogic());
        for (i = 0; i < this.m_dependsOnUI.size(); ++i) {
            String impactColumnName = this.m_dependsOnUI.get(i);
            UIField impactField = this.getField(impactColumnName);
            if (impactField == null) {
                log.finer("Not found (TabUI): " + impactColumnName);
                continue;
            }
            impactField.setImpactsUITab(true);
        }
        for (i = 0; i < this.p_vos.size(); ++i) {
            field = (UIField)this.p_vos.get(i);
            String columnName = field.getColumnName();
            ArrayList<String> uis = field.getDependsOnUI();
            for (int j = 0; j < uis.size(); ++j) {
                String impactColumnName = uis.get(j);
                UIField impactField = this.getField(impactColumnName);
                if (impactField == null) {
                    log.finer("Not found (FieldUI): " + impactColumnName);
                    continue;
                }
                impactField.addImpactsUIColumn(columnName);
            }
            ArrayList<String> values = field.getDependsOnValue();
            for (int j = 0; j < values.size(); ++j) {
                String impactColumnName = values.get(j);
                UIField impactField = this.getField(impactColumnName);
                if (impactField == null) {
                    log.finer("Not found (FieldValue): " + impactColumnName);
                    continue;
                }
                impactField.addImpactsValueColumn(columnName);
            }
        }
        if (CLogMgt.isLevelFiner()) {
            for (i = 0; i < this.p_vos.size(); ++i) {
                field = (UIField)this.p_vos.get(i);
                if (field.getImpactsUI().size() > 0) {
                    log.fine(field.getColumnName() + ": UI Impact on: " + field.getImpactsUI());
                }
                if (field.getImpactsValue().size() > 0) {
                    log.fine(field.getColumnName() + ": Value Impact on: " + field.getImpactsValue());
                }
                if (!field.isImpactsUITab()) continue;
                log.fine(field.getColumnName() + ": Tab Impact");
            }
        }
    }

    public ArrayList<String> getDependsOnUI() {
        return this.m_dependsOnUI;
    }

    public ArrayList<UIField> getFields() {
        if (this.p_vos == null) {
            return null;
        }
        ArrayList<UIField> retValue = new ArrayList<UIField>(this.p_vos.size());
        for (int i = 0; i < this.p_vos.size(); ++i) {
            UIField field = (UIField)this.p_vos.get(i);
            retValue.add(field);
        }
        return retValue;
    }

    public UIField getField(String columnName) {
        if (this.p_vos == null) {
            return null;
        }
        for (int i = 0; i < this.p_vos.size(); ++i) {
            UIField field = (UIField)this.p_vos.get(i);
            if (!field.getColumnName().equals(columnName)) continue;
            return field;
        }
        return null;
    }

    public int getFieldIndex(String columnName) {
        if (this.p_vos == null) {
            return -1;
        }
        for (int i = 0; i < this.p_vos.size(); ++i) {
            UIField field = (UIField)this.p_vos.get(i);
            if (!field.getColumnName().equals(columnName)) continue;
            return i;
        }
        return -1;
    }

    public String[] getColumnNames() {
        if (this.m_columnNames == null && this.p_vos != null) {
            this.m_columnNames = new String[this.p_vos.size()];
            for (int i = 0; i < this.p_vos.size(); ++i) {
                UIField field = (UIField)this.p_vos.get(i);
                this.m_columnNames[i] = field.getColumnName();
            }
        }
        return this.m_columnNames;
    }

    public boolean isDetailTab() {
        return this.getAD_Column_ID() != 0 || this.getParentColumnNames().size() > 0;
    }

    public ArrayList<String> getKeyColumnNames() {
        if (this.m_keyColumns == null) {
            this.createColumnLists();
        }
        return this.m_keyColumns;
    }

    public String getKeyColumnName() {
        ArrayList<String> keyColumns = this.getKeyColumnNames();
        int size = keyColumns.size();
        if (size == 0) {
            log.warning("None - " + this.toString());
            return "";
        }
        if (size > 1) {
            log.warning("More than one KeyColumn - " + this.toString());
        }
        return keyColumns.get(0);
    }

    public ArrayList<String> getParentColumnNames() {
        if (this.m_parentColumns == null) {
            this.createColumnLists();
        }
        return this.m_parentColumns;
    }

    public ArrayList<String> getIdentifierColumnNames() {
        if (this.m_identifierColumns == null) {
            this.createColumnLists();
        }
        return this.m_identifierColumns;
    }

    public ArrayList<String> getSelectionColumnNames() {
        if (this.m_selectionColumns == null) {
            this.createColumnLists();
        }
        return this.m_selectionColumns;
    }

    public ArrayList<String> getSummaryColumnNames() {
        if (this.m_summaryColumns == null) {
            this.createColumnLists();
        }
        return this.m_summaryColumns;
    }

    private synchronized void createColumnLists() {
        int i;
        if (this.p_vos == null) {
            return;
        }
        this.m_keyColumns = new ArrayList(2);
        this.m_parentColumns = new ArrayList(2);
        this.m_identifierColumns = new ArrayList();
        this.m_selectionColumns = new ArrayList();
        this.m_summaryColumns = new ArrayList();
        this.m_keyColumnPos = -1;
        int parentColumnPos = -1;
        ArrayList<KeyNamePair> identifierPos = new ArrayList<KeyNamePair>();
        ArrayList<KeyNamePair> selectionPos = new ArrayList<KeyNamePair>();
        ArrayList<KeyNamePair> summaryPos = new ArrayList<KeyNamePair>();
        for (i = 0; i < this.p_vos.size(); ++i) {
            KeyNamePair pp;
            UIField field = (UIField)this.p_vos.get(i);
            String columnName = field.getColumnName();
            if (field.isKey()) {
                this.m_keyColumns = new ArrayList(1);
                this.m_keyColumns.add(columnName);
                if (this.m_keyColumnPos == -1) {
                    this.m_keyColumnPos = i;
                }
            }
            if (field.isParent()) {
                this.m_parentColumns.add(columnName);
                if (parentColumnPos == -1) {
                    parentColumnPos = i;
                }
            }
            if (field.isIdentifier()) {
                pp = new KeyNamePair(field.getSeqNo(), columnName);
                pp.setSortByName(false);
                identifierPos.add(pp);
            }
            if (field.isSelectionColumn()) {
                pp = new KeyNamePair(field.getSelectionSeqNo(), columnName);
                pp.setSortByName(false);
                selectionPos.add(pp);
            } else if (columnName.startsWith("DocumentNo") || columnName.equals("Value") || columnName.equals("Name")) {
                pp = new KeyNamePair(0, columnName);
                pp.setSortByName(false);
                selectionPos.add(pp);
            }
            if (field.isSummaryColumn()) {
                pp = new KeyNamePair(field.getSummarySeqNo(), columnName);
                pp.setSortByName(false);
                summaryPos.add(pp);
            } else if (columnName.startsWith("DocumentNo") || columnName.equals("Value") || columnName.equals("Name")) {
                pp = new KeyNamePair(0, columnName);
                pp.setSortByName(false);
                summaryPos.add(pp);
            }
            BigDecimal sort = field.getSortNo();
            if (sort == null || sort.signum() == 0) continue;
            int index = sort.abs().intValue() - 1;
            if (index < 3) {
                if (this.m_orderBys[index] == null) {
                    this.m_orderBys[index] = columnName;
                    if (sort.signum() >= 0) continue;
                    int n = index;
                    this.m_orderBys[n] = this.m_orderBys[n] + " DESC";
                    continue;
                }
                log.warning("Ignored OrderBy Duplicate Position " + (index + 1) + ": " + columnName + " - " + this.toString());
                continue;
            }
            log.warning("Ignored OrderBy " + columnName + " - " + this.toString());
        }
        if (this.m_keyColumns.size() == 0) {
            this.m_keyColumns = this.m_parentColumns;
            this.m_keyColumnPos = parentColumnPos;
        }
        Collections.sort(identifierPos);
        for (i = 0; i < identifierPos.size(); ++i) {
            this.m_identifierColumns.add(((KeyNamePair)identifierPos.get(i)).getName());
        }
        Collections.sort(selectionPos);
        for (i = 0; i < selectionPos.size(); ++i) {
            this.m_selectionColumns.add(((KeyNamePair)selectionPos.get(i)).getName());
        }
        Collections.sort(summaryPos);
        for (i = 0; i < summaryPos.size(); ++i) {
            this.m_summaryColumns.add(((KeyNamePair)summaryPos.get(i)).getName());
        }
    }

    private void createFieldMnemonics() {
        char mnemonic;
        String text;
        UIField field;
        int i;
        for (i = 0; i < this.p_vos.size(); ++i) {
            field = (UIField)this.p_vos.get(i);
            if (field.isCreateMnemonic()) {
                text = field.getName();
                int pos = text.indexOf(38);
                if (pos == -1 || text.length() <= pos || (mnemonic = text.toUpperCase().charAt(pos + 1)) == ' ') continue;
                if (!this.m_mnemonics.contains(Character.valueOf(mnemonic))) {
                    field.setMnemonic(mnemonic);
                    this.m_mnemonics.add(Character.valueOf(mnemonic));
                    continue;
                }
                log.warning(field.getColumnName() + " - Conflict - Already exists: " + mnemonic + " (" + text + ")");
                continue;
            }
            field.setMnemonic('\u0000');
        }
        for (i = 0; i < this.p_vos.size(); ++i) {
            field = (UIField)this.p_vos.get(i);
            if (field.getMnemonic() != '\u0000') continue;
            String oText = text = field.getName();
            mnemonic = (text = text.trim().toUpperCase()).charAt(0);
            if (this.m_mnemonics.contains(Character.valueOf(mnemonic))) {
                mnemonic = '\u0000';
                int index = text.indexOf(32);
                while (index != -1 && text.length() > index) {
                    char c = text.charAt(index + 1);
                    if (Character.isLetterOrDigit(c) && !this.m_mnemonics.contains(Character.valueOf(c))) {
                        mnemonic = c;
                        break;
                    }
                    index = text.indexOf(32, index + 1);
                }
                if (mnemonic == '\u0000') {
                    for (int j = 1; j < text.length(); ++j) {
                        char c = text.charAt(j);
                        if (!Character.isLetterOrDigit(c) || this.m_mnemonics.contains(Character.valueOf(c))) continue;
                        mnemonic = c;
                        break;
                    }
                }
                if (mnemonic == '\u0000') {
                    log.finest("None for: " + oText);
                }
            }
            if (mnemonic == '\u0000') continue;
            field.setMnemonic(mnemonic);
            this.m_mnemonics.add(Character.valueOf(mnemonic));
        }
    }

    public boolean isSOTrx() {
        return this.m_isSOTrx;
    }

    public int evaluateQuery(QueryVO queryVO, HashMap<String, String> context, CContext ctx) {
        int AD_Role_ID = ctx.getAD_Role_ID();
        int AD_User_ID = ctx.getAD_User_ID();
        MRole role = MRole.get(ctx, AD_Role_ID, AD_User_ID, false);
        String whereClause = this.getWhereClause(queryVO, role, context, ctx, false);
        StringBuffer sql0 = new StringBuffer("SELECT COUNT(*) FROM ").append(this.getTableName()).append(whereClause);
        String sql1 = role.addAccessSQL(sql0.toString(), this.getTableName(), true, false);
        int no = DB.getSQLValue(null, sql1);
        return no;
    }

    public ArrayList<Object[]> executeQuery(QueryVO queryVO, HashMap<String, String> context, CContext ctx) {
        int AD_Role_ID = ctx.getAD_Role_ID();
        MRole role = MRole.get(ctx, AD_Role_ID, ctx.getAD_User_ID(), true);
        String whereClause = this.getWhereClause(queryVO, role, context, ctx, true);
        StringBuffer sql0 = new StringBuffer("SELECT ");
        ArrayList<UIField> fields = this.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            UIField field;
            if (i > 0) {
                sql0.append(",");
            }
            if ((field = fields.get(i)).isVirtualColumn()) {
                sql0.append(field.getColumnSQL()).append(" AS ");
            }
            sql0.append(field.getColumnName());
        }
        sql0.append(" FROM ").append(this.getTableName()).append(whereClause);
        String sql1 = role.addAccessSQL(sql0.toString(), this.getTableName(), true, false);
        ArrayList<Object[]> results = new ArrayList<Object[]>();
        String[] columns = this.getColumnNames();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql1, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Object[] row = new Object[columns.length];
                for (int i = 0; i < columns.length; ++i) {
                    Object oo = rs.getObject(columns[i]);
                    if (oo instanceof Date) {
                        oo = rs.getTimestamp(columns[i]);
                    }
                    row[i] = oo;
                }
                results.add(row);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql1, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (results.size() > 0) {
            MSession session = MSession.get(ctx, true);
            session.queryLog(ctx.getAD_Client_ID(), ctx.getAD_Org_ID(), this.getAD_Table_ID(), whereClause, results.size());
        }
        return results;
    }

    public ArrayList<String[]> executeQueryString(QueryVO queryVO, HashMap<String, String> context, CContext ctx) {
        ArrayList<Object[]> from = this.executeQuery(queryVO, context, ctx);
        ArrayList<String[]> to = new ArrayList<String[]>(from.size());
        for (int i = 0; i < from.size(); ++i) {
            Object[] fromRow = from.get(i);
            to.add(this.convertToString(fromRow));
        }
        return to;
    }

    public String[] convertToString(Object[] fromRow) {
        String[] toRow = new String[fromRow.length];
        for (int i = 0; i < fromRow.length; ++i) {
            long time;
            Object fromValue = fromRow[i];
            if (fromValue == null) {
                toRow[i] = null;
                continue;
            }
            if (fromValue instanceof Timestamp) {
                time = ((Timestamp)fromValue).getTime();
                toRow[i] = String.valueOf(time);
                continue;
            }
            if (fromValue instanceof Date) {
                time = ((Date)fromValue).getTime();
                toRow[i] = String.valueOf(time);
                continue;
            }
            if (fromValue instanceof Boolean) {
                if (((Boolean)fromValue).booleanValue()) {
                    toRow[i] = "Y";
                    continue;
                }
                toRow[i] = "N";
                continue;
            }
            toRow[i] = fromValue.toString();
        }
        return toRow;
    }

    private String getWhereClause(QueryVO queryVO, MRole role, HashMap<String, String> context, CContext ctx, boolean addOrderBy) {
        Query query;
        StringBuffer sb = new StringBuffer();
        if (this.isDetailTab()) {
            String linkColumnName = this.getLinkColumnName();
            if (linkColumnName.length() == 0) {
                log.warning("No LinkColumn - " + this.toString());
                sb.append(" WHERE 2=3");
                return sb.toString();
            }
            String linkColumnValue = context.get(linkColumnName);
            if (linkColumnValue == null) {
                log.warning("No Value for LinkColumn=" + linkColumnName + " - " + this.toString());
                sb.append(" WHERE 2=4");
                return sb.toString();
            }
            if (linkColumnName.endsWith("_ID")) {
                sb.append(" WHERE ").append(linkColumnName).append("=").append(linkColumnValue);
            } else {
                sb.append(" WHERE ").append(linkColumnName).append("='").append(linkColumnValue).append("'");
            }
        }
        int onlyCurrentDays = 0;
        boolean onlyCurrentCreated = true;
        if (queryVO != null && queryVO.onlyCurrentDays > 0) {
            boolean showNotProcessed;
            onlyCurrentDays = queryVO.onlyCurrentDays;
            onlyCurrentCreated = queryVO.onlyCurrentCreated;
            if (sb.length() == 0) {
                sb.append(" WHERE ");
            } else {
                sb.append(" AND ");
            }
            boolean bl = showNotProcessed = this.getField("Processed") != null;
            if (showNotProcessed) {
                sb.append("(Processed='N' OR ");
            }
            if (onlyCurrentCreated) {
                sb.append("Created>=");
            } else {
                sb.append("Updated>=");
            }
            sb.append("addDays(SysDate, -").append(onlyCurrentDays).append(")");
            if (showNotProcessed) {
                sb.append(")");
            }
        } else if (queryVO != null && (query = this.createQuery(ctx, queryVO)) != null && query.isActive()) {
            if (sb.length() == 0) {
                sb.append(" WHERE ");
            } else {
                sb.append(" AND ");
            }
            sb.append(this.validateQuery(query));
        }
        String where = this.getWhereClause();
        if (where != null && where.length() > 0) {
            if (sb.length() == 0) {
                sb.append(" WHERE ");
            } else {
                sb.append(" AND ");
            }
            if (where.indexOf("@") != -1) {
                int windowNo = 111111;
                ctx.addWindow(windowNo, context);
                where = Env.parseContext(ctx, windowNo, where, false);
            }
            sb.append(where);
        }
        if (addOrderBy) {
            sb.append(this.getOrderByClause(onlyCurrentDays, onlyCurrentCreated));
        }
        return sb.toString();
    }

    private Query createQuery(CContext ctx, QueryVO queryVO) {
        if (queryVO == null) {
            return null;
        }
        Query query = null;
        if (queryVO.restrictions != null && queryVO.restrictions.size() > 0) {
            query = new Query(this.getTableName());
            for (int i = 0; i < queryVO.restrictions.size(); ++i) {
                QueryRestrictionVO vo = (QueryRestrictionVO)queryVO.restrictions.get(i);
                Object qCode = DisplayType.convertFromString(vo.DisplayType, vo.Code);
                Object qCode_to = DisplayType.convertFromString(vo.DisplayType, vo.Code_to);
                QueryRestriction restriction = new QueryRestriction(vo.ColumnName, qCode, qCode_to, vo.InfoName, vo.InfoDisplay, vo.InfoDisplay_to, vo.Operator, vo.DirectWhereClause, vo.AndCondition);
                query.addRestriction(restriction);
            }
        }
        if (queryVO.savedQueryName != null && queryVO.savedQueryName.length() > 0 && queryVO.saveQuery && query != null) {
            MUserQuery userQ = MUserQuery.getForUser(ctx, this.getAD_Tab_ID(), queryVO.savedQueryName);
            if (userQ == null) {
                userQ = new MUserQuery((Ctx)ctx, 0, null);
                userQ.setName(queryVO.savedQueryName);
                userQ.setAD_Tab_ID(this.getAD_Tab_ID());
                userQ.setAD_Table_ID(this.getAD_Table_ID());
                userQ.setAD_User_ID(ctx.getAD_User_ID());
            }
            userQ.setCode(query.getWhereClause());
            userQ.save();
        } else if (queryVO.savedQueryName != null && queryVO.savedQueryName.length() > 0) {
            MUserQuery userQ = MUserQuery.get((Ctx)ctx, this.getAD_Tab_ID(), queryVO.savedQueryName);
            if (userQ == null) {
                log.warning("SavedQuery nor found: " + queryVO.savedQueryName + " - " + this.toString());
            } else {
                query = new Query(this.getTableName());
                query.addRestriction(userQ.getCode());
            }
        }
        return query;
    }

    private String getOrderByClause(int currentDays, boolean currentCreated) {
        StringBuffer ob = new StringBuffer(" ORDER BY ");
        String order = super.getOrderByClause();
        if (order != null && order.length() > 0) {
            return ob.append(order).toString();
        }
        StringBuffer fieldOrder = new StringBuffer();
        for (int i = 0; i < 3; ++i) {
            order = this.m_orderBys[i];
            if (order == null || order.length() <= 0) continue;
            if (fieldOrder.length() > 0) {
                fieldOrder.append(",");
            }
            fieldOrder.append(order);
        }
        if (fieldOrder.length() > 0) {
            this.setOrderByClause(fieldOrder.toString());
            return ob.append(fieldOrder).toString();
        }
        if (currentDays > 0) {
            if (currentCreated) {
                ob.append("Created DESC");
            } else {
                ob.append("Updated DESC");
            }
            return ob.toString();
        }
        log.warning("No OrderBy - " + this.toString());
        return "";
    }

    private String validateQuery(Query query) {
        if (query == null || query.getRestrictionCount() == 0) {
            return null;
        }
        if (query.getRestrictionCount() != 1) {
            log.fine("Ignored(More than 1 Restriction): " + query);
            return query.getWhereClause();
        }
        String colName = query.getColumnName(0);
        if (colName == null) {
            log.fine("Ignored(No Column): " + query);
            return query.getWhereClause();
        }
        if (colName.indexOf(40) != -1) {
            log.fine("Ignored(Function): " + colName);
            return query.getWhereClause();
        }
        String refColName = null;
        if (colName.equals("R_RequestRelated_ID")) {
            refColName = "R_Request_ID";
        } else if (colName.startsWith("C_DocType")) {
            refColName = "C_DocType_ID";
        } else if (colName.equals("Orig_Order_ID")) {
            refColName = "C_Order_ID";
        } else if (colName.equals("Orig_InOut_ID")) {
            refColName = "M_InOut_ID";
        }
        if (refColName != null) {
            query.setColumnName(0, refColName);
            if (this.getField(refColName) != null) {
                log.fine("Column " + colName + " replaced with synonym " + refColName);
                return query.getWhereClause();
            }
            refColName = null;
        }
        if (this.getField(colName) != null) {
            log.fine("Field Found: " + colName);
            return query.getWhereClause();
        }
        String sql = "SELECT cc.ColumnName FROM AD_Column c INNER JOIN AD_Ref_Table r ON (c.AD_Reference_Value_ID=r.AD_Reference_ID) INNER JOIN AD_Column cc ON (r.Column_Key_ID=cc.AD_Column_ID) WHERE c.AD_Reference_ID IN (18,30) AND c.ColumnName=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setString(1, colName);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                refColName = rs.getString(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "(ref) - Column=" + colName, e);
            return query.getWhereClause();
        }
        if (refColName != null) {
            query.setColumnName(0, refColName);
            if (this.getField(refColName) != null) {
                log.fine("Column " + colName + " replaced with " + refColName);
                return query.getWhereClause();
            }
            colName = refColName;
        }
        String tableName = null;
        String tabKeyColumn = this.getKeyColumnName();
        sql = "SELECT t.TableName FROM AD_Column c INNER JOIN AD_Table t ON (c.AD_Table_ID=t.AD_Table_ID) WHERE c.ColumnName=? AND IsKey='Y' AND EXISTS (SELECT * FROM AD_Column cc WHERE cc.AD_Table_ID=t.AD_Table_ID AND cc.ColumnName=?)";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setString(1, colName);
            pstmt.setString(2, tabKeyColumn);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                tableName = rs.getString(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Column=" + colName + ", Key=" + tabKeyColumn, e);
            return null;
        }
        if (tabKeyColumn.equals("AD_Reference_ID")) {
            sql = "SELECT AD_Reference_ID FROM AD_Column WHERE ColumnName=?";
            int AD_Reference_ID = DB.getSQLValue(null, sql, colName);
            return "AD_Reference_ID=" + AD_Reference_ID;
        }
        if (tableName == null) {
            log.info("Not successfull - Column=" + colName + ", Key=" + tabKeyColumn + ", Query=" + query);
            return query.getWhereClause();
        }
        query.setTableName("xx");
        StringBuffer result = new StringBuffer("EXISTS (SELECT * FROM ").append(tableName).append(" xx WHERE ").append(query.getWhereClause(true)).append(" AND xx.").append(tabKeyColumn).append("=").append(this.getTableName()).append(".").append(tabKeyColumn).append(")");
        log.fine(result.toString());
        return result.toString();
    }

    private ArrayList<String> getUpdatedFieldsByOthers(PO po, String[] cachedRow) {
        ArrayList<String> conflictedFields = new ArrayList<String>();
        int size = this.p_vos.size();
        for (int i = 0; i < size; ++i) {
            String v;
            UIField field = (UIField)this.p_vos.get(i);
            String colName = field.getColumnName();
            if (colName.startsWith("Created") || colName.startsWith("Updated") || colName.equals("IsActive") || colName.equals("AD_Client_ID") || colName.equals("AD_Org_ID")) continue;
            String string = v = cachedRow[i] == null ? "" : cachedRow[i];
            if (v.equals(po.get_ValueAsString(colName))) continue;
            conflictedFields.add(colName);
        }
        return conflictedFields;
    }

    public ChangeVO saveRow(CContext ctx, int windowNo, boolean newRecord) {
        return this.saveRow(ctx, windowNo, newRecord, null);
    }

    public ChangeVO saveRow(CContext ctx, int windowNo, boolean newRecord, String[] cachedRow) {
        ArrayList<String> fields;
        String error = this.checkReadOnly(ctx, windowNo);
        if (error != null) {
            return new ChangeVO(true, Msg.parseTranslation(ctx, error));
        }
        error = this.checkMandatory(ctx, windowNo);
        if (error != null) {
            return new ChangeVO(true, Msg.parseTranslation(ctx, error));
        }
        PO po = this.getPO(ctx, windowNo, newRecord);
        Map<String, String> windowMap = ctx.getMap(windowNo);
        windowMap.remove("CreatedBy");
        windowMap.remove("UpdatedBy");
        windowMap.remove("CreatedOn");
        windowMap.remove("UpdatedOn");
        int size = this.p_vos.size();
        for (int i = 0; i < size; ++i) {
            String colName;
            UIField field = (UIField)this.p_vos.get(i);
            if (!field.isEncryptedField() && !field.isEncryptedColumn() && !"Password".equals(field.getColumnName()) || windowMap.get(colName = field.getColumnName()) != null && windowMap.get(colName).length() != 0) continue;
            windowMap.remove(colName);
        }
        if (!newRecord && cachedRow != null && (fields = this.getUpdatedFieldsByOthers(po, cachedRow)).size() > 0) {
            ChangeVO c = new ChangeVO(true, "Please refresh the row. The following fileds are updated by others:" + fields);
            return c;
        }
        if (po == null) {
            return new ChangeVO(true, Msg.getMsg(ctx, "Error") + " - No PO for " + this.toString());
        }
        error = po.update(windowMap);
        if (error != null) {
            return new ChangeVO(true, Msg.getMsg(ctx, "Error") + " - " + error);
        }
        if (!po.save()) {
            ChangeVO change = new ChangeVO(true, Msg.getMsg(ctx, "NotSaved"));
            ValueNamePair e = CLogger.retrieveError();
            change.addError(Msg.getMsg((Ctx)ctx, e.getID(), e.getName()));
            Exception ex = CLogger.retrieveException();
            if (ex != null) {
                if (ex.getCause() != null) {
                    change.addError(ex.getCause().getLocalizedMessage());
                } else {
                    change.addError(ex.getLocalizedMessage());
                }
            }
            return change;
        }
        ChangeVO retValue = new ChangeVO(Msg.getMsg(ctx, "Saved"));
        po.load((String)null);
        this.addLog(ctx, retValue);
        retValue.rowData = po.get_ValuesAsString(this.getColumnNames());
        return retValue;
    }

    private void addLog(CContext ctx, ChangeVO change) {
        ValueNamePair p = CLogger.retrieveWarning();
        if (p != null) {
            change.addWarning(Msg.getMsg((Ctx)ctx, p.getID(), p.getName()));
        }
        if ((p = CLogger.retrieveInfo()) != null) {
            change.addSuccess(Msg.getMsg((Ctx)ctx, p.getID(), p.getName()));
        }
    }

    public ChangeVO refreshRow(CContext ctx, int windowNo) {
        PO po = this.getPO(ctx, windowNo, false);
        if (po == null) {
            ChangeVO c = new ChangeVO(false, "No PO for " + this.toString());
            c.rowData = new String[this.m_columnNames.length];
            for (int i = 0; i < c.rowData.length; ++i) {
                c.rowData[i] = null;
            }
            return c;
        }
        ChangeVO retValue = new ChangeVO();
        retValue.rowData = po.get_ValuesAsString(this.getColumnNames());
        return retValue;
    }

    public ChangeVO deleteRow(CContext ctx, int windowNo) {
        String error = this.checkReadOnly(ctx, windowNo);
        if (error != null) {
            return new ChangeVO(true, error);
        }
        PO po = this.getPO(ctx, windowNo, false);
        if (po == null) {
            return new ChangeVO(true, Msg.getMsg(ctx, "Error") + " - No PO for " + this.toString());
        }
        if (!po.delete(false)) {
            ValueNamePair e = CLogger.retrieveError();
            ChangeVO change = new ChangeVO(true, Msg.getMsg((Ctx)ctx, e.getID(), e.getName()));
            return change;
        }
        ChangeVO retValue = new ChangeVO(Msg.getMsg(ctx, "Deleted"));
        this.addLog(ctx, retValue);
        return retValue;
    }

    public ChangeVO newRow(CContext ctx, int windowNo) {
        String key;
        UIField field;
        int i;
        HashMap<String, String> changedValues;
        int size = this.p_vos.size();
        ChangeVO retValue = new ChangeVO();
        retValue.changedFields = changedValues = new HashMap<String, String>();
        for (i = 0; i < size; ++i) {
            field = (UIField)this.p_vos.get(i);
            key = field.getColumnName();
            String value = field.getDefaultAsString(ctx, windowNo, this);
            if (field.isKey() && field.getColumnName().endsWith("_ID")) {
                value = "0";
            }
            changedValues.put(key, value);
        }
        if (Build.isDebug()) {
            log.info("changed values are  before callout:" + changedValues);
        }
        ctx.setContext(windowNo, changedValues);
        for (i = 0; i < size; ++i) {
            field = (UIField)this.p_vos.get(i);
            if (!field.isCallout() && (field.getCallout() == null || field.getCallout().length() <= 0)) continue;
            key = field.getColumnName();
            String newValue = (String)changedValues.get(key);
            ChangeVO calloutChange = this.processCallout(ctx, windowNo, field, null, newValue);
            if (Build.isDebug()) {
                log.info("After callout for " + field.getColumnName() + " the change is" + calloutChange);
            }
            if (calloutChange != null) {
                ctx.setContext(windowNo, calloutChange.changedContext);
                ctx.setContext(windowNo, calloutChange.changedFields);
            }
            retValue.addAll(calloutChange);
        }
        if (Build.isDebug()) {
            log.info("field values are  after callout:" + retValue.changedFields);
        }
        return retValue;
    }

    private PO getPO(CContext ctx, int windowNo, boolean newRecord) {
        MTable table = MTable.get((Ctx)ctx, this.getAD_Table_ID());
        if (newRecord) {
            return table.getPO((Ctx)ctx, 0, null);
        }
        ArrayList<String> keys = this.getKeyColumnNames();
        if (keys.size() < 1) {
            log.config("No Keys for " + this.toString());
            return null;
        }
        if (keys.size() == 1) {
            String keyColumn = keys.get(0);
            String stringID = ctx.getContext(windowNo, keyColumn);
            if (stringID == null || stringID.length() == 0) {
                log.config("@NotFound@ " + keyColumn + " - " + this.toString());
                if (keyColumn.endsWith("_ID")) {
                    stringID = "0";
                } else {
                    return null;
                }
            }
            if (keyColumn.endsWith("_ID")) {
                int Record_ID = Integer.parseInt(stringID);
                if (Record_ID == 0) {
                    PO po = table.getPO(ctx, Record_ID, null, false);
                    return po;
                }
                PO po = table.getPO((Ctx)ctx, Record_ID, null);
                return po;
            }
            StringBuffer where = new StringBuffer(keyColumn).append("='").append(stringID).append("'");
            PO po = table.getPO((Ctx)ctx, where.toString(), null);
            return po;
        }
        StringBuffer where = new StringBuffer();
        for (int i = 0; i < keys.size(); ++i) {
            String keyColumn = keys.get(i);
            String stringID = ctx.getContext(windowNo, keyColumn);
            if (stringID == null || stringID.length() == 0) {
                log.config("@NotFound@ " + keyColumn + " - " + this.toString());
                return null;
            }
            if (i > 0) {
                where.append(" AND ");
            }
            where.append(keyColumn);
            if (keyColumn.endsWith("_ID")) {
                where.append("=").append(stringID);
                continue;
            }
            where.append("='").append(stringID).append("'");
        }
        PO po = table.getPO((Ctx)ctx, where.toString(), null);
        return po;
    }

    private String checkReadOnly(CContext ctx, int windowNo) {
        if (this.isReadOnly()) {
            return "@IsReadOnly@";
        }
        int AD_Client_ID = ctx.getAD_Client_ID(windowNo);
        int AD_Org_ID = ctx.getAD_Org_ID(windowNo);
        int Record_ID = ctx.getContextAsInt(windowNo, this.getKeyColumnName());
        boolean createError = true;
        MRole role = MRole.get(ctx, ctx.getAD_Role_ID(), ctx.getAD_User_ID(), false);
        if (!role.canUpdate(AD_Client_ID, AD_Org_ID, this.getAD_Table_ID(), Record_ID, createError)) {
            String errorMsg = "@CannotUpdate@";
            ValueNamePair error = CLogger.retrieveError();
            if (error != null) {
                errorMsg = Msg.getMsg((Ctx)ctx, error.getID(), error.getName());
            }
            return errorMsg;
        }
        String logic = this.getReadOnlyLogic();
        if (logic == null || logic.length() == 0) {
            return null;
        }
        return null;
    }

    private String checkMandatory(CContext ctx, int windowNo) {
        StringBuffer sb = new StringBuffer();
        int size = this.p_vos.size();
        for (int i = 0; i < size; ++i) {
            UIField field = (UIField)this.p_vos.get(i);
            if (!field.isMandatory(ctx, windowNo)) continue;
            String data = ctx.getContext(windowNo, field.getColumnName());
            if (data == null || data.toString().length() == 0 || "NULLValue".equals(data)) {
                field.setError(true);
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append("@").append(field.getName()).append("@");
                continue;
            }
            field.setError(false);
        }
        if (sb.length() == 0) {
            return null;
        }
        sb.insert(0, "@FillMandatory@: ");
        return sb.toString();
    }

    public ChangeVO fieldChanged(CContext ctx, int windowNo, UIField field, String oldValue, String newValue) {
        ChangeVO retValue = new ChangeVO();
        retValue.changedFields = new HashMap();
        retValue.changedDropDowns = new HashMap();
        String columnName = field.getColumnName();
        retValue.newConfirmedFieldValue = field.validateValueAsString(oldValue, newValue);
        retValue.addChangedValue(columnName, (Object)retValue.newConfirmedFieldValue);
        ctx.setContext(windowNo, columnName, retValue.newConfirmedFieldValue);
        if (field.isImpactsValue()) {
            ArrayList<String> impactedColumnNames = field.getImpactsValue();
            for (int i = 0; i < impactedColumnNames.size(); ++i) {
                String oldImpactedValue;
                String impactedColumnName = impactedColumnNames.get(i);
                UIField impactedField = this.getField(impactedColumnName);
                if (impactedField == null) {
                    log.warning(columnName + ": Impact Not found - " + impactedColumnName);
                    continue;
                }
                String newImpactedValue = oldImpactedValue = ctx.getContext(windowNo, impactedColumnName);
                if (impactedField.isLookup()) {
                    Lookup impactedLookup = impactedField.getLookup();
                    if (impactedLookup instanceof MLocatorLookup) {
                        MLocatorLookup locLookup = (MLocatorLookup)impactedLookup;
                        int valueAsInt = 0;
                        if (newValue != null) {
                            try {
                                valueAsInt = Integer.parseInt(newValue);
                            }
                            catch (Exception e) {
                                log.warning("Cannot Parse " + columnName + "=" + newValue);
                            }
                        }
                        if (columnName.equals("M_Warehouse_ID")) {
                            locLookup.setOnly_Warehouse_ID(valueAsInt);
                        }
                        if (columnName.equals("M_Product_ID")) {
                            locLookup.setOnly_Product_ID(valueAsInt);
                        }
                        locLookup.setOnly_Outgoing(ctx.isSOTrx(windowNo));
                        locLookup.refresh();
                        int M_Locator_ID = ctx.getContextAsInt(windowNo, impactedColumnName);
                        if (!locLookup.isValid(new Integer(M_Locator_ID))) {
                            newImpactedValue = null;
                            retValue.addChangedValue(impactedColumnName, (Object)newImpactedValue);
                            ctx.setContext(windowNo, impactedColumnName, newImpactedValue);
                        }
                    } else {
                        ArrayList<NamePair> data = impactedField.getLookupData(ctx, windowNo, false);
                        retValue.addChangedDropDown(impactedColumnName, data);
                        newImpactedValue = null;
                        retValue.addChangedValue(impactedColumnName, (Object)newImpactedValue);
                        ctx.setContext(windowNo, impactedColumnName, newImpactedValue);
                    }
                } else {
                    log.warning(columnName + ": Impact Not Lookup - " + impactedColumnName);
                }
                if (!impactedField.isImpactsValue()) continue;
                UIField impactField = this.getField(impactedColumnName);
                ChangeVO cascadingChange = this.fieldChanged(ctx, windowNo, impactField, oldImpactedValue, newImpactedValue);
                retValue.addAll(cascadingChange);
            }
            ChangeVO calloutChange = this.processCallout(ctx, windowNo, field, oldValue, newValue);
            retValue.addAll(calloutChange);
        }
        return retValue.cleanup();
    }

    private ChangeVO processCallout(CContext ctx, int windowNo, UIField field, String oldValue, String newValue) {
        String callout = field.getCallout();
        if (!field.isCallout() && callout.length() == 0) {
            return null;
        }
        if (ctx.isProcessed(windowNo)) {
            log.warning("record processed. no callout for " + field.getColumnName());
            return null;
        }
        ChangeVO retValue = null;
        if (field.isCallout()) {
            log.fine(field.getColumnName() + "=" + newValue + " - old=" + oldValue);
            retValue = this.processCalloutDirect(ctx, windowNo, field, oldValue, newValue);
            if (callout.length() == 0) {
                return retValue;
            }
        }
        log.info(field.getColumnName() + "=" + newValue + " (" + callout + " IGNORED)");
        return retValue;
    }

    private ChangeVO processCalloutExternal(CContext ctx, int windowNo, UIField field, String oldValue, String newValue, String cmd) {
        ChangeVO retValue = new ChangeVO();
        CalloutInterface call = null;
        String method = null;
        int methodStart = cmd.lastIndexOf(".");
        try {
            if (methodStart != -1) {
                Class<?> cClass = Class.forName(cmd.substring(0, methodStart));
                call = (CalloutInterface)cClass.newInstance();
                method = cmd.substring(methodStart + 1);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Class: " + cmd, e);
            retValue.addError("Callout Invalid: " + cmd + " (" + e.toString() + ")");
            return retValue;
        }
        if (call == null || method == null || method.length() == 0) {
            retValue.addError("No Callout: " + cmd);
            return retValue;
        }
        PO po = this.getPO(ctx, windowNo, false);
        if (po == null) {
            retValue.addError("No PO: (" + this.getKeyColumnName() + ") - " + cmd);
            return retValue;
        }
        try {
            retValue = call.start(ctx, windowNo, po, field, oldValue, newValue, method);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Start: " + cmd, e);
            retValue.addError("Callout Error: " + e.toString());
        }
        return retValue;
    }

    public ChangeVO processCalloutDirect(CContext ctx, int windowNo, UIField field, String oldValue, String newValue) {
        ChangeVO change = new ChangeVO();
        MTable table = MTable.get((Ctx)ctx, this.getAD_Table_ID());
        Map<String, String> context = ctx.getMap(windowNo);
        PO po = null;
        try {
            po = table.getPO(ctx, context);
            po.set_ChangeVO(change);
        }
        catch (Exception e1) {
            change.addError("Cannot create PO - " + e1.getLocalizedMessage());
            log.log(Level.WARNING, "Cannot create PO", e1);
            return change;
        }
        Method method = null;
        String methodName = "set" + field.getColumnName();
        try {
            Class[] params = new Class[]{String.class, String.class, Integer.TYPE};
            method = po.getClass().getMethod(methodName, params);
        }
        catch (Exception e2) {
            String msg = po.getClass() + ": No Method " + methodName;
            change.addError(msg + " - " + e2.getLocalizedMessage());
            log.log(Level.WARNING, msg, e2);
            return change;
        }
        try {
            Object[] args = new Object[]{oldValue, newValue, windowNo};
            method.invoke((Object)po, args);
        }
        catch (Exception e3) {
            String msg = e3.getCause() != null ? e3.getCause().getLocalizedMessage() : e3.getLocalizedMessage();
            if (msg == null || msg.length() == 0) {
                msg = e3.toString();
            }
            change.addError(po.getClass() + "." + methodName + ": " + msg);
            log.log(Level.WARNING, po.getClass() + "." + methodName, e3);
        }
        return change;
    }

    public boolean isCanExport(Ctx ctx) {
        MRole role = MRole.get(ctx, ctx.getAD_Role_ID(), ctx.getAD_User_ID(), false);
        return role.isCanExport(this.getAD_Table_ID());
    }

    public boolean isCanReport(Ctx ctx) {
        MRole role = MRole.get(ctx, ctx.getAD_Role_ID(), ctx.getAD_User_ID(), false);
        return role.isCanReport(this.getAD_Table_ID());
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("UITab[").append(this.getAD_Tab_ID()).append("-").append(this.getName());
        if (this.p_vos != null) {
            sb.append(";#Fields=").append(this.p_vos.size());
        }
        sb.append("]");
        return sb.toString();
    }

    public void refreshDropDowns(ChangeVO change, int windowNo, CContext newCtx) {
        if (change.changedContext != null) {
            newCtx.setContext(windowNo, change.changedContext);
        }
        if (change.changedFields != null) {
            newCtx.setContext(windowNo, change.changedFields);
        }
        if (change.rowData != null) {
            log.info("found row data, now merge");
            int i = 0;
            for (UIField f : this.getFields()) {
                newCtx.setContext(windowNo, f.getColumnName(), change.rowData[i]);
                ++i;
            }
        }
        for (UIField f : this.getFields()) {
            String val;
            String colName = f.getColumnName();
            if (!f.isLookup() || !f.isDependentValue() || (val = (String)change.changedFields.get(colName)) == null) continue;
            if (change.changedDropDowns == null) {
                change.changedDropDowns = new HashMap();
            }
            ArrayList arry = (ArrayList)change.changedDropDowns.get(colName);
            ArrayList<NamePair> data = f.getLookupData(newCtx, windowNo, false);
            if (arry == null) {
                change.changedDropDowns.put(colName, data);
                continue;
            }
            log.warning("field" + colName + " already has changedDropDowns, merge it. Before merge:" + arry);
            for (NamePair d : data) {
                if (NamePair.indexOfKey((ArrayList)arry, (String)d.getID()) != -1) continue;
                arry.add(d);
            }
            log.warning("After merge:" + arry);
        }
    }

    public int getRecord_ID(String[] row) {
        int keyColumnPos = this.getKeyColumnPos();
        if (keyColumnPos == -1) {
            return -1;
        }
        return Integer.parseInt(row[keyColumnPos]);
    }

    public int getKeyColumnPos() {
        if (this.m_keyColumns == null) {
            this.createColumnLists();
        }
        return this.m_keyColumnPos;
    }
}

