/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.controller;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import org.compiere.controller.UIWindowVO;
import org.compiere.controller.UIWindowVOFT;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class UIWindowVOFactory
extends UIWindowVOFT {
    public UIWindowVO get(Ctx ctx, int AD_Window_ID, int AD_Menu_ID) {
        UIWindowVO vo;
        this.log.config("AD_Window_ID=" + AD_Window_ID + "; AD_Menu_ID=" + AD_Menu_ID);
        boolean IsReadOnly = false;
        if (AD_Window_ID == 0 && AD_Menu_ID != 0) {
            String sql = "SELECT AD_Window_ID, IsReadOnly FROM AD_Menu WHERE AD_Menu_ID=? AND Action='W'";
            try {
                CPreparedStatement pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, AD_Menu_ID);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    AD_Window_ID = rs.getInt(1);
                    IsReadOnly = "Y".equals(rs.getString(3));
                }
                rs.close();
                pstmt.close();
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, e);
                return null;
            }
            this.log.config("AD_Window_ID=" + AD_Window_ID);
        }
        if ((vo = this.get(ctx, AD_Window_ID)) != null && IsReadOnly) {
            vo.setIsReadWrite(false);
        }
        return vo;
    }

    protected UIWindowVO get(Ctx ctx, int AD_Window_ID) {
        int AD_Role_ID;
        UIWindowVO vo;
        this.log.fine("AD_Window_ID=" + AD_Window_ID);
        String sql = "SELECT * FROM AD_Window_v WHERE AD_Window_ID=? AND AD_Role_ID=?";
        if (!Env.isBaseLanguage(ctx, "AD_Window")) {
            sql = "SELECT * FROM AD_Window_vt WHERE AD_Window_ID=? AND AD_Role_ID=? AND AD_Language='" + Env.getAD_Language(ctx) + "'";
        }
        if ((vo = (UIWindowVO)this.get(sql, AD_Window_ID, AD_Role_ID = ctx.getAD_Role_ID())) == null) {
            this.log.log(Level.SEVERE, "No Window - AD_Window_ID=" + AD_Window_ID + ", AD_Role_ID=" + AD_Role_ID + " - " + sql);
            this.log.saveError("AccessTableNoView", "(Not found)");
            return null;
        }
        return vo;
    }
}

