/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.compiere.db.ConvertMap;
import org.compiere.db.Join;
import org.compiere.util.CLogger;
import org.compiere.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Convert {
    public static final int REGEX_FLAGS = 34;
    private boolean m_isOracle = false;
    private TreeMap m_map;
    private Statement m_stmt = null;
    private String m_conversionError = null;
    private Exception m_exception = null;
    private boolean m_verbose = true;
    private static CLogger log = CLogger.getCLogger(Convert.class);

    public Convert(String type) {
        if ("oracle".equals(type)) {
            this.m_isOracle = true;
        } else if ("db2".equals(type)) {
            this.m_map = ConvertMap.getDB2Map();
        } else if ("postgreSQL".equals(type)) {
            this.m_map = ConvertMap.getPGMap();
        } else if ("sqlServer".equals(type)) {
            this.m_map = ConvertMap.getMSMap();
        } else {
            throw new UnsupportedOperationException("Unsupported database: " + type);
        }
    }

    public void setVerbose(boolean verbose) {
        this.m_verbose = verbose;
    }

    public boolean isOracle() {
        return this.m_isOracle;
    }

    public boolean execute(String sqlStatements, Connection conn) {
        if (conn == null) {
            throw new IllegalStateException("Require connection");
        }
        String[] sql = this.convert(sqlStatements);
        this.m_exception = null;
        if (this.m_conversionError != null || sql == null) {
            return false;
        }
        boolean ok = true;
        int i = 0;
        String statement = null;
        try {
            if (this.m_stmt == null) {
                this.m_stmt = conn.createStatement();
            }
            for (i = 0; ok && i < sql.length; ++i) {
                statement = sql[i];
                if (statement.length() == 0) {
                    if (!this.m_verbose) continue;
                    log.finer("Skipping empty (" + i + ")");
                    continue;
                }
                if (this.m_verbose) {
                    log.info("Executing (" + i + ") <<" + statement + ">>");
                } else {
                    log.info("Executing " + i);
                }
                try {
                    this.m_stmt.clearWarnings();
                    int no = this.m_stmt.executeUpdate(statement);
                    SQLWarning warn = this.m_stmt.getWarnings();
                    if (warn != null) {
                        if (this.m_verbose) {
                            log.info("- " + warn);
                        } else {
                            log.info("Executing (" + i + ") <<" + statement + ">>");
                            log.info("- " + warn);
                        }
                    }
                    if (!this.m_verbose) continue;
                    log.fine("- ok " + no);
                    continue;
                }
                catch (SQLException ex) {
                    if (!statement.startsWith("DROP ")) {
                        ok = false;
                        this.m_exception = ex;
                    }
                    if (!this.m_verbose) {
                        log.info("Executing (" + i + ") <<" + statement + ">>");
                    }
                    log.info("Error executing " + i + "/" + sql.length + " = " + ex);
                }
            }
        }
        catch (SQLException e) {
            this.m_exception = e;
            if (!this.m_verbose) {
                log.info("Executing (" + i + ") <<" + statement + ">>");
            }
            log.info("Error executing " + i + "/" + sql.length + " = " + e);
            return false;
        }
        return ok;
    }

    public Exception getException() {
        return this.m_exception;
    }

    public boolean hasError() {
        return this.m_exception != null | this.m_conversionError != null;
    }

    public String convertAll(String sqlStatements) {
        String[] sql = this.convert(sqlStatements);
        StringBuffer sb = new StringBuffer(sqlStatements.length() + 10);
        for (int i = 0; i < sql.length; ++i) {
            sb.append(sql[i]).append("\n/\n");
            if (!this.m_verbose) continue;
            log.info("Statement " + i + ": " + sql[i]);
        }
        return sb.toString();
    }

    public String[] convert(String sqlStatements) {
        this.m_conversionError = null;
        if (sqlStatements == null || sqlStatements.length() == 0) {
            this.m_conversionError = "SQL_Statement is null or has zero length";
            log.info(this.m_conversionError);
            return null;
        }
        return this.convertIt(sqlStatements);
    }

    public String getConversionError() {
        return this.m_conversionError;
    }

    private String[] convertIt(String sqlStatements) {
        int MASK = 31;
        StringBuffer masked = new StringBuffer(sqlStatements.length());
        Matcher m = Pattern.compile("'[^']+'", 32).matcher(sqlStatements);
        while (m.find()) {
            String group = m.group();
            if (group.indexOf("/") != -1) {
                group = group.replace('/', '\u001f');
            }
            if (group.indexOf(92) != -1) {
                group = Util.replace(group, "\\", "\\\\\\\\");
            }
            if (group.indexOf(36) != -1) {
                group = Util.replace(group, "$", "\\$");
            }
            m.appendReplacement(masked, group);
        }
        m.appendTail(masked);
        String tempResult = masked.toString();
        String[] sql = tempResult.split("\\s/\\s");
        ArrayList<String> result = new ArrayList<String>(sql.length);
        for (int i = 0; i < sql.length; ++i) {
            String statement = sql[i];
            if (statement.indexOf(31) != -1) {
                statement = statement.replace('\u001f', '/');
            }
            result.addAll(this.convertStatement(statement));
        }
        sql = new String[result.size()];
        result.toArray(sql);
        return sql;
    }

    private ArrayList<String> convertStatement(String sqlStatement) {
        ArrayList<String> result = new ArrayList<String>();
        if (this.m_isOracle) {
            result.add(sqlStatement);
            return result;
        }
        String statement = sqlStatement;
        String cmpString = statement.toUpperCase();
        boolean isCreate = cmpString.startsWith("CREATE ");
        if (isCreate && cmpString.indexOf(" FUNCTION ") != -1) {
            result.addAll(this.convertFunction(statement));
        } else if (isCreate && cmpString.indexOf(" TRIGGER ") != -1) {
            result.addAll(this.convertTrigger(statement));
        } else if (isCreate && cmpString.indexOf(" PROCEDURE ") != -1) {
            result.addAll(this.convertProcedure(statement));
        } else if (isCreate && cmpString.indexOf(" VIEW ") != -1) {
            result.addAll(this.convertView(statement));
        } else {
            result.add(this.converSimpleStatement(statement));
        }
        return result;
    }

    private String converSimpleStatement(String sqlStatement) {
        if (sqlStatement.toUpperCase().indexOf("EXCEPTION WHEN") != -1) {
            String error = "Exception clause needs to be converted: " + sqlStatement;
            log.info(error);
            this.m_conversionError = error;
            return sqlStatement;
        }
        String retValue = sqlStatement;
        for (String regex : this.m_map.keySet()) {
            String replacement = (String)this.m_map.get(regex);
            try {
                Pattern p = Pattern.compile(regex, 34);
                Matcher m = p.matcher(retValue);
                retValue = m.replaceAll(replacement);
            }
            catch (Exception e) {
                String error = "Error expression: " + regex + " - " + e;
                log.info(error);
                this.m_conversionError = error;
            }
        }
        return this.convertComplexStatement(retValue);
    }

    protected String removeComments(String statement) {
        String clean = statement.trim();
        Matcher m = Pattern.compile("\\/\\*ORACLE>.*<ORACLE\\*\\/", 32).matcher(clean);
        clean = m.replaceAll("");
        m = Pattern.compile("\\/\\*POSTGRESQL>").matcher(clean);
        clean = m.replaceAll("");
        m = Pattern.compile("<POSTGRESQL\\*\\/").matcher(clean);
        clean = m.replaceAll("");
        m = Pattern.compile("\\/\\*.*\\*\\/", 32).matcher(clean);
        clean = m.replaceAll("");
        m = Pattern.compile("\\s+").matcher(clean);
        clean = m.replaceAll(" ");
        clean = clean.trim();
        return clean;
    }

    private ArrayList<String> convertFunction(String sqlStatement) {
        ArrayList<String> result = new ArrayList<String>();
        String stmt = this.converSimpleStatement(sqlStatement);
        stmt = Pattern.compile("'").matcher(stmt).replaceAll("''");
        int orReplacePos = stmt.toUpperCase().indexOf(" OR REPLACE ");
        if (orReplacePos != -1) {
            stmt = "CREATE" + stmt.substring(orReplacePos + 11);
        }
        String match = "(\\([^\\)]*\\))|(\\bRETURN \\w+ (AS)|(IS))|(;)|(\\bBEGIN\\b)|(\\bTHEN\\b)|(\\bELSE\\b)|(\\bELSIF\\b)";
        Matcher m = Pattern.compile(match, 2).matcher(stmt);
        StringBuffer sb = new StringBuffer();
        m.find();
        m.appendReplacement(sb, "");
        String name = sb.substring(6).trim();
        StringBuffer signature = new StringBuffer();
        String group = m.group().trim();
        StringBuffer alias = new StringBuffer();
        if (group.startsWith("(") && group.endsWith(")")) {
            if (group.toUpperCase().indexOf(" DEFAULT ") != -1) {
                String error = "DEFAULT in Parameter not supported";
                log.info(error);
                this.m_conversionError = error;
                return result;
            }
            signature.append("(");
            if (group.length() > 2) {
                group = group.substring(1, group.length() - 1);
                String[] parameters = group.split(",");
                for (int i = 0; i < parameters.length; ++i) {
                    if (i != 0) {
                        signature.append(", ");
                    }
                    String p = parameters[i].trim();
                    alias.append(p.substring(0, p.indexOf(" "))).append(" ALIAS FOR $").append(i + 1).append(";\n");
                    signature.append(p.substring(p.lastIndexOf(" ") + 1));
                }
            }
        } else {
            String error = "Missing Parameter ()";
            log.info(error);
            this.m_conversionError = error;
            return result;
        }
        signature.append(")");
        sb.append(signature);
        sb.append("\n");
        if (orReplacePos != -1) {
            String drop = "DROP " + name + signature.toString();
            result.add(drop);
        }
        m.find();
        group = m.group();
        m.appendReplacement(sb, "");
        if (group.startsWith("RETURN")) {
            sb.append("RETURNS").append(group.substring(group.indexOf(" ")));
        }
        sb.append(" '\nDECLARE\n").append(alias);
        while (m.find()) {
            String group2 = m.group();
            if (group2.indexOf(36) != -1) {
                group2 = Util.replace(group2, "$", "\\$");
            }
            m.appendReplacement(sb, group2);
            sb.append("\n");
        }
        m.appendTail(sb);
        sb.append("' LANGUAGE 'plpgsql';");
        result.add(sb.toString());
        return result;
    }

    private ArrayList<String> convertProcedure(String sqlStatement) {
        ArrayList<String> result = new ArrayList<String>();
        String stmt = this.converSimpleStatement(sqlStatement);
        stmt = Pattern.compile("'").matcher(stmt).replaceAll("''");
        int orReplacePos = stmt.toUpperCase().indexOf(" OR REPLACE ");
        if (orReplacePos != -1) {
            stmt = "CREATE" + stmt.substring(orReplacePos + 11);
        }
        String match = "(\\([^\\)]*\\))|(\\bRETURN \\w+ (AS)|(IS))|(;)|(\\bBEGIN\\b)|(\\bTHEN\\b)|(\\bELSE\\b)|(\\bELSIF\\b)";
        Matcher m = Pattern.compile(match, 2).matcher(stmt);
        StringBuffer sb = new StringBuffer();
        m.find();
        m.appendReplacement(sb, "");
        String name = sb.substring(6).trim();
        StringBuffer signature = new StringBuffer();
        String group = m.group().trim();
        StringBuffer alias = new StringBuffer();
        if (group.startsWith("(") && group.endsWith(")")) {
            if (group.toUpperCase().indexOf(" DEFAULT ") != -1) {
                String error = "DEFAULT in Parameter not supported";
                log.info(error);
                this.m_conversionError = error;
                return result;
            }
            signature.append("(");
            if (group.length() > 2) {
                group = group.substring(1, group.length() - 1);
                String[] parameters = group.split(",");
                for (int i = 0; i < parameters.length; ++i) {
                    if (i != 0) {
                        signature.append(", ");
                    }
                    String p = parameters[i].trim();
                    alias.append(p.substring(0, p.indexOf(" "))).append(" ALIAS FOR $").append(i + 1).append(";\n");
                    signature.append(p.substring(p.lastIndexOf(" ") + 1));
                }
            }
        } else {
            String error = "Missing Parameter ()";
            log.info(error);
            this.m_conversionError = error;
            return result;
        }
        signature.append(")");
        sb.append(signature);
        sb.append("\n");
        if (orReplacePos != -1) {
            String drop = "DROP " + name + signature.toString();
            result.add(drop);
        }
        m.find();
        group = m.group();
        m.appendReplacement(sb, "");
        if (group.startsWith("RETURN")) {
            sb.append("RETURNS").append(group.substring(group.indexOf(" ")));
        }
        sb.append(" '\nDECLARE\n").append(alias);
        while (m.find()) {
            String group2 = m.group();
            if (group2.indexOf(36) != -1) {
                group2 = Util.replace(group2, "$", "\\$");
            }
            m.appendReplacement(sb, group2);
            sb.append("\n");
        }
        m.appendTail(sb);
        sb.append("' LANGUAGE 'plpgsql';");
        result.add(sb.toString());
        return result;
    }

    private ArrayList<String> convertTrigger(String sqlStatement) {
        int pos;
        ArrayList<String> result = new ArrayList<String>();
        String stmt = this.converSimpleStatement(sqlStatement);
        stmt = Pattern.compile("\\bINSERTING\\b").matcher(stmt).replaceAll("TG_OP='INSERT'");
        stmt = Pattern.compile("\\bUPDATING\\b").matcher(stmt).replaceAll("TG_OP='UPDATE'");
        stmt = Pattern.compile("\\bDELETING\\b").matcher(stmt).replaceAll("TG_OP='DELETE'");
        stmt = Pattern.compile(":new.").matcher(stmt).replaceAll("NEW.");
        stmt = Pattern.compile(":old.").matcher(stmt).replaceAll("OLD.");
        stmt = Pattern.compile("'").matcher(stmt).replaceAll("''");
        int orReplacePos = stmt.toUpperCase().indexOf(" OR REPLACE ");
        int triggerPos = stmt.toUpperCase().indexOf(" TRIGGER ") + 9;
        String triggerName = stmt.substring(triggerPos);
        triggerName = triggerName.substring(0, triggerName.indexOf(" "));
        String tableName = stmt.substring(stmt.toUpperCase().indexOf(" ON ") + 4);
        tableName = tableName.substring(0, tableName.indexOf(" "));
        if (orReplacePos != -1) {
            String drop = "DROP FUNCTION " + triggerName + "F()";
            result.add(drop);
        }
        if ((pos = stmt.indexOf("DECLARE ")) == -1) {
            pos = stmt.indexOf("BEGIN ");
        }
        String functionCode = stmt.substring(pos);
        StringBuffer triggerCode = new StringBuffer("CREATE TRIGGER ");
        triggerCode.append(triggerName).append("\n").append(stmt.substring(triggerPos + triggerName.length(), pos)).append("\nEXECUTE PROCEDURE ").append(triggerName).append("F();");
        functionCode = Pattern.compile("\\bRETURN;", 2).matcher(functionCode).replaceAll("RETURN NEW;");
        functionCode = Pattern.compile("\\bEND " + triggerName + ";", 2).matcher(functionCode).replaceAll("\nRETURN NEW;\nEND " + triggerName + "F;");
        String match = "(\\(.*\\))|(;)|(\\bBEGIN\\b)|(\\bTHEN\\b)|(\\bELSE\\b)|(\\bELSIF\\b)";
        Matcher m = Pattern.compile(match, 2).matcher(functionCode);
        StringBuffer sb = new StringBuffer("CREATE FUNCTION ");
        sb.append(triggerName).append("F() RETURNS OPAQUE AS '\n");
        while (m.find()) {
            String group = m.group();
            if (group.indexOf(36) != -1) {
                group = Util.replace(group, "$", "\\$");
            }
            m.appendReplacement(sb, group);
            sb.append("\n");
        }
        m.appendTail(sb);
        sb.append("' LANGUAGE 'plpgsql';");
        result.add(sb.toString());
        if (orReplacePos != -1) {
            String drop = "DROP TRIGGER " + triggerName.toLowerCase() + " ON " + tableName;
            result.add(drop);
        }
        String trigger = Pattern.compile("\\sOF.*ON\\s").matcher(triggerCode).replaceAll(" ON ");
        result.add(trigger);
        return result;
    }

    private ArrayList<String> convertView(String sqlStatement) {
        ArrayList<String> result = new ArrayList<String>();
        String stmt = this.converSimpleStatement(sqlStatement);
        int orReplacePos = stmt.toUpperCase().indexOf(" OR REPLACE ");
        if (orReplacePos != -1) {
            int index = stmt.indexOf(" VIEW ");
            int space = stmt.indexOf(32, index + 6);
            String drop = "DROP VIEW " + stmt.substring(index + 6, space);
            result.add(drop);
            String create = "CREATE" + stmt.substring(index);
            result.add(create);
        } else {
            result.add(stmt);
        }
        return result;
    }

    private String convertComplexStatement(String sqlStatement) {
        String group;
        String retValue = sqlStatement;
        StringBuffer sb = null;
        while (retValue.indexOf("DECODE(") != -1 || retValue.indexOf("DECODE (") != -1) {
            retValue = this.convertDecode(retValue);
        }
        Matcher m = Pattern.compile("\\w+\\.(nextval)|(curval)", 2).matcher(retValue);
        sb = new StringBuffer();
        while (m.find()) {
            group = m.group();
            int pos = group.indexOf(".");
            String seqName = group.substring(0, pos);
            String funcName = group.substring(pos + 1);
            if ((group = funcName + "('" + seqName + "')").indexOf(36) != -1) {
                group = Util.replace(group, "$", "\\$");
            }
            m.appendReplacement(sb, group);
        }
        m.appendTail(sb);
        retValue = sb.toString();
        m = Pattern.compile("RAISE_APPLICATION_ERROR\\s*\\(.+'\\)", 2).matcher(retValue);
        sb = new StringBuffer();
        while (m.find()) {
            group = m.group();
            System.out.print("-> " + group);
            String result = "RAISE EXCEPTION " + group.substring(group.indexOf(39), group.lastIndexOf(39) + 1);
            log.info(" => " + result);
            if (result.indexOf(36) != -1) {
                result = Util.replace(result, "$", "\\$");
            }
            m.appendReplacement(sb, result);
        }
        m.appendTail(sb);
        retValue = sb.toString();
        int it = retValue.indexOf("TRUNC(");
        while (it != -1) {
            retValue = this.convertTrunc(retValue);
            it = retValue.indexOf("TRUNC(", it + 1);
        }
        int index = retValue.indexOf("SELECT ");
        if (index != -1 && retValue.indexOf("(+)", index) != -1) {
            retValue = this.convertOuterJoin(retValue);
        }
        return retValue;
    }

    private String convertDecode(String sqlStatement) {
        String statement = sqlStatement;
        StringBuffer sb = new StringBuffer("CASE");
        int index = statement.indexOf("DECODE");
        String firstPart = statement.substring(0, index);
        index = statement.indexOf(40, index);
        statement = statement.substring(index + 1);
        index = Util.findIndexOf(statement, ',');
        String expression = statement.substring(0, index).trim();
        statement = statement.substring(index + 1);
        index = Util.findIndexOf(statement, ',');
        while (index != -1) {
            String first = statement.substring(0, index);
            char cc = statement.charAt(index);
            statement = statement.substring(index + 1);
            boolean error = false;
            if (cc == ',') {
                index = Util.findIndexOf(statement, ',', ')');
                if (index == -1) {
                    error = true;
                } else {
                    String second = statement.substring(0, index);
                    sb.append(" WHEN ").append(expression).append("=").append(first.trim()).append(" THEN ").append(second.trim());
                    statement = statement.substring(index + 1);
                    index = Util.findIndexOf(statement, ',', ')');
                }
            } else if (cc == ')') {
                sb.append(" ELSE ").append(first.trim()).append(" END");
                index = -1;
            } else {
                error = true;
            }
            if (!error) continue;
            log.log(Level.SEVERE, "SQL=(" + sqlStatement + ")\n====Result=(" + sb.toString() + ")\n====Statement=(" + statement + ")\n====First=(" + first + ")\n====Index=" + index);
            this.m_conversionError = "Decode conversion error";
        }
        sb.append(statement);
        sb.insert(0, firstPart);
        return sb.toString();
    }

    private String convertOuterJoin(String sqlStatement) {
        boolean trace = false;
        int fromIndex = Util.findIndexOf(sqlStatement.toUpperCase(), " FROM ");
        int whereIndex = Util.findIndexOf(sqlStatement.toUpperCase(), " WHERE ");
        int endWhereIndex = Util.findIndexOf(sqlStatement.toUpperCase(), " GRPUP BY ");
        if (endWhereIndex == -1) {
            endWhereIndex = Util.findIndexOf(sqlStatement.toUpperCase(), " ORDER BY ");
        }
        if (endWhereIndex == -1) {
            endWhereIndex = sqlStatement.length();
        }
        if (trace) {
            log.info("OuterJoin<== " + sqlStatement);
        }
        String selectPart = sqlStatement.substring(0, fromIndex);
        String fromPart = sqlStatement.substring(fromIndex, whereIndex);
        String wherePart = sqlStatement.substring(whereIndex, endWhereIndex);
        String rest = sqlStatement.substring(endWhereIndex);
        String newWherePart = wherePart;
        ArrayList<String> joins = new ArrayList<String>();
        int pos = newWherePart.indexOf("(+)");
        while (pos != -1) {
            int start = newWherePart.lastIndexOf(" AND ", pos);
            int startOffset = 5;
            if (start == -1) {
                start = newWherePart.lastIndexOf(" OR ", pos);
                startOffset = 4;
            }
            if (start == -1) {
                start = newWherePart.lastIndexOf("WHERE ", pos);
                startOffset = 6;
            }
            if (start == -1) {
                String error = "Start point not found in clause " + wherePart;
                log.severe(error);
                this.m_conversionError = error;
                return sqlStatement;
            }
            int end = newWherePart.indexOf(" AND ", pos);
            if (end == -1) {
                end = newWherePart.indexOf(" OR ", pos);
            }
            if (end == -1) {
                end = newWherePart.length();
            }
            String condition = newWherePart.substring(start + startOffset, end);
            joins.add(condition);
            if (trace) {
                log.info("->" + condition);
            }
            newWherePart = newWherePart.substring(0, start) + newWherePart.substring(end);
            pos = newWherePart.indexOf("(+)");
        }
        if ((newWherePart = newWherePart.trim()).startsWith("AND ")) {
            newWherePart = "WHERE" + newWherePart.substring(3);
        } else if (newWherePart.startsWith("OR ")) {
            newWherePart = "WHERE" + newWherePart.substring(2);
        }
        if (trace) {
            log.info("=> " + newWherePart);
        }
        String[] fromParts = fromPart.trim().substring(4).split(",");
        HashMap<String, String> fromAlias = new HashMap<String, String>();
        HashMap<String, String> fromLookup = new HashMap<String, String>();
        for (int i = 0; i < fromParts.length; ++i) {
            String entry;
            String alias = entry = fromParts[i].trim();
            String table = entry;
            int aPos = entry.lastIndexOf(32);
            if (aPos != -1) {
                alias = entry.substring(aPos + 1);
                table = entry.substring(0, entry.indexOf(32));
            }
            fromAlias.put(alias, table);
            fromLookup.put(alias, table);
            if (!trace) continue;
            log.info("Alias=" + alias + ", Table=" + table);
        }
        StringBuffer newFrom = new StringBuffer();
        for (int i = 0; i < joins.size(); ++i) {
            Join third;
            int k;
            Join second;
            int j;
            Join first = new Join((String)joins.get(i));
            first.setMainTable((String)fromLookup.get(first.getMainAlias()));
            fromAlias.remove(first.getMainAlias());
            first.setJoinTable((String)fromLookup.get(first.getJoinAlias()));
            fromAlias.remove(first.getJoinAlias());
            if (trace) {
                log.info("-First: " + first);
            }
            if (newFrom.length() == 0) {
                newFrom.append(" FROM ");
            } else {
                newFrom.append(", ");
            }
            newFrom.append(first.getMainTable()).append(" ").append(first.getMainAlias()).append(first.isLeft() ? " LEFT" : " RIGHT").append(" OUTER JOIN ").append(first.getJoinTable()).append(" ").append(first.getJoinAlias()).append(" ON (").append(first.getCondition());
            for (j = i + 1; j < joins.size(); ++j) {
                second = new Join((String)joins.get(j));
                second.setMainTable((String)fromLookup.get(second.getMainAlias()));
                second.setJoinTable((String)fromLookup.get(second.getJoinAlias()));
                if (first.getMainTable().equals(second.getMainTable()) && first.getJoinTable().equals(second.getJoinTable()) || second.isConditionOf(first)) {
                    if (trace) {
                        log.info("-Second/key: " + second);
                    }
                    newFrom.append(" AND ").append(second.getCondition());
                    joins.remove(j);
                    fromAlias.remove(first.getJoinAlias());
                    for (k = i + 1; k < joins.size(); ++k) {
                        third = new Join((String)joins.get(k));
                        third.setMainTable((String)fromLookup.get(third.getMainAlias()));
                        third.setJoinTable((String)fromLookup.get(third.getJoinAlias()));
                        if (third.isConditionOf(second)) {
                            if (trace) {
                                log.info("-Third/key: " + third);
                            }
                            newFrom.append(" AND ").append(third.getCondition());
                            joins.remove(k);
                            fromAlias.remove(third.getJoinAlias());
                            continue;
                        }
                        if (!trace) continue;
                        log.info("-Third/key-skip: " + third);
                    }
                    continue;
                }
                if (!trace) continue;
                log.info("-Second/key-skip: " + second);
            }
            newFrom.append(")");
            for (j = i + 1; j < joins.size(); ++j) {
                second = new Join((String)joins.get(j));
                second.setMainTable((String)fromLookup.get(second.getMainAlias()));
                second.setJoinTable((String)fromLookup.get(second.getJoinAlias()));
                if (first.getMainTable().equals(second.getMainTable())) {
                    if (trace) {
                        log.info("-Second/dep: " + second);
                    }
                    newFrom.insert(6, '(');
                    newFrom.append(')');
                    newFrom.append(second.isLeft() ? " LEFT" : " RIGHT").append(" OUTER JOIN ").append(second.getJoinTable()).append(" ").append(second.getJoinAlias()).append(" ON (").append(second.getCondition());
                    joins.remove(j);
                    fromAlias.remove(second.getJoinAlias());
                    newFrom.append(")");
                    for (k = i + 1; k < joins.size(); ++k) {
                        third = new Join((String)joins.get(k));
                        third.setMainTable((String)fromLookup.get(third.getMainAlias()));
                        third.setJoinTable((String)fromLookup.get(third.getJoinAlias()));
                        if (second.getJoinTable().equals(third.getMainTable())) {
                            if (trace) {
                                log.info("-Third-dep: " + third);
                            }
                            newFrom.insert(6, '(');
                            newFrom.append(')');
                            newFrom.append(third.isLeft() ? " LEFT" : " RIGHT").append(" OUTER JOIN ").append(third.getJoinTable()).append(" ").append(third.getJoinAlias()).append(" ON (").append(third.getCondition());
                            joins.remove(k);
                            fromAlias.remove(third.getJoinAlias());
                            newFrom.append(")");
                            continue;
                        }
                        if (!trace) continue;
                        log.info("-Third-skip: " + third);
                    }
                    continue;
                }
                if (!trace) continue;
                log.info("-Second/dep-skip: " + second);
            }
        }
        for (String alias : fromAlias.keySet()) {
            Object table = fromAlias.get(alias);
            newFrom.append(", ").append(table);
            if (table.equals(alias)) continue;
            newFrom.append(" ").append((Object)alias);
        }
        if (trace) {
            log.info(newFrom.toString());
        }
        StringBuffer retValue = new StringBuffer(sqlStatement.length() + 20);
        retValue.append(selectPart).append(newFrom).append(" ").append(newWherePart).append(rest);
        if (trace) {
            log.info("OuterJoin==> " + retValue.toString());
        }
        return retValue.toString();
    }

    private String convertRowNum(String sqlStatement) {
        log.info("RowNum<== " + sqlStatement);
        String retValue = sqlStatement;
        return retValue;
    }

    private String convertTrunc(String sqlStatement) {
        return sqlStatement;
    }
}

