/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.db;

import com.ibm.db2.jcc.DB2DataSource;
import com.ibm.db2.jcc.DB2Driver;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Random;
import java.util.logging.Level;
import javax.sql.DataSource;
import org.compiere.db.CConnection;
import org.compiere.db.CConstraint;
import org.compiere.db.CompiereDatabase;
import org.compiere.db.Convert;
import org.compiere.db.DBUtils;
import org.compiere.db.Database;
import org.compiere.util.CLogger;

public class DB_DB2
implements CompiereDatabase {
    private static DB2Driver s_driver = null;
    public static final String DRIVER = "com.ibm.db2.jcc.DB2Driver";
    public static final String DRIVER2 = "COM.ibm.db2.jdbc.app.DB2Driver";
    public static final int DEFAULT_PORT = 50000;
    public static final int DEFAULT_PORT_0 = 446;
    public static final String DEFAULT_DBNAME = "compiere";
    private String m_userName = null;
    private String m_connectionURL;
    private DB2DataSource m_ds = null;
    private Connection m_conn = null;
    private Convert m_convert = new Convert("db2");
    private static CLogger log = CLogger.getCLogger(DB_DB2.class);
    private Random r_key = new Random(123456L);

    public DB_DB2() {
        try {
            this.getDriver();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage());
        }
    }

    public boolean isConnectionValid(Connection conn) {
        return true;
    }

    public String getName() {
        return "db2";
    }

    public String getDescription() {
        try {
            if (s_driver == null) {
                this.getDriver();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (s_driver != null) {
            return s_driver.toString();
        }
        return "No Driver";
    }

    public int getStandardPort() {
        return 446;
    }

    public Driver getDriver() throws SQLException {
        if (s_driver == null) {
            s_driver = new DB2Driver();
            DriverManager.registerDriver((Driver)s_driver);
            DriverManager.setLoginTimeout(Database.CONNECTION_TIMEOUT);
        }
        return s_driver;
    }

    public String getConnectionURL(CConnection connection) {
        StringBuffer sb = null;
        sb = new StringBuffer("jdbc:db2:");
        sb.append("//").append(connection.getDbHost()).append(":").append(connection.getDbPort()).append("/").append(connection.getDbName() + ":retrieveMessagesFromServerOnGetMessage=true;");
        this.m_connectionURL = sb.toString();
        this.m_userName = connection.getDbUid();
        return this.m_connectionURL;
    }

    public String getConnectionURL(String dbHost, int dbPort, String dbName, String userName) {
        this.m_userName = userName;
        this.m_connectionURL = "jdbc:db2://" + dbHost + ":" + dbPort + "/" + dbName + ":retrieveMessagesFromServerOnGetMessage=true;";
        return this.m_connectionURL;
    }

    public String getConnectionURL(String connectionURL, String userName) {
        this.m_userName = userName;
        this.m_connectionURL = connectionURL;
        return this.m_connectionURL;
    }

    public String getCatalog() {
        return null;
    }

    public String getSchema() {
        if (this.m_userName != null) {
            return this.m_userName.toUpperCase();
        }
        log.severe("User Name not set (yet) - call getConnectionURL first");
        return null;
    }

    public boolean supportsBLOB() {
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("DB_DB2[");
        sb.append(this.m_connectionURL);
        sb.append("]");
        return sb.toString();
    }

    public String getStatus() {
        StringBuffer sb = new StringBuffer();
        return sb.toString();
    }

    public String repRownum(String oraS) {
        return DBUtils.repRownum(oraS);
    }

    public String convertStatement(String oraStatement) {
        String[] retValue;
        if (oraStatement.startsWith("ALTER TABLE") && oraStatement.indexOf(" MODIFY ") > 0) {
            String[] tokens = oraStatement.split(" ");
            String sql = "ALTER TABLE " + tokens[2] + " ALTER " + tokens[4];
            int idef = oraStatement.indexOf(" DEFAULT ");
            if (idef > 0 || oraStatement.indexOf(" NULL") < 0) {
                int i = sql.length() + 1;
                if (idef > 0) {
                    sql = sql + " SET DATA TYPE " + oraStatement.substring(i, idef + 1);
                    sql = sql + ", ALTER " + tokens[4] + " SET DEFAULT " + oraStatement.substring(idef + 9, oraStatement.length());
                } else {
                    sql = sql + " TYPE " + oraStatement.substring(i, oraStatement.length());
                }
                oraStatement = sql;
            } else {
                if (oraStatement.indexOf(" NOT NULL") > 0) {
                    sql = sql + " SET NOT NULL";
                    return sql;
                }
                if (oraStatement.indexOf(" NULL") > 0) {
                    sql = sql + " DROP NOT NULL";
                    return sql;
                }
            }
        }
        while (oraStatement.indexOf("DECIMAL(10,0)") > -1) {
            oraStatement = oraStatement.replace("DECIMAL(10,0)", "INTEGER");
        }
        while (oraStatement.indexOf("currencyBase(invoiceOpen") > -1) {
            oraStatement = oraStatement.replace("currencyBase(invoiceOpen", "currencyBaseD(invoiceOpen");
        }
        if (oraStatement.startsWith("SELECT p.M_Product_ID, p.Discontinued, p.Value, p.Name, bomQtyAvailable")) {
            while (oraStatement.indexOf("(p.M_Product_ID,?,0)") > -1) {
                oraStatement = oraStatement.replace("(p.M_Product_ID,?,0)", "(p.M_Product_ID,cast(? as integer),0)");
            }
        }
        if (oraStatement.startsWith("SELECT C_BPartner_ID,C_Currency_ID, invoiceOpen(C_Invoice_ID, ?),")) {
            oraStatement = oraStatement.replace("invoiceOpen(C_Invoice_ID, ?),", "invoiceOpen(C_Invoice_ID, cast(? as integer)),");
            oraStatement = oraStatement.replace("invoiceDiscount(C_Invoice_ID,?,?),", "invoiceDiscount(C_Invoice_ID,cast(? as timestamp),cast(? as integer)),");
        }
        if (oraStatement.startsWith("SELECT C_Invoice_ID, currencyConvert(invoiceOpen(")) {
            oraStatement = oraStatement.replace("currencyConvert(invoiceOpen(i.C_Invoice_ID, 0),i.C_Currency_ID, ?,?, i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID)", "currencyConvertD(invoiceOpen(i.C_Invoice_ID, 0),i.C_Currency_ID, cast(? as integer),cast(? as timestamp), i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID)");
            oraStatement = oraStatement.replace("currencyConvert(paymentTermDiscount(i.GrandTotal,i.C_Currency_ID,i.C_PaymentTerm_ID,i.DateInvoiced, ?),i.C_Currency_ID, ?,?,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID)", "currencyConvertD(paymentTermDiscount(i.GrandTotal,i.C_Currency_ID,i.C_PaymentTerm_ID,i.DateInvoiced, cast(? as timestamp)),i.C_Currency_ID, cast(? as integer),cast(? as timestamp),i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID)");
            oraStatement = oraStatement.replace("paymentTermDiscount(invoiceOpen(C_Invoice_ID, 0), C_Currency_ID, C_PaymentTerm_ID, DateInvoiced, ?)", "paymentTermDiscountD(invoiceOpen(C_Invoice_ID, 0), C_Currency_ID, C_PaymentTerm_ID, DateInvoiced, cast(? as timestamp))");
            oraStatement = oraStatement.replace("paymentTermDueDays(C_PaymentTerm_ID, DateInvoiced, ?)", "paymentTermDueDays(C_PaymentTerm_ID, DateInvoiced, cast(? as timestamp))");
        }
        if (oraStatement.startsWith("SELECT currencyConvert(")) {
            oraStatement = oraStatement.replace("currencyConvert(ol.PriceCost, o.C_Currency_ID, ?,", "currencyConvert(ol.PriceCost, o.C_Currency_ID, cast(? as integer),");
            oraStatement = oraStatement.replace("currencyConvert(ol.PriceActual, o.C_Currency_ID, ?,", "currencyConvert(ol.PriceActual, o.C_Currency_ID, cast(? as integer),");
            oraStatement = oraStatement.replace("currencyConvert(il.PriceActual, i.C_Currency_ID, ?,", "currencyConvert(il.PriceActual, i.C_Currency_ID, cast(? as integer),");
        }
        if (oraStatement.startsWith("UPDATE ")) {
            oraStatement = DBUtils.updateSetSelectList(oraStatement);
        }
        if ((retValue = this.m_convert.convert(oraStatement = this.repRownum(oraStatement))) == null) {
            log.severe("Not Converted (" + oraStatement + ") - " + this.m_convert.getConversionError());
            return oraStatement;
        }
        if (retValue.length != 1) {
            log.severe("Convert Command Number=" + retValue.length + " (" + oraStatement + ") - " + this.m_convert.getConversionError());
            return oraStatement;
        }
        if (!oraStatement.equals(retValue[0]) && retValue[0].indexOf("AD_Error") == -1) {
            log.finest("=>" + retValue[0] + "<= [" + oraStatement + "]");
        }
        if (!this.isSupported(retValue[0])) {
            log.finest("DB2 doesn't support this sql: " + retValue[0]);
            return "";
        }
        return retValue[0];
    }

    public boolean isSupported(String sql) {
        return !sql.equals("ResultSet_MoveToInsertRow");
    }

    public String getConstraintType(Connection conn, String tableName, String IXName) {
        if (IXName == null || IXName.length() == 0) {
            return "0";
        }
        String sqlp = "select a.uniquerule, b.dconstname from sysibm.sysindexes a join sysibm.sysconstdep b on (a.creator=b.bcreator and a.name=b.bname) where a.creator='" + IXName + "' and a.uniquerule='P' and b.btype='I' and " + "a.name='PK_EMPLOYEE'";
        try {
            Statement stmt = conn.createStatement();
            boolean gotit = false;
            ResultSet rs1 = null;
            String ct = null;
            String cn = null;
            rs1 = stmt.executeQuery(sqlp);
            if (rs1 == null) {
                return "0";
            }
            ct = null;
            cn = null;
            if (rs1.next()) {
                ct = rs1.getString(1);
                cn = rs1.getString(2);
                ct = ct != null && ct.equals(Character.valueOf('P')) ? "1" : (ct != null && ct.equals(Character.valueOf('F')) ? "2" : "0");
            }
            if (ct == null) {
                return "0";
            }
            if (cn == null) {
                return ct;
            }
            return ct + cn;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "0";
        }
    }

    public String getSystemUser() {
        return "db2adm";
    }

    public String getSystemDatabase(String databaseName) {
        return databaseName;
    }

    public String TO_DATE(Timestamp time, boolean dayOnly) {
        if (time == null) {
            if (dayOnly) {
                return "trunc(CURRENT TIMESTAMP, 'DD')";
            }
            return "CURRENT TIMESTAMP";
        }
        StringBuffer dateString = new StringBuffer("TIMESTAMP('");
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTimeInMillis(time.getTime());
        String myDate = Integer.toString(cal.get(1));
        String mm = Integer.toString(cal.get(2) + 1);
        if (mm.length() == 1) {
            mm = "0" + mm;
        }
        myDate = myDate + mm;
        mm = Integer.toString(cal.get(5));
        if (mm.length() == 1) {
            mm = "0" + mm;
        }
        myDate = myDate + mm;
        if (dayOnly) {
            dateString.append(myDate + "000000')");
        } else {
            mm = Integer.toString(cal.get(11));
            if (mm.length() == 1) {
                mm = "0" + mm;
            }
            myDate = myDate + mm;
            mm = Integer.toString(cal.get(12));
            if (mm.length() == 1) {
                mm = "0" + mm;
            }
            myDate = myDate + mm;
            mm = Integer.toString(cal.get(13));
            if (mm.length() == 1) {
                mm = "0" + mm;
            }
            myDate = myDate + mm;
            dateString.append(myDate + "')");
        }
        return dateString.toString();
    }

    public String TO_CHAR(String columnName, int displayType, String AD_Language) {
        return DBUtils.TO_CHAR(columnName, displayType, AD_Language);
    }

    public String TO_NUMBER(BigDecimal number, int displayType) {
        if (number == null) {
            return "NULL";
        }
        return number.toString();
    }

    public String[] getCommands(int cmdType) {
        if (0 == cmdType) {
            return new String[0];
        }
        if (1 == cmdType) {
            return new String[0];
        }
        if (2 == cmdType) {
            return new String[0];
        }
        return null;
    }

    public DataSource getDataSource(CConnection connection) {
        if (this.m_ds == null) {
            this.m_ds = new DB2DataSource();
            this.m_ds.setServerName(connection.getDbHost());
            this.m_ds.setPortNumber(connection.getDbPort());
            this.m_ds.setDatabaseName(connection.getDbName());
            this.m_ds.setDescription("Compiere DataSource");
            this.m_ds.setUser(connection.getDbUid());
            this.m_ds.setPassword(connection.getDbPwd());
            this.m_ds.setLoginTimeout(5);
            this.m_ds.setCurrentSchema("COMPIERE");
        }
        return this.m_ds;
    }

    public Connection getCachedConnection(CConnection connection, boolean autoCommit, int transactionIsolation) throws Exception {
        Connection conn = this.getDataSource(connection).getConnection();
        conn.setAutoCommit(autoCommit);
        conn.setTransactionIsolation(transactionIsolation);
        return conn;
    }

    public Connection getDriverConnection(CConnection connection) throws SQLException {
        this.getDriver();
        this.m_conn = DriverManager.getConnection(this.getConnectionURL(connection), connection.getDbUid(), connection.getDbPwd());
        return this.m_conn;
    }

    public Connection getDriverConnection(String dbUrl, String dbUid, String dbPwd) throws SQLException {
        this.getDriver();
        this.m_conn = DriverManager.getConnection(dbUrl, dbUid, dbPwd);
        return this.m_conn;
    }

    public void close() {
        log.config(this.toString());
        this.m_ds = null;
    }

    public void cleanup() {
        log.config("");
    }

    public String getDataType(int displayType, int precision, boolean defaultValue) {
        String retValue = null;
        switch (displayType) {
            case 13: 
            case 18: 
            case 19: 
            case 21: 
            case 25: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: {
                retValue = "INTEGER";
                break;
            }
            case 12: {
                retValue = "DECIMAL(18,2)";
                if (!defaultValue) break;
                retValue = retValue + " DEFAULT 0";
                break;
            }
            case 23: {
                retValue = "BLOB";
                break;
            }
            case 28: {
                retValue = "CHAR(1)";
                break;
            }
            case 37: {
                retValue = "DECIMAL(22,6)";
                if (!defaultValue) break;
                retValue = retValue + " DEFAULT 0";
                break;
            }
            case 15: 
            case 16: 
            case 24: {
                retValue = "Timestamp";
                if (!defaultValue) break;
                retValue = retValue + " DEFAULT 0";
                break;
            }
            case 11: {
                retValue = "NUMBER(10)";
                break;
            }
            case 17: {
                retValue = "CHAR(" + precision + ")";
                break;
            }
            case 10: 
            case 14: 
            case 34: {
                retValue = "NVARCHAR(" + precision + ")";
                break;
            }
            case 36: {
                retValue = "CLOB";
                break;
            }
            case 29: {
                retValue = "NUMBER";
                break;
            }
            case 20: {
                retValue = "CHAR(1)";
                break;
            }
            default: {
                log.severe("Unknown: " + displayType);
            }
        }
        return retValue;
    }

    private String getNewkey(String oldkey, String ktype, String sql) {
        String newKey = null;
        String s_key = null;
        if (ktype.equals("K") || this.m_conn == null) {
            int ikey = this.r_key.nextInt();
            if (ikey < 0) {
                ikey *= -1;
            }
            if ((s_key = Integer.toString(ikey)).length() > 12) {
                s_key = s_key.substring(s_key.length() - 12, s_key.length());
            }
            newKey = ktype + s_key + "_KEY";
            return newKey;
        }
        int it1 = sql.indexOf("ALTER TABLE ") + 12;
        int it1e = sql.indexOf(" ADD ", it1);
        int it2 = sql.indexOf("REFERENCES ") + 11;
        int it2e = sql.indexOf("(", it2);
        if (it1 == -1 || it1e == -1 || it2 == -1 || it2e == -1) {
            return oldkey;
        }
        String[] tbname = new String[]{sql.substring(it1, it1e), sql.substring(it2, it2e)};
        int[] tid = new int[]{0, 0};
        try {
            Statement s = this.m_conn.createStatement();
            for (int i = 0; i < tbname.length; ++i) {
                String sql1 = "select ad_table_id from ad_table where tablename = '" + tbname[i] + "'";
                ResultSet rs = s.executeQuery(sql1);
                if (rs.next()) {
                    tid[i] = rs.getInt(1);
                }
                rs.close();
            }
            if (tid[0] == 0 || tid[1] == 0) {
                return oldkey;
            }
            s_key = ktype + String.valueOf(tid[0]) + "_" + String.valueOf(tid[1]);
            return s_key;
        }
        catch (SQLException e) {
            return oldkey;
        }
    }

    public String getAlternativeSQL(int reExNo, String msg, String sql) {
        if (sql == null || sql.length() == 0) {
            return null;
        }
        StringBuffer newSQL = null;
        int is = msg.indexOf("The name \"");
        int ie = msg.indexOf("\" is too long.  The maximum length ");
        int ifk = sql.indexOf("FOREIGN KEY");
        if (sql.startsWith("CREATE TABLE ") && is >= 0 && ie > 0 || sql.startsWith("ALTER TABLE ") && is >= 0 && ie > 0 && ifk > 0) {
            String oldkey;
            String newKey;
            String ktype = "K";
            if (ifk > 0) {
                ktype = "F";
            }
            if ((newKey = this.getNewkey(oldkey = msg.substring(is + 10, ie), ktype, sql)) == null) {
                return null;
            }
            newSQL = new StringBuffer(sql);
            int bk = 0;
            int ak = 0;
            if (sql.startsWith("CREATE TABLE ")) {
                bk = sql.indexOf(" CONSTRAINT ") + 12;
                ak = sql.indexOf(" PRIMARY KEY ", bk);
            } else {
                bk = sql.indexOf(" CONSTRAINT ") + 12;
                ak = sql.indexOf(" FOREIGN KEY ", bk);
            }
            return oldkey + " | " + newSQL.toString().substring(0, bk) + newKey + newSQL.toString().substring(ak, newSQL.length());
        }
        return CConstraint.forTrigger(reExNo, msg, sql);
    }

    public String nullValue(String sqlClause, int dataType) {
        return DBUtils.nullValue(sqlClause, dataType);
    }

    public String updateSetSelectList(String sql) {
        return DBUtils.updateSetSelectList(sql);
    }

    public Clob getClob(Connection con, String clobString) {
        return null;
    }

    public Blob getBlob(Connection con, byte[] bytes) {
        return null;
    }

    public static void main(String[] args) {
        try {
            DB2Driver driver = new DB2Driver();
            DriverManager.registerDriver((Driver)driver);
            Connection con = DriverManager.getConnection("jdbc:db2://dev1:50000/sample", "db2admin", "db2admin");
            System.out.println("Connection Catalog = " + con.getCatalog());
            DatabaseMetaData md = con.getMetaData();
            System.out.println(md.getDatabaseProductName() + " - " + md.getDatabaseProductVersion());
            System.out.println(md.getDriverName() + " - " + md.getDriverVersion());
            System.out.println("URL=" + md.getURL());
            System.out.println("User=" + md.getUserName());
            System.out.println(md.getNumericFunctions());
            System.out.println(md.getStringFunctions());
            System.out.println(md.getTimeDateFunctions());
            System.out.println(md.getSystemFunctions());
            System.out.println("Catalogs - " + md.getCatalogTerm());
            ResultSet rs = md.getCatalogs();
            while (rs.next()) {
                System.out.println("- " + rs.getString(1));
            }
            System.out.println("Schemas - " + md.getSchemaTerm());
            rs = md.getSchemas();
            while (rs.next()) {
                System.out.println("- " + rs.getString(1));
            }
            String sql = "SELECT GRANTOR,GRANTEE,DBADMAUTH FROM SYSCAT.DBAUTH";
            PreparedStatement pstmt = null;
            try {
                pstmt = con.prepareStatement(sql);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    String GRANTOR = rs.getString(1);
                    String GRANTEE = rs.getString(2);
                    String DBADMAUTH = rs.getString(3);
                    System.out.println(GRANTOR + " -> " + GRANTEE + " = " + DBADMAUTH);
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, sql, e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception e) {
                pstmt = null;
            }
            System.out.println("SysCat Table");
            rs = md.getTables(null, "SYSCAT", null, new String[]{"TABLE", "VIEW"});
            while (rs.next()) {
                System.out.println("- User=" + rs.getString(2) + " | Table=" + rs.getString(3) + " | Type=" + rs.getString(4) + " | " + rs.getString(5));
            }
            System.out.println("Column");
            rs = md.getColumns(null, "SYSCAT", "DBAUTH", null);
            while (rs.next()) {
                System.out.println("- Tab=" + rs.getString(3) + " | Col=" + rs.getString(4) + " | Type=" + rs.getString(5) + ", " + rs.getString(6) + " | Size=" + rs.getString(7) + " | " + rs.getString(8) + " | Digits=" + rs.getString(9) + " | Radix=" + rs.getString(10) + " | Null=" + rs.getString(11) + " | Rem=" + rs.getString(12) + " | Def=" + rs.getString(13) + " | " + rs.getString(14) + " | " + rs.getString(15) + " | " + rs.getString(16) + " | Ord=" + rs.getString(17) + " | Null=" + rs.getString(18));
            }
            con.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }
}

