/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.db;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import javax.sql.DataSource;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleDriver;
import oracle.jdbc.pool.OracleConnectionCacheManager;
import oracle.jdbc.pool.OracleDataSource;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import org.compiere.Compiere;
import org.compiere.db.CConnection;
import org.compiere.db.CompiereDatabase;
import org.compiere.db.Database;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Ini;
import org.compiere.util.Language;
import org.compiere.util.Util;

public class DB_Oracle
implements CompiereDatabase {
    private static OracleDriver s_driver = null;
    public static final String DRIVER = "oracle.jdbc.OracleDriver";
    public static final int DEFAULT_PORT = 1521;
    public static final int DEFAULT_CM_PORT = 1630;
    private String m_connectionURL;
    private static final int MAX_STATEMENTS = 50;
    private OracleDataSource m_ds = null;
    private static final boolean USE_CACHE = false;
    private OracleConnectionCacheManager m_cacheMgr = null;
    private static final String CACHE_NAME = "CompiereCCache";
    private String m_userName = null;
    private static CLogger log = CLogger.getCLogger(DB_Oracle.class);

    public boolean isConnectionValid(Connection conn) {
        try {
            return ((OracleConnection)conn).pingDatabase(1) >= 0;
        }
        catch (SQLException e) {
            return false;
        }
    }

    public String getName() {
        return "oracle";
    }

    public String getDescription() {
        try {
            if (s_driver == null) {
                this.getDriver();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (s_driver != null) {
            return s_driver.toString();
        }
        return "No Driver";
    }

    public int getStandardPort() {
        return 1521;
    }

    public Driver getDriver() throws SQLException {
        if (s_driver == null) {
            System.setProperty("oracle.jdbc.TcpNoDelay", "true");
            System.setProperty("oracle.jdbc.defaultNChar", "true");
            s_driver = new OracleDriver();
            DriverManager.registerDriver((Driver)s_driver);
            DriverManager.setLoginTimeout(Database.CONNECTION_TIMEOUT);
        }
        return s_driver;
    }

    public String getConnectionURL(CConnection connection) {
        StringBuffer sb = null;
        if (connection.isBequeath()) {
            sb = new StringBuffer("jdbc:oracle:oci8:@");
        } else {
            sb = new StringBuffer("jdbc:oracle:thin:@");
            if (connection.isViaFirewall()) {
                sb.append("(DESCRIPTION=(ADDRESS_LIST=").append("(SOURCE_ROUTE=YES)").append("(ADDRESS=(PROTOCOL=TCP)(HOST=").append(connection.getFwHost()).append(")(PORT=").append(connection.getFwPort()).append("))").append("(ADDRESS=(PROTOCOL=TCP)(HOST=").append(connection.getDbHost()).append(")(PORT=").append(connection.getDbPort()).append(")))").append("(CONNECT_DATA=(SERVICE_NAME=").append(connection.getDbName()).append(")))");
            } else {
                sb.append("//").append(connection.getDbHost()).append(":").append(connection.getDbPort()).append("/").append(connection.getDbName());
            }
        }
        this.m_connectionURL = sb.toString();
        this.m_userName = connection.getDbUid();
        return this.m_connectionURL;
    }

    public String getConnectionURL(String dbHost, int dbPort, String dbName, String userName) {
        this.m_userName = userName;
        this.m_connectionURL = "jdbc:oracle:thin:@//" + dbHost + ":" + dbPort + "/" + dbName;
        return this.m_connectionURL;
    }

    public String getConnectionURL(String connectionURL, String userName) {
        this.m_userName = userName;
        this.m_connectionURL = connectionURL;
        return this.m_connectionURL;
    }

    public String getCatalog() {
        return null;
    }

    public String getSchema() {
        if (this.m_userName != null) {
            return this.m_userName.toUpperCase();
        }
        log.severe("User Name not set (yet) - call getConnectionURL first");
        return null;
    }

    public boolean supportsBLOB() {
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("DB_Oracle[");
        sb.append(this.m_connectionURL);
        try {
            if (this.m_ds != null) {
                sb.append("-").append(this.m_ds.getDataSourceName()).append(",ImplCache=").append(this.m_ds.getImplicitCachingEnabled()).append(",MaxStmts=").append(this.m_ds.getMaxStatements());
            }
            if (this.m_cacheMgr != null && this.m_cacheMgr.existsCache(CACHE_NAME)) {
                sb.append(";ConnectionActive=").append(this.m_cacheMgr.getNumberOfActiveConnections(CACHE_NAME)).append(",CacheAvailable=").append(this.m_cacheMgr.getNumberOfAvailableConnections(CACHE_NAME));
            }
        }
        catch (Exception e) {
            sb.append("=").append(e.getLocalizedMessage());
        }
        sb.append("]");
        return sb.toString();
    }

    public String getStatus() {
        StringBuffer sb = new StringBuffer();
        try {
            if (this.m_cacheMgr != null && this.m_cacheMgr.existsCache(CACHE_NAME)) {
                sb.append("-Connections=").append(this.m_cacheMgr.getNumberOfActiveConnections(CACHE_NAME)).append(",Cache=").append(this.m_cacheMgr.getNumberOfAvailableConnections(CACHE_NAME));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    public String convertStatement(String oraStatement) {
        return oraStatement;
    }

    public boolean isSupported(String sql) {
        return true;
    }

    public String getConstraintType(Connection conn, String tableName, String IXName) {
        if (IXName == null || IXName.length() == 0) {
            return "0";
        }
        if (IXName.endsWith("_KEY")) {
            return "1" + IXName;
        }
        return "0";
    }

    public String getSystemUser() {
        return "system";
    }

    public String getSystemDatabase(String databaseName) {
        return databaseName;
    }

    public String TO_DATE(Timestamp time, boolean dayOnly) {
        if (time == null) {
            if (dayOnly) {
                return "TRUNC(SysDate)";
            }
            return "SysDate";
        }
        StringBuffer dateString = new StringBuffer("TO_DATE('");
        String myDate = time.toString();
        if (dayOnly) {
            dateString.append(myDate.substring(0, 10));
            dateString.append("','YYYY-MM-DD')");
        } else {
            dateString.append(myDate.substring(0, myDate.indexOf(".")));
            dateString.append("','YYYY-MM-DD HH24:MI:SS')");
        }
        return dateString.toString();
    }

    public String TO_CHAR(String columnName, int displayType, String AD_Language) {
        StringBuffer retValue = new StringBuffer("TRIM(TO_CHAR(");
        retValue.append(columnName);
        if (DisplayType.isNumeric((int)displayType)) {
            if (displayType == 12) {
                retValue.append(",'9G999G990D00'");
            } else {
                retValue.append(",'TM9'");
            }
            if (!Language.isDecimalPoint(AD_Language)) {
                retValue.append(",'NLS_NUMERIC_CHARACTERS='',.'''");
            }
        } else if (DisplayType.isDate((int)displayType)) {
            retValue.append(",'").append(Language.getLanguage(AD_Language).getDBdatePattern()).append("'");
        }
        retValue.append("))");
        return retValue.toString();
    }

    public String TO_NUMBER(BigDecimal number, int displayType) {
        if (number == null) {
            return "NULL";
        }
        BigDecimal result = number;
        int scale = DisplayType.getDefaultPrecision((int)displayType);
        if (scale > number.scale()) {
            try {
                result = number.setScale(scale, 4);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result.toString();
    }

    public String[] getCommands(int cmdType) {
        if (0 == cmdType) {
            return new String[0];
        }
        if (1 == cmdType) {
            return new String[0];
        }
        if (2 == cmdType) {
            return new String[0];
        }
        return null;
    }

    public DataSource getDataSource(CConnection connection) {
        if (this.m_ds != null) {
            return this.m_ds;
        }
        try {
            this.m_ds = new OracleDataSource();
            this.m_ds.setDriverType("thin");
            this.m_ds.setNetworkProtocol("tcp");
            this.m_ds.setServerName(connection.getDbHost());
            this.m_ds.setServiceName(connection.getDbName());
            this.m_ds.setPortNumber(connection.getDbPort());
            this.m_ds.setUser(connection.getDbUid());
            this.m_ds.setPassword(connection.getDbPwd());
            this.m_ds.setDataSourceName("CompiereDS");
            this.m_ds.setDescription("Compiere Oracle Data Source");
            this.m_ds.setImplicitCachingEnabled(true);
            this.m_ds.setExplicitCachingEnabled(true);
            this.m_ds.setMaxStatements(50);
            Properties connProperties = new Properties();
            connProperties.setProperty("SetBigStringUseClob", "true");
            connProperties.setProperty("SetBigStringTryClob", "true");
            this.m_ds.setConnectionProperties(connProperties);
            Properties cacheProperties = new Properties();
            cacheProperties.setProperty("ClosestConnectionMatch", "true");
            cacheProperties.setProperty("ValidateConnection", "true");
            if (Ini.isClient()) {
                cacheProperties.setProperty("MinLimit", "0");
                cacheProperties.setProperty("InactivityTimeout", "300");
                cacheProperties.setProperty("AbandonedConnectionTimeout", "300");
            } else {
                cacheProperties.setProperty("MinLimit", "3");
                cacheProperties.setProperty("InactivityTimeout", "600");
                cacheProperties.setProperty("AbandonedConnectionTimeout", "600");
            }
            cacheProperties.setProperty("PropertyCheckInterval", "120");
            if (this.m_cacheMgr == null) {
                // empty if block
            }
            log.config(this.toString());
            return this.m_ds;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, this.toString(), e);
            return null;
        }
    }

    public Connection getCachedConnection(CConnection connection, boolean autoCommit, int transactionIsolation) throws Exception {
        OracleConnection conn = null;
        Exception exception = null;
        try {
            if (this.m_ds == null) {
                this.getDataSource(connection);
            }
            for (int i = 0; i < 5; ++i) {
                block14: {
                    try {
                        conn = (OracleConnection)this.m_ds.getConnection();
                        if (conn == null) break block14;
                        if (conn.getTransactionIsolation() != transactionIsolation) {
                            conn.setTransactionIsolation(transactionIsolation);
                        }
                        if (conn.getAutoCommit() != autoCommit) {
                            conn.setAutoCommit(autoCommit);
                        }
                        conn.setDefaultRowPrefetch(20);
                    }
                    catch (Exception e) {
                        exception = e;
                        conn = null;
                        if (!(e instanceof SQLException) || ((SQLException)e).getErrorCode() != 1017) break block14;
                        log.severe("Cannot connect to database: " + this.getConnectionURL(connection) + " - UserID=" + connection.getDbUid());
                        break;
                    }
                }
                try {
                    if (conn != null && conn.isClosed()) {
                        conn = null;
                    }
                    if (conn != null && !conn.isClosed()) break;
                    if (i == 0) {
                        Thread.yield();
                        continue;
                    }
                    Thread.sleep(100L);
                    continue;
                }
                catch (Exception e) {
                    exception = e;
                    conn = null;
                }
            }
            if (conn == null && exception != null) {
                log.log(Level.SEVERE, exception.toString());
                log.fine(this.toString());
                log.finest("Reference=" + this.m_ds.getReference());
            }
        }
        catch (Exception e) {
            exception = e;
        }
        if (exception != null) {
            throw exception;
        }
        return conn;
    }

    public Connection getDriverConnection(CConnection connection) throws SQLException {
        this.getDriver();
        return DriverManager.getConnection(this.getConnectionURL(connection), connection.getDbUid(), connection.getDbPwd());
    }

    public Connection getDriverConnection(String dbUrl, String dbUid, String dbPwd) throws SQLException {
        this.getDriver();
        return DriverManager.getConnection(dbUrl, dbUid, dbPwd);
    }

    public void close() {
        log.config(this.toString());
        if (this.m_ds != null) {
            try {
                this.m_ds.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (this.m_cacheMgr != null) {
            try {
                if (this.m_cacheMgr.existsCache(CACHE_NAME)) {
                    this.m_cacheMgr.purgeCache(CACHE_NAME, false);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        this.m_cacheMgr = null;
        this.m_ds = null;
    }

    public void cleanup() {
    }

    public boolean handleAbandonedConnection(OracleConnection conn, Object userObject) {
        System.out.println("--------------------handleAbandonedConnection " + conn + " - " + userObject);
        return true;
    }

    public void releaseConnection(OracleConnection conn, Object userObject) {
        System.out.println("----------------------releaseConnection " + conn + " - " + userObject);
    }

    public String getDataType(int displayType, int precision, boolean defaultValue) {
        String retValue = null;
        switch (displayType) {
            case 13: 
            case 18: 
            case 19: 
            case 21: 
            case 25: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: {
                retValue = "NUMBER(10)";
                break;
            }
            case 12: {
                retValue = "NUMBER";
                if (!defaultValue) break;
                retValue = retValue + " DEFAULT 0";
                break;
            }
            case 23: {
                retValue = "BLOB";
                break;
            }
            case 28: {
                retValue = "CHAR(1)";
                break;
            }
            case 37: {
                retValue = "NUMBER";
                if (!defaultValue) break;
                retValue = retValue + " DEFAULT 0";
                break;
            }
            case 15: 
            case 16: 
            case 24: {
                retValue = "DATE";
                if (!defaultValue) break;
                retValue = retValue + " DEFAULT SYSDATE";
                break;
            }
            case 11: {
                retValue = "NUMBER(10)";
                break;
            }
            case 17: {
                retValue = "CHAR(" + precision + ")";
                break;
            }
            case 10: 
            case 14: 
            case 34: {
                retValue = "NVARCHAR(" + precision + ")";
                break;
            }
            case 36: {
                retValue = "CLOB";
                break;
            }
            case 29: {
                retValue = "NUMBER";
                break;
            }
            case 20: {
                retValue = "CHAR(1)";
                break;
            }
            default: {
                log.severe("Unknown: " + displayType);
            }
        }
        return retValue;
    }

    public String getAlternativeSQL(int reExNo, String msg, String sql) {
        return null;
    }

    public String updateSetSelectList(String sql) {
        return sql;
    }

    public String nullValue(String sqlClause, int dataType) {
        return "NULL";
    }

    public Clob getClob(Connection con, String clobString) {
        if (con == null || clobString == null) {
            return null;
        }
        CLOB clob = null;
        try {
            clob = CLOB.createTemporary((Connection)con, (boolean)true, (int)10);
            clob.open(1);
            clob.setString(1L, clobString);
            clob.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return clob;
    }

    public Blob getBlob(Connection con, byte[] bytes) {
        if (con == null || bytes == null) {
            return null;
        }
        BLOB blob = null;
        try {
            blob = BLOB.createTemporary((Connection)con, (boolean)true, (int)10);
            blob.open(1);
            blob.setBytes(1L, bytes);
            blob.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return blob;
    }

    public static void main(String[] args) {
        Compiere.startup(true);
        CConnection cc = CConnection.get();
        DB_Oracle db = (DB_Oracle)cc.getDatabase();
        db.cleanup();
        try {
            Connection conn = null;
            DataSource ds = db.getDataSource(cc);
            System.out.println("DS=" + ds.getConnection());
            conn = db.getCachedConnection(cc, true, 2);
            System.out.println("Cached=" + conn);
            System.out.println(db);
            System.out.println("JAVA classpath: [\n" + System.getProperty("java.class.path") + "\n]");
            DatabaseMetaData dmd = conn.getMetaData();
            System.out.println("DriverVersion: [" + dmd.getDriverVersion() + "]");
            System.out.println("DriverMajorVersion: [" + dmd.getDriverMajorVersion() + "]");
            System.out.println("DriverMinorVersion: [" + dmd.getDriverMinorVersion() + "]");
            System.out.println("DriverName: [" + dmd.getDriverName() + "]");
            System.out.println("ProductName: [" + dmd.getDatabaseProductName() + "]");
            System.out.println("ProductVersion: [\n" + dmd.getDatabaseProductVersion() + "\n]");
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        db.cleanup();
        System.out.println("--------------------------------------------------");
        try {
            String myString1 = "123456789 12345678";
            String myString = "";
            for (int i = 0; i < 99; ++i) {
                myString = myString + myString1 + (char)(97 + i) + "\n";
            }
            System.out.println(myString.length());
            System.out.println(Util.size(myString));
            myString = Util.trimSize(myString, 2000);
            System.out.println(myString.length());
            System.out.println(Util.size(myString));
            Connection conn2 = db.getCachedConnection(cc, true, 2);
            PreparedStatement pstmt = conn2.prepareStatement("INSERT INTO X_Test(Text1, Text2) values(?,?)");
            pstmt.setString(1, myString);
            pstmt.setString(2, myString);
            System.out.println(pstmt.executeUpdate());
            Statement stmt = conn2.createStatement();
            System.out.println(stmt.executeUpdate("INSERT INTO X_Test(Text1, Text2) values('" + myString + "','" + myString + "')"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        db.cleanup();
        System.out.println("--------------------------------------------------");
        System.exit(0);
        System.out.println("--------------------------------------------------");
        try {
            Connection conn1 = db.getCachedConnection(cc, false, 2);
            Connection conn2 = db.getCachedConnection(cc, true, 2);
            Connection conn3 = db.getCachedConnection(cc, false, 2);
            System.out.println("3 -> " + db);
            conn1.close();
            conn2.close();
            conn1 = db.getCachedConnection(cc, true, 2);
            conn2 = db.getCachedConnection(cc, true, 2);
            System.out.println("3 -> " + db);
            conn1.close();
            conn2.close();
            conn3.close();
            System.out.println("0 -> " + db);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        db.cleanup();
        System.out.println("--------------------------------------------------");
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.createConnection(false, 2));
        System.out.println(db);
        try {
            System.out.println("-- Sleeping --");
            Thread.sleep(60000L);
            System.out.println(db);
            db.close();
            db.cleanup();
            System.out.println(db);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

