/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.framework;

import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.AbstractListModel;
import javax.swing.MutableComboBoxModel;
import org.compiere.framework.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.KeyNamePair;
import org.compiere.util.NamePair;
import org.compiere.util.ValueNamePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Lookup
extends AbstractListModel
implements MutableComboBoxModel,
Serializable {
    protected volatile ArrayList<NamePair> p_data = new ArrayList();
    private volatile Object m_selectedObject;
    private NamePair[] m_tempData = null;
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private Ctx m_ctx;
    protected int m_WindowNo;
    private int m_displayType;
    private boolean m_validationDisabled = false;

    public Lookup(Ctx ctx, int windowNo, int displayType) {
        this.setContext(ctx, windowNo);
        this.setDisplayType(displayType);
    }

    public void setContext(Ctx ctx, int windowNo) {
        this.m_ctx = ctx;
        this.m_WindowNo = windowNo;
    }

    public Ctx getCtx() {
        return this.m_ctx;
    }

    public int getWindowNo() {
        return this.m_WindowNo;
    }

    public int getDisplayType() {
        return this.m_displayType;
    }

    public void setDisplayType(int displayType) {
        this.m_displayType = displayType;
    }

    @Override
    public void setSelectedItem(Object anObject) {
        if (this.m_selectedObject != null && !this.m_selectedObject.equals(anObject) || this.m_selectedObject == null && anObject != null) {
            if (this.p_data.contains(anObject) || anObject == null) {
                this.m_selectedObject = anObject;
            } else {
                this.m_selectedObject = null;
                this.log.fine(this.getColumnName() + ": setSelectedItem - Set to NULL");
            }
            this.fireContentsChanged(this, -1, -1);
        }
    }

    @Override
    public Object getSelectedItem() {
        return this.m_selectedObject;
    }

    @Override
    public int getSize() {
        return this.p_data.size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.p_data.get(index);
    }

    public int getIndexOf(Object anObject) {
        return this.p_data.indexOf(anObject);
    }

    public void addElement(NamePair anObject) {
        this.p_data.add(anObject);
        this.fireIntervalAdded(this, this.p_data.size() - 1, this.p_data.size() - 1);
        if (this.p_data.size() == 1 && this.m_selectedObject == null && anObject != null) {
            this.setSelectedItem(anObject);
        }
    }

    public void addElement(Object anObject) {
        this.addElement((NamePair)anObject);
    }

    public void insertElementAt(NamePair anObject, int index) {
        this.p_data.add(index, anObject);
        this.fireIntervalAdded(this, index, index);
    }

    public void insertElementAt(Object anObject, int index) {
        this.insertElementAt((NamePair)anObject, index);
    }

    @Override
    public void removeElementAt(int index) {
        if (this.getElementAt(index) == this.m_selectedObject) {
            if (index == 0) {
                this.setSelectedItem(this.getSize() == 1 ? null : this.getElementAt(index + 1));
            } else {
                this.setSelectedItem(this.getElementAt(index - 1));
            }
        }
        this.p_data.remove(index);
        this.fireIntervalRemoved(this, index, index);
    }

    @Override
    public void removeElement(Object anObject) {
        int index = this.p_data.indexOf(anObject);
        if (index != -1) {
            this.removeElementAt(index);
        }
    }

    public void removeAllElements() {
        if (this.p_data.size() > 0) {
            int firstIndex = 0;
            int lastIndex = this.p_data.size() - 1;
            this.p_data.clear();
            this.m_selectedObject = null;
            this.fireIntervalRemoved(this, firstIndex, lastIndex);
        }
    }

    public void put(String key, String value) {
        ValueNamePair pp = new ValueNamePair(key, value);
        this.addElement((NamePair)pp);
    }

    public void put(int key, String value) {
        KeyNamePair pp = new KeyNamePair(key, value);
        this.addElement((NamePair)pp);
    }

    public void fillComboBox(boolean mandatory, boolean onlyValidated, boolean onlyActive, boolean temporary) {
        long startTime = System.currentTimeMillis();
        if (temporary) {
            int size = this.p_data.size();
            this.m_tempData = new NamePair[size];
            this.p_data.toArray(this.m_tempData);
        }
        Object obj = this.m_selectedObject;
        if (this.p_data != null) {
            this.p_data.clear();
        }
        this.p_data = this.getData(mandatory, onlyValidated, onlyActive, temporary);
        int size = 0;
        if (this.p_data != null) {
            size = this.p_data.size();
        }
        if (obj != this.m_selectedObject) {
            this.log.finest(this.getColumnName() + ": SelectedValue Changed=" + obj + "->" + this.m_selectedObject);
            obj = this.m_selectedObject;
        }
        if (obj == null && mandatory && size > 0) {
            this.m_selectedObject = obj = this.p_data.get(0);
            this.log.finest(this.getColumnName() + ": SelectedValue SetToFirst=" + obj);
        }
        this.fireContentsChanged(this, 0, size);
        if (size == 0) {
            this.log.fine(this.getColumnName() + ": #0 - ms=" + String.valueOf(System.currentTimeMillis() - startTime));
        } else {
            this.log.fine(this.getColumnName() + ": #" + size + " - ms=" + String.valueOf(System.currentTimeMillis() - startTime));
        }
    }

    public void fillComboBox(boolean restore) {
        if (restore && this.m_tempData != null) {
            Object obj = this.m_selectedObject;
            this.p_data.clear();
            this.p_data = new ArrayList(this.m_tempData.length);
            for (int i = 0; i < this.m_tempData.length; ++i) {
                this.p_data.add(this.m_tempData[i]);
            }
            this.m_tempData = null;
            if (obj == null && this.p_data.size() > 0) {
                obj = this.p_data.get(0);
            }
            this.setSelectedItem(obj);
            this.fireContentsChanged(this, 0, this.p_data.size());
            return;
        }
        if (this.p_data != null) {
            this.fillComboBox(false, false, false, false);
        }
    }

    public abstract String getDisplay(Object var1);

    public abstract NamePair get(Object var1);

    public abstract ArrayList<NamePair> getData(boolean var1, boolean var2, boolean var3, boolean var4);

    public abstract String getColumnName();

    public abstract boolean containsKey(Object var1);

    public int refresh() {
        return 0;
    }

    public void disableValidation() {
        String validationCode = this.getValidation();
        if (validationCode == null || validationCode.length() > 0) {
            // empty if block
        }
        this.m_validationDisabled = true;
    }

    public boolean isValidationDisabled() {
        return this.m_validationDisabled;
    }

    public boolean isValidated() {
        return true;
    }

    public String getValidation() {
        return "";
    }

    public boolean hasInactive() {
        return false;
    }

    public int getZoomWindow() {
        return 0;
    }

    public int getZoomWindow(Query query) {
        return 0;
    }

    public Query getZoomQuery() {
        return null;
    }

    public NamePair getDirect(Object key, boolean saveInCache, boolean cacheLocal) {
        return this.get(key);
    }

    public void dispose() {
        if (this.p_data != null) {
            this.p_data.clear();
        }
        this.p_data = null;
        this.m_selectedObject = null;
        this.m_tempData = null;
    }

    public void loadComplete() {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Lookup[");
        if (this.p_data != null) {
            sb.append("#").append(this.p_data.size());
        }
        sb.append("]");
        return sb.toString();
    }
}

