/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.framework;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.compiere.Compiere;
import org.compiere.api.DocWorkflowMgr;
import org.compiere.common.ChangeVO;
import org.compiere.framework.Lookup;
import org.compiere.framework.ModelValidationEngine;
import org.compiere.framework.POInfo;
import org.compiere.framework.PO_LOB;
import org.compiere.framework.PO_Record;
import org.compiere.framework.VO;
import org.compiere.model.MAssignSet;
import org.compiere.model.MAttachment;
import org.compiere.model.MChangeLog;
import org.compiere.model.MClient;
import org.compiere.model.MClientShare;
import org.compiere.model.MPreference;
import org.compiere.model.MSession;
import org.compiere.model.MTree;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.CacheMgt;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.DBException;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Evaluatee;
import org.compiere.util.Msg;
import org.compiere.util.Null;
import org.compiere.util.SecureEngine;
import org.compiere.util.Trace;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PO
implements Serializable,
Comparator<PO>,
Evaluatee {
    private static DocWorkflowMgr s_docWFMgr = null;
    protected static final String ENTITYTYPE_UserMaintained = "U";
    protected static final String ENTITYTYPE_Dictionary = "D";
    protected transient CLogger log = CLogger.getCLogger(this.getClass());
    private static CLogger s_log = CLogger.getCLogger(PO.class);
    protected Ctx p_ctx;
    protected volatile POInfo p_info = null;
    private Object[] m_oldValues = null;
    private Object[] m_newValues = null;
    private Object[] m_IDs = new Object[]{I_ZERO};
    private String[] m_KeyColumns = null;
    private boolean m_createNew = false;
    private MAttachment m_attachment = null;
    private int m_idOld = 0;
    private HashMap<String, String> m_custom = null;
    protected static final Integer I_ZERO = new Integer(0);
    private ArrayList<String> s_acctColumns = null;
    protected ChangeVO p_changeVO = null;
    public static final int ACCESSLEVEL_SYSTEM = 4;
    public static final int ACCESSLEVEL_CLIENT = 2;
    public static final int ACCESSLEVEL_ORG = 1;
    public static final int ACCESSLEVEL_ALL = 7;
    public static final int ACCESSLEVEL_SYSTEMCLIENT = 6;
    public static final int ACCESSLEVEL_CLIENTORG = 3;
    private String m_trxName = null;
    private ArrayList<PO_LOB> m_lobInfo = null;
    protected static final String XML_ATTRIBUTE_AD_Table_ID = "AD_Table_ID";
    protected static final String XML_ATTRIBUTE_Record_ID = "Record_ID";

    public static void setDocWorkflowMgr(DocWorkflowMgr docWFMgr) {
        s_docWFMgr = docWFMgr;
        s_log.config(s_docWFMgr.toString());
    }

    public static int convertToInt(String stringValue) {
        if (stringValue == null || stringValue.length() == 0) {
            throw new IllegalArgumentException("Value is NULL");
        }
        return Integer.parseInt(stringValue);
    }

    public static Timestamp convertToTimestamp(String stringValue) {
        if (stringValue == null || stringValue.length() == 0) {
            return null;
        }
        try {
            long time = Long.parseLong(stringValue);
            return new Timestamp(time);
        }
        catch (Exception e) {
            try {
                return Timestamp.valueOf(stringValue);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Cannot convert to Timestamp: " + stringValue);
            }
        }
    }

    public static BigDecimal convertToBigDecimal(String stringValue) {
        if (stringValue == null || stringValue.length() == 0) {
            return null;
        }
        return new BigDecimal(stringValue);
    }

    public static boolean convertToBoolean(String stringValue) {
        return stringValue != null && ("Y".equals(stringValue) || "true".equals(stringValue) || "on".equals(stringValue));
    }

    public PO(Ctx ctx) {
        this(ctx, 0, null, null);
    }

    public PO(Ctx ctx, int ID, String trxName) {
        this(ctx, ID, null, trxName);
    }

    public PO(Ctx ctx, ResultSet rs, String trxName) {
        this(ctx, 0, rs, trxName);
    }

    private PO(Ctx ctx, int ID, ResultSet rs, String trxName) {
        if (ctx == null) {
            throw new IllegalArgumentException("No Context");
        }
        this.p_ctx = ctx;
        this.p_info = this.initPO(ctx);
        if (this.p_info == null || this.p_info.getTableName() == null) {
            throw new IllegalArgumentException("Invalid PO Info - " + this.p_info);
        }
        int size = this.p_info.getColumnCount();
        this.m_oldValues = new Object[size];
        this.m_newValues = new Object[size];
        this.m_trxName = trxName;
        if (rs != null) {
            this.load(rs);
        } else {
            this.load(ID, trxName);
        }
    }

    public PO(Ctx ctx, PO source, int AD_Client_ID, int AD_Org_ID) {
        this(ctx, 0, null, null);
        if (source != null) {
            PO.copyValues(source, this);
        }
        this.setAD_Client_ID(AD_Client_ID);
        this.setAD_Org_ID(AD_Org_ID);
    }

    public PO(Ctx ctx, VO vo) {
        this(ctx, 0, null);
        this.load(vo);
    }

    protected abstract POInfo initPO(Ctx var1);

    protected abstract int get_AccessLevel();

    public String toString() {
        StringBuffer sb = new StringBuffer("PO[").append(this.get_WhereClause(true)).append("]");
        return sb.toString();
    }

    public String toStringX() {
        return this.toString();
    }

    @Override
    public boolean equals(Object cmp) {
        if (cmp == null) {
            return false;
        }
        if (!(cmp instanceof PO)) {
            return false;
        }
        if (cmp.getClass().equals(this.getClass())) {
            if (this.m_IDs.length < 2) {
                return ((PO)cmp).get_ID() == this.get_ID();
            }
            String[] keyColumns = this.get_KeyColumns();
            for (int i = 0; i < keyColumns.length; ++i) {
                Object o2;
                String keyColumn = keyColumns[i];
                Object o1 = this.get_Value(keyColumn);
                if (Util.isEqual(o1, o2 = ((PO)cmp).get_Value(keyColumn))) continue;
                return false;
            }
            return true;
        }
        return super.equals(cmp);
    }

    public int hashCode() {
        StringBuffer keyValue = new StringBuffer().append(this.get_Table_ID()).append(7);
        for (int i = 0; i < this.m_IDs.length; ++i) {
            keyValue.append(this.m_IDs[i]);
        }
        try {
            return Integer.parseInt(keyValue.toString());
        }
        catch (Exception exception) {
            return super.hashCode();
        }
    }

    @Override
    public int compare(PO o1, PO o2) {
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1.getClass().equals(o2.getClass())) {
            int index = this.get_ColumnIndex("DocumentNo");
            if (index == -1) {
                index = this.get_ColumnIndex("Value");
            }
            if (index == -1) {
                index = this.get_ColumnIndex("Name");
            }
            if (index == -1) {
                index = this.get_ColumnIndex("Description");
            }
            if (index != -1) {
                PO po1 = o1;
                Object comp1 = po1.get_Value(index);
                PO po2 = o2;
                Object comp2 = po2.get_Value(index);
                if (comp1 == null) {
                    return -1;
                }
                if (comp2 == null) {
                    return 1;
                }
                return comp1.toString().compareTo(comp2.toString());
            }
        }
        return o1.toString().compareTo(o2.toString());
    }

    public String get_TableName() {
        return this.p_info.getTableName();
    }

    public String[] get_KeyColumns() {
        return this.m_KeyColumns;
    }

    public boolean is_KeyColumn(String columnName) {
        for (int i = 0; i < this.m_KeyColumns.length; ++i) {
            if (!this.m_KeyColumns.equals(columnName)) continue;
            return true;
        }
        return false;
    }

    public int get_Table_ID() {
        return this.p_info.getAD_Table_ID();
    }

    public int get_ID() {
        Object oo = this.m_IDs[0];
        if (oo != null && oo instanceof Integer) {
            return (Integer)oo;
        }
        return 0;
    }

    public int get_IDOld() {
        return this.m_idOld;
    }

    public Ctx getCtx() {
        return this.p_ctx;
    }

    public CLogger get_Logger() {
        return this.log;
    }

    public final Object get_Value(int index) {
        if (index < 0 || index >= this.get_ColumnCount()) {
            this.log.log(Level.WARNING, "Index invalid - " + index);
            return null;
        }
        if (this.m_newValues[index] != null) {
            if (this.m_newValues[index].equals(Null.NULL)) {
                return null;
            }
            return this.m_newValues[index];
        }
        return this.m_oldValues[index];
    }

    protected int get_ValueAsInt(int index) {
        Object value = this.get_Value(index);
        if (value == null) {
            return 0;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (NumberFormatException ex) {
            this.log.warning(this.p_info.getColumnName(index) + " - " + ex.getMessage());
            return 0;
        }
    }

    public final Object get_Value(String columnName) {
        int index = this.get_ColumnIndex(columnName);
        if (index < 0) {
            this.log.log(Level.WARNING, "Column not found - " + columnName);
            Trace.printStack();
            return null;
        }
        return this.get_Value(index);
    }

    public String get_ValueAsString(String columnName) {
        Object value = this.get_Value(columnName);
        if (value == null) {
            return "";
        }
        if (value instanceof Timestamp) {
            long time = ((Timestamp)value).getTime();
            return String.valueOf(time);
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return "Y";
            }
            return "N";
        }
        return value.toString();
    }

    public String[] get_ValuesAsString(String[] columnNames) {
        String[] retValue = new String[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            retValue[i] = this.get_ValueAsString(columnNames[i]);
        }
        return retValue;
    }

    public final Object get_ValueOfColumn(int AD_Column_ID) {
        int index = this.p_info.getColumnIndex(AD_Column_ID);
        if (index < 0) {
            this.log.log(Level.WARNING, "Not found - AD_Column_ID=" + AD_Column_ID);
            return null;
        }
        return this.get_Value(index);
    }

    public final Object get_ValueOld(int index) {
        if (index < 0 || index >= this.get_ColumnCount()) {
            this.log.log(Level.WARNING, "Index invalid - " + index);
            return null;
        }
        return this.m_oldValues[index];
    }

    public final Object get_ValueOld(String columnName) {
        int index = this.get_ColumnIndex(columnName);
        if (index < 0) {
            this.log.log(Level.WARNING, "Column not found - " + columnName);
            return null;
        }
        return this.get_ValueOld(index);
    }

    protected int get_ValueOldAsInt(String columnName) {
        Object value = this.get_ValueOld(columnName);
        if (value == null) {
            return 0;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (NumberFormatException ex) {
            this.log.warning(columnName + " - " + ex.getMessage());
            return 0;
        }
    }

    public final boolean is_ValueChanged(int index) {
        if (index < 0 || index >= this.get_ColumnCount()) {
            this.log.log(Level.WARNING, "Index invalid - " + index);
            return false;
        }
        if (this.m_newValues[index] == null) {
            return false;
        }
        return !this.m_newValues[index].equals(this.m_oldValues[index]);
    }

    public final boolean is_ValueChanged(String columnName) {
        int index = this.get_ColumnIndex(columnName);
        if (index < 0) {
            this.log.log(Level.WARNING, "Column not found - " + columnName);
            return false;
        }
        return this.is_ValueChanged(index);
    }

    public final Object get_ValueDifference(int index) {
        if (index < 0 || index >= this.get_ColumnCount()) {
            this.log.log(Level.WARNING, "Index invalid - " + index);
            return null;
        }
        Object nValue = this.m_newValues[index];
        if (nValue == null || nValue == Null.NULL) {
            return null;
        }
        Object oValue = this.m_oldValues[index];
        if (oValue == null || oValue == Null.NULL) {
            return nValue;
        }
        if (nValue instanceof BigDecimal) {
            BigDecimal obd = (BigDecimal)oValue;
            return ((BigDecimal)nValue).subtract(obd);
        }
        if (nValue instanceof Integer) {
            int result = (Integer)nValue;
            return new Integer(result -= ((Integer)oValue).intValue());
        }
        this.log.warning("Invalid type - New=" + nValue);
        return null;
    }

    public final Object get_ValueDifference(String columnName) {
        int index = this.get_ColumnIndex(columnName);
        if (index < 0) {
            this.log.log(Level.WARNING, "Column not found - " + columnName);
            return null;
        }
        return this.get_ValueDifference(index);
    }

    public final boolean set_Value(String ColumnName, Object value) {
        int index;
        if (value instanceof String && ColumnName.equals("WhereClause") && value.toString().toUpperCase().indexOf("=NULL") != -1) {
            this.log.warning("Invalid Null Value - " + ColumnName + "=" + value);
        }
        if ((index = this.get_ColumnIndex(ColumnName)) < 0) {
            this.log.log(Level.SEVERE, "Column not found - " + ColumnName);
            return false;
        }
        if (ColumnName.endsWith("_ID") && value instanceof String) {
            this.log.warning("String converted to Integer for " + ColumnName + "=" + value);
            value = Integer.parseInt((String)value);
        }
        return this.set_Value(index, value);
    }

    protected final boolean set_ValueE(String ColumnName, Object value) {
        return this.set_Value(ColumnName, value);
    }

    public final boolean set_Value(int index, Object value) {
        if (index < 0 || index >= this.get_ColumnCount()) {
            this.log.log(Level.WARNING, "Index invalid - " + index);
            return false;
        }
        String ColumnName = this.p_info.getColumnName(index);
        String colInfo = " - " + ColumnName;
        if (this.p_info.isVirtualColumn(index)) {
            this.log.log(Level.WARNING, "Virtual Column" + colInfo);
            return false;
        }
        if (!this.p_info.isColumnUpdateable(index)) {
            colInfo = colInfo + " - NewValue=" + value + " - OldValue=" + this.get_Value(index);
            this.log.log(Level.WARNING, "Column not updateable" + colInfo);
            return false;
        }
        if (value == null) {
            if (this.p_info.isColumnMandatory(index)) {
                this.log.log(Level.WARNING, "Cannot set mandatory column to null " + colInfo);
                return false;
            }
            this.m_newValues[index] = Null.NULL;
            this.log.finer(ColumnName + " = null");
        } else {
            Class<?> clazz = this.p_info.getColumnClass(index);
            if (value.getClass().equals(clazz) || clazz == Object.class) {
                this.m_newValues[index] = value;
            } else if (value.getClass() == BigDecimal.class && clazz == Integer.class) {
                this.m_newValues[index] = new Integer(((BigDecimal)value).intValue());
            } else if (clazz == Boolean.class && ("Y".equals(value) || "N".equals(value))) {
                this.m_newValues[index] = new Boolean("Y".equals(value));
            } else if (this.p_info.getColumnDisplayType(index) == 28) {
                this.m_newValues[index] = ColumnName.endsWith("_ID") ? (value instanceof Integer ? value : new Integer(value.toString())) : value.toString();
            } else {
                this.log.log(Level.SEVERE, ColumnName + " - Class invalid: " + value.getClass().toString() + ", Should be " + clazz.toString() + ": " + value);
                return false;
            }
            String error = this.p_info.validate(index, value);
            if (error != null) {
                this.log.log(Level.WARNING, ColumnName + "=" + value + " - " + error);
                return false;
            }
            if (clazz == String.class) {
                String stringValue = value.toString();
                int length = this.p_info.getFieldLength(index);
                if (stringValue.length() > length && length > 0) {
                    this.log.warning(ColumnName + " - Value too long - truncated to length=" + length);
                    this.m_newValues[index] = stringValue.substring(0, length);
                }
            }
            this.log.finest(ColumnName + " = " + this.m_newValues[index]);
        }
        this.set_Keys(ColumnName, this.m_newValues[index]);
        if (this.p_changeVO != null) {
            this.p_changeVO.addChangedValue(ColumnName, value);
        }
        return true;
    }

    public final boolean set_ValueNoCheck(String ColumnName, Object value) {
        boolean success = true;
        int index = this.get_ColumnIndex(ColumnName);
        if (index < 0) {
            this.log.log(Level.SEVERE, "Column not found - " + ColumnName);
            return false;
        }
        if (value == null) {
            this.m_newValues[index] = Null.NULL;
        } else {
            Class<?> clazz = this.p_info.getColumnClass(index);
            if (value.getClass().equals(clazz) || clazz == Object.class) {
                this.m_newValues[index] = value;
            } else if (value.getClass() == BigDecimal.class && clazz == Integer.class) {
                this.m_newValues[index] = new Integer(((BigDecimal)value).intValue());
            } else if (clazz == Boolean.class && ("Y".equals(value) || "N".equals(value))) {
                this.m_newValues[index] = new Boolean("Y".equals(value));
            } else {
                this.log.warning(ColumnName + " - Class invalid: " + value.getClass().toString() + ", Should be " + clazz.toString() + ": " + value);
                this.m_newValues[index] = value;
            }
            String error = this.p_info.validate(index, value);
            if (error != null) {
                success = false;
                this.log.warning(ColumnName + "=" + value + " - " + error);
            }
            if (clazz == String.class) {
                String stringValue = value.toString();
                int length = this.p_info.getFieldLength(index);
                if (stringValue.length() > length && length > 0) {
                    this.log.warning(ColumnName + " - Value too long - truncated to length=" + length);
                    this.m_newValues[index] = stringValue.substring(0, length);
                }
            }
        }
        this.log.finest(ColumnName + " = " + this.m_newValues[index] + " (" + (this.m_newValues[index] == null ? "-" : this.m_newValues[index].getClass().getName()) + ")");
        this.set_Keys(ColumnName, this.m_newValues[index]);
        if (this.p_changeVO != null) {
            this.p_changeVO.addChangedValue(ColumnName, value);
        }
        return success;
    }

    protected final boolean set_ValueNoCheckE(String ColumnName, Object value) {
        return this.set_ValueNoCheckE(ColumnName, value);
    }

    protected String set_ValueString(int index, String stringValue) throws Exception {
        String error = null;
        if (index < 0 || index >= this.get_ColumnCount()) {
            return "Index invalid - " + index;
        }
        String ColumnName = this.p_info.getColumnName(index);
        String colInfo = " - " + ColumnName;
        if (this.p_info.isVirtualColumn(index)) {
            return "Virtual Column" + colInfo;
        }
        if (stringValue == null) {
            this.m_newValues[index] = Null.NULL;
            this.log.finer(ColumnName + " = null");
        } else {
            Class<?> clazz = this.p_info.getColumnClass(index);
            if (this.p_info.getColumnDisplayType(index) == 28) {
                this.m_newValues[index] = ColumnName.endsWith("_ID") ? new Integer(stringValue) : stringValue;
            } else if (clazz == String.class) {
                this.m_newValues[index] = stringValue;
                int length = this.p_info.getFieldLength(index);
                if (stringValue.length() > length && length > 0) {
                    this.log.warning(ColumnName + " - Value too long - truncated to length=" + length);
                    this.m_newValues[index] = stringValue.substring(0, length);
                }
            } else if (clazz == Integer.class) {
                this.m_newValues[index] = new Integer(stringValue);
            } else if (clazz == BigDecimal.class) {
                this.m_newValues[index] = new BigDecimal(stringValue);
            } else if (clazz == Timestamp.class) {
                long time = Long.parseLong(stringValue);
                this.m_newValues[index] = new Timestamp(time);
            } else if (clazz == Boolean.class) {
                if (!"Y".equals(stringValue) && !"N".equals(stringValue)) {
                    this.log.warning("Boolean value = " + stringValue);
                }
                this.m_newValues[index] = new Boolean("Y".equals(stringValue));
            } else {
                return ColumnName + ": Class unknown: " + clazz;
            }
            error = this.p_info.validate(index, stringValue);
            if (error != null) {
                return ColumnName + ": " + error;
            }
            this.log.finest(ColumnName + " = " + this.m_newValues[index]);
        }
        this.set_Keys(ColumnName, this.m_newValues[index]);
        return error;
    }

    public final void set_ValueOfColumn(int AD_Column_ID, Object value) {
        String ColumnName;
        int index = this.p_info.getColumnIndex(AD_Column_ID);
        if (index < 0) {
            this.log.log(Level.SEVERE, "Not found - AD_Column_ID=" + AD_Column_ID);
        }
        if ((ColumnName = this.p_info.getColumnName(index)).equals("IsApproved")) {
            this.set_ValueNoCheck(ColumnName, value);
        } else {
            this.set_Value(index, value);
        }
    }

    public final void set_CustomColumn(String columnName, Object value) {
        if (this.m_custom == null) {
            this.m_custom = new HashMap();
        }
        String valueString = "NULL";
        if (value != null) {
            valueString = value instanceof Number ? value.toString() : (value instanceof Boolean ? ((Boolean)value != false ? "'Y'" : "'N'") : (value instanceof Timestamp ? DB.TO_DATE((Timestamp)value, false) : DB.TO_STRING(value.toString())));
        }
        this.log.log(Level.INFO, columnName + "=" + valueString);
        this.m_custom.put(columnName, valueString);
    }

    private void set_Keys(String ColumnName, Object value) {
        for (int i = 0; i < this.m_IDs.length; ++i) {
            if (!ColumnName.equals(this.m_KeyColumns[i])) continue;
            this.m_IDs[i] = value;
        }
    }

    protected int get_ColumnCount() {
        return this.p_info.getColumnCount();
    }

    public String get_ColumnName(int index) {
        return this.p_info.getColumnName(index);
    }

    protected String get_ColumnLabel(int index) {
        return this.p_info.getColumnLabel(index);
    }

    protected String get_ColumnDescription(int index) {
        return this.p_info.getColumnDescription(index);
    }

    protected boolean isColumnMandatory(int index) {
        return this.p_info.isColumnMandatory(index);
    }

    protected boolean isColumnUpdateable(int index) {
        return this.p_info.isColumnUpdateable(index);
    }

    protected void set_ColumnUpdateable(int index, boolean updateable) {
        this.p_info.setColumnUpdateable(index, updateable);
    }

    protected void setUpdateable(boolean updateable) {
        this.p_info.setUpdateable(updateable);
    }

    protected int get_ColumnDisplayType(int index) {
        return this.p_info.getColumnDisplayType(index);
    }

    protected Lookup get_ColumnLookup(int index) {
        return this.p_info.getColumnLookup(index);
    }

    public final int get_ColumnIndex(String columnName) {
        return this.p_info.getColumnIndex(columnName);
    }

    protected String get_DisplayValue(String columnName, boolean currentValue) {
        Object value;
        Object object = value = currentValue ? this.get_Value(columnName) : this.get_ValueOld(columnName);
        if (value == null) {
            return "./.";
        }
        String retValue = value.toString();
        int index = this.get_ColumnIndex(columnName);
        if (index < 0) {
            return retValue;
        }
        int dt = this.get_ColumnDisplayType(index);
        if (DisplayType.isText((int)dt) || 20 == dt) {
            return retValue;
        }
        Lookup lookup = this.get_ColumnLookup(index);
        if (lookup != null) {
            return lookup.getDisplay(value);
        }
        return retValue;
    }

    protected static void copyValues(PO from, PO to, int AD_Client_ID, int AD_Org_ID) {
        PO.copyValues(from, to);
        to.setAD_Client_ID(AD_Client_ID);
        to.setAD_Org_ID(AD_Org_ID);
    }

    protected static void copyValues(PO from, PO to) {
        s_log.fine("From ID=" + from.get_ID() + " - To ID=" + to.get_ID());
        if (from.getClass() != to.getClass()) {
            block0: for (int i1 = 0; i1 < from.m_oldValues.length; ++i1) {
                String colName;
                if (from.p_info.isVirtualColumn(i1) || from.p_info.isKey(i1) || (colName = from.p_info.getColumnName(i1)).startsWith("Created") || colName.startsWith("Updated") || colName.equals("IsActive") || colName.equals("AD_Client_ID") || colName.equals("AD_Org_ID")) continue;
                for (int i2 = 0; i2 < to.m_oldValues.length; ++i2) {
                    if (!to.p_info.getColumnName(i2).equals(colName)) continue;
                    to.m_newValues[i2] = from.m_oldValues[i1];
                    continue block0;
                }
            }
        } else {
            for (int i = 0; i < from.m_oldValues.length; ++i) {
                String colName;
                if (from.p_info.isVirtualColumn(i) || from.p_info.isKey(i) || (colName = from.p_info.getColumnName(i)).startsWith("Created") || colName.startsWith("Updated") || colName.equals("IsActive") || colName.equals("AD_Client_ID") || colName.equals("AD_Org_ID")) continue;
                to.m_newValues[i] = from.m_oldValues[i];
            }
        }
    }

    public ChangeVO get_ChangeVO() {
        return this.p_changeVO;
    }

    public void set_ChangeVO(ChangeVO change) {
        this.p_changeVO = change;
    }

    public void load(int ID, String trxName) {
        this.log.finest("ID=" + ID);
        if (ID > 0) {
            this.m_IDs = new Object[]{new Integer(ID)};
            String keyColumn = null;
            String parentColumn = null;
            for (int i = 0; i < this.p_info.getColumnCount(); ++i) {
                if (this.p_info.isKey(i)) {
                    keyColumn = this.p_info.getColumnName(i);
                    break;
                }
                if (!this.p_info.isColumnParent(i)) continue;
                parentColumn = this.p_info.getColumnName(i);
            }
            if (keyColumn == null) {
                keyColumn = parentColumn;
            }
            if (keyColumn == null) {
                throw new IllegalStateException("No PK for " + this.p_info.getTableName());
            }
            this.m_KeyColumns = new String[]{keyColumn};
            this.load(trxName);
        } else {
            this.loadDefaults();
            this.m_createNew = true;
            this.setKeyInfo();
            this.loadComplete(true);
        }
    }

    public boolean load(String trxName) {
        this.m_trxName = trxName;
        boolean success = true;
        StringBuffer sql = new StringBuffer("SELECT ");
        int size = this.get_ColumnCount();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                sql.append(",");
            }
            sql.append(this.p_info.getColumnSQL(i));
        }
        sql.append(" FROM ").append(this.p_info.getTableName()).append(" WHERE ").append(this.get_WhereClause(false));
        if (CLogMgt.isLevelFinest()) {
            this.log.finest(this.get_WhereClause(true));
        }
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql.toString(), this.m_trxName);
            for (int i = 0; i < this.m_IDs.length; ++i) {
                Object oo = this.m_IDs[i];
                if (oo instanceof Integer) {
                    pstmt.setInt(i + 1, (Integer)this.m_IDs[i]);
                    continue;
                }
                pstmt.setString(i + 1, this.m_IDs[i].toString());
            }
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                success = this.load(rs);
            } else {
                this.log.log(Level.SEVERE, "NO Data found for " + this.get_WhereClause(true), new Exception());
                this.m_IDs = new Object[]{I_ZERO};
                success = false;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
            this.m_createNew = false;
            this.m_newValues = new Object[size];
        }
        catch (Exception e) {
            String msg = "";
            if (this.m_trxName != null) {
                msg = "[" + this.m_trxName + "] - ";
            }
            msg = msg + this.get_WhereClause(true) + ", SQL=" + sql.toString();
            success = false;
            this.m_IDs = new Object[]{I_ZERO};
            this.log.log(Level.SEVERE, msg, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (SQLException e1) {
            // empty catch block
        }
        this.loadComplete(success);
        return success;
    }

    protected boolean load(ResultSet rs) {
        int size = this.get_ColumnCount();
        boolean success = true;
        int index = 0;
        this.log.finest("(rs)");
        for (index = 0; index < size; ++index) {
            String columnName = this.p_info.getColumnName(index);
            if (DB.isMSSQLServer() && columnName.equals("[LineNo]")) {
                columnName = "LineNo";
            }
            if (this.p_info.isVirtualColumn(index)) {
                try {
                    int ii = rs.findColumn(columnName);
                    if (ii < 0) {
                    }
                }
                catch (Exception e) {}
                continue;
            }
            Class<?> clazz = this.p_info.getColumnClass(index);
            int dt = this.p_info.getColumnDisplayType(index);
            try {
                this.m_oldValues[index] = clazz == Integer.class ? this.decrypt(index, new Integer(rs.getInt(columnName))) : (clazz == BigDecimal.class ? this.decrypt(index, rs.getBigDecimal(columnName)) : (clazz == Boolean.class ? new Boolean("Y".equals(this.decrypt(index, rs.getString(columnName)))) : (clazz == Timestamp.class ? this.decrypt(index, rs.getTimestamp(columnName)) : (DisplayType.isLOB((int)dt) ? this.get_LOB(rs.getObject(columnName)) : (clazz == String.class ? this.decrypt(index, rs.getString(columnName)) : this.loadSpecial(rs, index))))));
                if (rs.wasNull() && this.m_oldValues[index] != null) {
                    this.m_oldValues[index] = null;
                }
                if (!CLogMgt.isLevelAll()) continue;
                this.log.finest(String.valueOf(index) + ": " + this.p_info.getColumnName(index) + "(" + clazz + ") = " + this.m_oldValues[index]);
                continue;
            }
            catch (SQLException e) {
                if (this.p_info.isVirtualColumn(index)) {
                    this.log.log(Level.FINER, "Virtual Column not loaded: " + columnName);
                    continue;
                }
                this.log.log(Level.WARNING, "(rs) - " + String.valueOf(index) + ": " + this.p_info.getTableName() + "." + this.p_info.getColumnName(index) + " (" + clazz + ") - " + e);
                success = false;
            }
        }
        this.m_createNew = false;
        this.setKeyInfo();
        this.loadComplete(success);
        return success;
    }

    public boolean load(Map<String, String> hmIn) {
        String value;
        int size = this.get_ColumnCount();
        boolean success = true;
        boolean keyHasNoValue = true;
        String[] keyColumns = this.get_KeyColumns();
        if (keyColumns.length > 0) {
            for (int i = 0; i < keyColumns.length; ++i) {
                String keyColumn = keyColumns[i];
                value = hmIn.get(keyColumn);
                if (value != null) {
                    int index = this.p_info.getColumnIndex(keyColumn);
                    this.m_oldValues[index] = new Integer(value);
                }
                keyHasNoValue = false;
            }
        }
        this.log.finest("(hm)");
        int index = 0;
        for (index = 0; index < size; ++index) {
            String columnName = this.p_info.getColumnName(index);
            value = hmIn.get(columnName);
            if (value == null || value.length() == 0) continue;
            Class<?> clazz = this.p_info.getColumnClass(index);
            int dt = this.p_info.getColumnDisplayType(index);
            try {
                if (clazz == Integer.class) {
                    this.m_newValues[index] = new Integer(value);
                } else if (clazz == BigDecimal.class) {
                    this.m_newValues[index] = new BigDecimal(value);
                } else if (clazz == Boolean.class) {
                    this.m_newValues[index] = new Boolean("Y".equals(value) || "on".equals(value) || "true".equals(value));
                } else if (clazz == Timestamp.class) {
                    this.m_newValues[index] = PO.convertToTimestamp(value);
                } else if (DisplayType.isLOB((int)dt)) {
                    this.m_newValues[index] = null;
                } else if (clazz == String.class) {
                    this.m_newValues[index] = value;
                    int length = this.p_info.getFieldLength(index);
                    if (value.length() > length) {
                        this.m_newValues[index] = value.substring(0, length);
                        this.log.warning(columnName + ": truncated to length=" + length + " from=" + value);
                    }
                } else {
                    this.m_newValues[index] = null;
                }
                if (!CLogMgt.isLevelAll()) continue;
                this.log.finest(String.valueOf(index) + ": " + this.p_info.getColumnName(index) + "(" + clazz + ") = " + this.m_oldValues[index]);
                continue;
            }
            catch (Exception e) {
                if (this.p_info.isVirtualColumn(index)) {
                    this.log.log(Level.FINER, "Virtual Column not loaded: " + columnName);
                    continue;
                }
                this.log.log(Level.SEVERE, "(ht) - " + String.valueOf(index) + ": " + this.p_info.getTableName() + "." + this.p_info.getColumnName(index) + " (" + clazz + ") - " + e);
                success = false;
            }
        }
        this.setKeyInfo();
        this.loadComplete(success);
        this.m_createNew = keyHasNoValue;
        return success;
    }

    protected HashMap<String, String> get_HashMap() {
        HashMap<String, String> hmOut = new HashMap<String, String>();
        this.fillMap(hmOut);
        return hmOut;
    }

    public VO getVO() {
        VO vo = new VO();
        this.fillMap(vo);
        return vo;
    }

    private void fillMap(Map<String, String> hmOut) {
        int size = this.get_ColumnCount();
        for (int i = 0; i < size; ++i) {
            Object value = this.get_Value(i);
            if (value == null || this.p_info.isVirtualColumn(i)) continue;
            int dt = this.p_info.getColumnDisplayType(i);
            Class<?> c = this.p_info.getColumnClass(i);
            String stringValue = null;
            if (c != Object.class && value != null && !value.equals(Null.NULL)) {
                if (value instanceof Integer || value instanceof BigDecimal) {
                    stringValue = value.toString();
                } else if (c == Boolean.class) {
                    boolean bValue = false;
                    bValue = value instanceof Boolean ? ((Boolean)value).booleanValue() : "Y".equals(value);
                    stringValue = bValue ? "Y" : "N";
                } else if (value instanceof Timestamp) {
                    stringValue = value.toString();
                } else if (c == String.class) {
                    stringValue = (String)value;
                } else if (dt == 36) {
                    stringValue = (String)value;
                } else if (dt == 23) {
                    stringValue = Util.toHexString((byte[])value);
                }
            }
            if (stringValue == null) continue;
            hmOut.put(this.p_info.getColumnName(i), stringValue);
        }
        if (this.m_custom != null) {
            for (String column : this.m_custom.keySet()) {
                String value = this.m_custom.get(column);
                if (value == null) continue;
                hmOut.put(column, value);
            }
            this.m_custom = null;
        }
    }

    protected Object loadSpecial(ResultSet rs, int index) throws SQLException {
        this.log.finest("(NOP) - " + this.p_info.getColumnName(index));
        return null;
    }

    protected void loadComplete(boolean success) {
    }

    protected void loadDefaults() {
        this.setStandardDefaults();
    }

    protected void setStandardDefaults() {
        int size = this.get_ColumnCount();
        for (int i = 0; i < size; ++i) {
            if (this.p_info.isVirtualColumn(i)) continue;
            String colName = this.p_info.getColumnName(i);
            if (colName.endsWith("tedBy")) {
                this.m_newValues[i] = new Integer(this.p_ctx.getAD_User_ID());
                continue;
            }
            if (colName.equals("Created") || colName.equals("Updated")) {
                this.m_newValues[i] = new Timestamp(System.currentTimeMillis());
                continue;
            }
            if (colName.equals(this.p_info.getTableName() + "_ID")) {
                this.m_newValues[i] = I_ZERO;
                continue;
            }
            if (colName.equals("IsActive")) {
                this.m_newValues[i] = new Boolean(true);
                continue;
            }
            if (colName.equals("AD_Client_ID")) {
                this.m_newValues[i] = new Integer(this.p_ctx.getAD_Client_ID());
                continue;
            }
            if (colName.equals("AD_Org_ID")) {
                this.m_newValues[i] = new Integer(this.p_ctx.getAD_Org_ID());
                continue;
            }
            if (colName.equals("Processed")) {
                this.m_newValues[i] = new Boolean(false);
                continue;
            }
            if (colName.equals("Processing")) {
                this.m_newValues[i] = new Boolean(false);
                continue;
            }
            if (!colName.equals("Posted")) continue;
            this.m_newValues[i] = new Boolean(false);
        }
    }

    private void setKeyInfo() {
        for (int i = 0; i < this.p_info.getColumnCount(); ++i) {
            if (!this.p_info.isKey(i)) continue;
            String ColumnName = this.p_info.getColumnName(i);
            this.m_KeyColumns = new String[]{ColumnName};
            if (this.p_info.getColumnName(i).endsWith("_ID")) {
                Integer ii = (Integer)this.get_Value(i);
                this.m_IDs = ii == null ? new Object[]{I_ZERO} : new Object[]{ii};
                this.log.finest("(PK) " + ColumnName + "=" + ii);
            } else {
                Object oo = this.get_Value(i);
                this.m_IDs = oo == null ? new Object[]{null} : new Object[]{oo};
                this.log.finest("(PK) " + ColumnName + "=" + oo);
            }
            return;
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        for (int i = 0; i < this.p_info.getColumnCount(); ++i) {
            if (!this.p_info.isColumnParent(i)) continue;
            columnNames.add(this.p_info.getColumnName(i));
        }
        int size = columnNames.size();
        if (size == 0) {
            throw new IllegalStateException("No PK nor FK - " + this.p_info.getTableName());
        }
        this.m_IDs = new Object[size];
        this.m_KeyColumns = new String[size];
        for (int i = 0; i < size; ++i) {
            this.m_KeyColumns[i] = (String)columnNames.get(i);
            if (this.m_KeyColumns[i].endsWith("_ID")) {
                Integer ii = null;
                try {
                    ii = (Integer)this.get_Value(this.m_KeyColumns[i]);
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "", e);
                }
                if (ii != null) {
                    this.m_IDs[i] = ii;
                }
            } else {
                this.m_IDs[i] = this.get_Value(this.m_KeyColumns[i]);
            }
            this.log.finest("(FK) " + this.m_KeyColumns[i] + "=" + this.m_IDs[i]);
        }
    }

    protected boolean isMandatoryOK() {
        int size = this.get_ColumnCount();
        for (int i = 0; i < size; ++i) {
            if (!this.p_info.isColumnMandatory(i) || this.p_info.isVirtualColumn(i) || this.get_Value(i) != null && !this.get_Value(i).equals(Null.NULL)) continue;
            this.log.info(this.p_info.getColumnName(i));
            return false;
        }
        return true;
    }

    public final void setAD_Client_ID(int AD_Client_ID) {
        this.set_ValueNoCheck("AD_Client_ID", new Integer(AD_Client_ID));
    }

    public final int getAD_Client_ID() {
        Integer ii = (Integer)this.get_Value("AD_Client_ID");
        if (ii == null) {
            return 0;
        }
        return ii;
    }

    public final void setAD_Org_ID(int AD_Org_ID) {
        this.set_ValueNoCheck("AD_Org_ID", new Integer(AD_Org_ID));
    }

    public int getAD_Org_ID() {
        Integer ii = (Integer)this.get_Value("AD_Org_ID");
        if (ii == null) {
            return 0;
        }
        return ii;
    }

    public void setClientOrg(int AD_Client_ID, int AD_Org_ID) {
        if (AD_Client_ID != this.getAD_Client_ID()) {
            this.setAD_Client_ID(AD_Client_ID);
        }
        if (AD_Org_ID != this.getAD_Org_ID()) {
            this.setAD_Org_ID(AD_Org_ID);
        }
    }

    public void setClientOrg(PO po) {
        this.setClientOrg(po.getAD_Client_ID(), po.getAD_Org_ID());
    }

    public final void setIsActive(boolean active) {
        this.set_Value("IsActive", (Object)new Boolean(active));
    }

    public final boolean isActive() {
        Boolean bb = (Boolean)this.get_Value("IsActive");
        if (bb != null) {
            return bb;
        }
        return false;
    }

    public final Timestamp getCreated() {
        return (Timestamp)this.get_Value("Created");
    }

    public final Timestamp getUpdated() {
        return (Timestamp)this.get_Value("Updated");
    }

    public final int getCreatedBy() {
        Integer ii = (Integer)this.get_Value("CreatedBy");
        if (ii == null) {
            return 0;
        }
        return ii;
    }

    public final int getUpdatedBy() {
        Integer ii = (Integer)this.get_Value("UpdatedBy");
        if (ii == null) {
            return 0;
        }
        return ii;
    }

    protected final void setUpdatedBy(int AD_User_ID) {
        this.set_ValueNoCheck("UpdatedBy", new Integer(AD_User_ID));
    }

    protected String get_Translation(String columnName, String AD_Language) {
        if (columnName == null || AD_Language == null || this.m_IDs.length > 1 || this.m_IDs[0].equals(I_ZERO) || !(this.m_IDs[0] instanceof Integer)) {
            this.log.severe("Invalid Argument: ColumnName" + columnName + ", AD_Language=" + AD_Language + ", ID.length=" + this.m_IDs.length + ", ID=" + this.m_IDs[0]);
            return null;
        }
        int ID = (Integer)this.m_IDs[0];
        String retValue = null;
        StringBuffer sql = new StringBuffer("SELECT ").append(columnName).append(" FROM ").append(this.p_info.getTableName()).append("_Trl WHERE ").append(this.m_KeyColumns[0]).append("=?").append(" AND AD_Language=?");
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
            pstmt.setInt(1, ID);
            pstmt.setString(2, AD_Language);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = rs.getString(1);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public boolean is_new() {
        if (this.m_createNew) {
            return true;
        }
        for (int i = 0; i < this.m_IDs.length; ++i) {
            if (this.m_IDs[i].equals(I_ZERO)) continue;
            return false;
        }
        return true;
    }

    public String update(Map<String, String> context) {
        String error = null;
        Set<Map.Entry<String, String>> set = context.entrySet();
        for (Map.Entry<String, String> entry : set) {
            block5: {
                String oldValue;
                String columnName = entry.getKey();
                int index = this.get_ColumnIndex(columnName);
                if (index == -1 || this.is_KeyColumn(columnName) || this.p_info.isVirtualColumn(index) || columnName.equals("Created") || columnName.equals("CreatedBy") || columnName.equals("Updated") || columnName.equals("UpdatedBy")) continue;
                String stringValue = entry.getValue();
                if (stringValue != null && (stringValue.equals("NULLValue") || stringValue.length() == 0)) {
                    stringValue = null;
                }
                if ((oldValue = this.get_ValueAsString(columnName)).length() == 0) {
                    oldValue = null;
                }
                if (oldValue == null && stringValue == null || stringValue != null && oldValue != null && stringValue.equals(oldValue)) continue;
                try {
                    error = this.set_ValueString(index, stringValue);
                }
                catch (Exception e) {
                    error = e.getLocalizedMessage();
                    if (error != null) break block5;
                    error = e.toString();
                }
            }
            if (error == null) continue;
            return error;
        }
        return error;
    }

    public boolean save() {
        CLogger.resetLast();
        boolean newRecord = this.is_new();
        if (!newRecord && !this.is_Changed()) {
            this.log.fine("Nothing changed - " + this.p_info.getTableName());
            return true;
        }
        if (this.getAD_Org_ID() == 0 && (this.get_AccessLevel() == 1 || this.get_AccessLevel() == 3 && MClientShare.isOrgLevelOnly(this.getAD_Client_ID(), this.get_Table_ID()))) {
            this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "AD_Org_ID"));
            return false;
        }
        if (this.getAD_Org_ID() != 0) {
            boolean reset;
            boolean bl = reset = this.get_AccessLevel() == 4;
            if (!reset && MClientShare.isClientLevelOnly(this.getAD_Client_ID(), this.get_Table_ID())) {
                boolean bl2 = reset = this.get_AccessLevel() == 2 || this.get_AccessLevel() == 6 || this.get_AccessLevel() == 3;
            }
            if (reset) {
                this.log.warning("Set Org to 0");
                this.setAD_Org_ID(0);
            }
        }
        MAssignSet.execute(this, newRecord);
        try {
            if (!this.beforeSave(newRecord)) {
                this.log.warning("beforeSave failed - " + this.toString());
                return false;
            }
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "beforeSave - " + this.toString(), e);
            this.log.saveError("Error", e.toString(), false);
            return false;
        }
        String errorMsg = ModelValidationEngine.get().fireModelChange(this, newRecord ? 1 : 2);
        if (errorMsg != null) {
            this.log.warning("Validation failed - " + errorMsg);
            this.log.saveError("Error", errorMsg);
            return false;
        }
        if (newRecord) {
            return this.saveNew();
        }
        return this.saveUpdate();
    }

    private boolean saveFinish(boolean newRecord, boolean success) {
        if (success) {
            if (newRecord) {
                this.insertTranslations();
            } else {
                this.updateTranslations();
            }
            this.updatePreferences();
        }
        try {
            success = this.afterSave(newRecord, success);
            if (success && newRecord) {
                this.insertTreeNode();
            }
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "afterSave", e);
            this.log.saveError("Error", e.toString(), false);
            success = false;
        }
        if (success) {
            if (s_docWFMgr == null) {
                try {
                    Class.forName("org.compiere.wf.DocWorkflowManager");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (s_docWFMgr != null) {
                s_docWFMgr.process(this, this.p_info.getAD_Table_ID());
            }
            int size = this.p_info.getColumnCount();
            for (int i = 0; i < size; ++i) {
                if (this.m_newValues[i] == null) continue;
                this.m_oldValues[i] = this.m_newValues[i] == Null.NULL ? null : this.m_newValues[i];
            }
            this.m_newValues = new Object[size];
        }
        this.m_createNew = false;
        if (!newRecord) {
            CacheMgt.get().reset(this.p_info.getTableName());
        }
        return success;
    }

    public boolean save(String trxName) {
        this.set_TrxName(trxName);
        return this.save();
    }

    public boolean is_Changed() {
        int size = this.get_ColumnCount();
        for (int i = 0; i < size; ++i) {
            if (this.m_newValues[i] == null) continue;
            return true;
        }
        return false;
    }

    protected boolean beforeSave(boolean newRecord) {
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        return success;
    }

    protected boolean saveUpdate() {
        String where = this.get_WhereClause(true);
        boolean changes = false;
        StringBuffer sql = new StringBuffer("UPDATE ");
        sql.append(this.p_info.getTableName()).append(" SET ");
        boolean updated = false;
        boolean updatedBy = false;
        this.lobReset();
        MSession session = MSession.get(this.p_ctx, true);
        int AD_ChangeLog_ID = 0;
        int size = this.get_ColumnCount();
        for (int i = 0; i < size; ++i) {
            MChangeLog cLog;
            Object value = this.m_newValues[i];
            if (value == null || this.p_info.isVirtualColumn(i)) continue;
            Class<?> c = this.p_info.getColumnClass(i);
            int dt = this.p_info.getColumnDisplayType(i);
            String columnName = this.p_info.getColumnName(i);
            if (columnName.equals("UpdatedBy")) {
                if (updatedBy) continue;
                updatedBy = true;
            } else if (columnName.equals("Updated")) {
                if (updated) continue;
                updated = true;
            }
            if (DisplayType.isLOB((int)dt)) {
                this.lobAdd(value, i, dt);
                if (!(!changes & !updatedBy)) continue;
                int AD_User_ID = this.p_ctx.getAD_User_ID();
                this.set_ValueNoCheck("UpdatedBy", new Integer(AD_User_ID));
                sql.append("UpdatedBy=").append(AD_User_ID);
                changes = true;
                updatedBy = true;
                continue;
            }
            if (columnName.equals("DocumentNo")) {
                String strValue = (String)value;
                if (strValue.startsWith("<") && strValue.endsWith(">")) {
                    value = null;
                    int AD_Client_ID = this.getAD_Client_ID();
                    int index = this.p_info.getColumnIndex("C_DocTypeTarget_ID");
                    if (index == -1) {
                        index = this.p_info.getColumnIndex("C_DocType_ID");
                    }
                    if (index != -1) {
                        value = DB.getDocumentNo(this.get_ValueAsInt(index), this.m_trxName);
                    }
                    if (value == null) {
                        value = DB.getDocumentNo(AD_Client_ID, this.p_info.getTableName(), this.m_trxName);
                    }
                } else {
                    this.log.warning("DocumentNo updated: " + this.m_oldValues[i] + " -> " + value);
                }
            }
            if (changes) {
                sql.append(", ");
            }
            changes = true;
            sql.append(columnName).append("=");
            if (value == Null.NULL) {
                sql.append("NULL");
            } else if (value instanceof Integer || value instanceof BigDecimal) {
                sql.append(this.encrypt(i, value));
            } else if (c == Boolean.class) {
                boolean bValue = false;
                bValue = value instanceof Boolean ? ((Boolean)value).booleanValue() : "Y".equals(value);
                sql.append(this.encrypt(i, bValue ? "'Y'" : "'N'"));
            } else if (value instanceof Timestamp) {
                sql.append(DB.TO_DATE((Timestamp)this.encrypt(i, value), this.p_info.getColumnDisplayType(i) == 15));
            } else {
                sql.append(this.encrypt(i, DB.TO_STRING(value.toString())));
            }
            if (session == null || this.p_info.isEncrypted(i) || this.p_info.isVirtualColumn(i) || "Password".equals(columnName)) continue;
            Object oldV = this.m_oldValues[i];
            Object newV = value;
            if (oldV != null && oldV == Null.NULL) {
                oldV = null;
            }
            if (newV != null && newV == Null.NULL) {
                newV = null;
            }
            Object keyInfo = this.get_ID();
            if (this.m_IDs.length != 1) {
                keyInfo = this.get_WhereClause(true);
            }
            if ((cLog = session.changeLog(this.m_trxName, AD_ChangeLog_ID, this.p_info.getAD_Table_ID(), this.p_info.getColumn((int)i).AD_Column_ID, keyInfo, this.getAD_Client_ID(), this.getAD_Org_ID(), oldV, newV, this.get_TableName(), ENTITYTYPE_UserMaintained)) == null) continue;
            AD_ChangeLog_ID = cLog.getAD_ChangeLog_ID();
        }
        if (this.m_custom != null) {
            Iterator<String> it = this.m_custom.keySet().iterator();
            while (it.hasNext()) {
                MChangeLog cLog;
                if (changes) {
                    sql.append(", ");
                }
                changes = true;
                String columnName = it.next();
                int index = this.p_info.getColumnIndex(columnName);
                String value = this.m_custom.get(columnName);
                if (value != null && value.equals("NULLValue")) {
                    value = "NULL";
                }
                sql.append(columnName).append("=").append(value);
                if (session == null || this.p_info.isEncrypted(index) || this.p_info.isVirtualColumn(index) || "Password".equals(columnName)) continue;
                Object oldV = this.m_oldValues[index];
                String newV = value;
                if (oldV != null && oldV == Null.NULL) {
                    oldV = null;
                }
                if (newV != null && newV == Null.NULL) {
                    newV = null;
                }
                if ((cLog = session.changeLog(this.m_trxName, AD_ChangeLog_ID, this.p_info.getAD_Table_ID(), this.p_info.getColumn((int)index).AD_Column_ID, this.m_IDs, this.getAD_Client_ID(), this.getAD_Org_ID(), oldV, newV, this.get_TableName(), ENTITYTYPE_UserMaintained)) == null) continue;
                AD_ChangeLog_ID = cLog.getAD_ChangeLog_ID();
            }
            this.m_custom = null;
        }
        if (changes) {
            boolean ok;
            if (this.m_trxName == null) {
                this.log.fine(this.p_info.getTableName() + "." + where);
            } else {
                this.log.fine("[" + this.m_trxName + "] - " + this.p_info.getTableName() + "." + where);
            }
            if (!updated) {
                Timestamp now = new Timestamp(System.currentTimeMillis());
                this.set_ValueNoCheck("Updated", now);
                sql.append(",Updated=").append(DB.TO_DATE(now, false));
            }
            if (!updatedBy) {
                int AD_User_ID = this.p_ctx.getAD_User_ID();
                this.set_ValueNoCheck("UpdatedBy", new Integer(AD_User_ID));
                sql.append(",UpdatedBy=").append(AD_User_ID);
            }
            sql.append(" WHERE ").append(where);
            this.log.finest(sql.toString());
            int no = DB.executeUpdate(sql.toString(), this.m_trxName);
            boolean bl = ok = no == 1;
            if (ok) {
                ok = this.lobSave();
            } else if (this.m_trxName == null) {
                this.log.log(Level.WARNING, "#" + no + " - " + this.p_info.getTableName() + "." + where);
            } else {
                this.log.log(Level.WARNING, "#" + no + " - [" + this.m_trxName + "] - " + this.p_info.getTableName() + "." + where);
            }
            return this.saveFinish(false, ok);
        }
        return this.saveFinish(false, true);
    }

    private boolean saveNew() {
        String value;
        if (this.m_IDs.length == 1 && this.p_info.hasKeyColumn() && this.m_KeyColumns[0].endsWith("_ID")) {
            int no = this.saveNew_getID();
            if (no <= 0) {
                no = DB.getNextID(this.getAD_Client_ID(), this.p_info.getTableName(), this.m_trxName);
            }
            if (no <= 0) {
                this.log.severe("No NextID (" + no + ")");
                return this.saveFinish(true, false);
            }
            this.m_IDs[0] = new Integer(no);
            this.set_ValueNoCheck(this.m_KeyColumns[0], this.m_IDs[0]);
        }
        if (this.m_trxName == null) {
            this.log.fine(this.p_info.getTableName() + " - " + this.get_WhereClause(true));
        } else {
            this.log.fine("[" + this.m_trxName + "] - " + this.p_info.getTableName() + " - " + this.get_WhereClause(true));
        }
        String columnName = "DocumentNo";
        int index = this.p_info.getColumnIndex(columnName);
        if (index != -1) {
            value = (String)this.get_Value(index);
            if (value != null && value.startsWith("<") && value.endsWith(">")) {
                value = null;
            }
            if (value == null || value.length() == 0) {
                int dt = this.p_info.getColumnIndex("C_DocTypeTarget_ID");
                if (dt == -1) {
                    dt = this.p_info.getColumnIndex("C_DocType_ID");
                }
                if (dt != -1) {
                    value = DB.getDocumentNo(this.get_ValueAsInt(dt), this.m_trxName);
                }
                if (value == null) {
                    value = DB.getDocumentNo(this.getAD_Client_ID(), this.p_info.getTableName(), this.m_trxName);
                }
                this.set_ValueNoCheck(columnName, value);
            }
        }
        if ((index = this.p_info.getColumnIndex(columnName = "Value")) != -1 && ((value = (String)this.get_Value(index)) == null || value.length() == 0)) {
            value = DB.getDocumentNo(this.getAD_Client_ID(), this.p_info.getTableName(), this.m_trxName);
            this.set_ValueNoCheck(columnName, value);
        }
        this.lobReset();
        boolean ok = this.saveNewInsertSQL();
        return this.saveFinish(true, ok);
    }

    public boolean saveNewInsertSQL() {
        boolean ok;
        MSession session = MSession.get(this.p_ctx, false);
        int AD_ChangeLog_ID = 0;
        StringBuffer sqlInsert = new StringBuffer("INSERT INTO ");
        sqlInsert.append(this.p_info.getTableName()).append(" (");
        StringBuffer sqlValues = new StringBuffer(") VALUES (");
        int size = this.get_ColumnCount();
        boolean doComma = false;
        for (int i = 0; i < size; ++i) {
            MChangeLog cLog;
            Object value;
            if (this.p_info.isVirtualColumn(i) || (value = this.get_Value(i)) == null || value == Null.NULL) continue;
            int dt = this.p_info.getColumnDisplayType(i);
            if (DisplayType.isLOB((int)dt)) {
                this.lobAdd(value, i, dt);
                continue;
            }
            if (doComma) {
                sqlInsert.append(",");
                sqlValues.append(",");
            } else {
                doComma = true;
            }
            String columnName = this.p_info.getColumnName(i);
            sqlInsert.append(columnName);
            Class<?> c = this.p_info.getColumnClass(i);
            try {
                if (c == Object.class) {
                    sqlValues.append(this.saveNewSpecial(value, i));
                } else if (value == null || value.equals(Null.NULL)) {
                    sqlValues.append("NULL");
                } else if (value instanceof Integer || value instanceof BigDecimal) {
                    sqlValues.append(this.encrypt(i, value));
                } else if (c == Boolean.class) {
                    boolean bValue = false;
                    bValue = value instanceof Boolean ? ((Boolean)value).booleanValue() : "Y".equals(value);
                    sqlValues.append(this.encrypt(i, bValue ? "'Y'" : "'N'"));
                } else if (value instanceof Timestamp) {
                    sqlValues.append(DB.TO_DATE((Timestamp)this.encrypt(i, value), this.p_info.getColumnDisplayType(i) == 15));
                } else if (c == String.class) {
                    sqlValues.append(this.encrypt(i, DB.TO_STRING((String)value)));
                } else if (DisplayType.isLOB((int)dt)) {
                    sqlValues.append("null");
                } else {
                    sqlValues.append(this.saveNewSpecial(value, i));
                }
            }
            catch (Exception e) {
                String msg = "";
                if (this.m_trxName != null) {
                    msg = "[" + this.m_trxName + "] - ";
                }
                msg = msg + this.p_info.toString(i) + " - Value=" + value + "(" + (value == null ? "null" : value.getClass().getName()) + ")";
                this.log.log(Level.SEVERE, msg, e);
                throw new DBException(e);
            }
            if (session == null || this.p_info.isEncrypted(i) || this.p_info.isVirtualColumn(i) || "Password".equals(columnName)) continue;
            Object keyInfo = this.get_ID();
            if (this.m_IDs.length != 1) {
                keyInfo = this.get_WhereClause(true);
            }
            if ((cLog = session.changeLog(this.m_trxName, AD_ChangeLog_ID, this.p_info.getAD_Table_ID(), this.p_info.getColumn((int)i).AD_Column_ID, keyInfo, this.getAD_Client_ID(), this.getAD_Org_ID(), null, value, this.get_TableName(), "I")) == null) continue;
            AD_ChangeLog_ID = cLog.getAD_ChangeLog_ID();
        }
        if (this.m_custom != null) {
            for (String columnName : this.m_custom.keySet()) {
                MChangeLog cLog;
                int index = this.p_info.getColumnIndex(columnName);
                String value = this.m_custom.get(columnName);
                if (value == null || value.equals("NULLValue")) continue;
                if (doComma) {
                    sqlInsert.append(",");
                    sqlValues.append(",");
                } else {
                    doComma = true;
                }
                sqlInsert.append(columnName);
                String value2 = DB.TO_STRING(this.encrypt(index, value));
                sqlValues.append(value2);
                if (session == null || this.p_info.isEncrypted(index) || this.p_info.isVirtualColumn(index) || "Password".equals(columnName) || (cLog = session.changeLog(this.m_trxName, AD_ChangeLog_ID, this.p_info.getAD_Table_ID(), this.p_info.getColumn((int)index).AD_Column_ID, this.m_IDs, this.getAD_Client_ID(), this.getAD_Org_ID(), null, value, this.get_TableName(), "I")) == null) continue;
                AD_ChangeLog_ID = cLog.getAD_ChangeLog_ID();
            }
            this.m_custom = null;
        }
        sqlInsert.append(sqlValues).append(")");
        int no = DB.executeUpdate(sqlInsert.toString(), this.m_trxName);
        boolean bl = ok = no == 1;
        if (ok) {
            ok = this.lobSave();
            if (!this.load(this.m_trxName)) {
                if (this.m_trxName == null) {
                    this.log.log(Level.SEVERE, "reloading");
                } else {
                    this.log.log(Level.SEVERE, "[" + this.m_trxName + "] - reloading");
                }
                ok = false;
            }
        } else {
            String msg = "Not inserted - ";
            msg = CLogMgt.isLevelFiner() ? msg + sqlInsert.toString() : msg + this.get_TableName();
            if (this.m_trxName == null) {
                this.log.log(Level.WARNING, msg);
            } else {
                this.log.log(Level.WARNING, "[" + this.m_trxName + "]" + msg);
            }
        }
        return ok;
    }

    protected int saveNew_getID() {
        return 0;
    }

    public String get_WhereClause(boolean withValues) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.m_IDs.length; ++i) {
            if (i != 0) {
                sb.append(" AND ");
            }
            sb.append(this.m_KeyColumns[i]).append("=");
            if (withValues) {
                if (this.m_KeyColumns[i].endsWith("_ID")) {
                    sb.append(this.m_IDs[i]);
                    continue;
                }
                sb.append("'").append(this.m_IDs[i]).append("'");
                continue;
            }
            sb.append("?");
        }
        return sb.toString();
    }

    protected String saveNewSpecial(Object value, int index) {
        String colName = this.p_info.getColumnName(index);
        String colClass = this.p_info.getColumnClass(index).toString();
        String colValue = value == null ? "null" : value.getClass().toString();
        this.log.log(Level.SEVERE, "Unknown class for column " + colName + " (" + colClass + ") - Value=" + colValue);
        if (value == null) {
            return "NULL";
        }
        return value.toString();
    }

    private Object encrypt(int index, Object xx) {
        if (xx == null) {
            return null;
        }
        if (index != -1 && this.p_info.isEncrypted(index)) {
            return SecureEngine.encrypt(xx);
        }
        return xx;
    }

    private String encrypt(int index, String xx) {
        if (xx == null) {
            return null;
        }
        if (index != -1 && this.p_info.isEncrypted(index)) {
            return SecureEngine.encrypt(xx);
        }
        return xx;
    }

    private Object decrypt(int index, Object yy) {
        if (yy == null) {
            return null;
        }
        if (index != -1 && this.p_info.isEncrypted(index)) {
            return SecureEngine.decrypt(yy);
        }
        return yy;
    }

    public boolean delete(boolean force) {
        Boolean processed;
        int iProcessed;
        CLogger.resetLast();
        if (this.is_new()) {
            return true;
        }
        int AD_Table_ID = this.p_info.getAD_Table_ID();
        int Record_ID = this.get_ID();
        if (!force && (iProcessed = this.get_ColumnIndex("Processed")) != -1 && (processed = (Boolean)this.get_Value(iProcessed)) != null && processed.booleanValue()) {
            this.log.warning("Record processed");
            this.log.saveError("Processed", "Processed", false);
            return false;
        }
        try {
            if (!this.beforeDelete()) {
                this.log.warning("beforeDelete failed");
                return false;
            }
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "beforeDelete", e);
            this.log.saveError("Error", e.toString(), false);
            return false;
        }
        String errorMsg = PO_Record.exists(AD_Table_ID, Record_ID, this.m_trxName);
        if (errorMsg != null) {
            this.log.saveError("CannotDelete", errorMsg);
            return false;
        }
        errorMsg = ModelValidationEngine.get().fireModelChange(this, 3);
        if (errorMsg != null) {
            this.log.saveError("Error", errorMsg);
            return false;
        }
        Trx localTrx = null;
        String localTrxName = this.m_trxName;
        if (localTrxName == null) {
            localTrxName = Trx.createTrxName("POdel");
            localTrx = Trx.get(localTrxName, true);
        }
        this.deleteTranslations(localTrxName);
        PO_Record.deleteCascade(AD_Table_ID, Record_ID, localTrxName);
        StringBuffer sql = new StringBuffer("DELETE FROM ").append(this.p_info.getTableName()).append(" WHERE ").append(this.get_WhereClause(true));
        int no = DB.executeUpdate(sql.toString(), localTrxName);
        boolean success = no == 1;
        this.m_idOld = this.get_ID();
        if (!success) {
            this.log.warning("Not deleted");
            if (localTrx != null) {
                localTrx.rollback();
            }
        } else {
            MSession session;
            if (localTrx != null) {
                localTrx.commit();
            }
            if ((session = MSession.get(this.p_ctx, false)) == null) {
                this.log.fine("No Session found");
            } else if (session.isWebStoreSession() || MChangeLog.isLogged(AD_Table_ID, ENTITYTYPE_Dictionary)) {
                int AD_ChangeLog_ID = 0;
                int size = this.get_ColumnCount();
                for (int i = 0; i < size; ++i) {
                    MChangeLog cLog;
                    Object value = this.m_oldValues[i];
                    if (value == null || this.p_info.isEncrypted(i) || this.p_info.isVirtualColumn(i) || "Password".equals(this.p_info.getColumnName(i))) continue;
                    Object keyInfo = this.get_ID();
                    if (this.m_IDs.length != 1) {
                        keyInfo = this.get_WhereClause(true);
                    }
                    if ((cLog = session.changeLog(this.m_trxName, AD_ChangeLog_ID, AD_Table_ID, this.p_info.getColumn((int)i).AD_Column_ID, keyInfo, this.getAD_Client_ID(), this.getAD_Org_ID(), value, null, this.get_TableName(), ENTITYTYPE_Dictionary)) == null) continue;
                    AD_ChangeLog_ID = cLog.getAD_ChangeLog_ID();
                }
            }
            this.m_IDs[0] = I_ZERO;
            if (this.m_trxName == null) {
                this.log.fine("complete");
            } else {
                this.log.fine("[" + this.m_trxName + "] - complete");
            }
            this.m_attachment = null;
        }
        if (localTrx != null) {
            localTrx.close();
        }
        localTrx = null;
        this.updatePreferences();
        try {
            success = this.afterDelete(success);
            if (success) {
                this.deleteTreeNode();
            }
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "afterDelete", e);
            this.log.saveError("Error", e.toString(), false);
            success = false;
        }
        if (success) {
            this.m_idOld = 0;
            int size = this.p_info.getColumnCount();
            this.m_oldValues = new Object[size];
            this.m_newValues = new Object[size];
            CacheMgt.get().reset(this.p_info.getTableName());
        }
        return success;
    }

    public boolean delete(boolean force, String trxName) {
        this.set_TrxName(trxName);
        return this.delete(force);
    }

    protected boolean beforeDelete() {
        return true;
    }

    protected boolean afterDelete(boolean success) {
        return success;
    }

    private boolean insertTranslations() {
        if (this.m_IDs.length > 1 || this.m_IDs[0].equals(I_ZERO) || !this.p_info.isTranslated() || !(this.m_IDs[0] instanceof Integer)) {
            return true;
        }
        StringBuffer iColumns = new StringBuffer();
        StringBuffer sColumns = new StringBuffer();
        for (int i = 0; i < this.p_info.getColumnCount(); ++i) {
            if (!this.p_info.isColumnTranslated(i)) continue;
            iColumns.append(this.p_info.getColumnName(i)).append(",");
            sColumns.append("t.").append(this.p_info.getColumnName(i)).append(",");
        }
        if (iColumns.length() == 0) {
            return true;
        }
        String tableName = this.p_info.getTableName();
        String keyColumn = this.m_KeyColumns[0];
        StringBuffer sql = new StringBuffer("INSERT INTO ").append(tableName).append("_Trl (AD_Language,").append(keyColumn).append(", ").append(iColumns).append(" IsTranslated,AD_Client_ID,AD_Org_ID,Created,CreatedBy,Updated,UpdatedBy) ").append("SELECT l.AD_Language,t.").append(keyColumn).append(", ").append(sColumns).append(" 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.CreatedBy,t.Updated,t.UpdatedBy ").append("FROM AD_Language l, ").append(tableName).append(" t ").append("WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.").append(keyColumn).append("=").append(this.get_ID()).append(" AND NOT EXISTS (SELECT * FROM ").append(tableName).append("_Trl tt WHERE tt.AD_Language=l.AD_Language AND tt.").append(keyColumn).append("=t.").append(keyColumn).append(")");
        int no = DB.executeUpdate(sql.toString(), this.m_trxName);
        this.log.fine("#" + no);
        return no > 0;
    }

    private boolean updateTranslations() {
        if (this.m_IDs.length > 1 || this.m_IDs[0].equals(I_ZERO) || !this.p_info.isTranslated() || !(this.m_IDs[0] instanceof Integer)) {
            return true;
        }
        boolean trlColumnChanged = false;
        for (int i = 0; i < this.p_info.getColumnCount(); ++i) {
            if (!this.p_info.isColumnTranslated(i) || !this.is_ValueChanged(this.p_info.getColumnName(i))) continue;
            trlColumnChanged = true;
            break;
        }
        if (!trlColumnChanged) {
            return true;
        }
        MClient client = MClient.get(this.getCtx());
        String tableName = this.p_info.getTableName();
        String keyColumn = this.m_KeyColumns[0];
        StringBuffer sql = new StringBuffer("UPDATE ").append(tableName).append("_Trl SET ");
        if (client.isAutoUpdateTrl(tableName)) {
            for (int i = 0; i < this.p_info.getColumnCount(); ++i) {
                if (!this.p_info.isColumnTranslated(i)) continue;
                String columnName = this.p_info.getColumnName(i);
                sql.append(columnName).append("=");
                Object value = this.get_Value(columnName);
                if (value == null) {
                    sql.append("NULL");
                } else if (value instanceof String) {
                    sql.append(DB.TO_STRING((String)value));
                } else if (value instanceof Boolean) {
                    sql.append((Boolean)value != false ? "'Y'" : "'N'");
                } else if (value instanceof Timestamp) {
                    sql.append(DB.TO_DATE((Timestamp)value));
                } else {
                    sql.append(value.toString());
                }
                sql.append(",");
            }
            sql.append("IsTranslated='Y'");
        } else {
            sql.append("IsTranslated='N'");
        }
        sql.append(" WHERE ").append(keyColumn).append("=").append(this.get_ID());
        int no = DB.executeUpdate(sql.toString(), this.m_trxName);
        this.log.fine("#" + no);
        return no >= 0;
    }

    private boolean deleteTranslations(String trxName) {
        if (this.m_IDs.length > 1 || this.m_IDs[0].equals(I_ZERO) || !this.p_info.isTranslated() || !(this.m_IDs[0] instanceof Integer)) {
            return true;
        }
        String tableName = this.p_info.getTableName();
        String keyColumn = this.m_KeyColumns[0];
        StringBuffer sql = new StringBuffer("DELETE FROM ").append(tableName).append("_Trl WHERE ").append(keyColumn).append("=").append(this.get_ID());
        int no = DB.executeUpdate(sql.toString(), trxName);
        this.log.fine("#" + no);
        return no >= 0;
    }

    protected boolean insert_Accounting(String acctTable, String acctBaseTable, String whereClause) {
        int i;
        if (this.s_acctColumns == null || acctTable.startsWith("C_BP_")) {
            this.s_acctColumns = new ArrayList();
            String sql = "SELECT c.ColumnName FROM AD_Column c INNER JOIN AD_Table t ON (c.AD_Table_ID=t.AD_Table_ID) WHERE t.TableName=? AND c.IsActive='Y' AND c.AD_Reference_ID=25 ORDER BY 1";
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setString(1, acctTable);
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    this.s_acctColumns.add(rs.getString(1));
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, acctTable, e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception e) {
                pstmt = null;
            }
            if (this.s_acctColumns.size() == 0) {
                this.log.severe("No Columns for " + acctTable);
                return false;
            }
        }
        StringBuffer sb = new StringBuffer("INSERT INTO ").append(acctTable).append(" (").append(this.get_TableName()).append("_ID, C_AcctSchema_ID, AD_Client_ID,AD_Org_ID,IsActive, Created,CreatedBy,Updated,UpdatedBy ");
        for (i = 0; i < this.s_acctColumns.size(); ++i) {
            sb.append(",").append(this.s_acctColumns.get(i));
        }
        sb.append(") SELECT ").append(this.get_ID()).append(", p.C_AcctSchema_ID, p.AD_Client_ID,0,'Y', SysDate,").append(this.getUpdatedBy()).append(",SysDate,").append(this.getUpdatedBy());
        for (i = 0; i < this.s_acctColumns.size(); ++i) {
            sb.append(",p.").append(this.s_acctColumns.get(i));
        }
        sb.append(" FROM ").append(acctBaseTable).append(" p WHERE p.AD_Client_ID=").append(this.getAD_Client_ID());
        if (whereClause != null && whereClause.length() > 0) {
            sb.append(" AND ").append(whereClause);
        }
        sb.append(" AND NOT EXISTS (SELECT * FROM ").append(acctTable).append(" e WHERE e.C_AcctSchema_ID=p.C_AcctSchema_ID AND e.").append(this.get_TableName()).append("_ID=").append(this.get_ID()).append(")");
        int no = DB.executeUpdate(sb.toString(), this.get_TrxName());
        if (no > 0) {
            this.log.fine("#" + no);
        } else {
            this.log.warning("#" + no + " - Table=" + acctTable + " from " + acctBaseTable);
        }
        return no > 0;
    }

    protected boolean delete_Accounting(String acctTable) {
        return true;
    }

    private void updatePreferences() {
        if (!this.isActive()) {
            String keyColumn = this.get_TableName() + "_ID";
            String keyValue = String.valueOf(this.get_ID());
            MPreference.delete(keyColumn, keyValue);
            this.getCtx().deletePreference(keyColumn, keyValue);
        }
    }

    private boolean insertTreeNode() {
        Integer ii;
        int AD_Table_ID = this.get_Table_ID();
        if (!MTree.hasTree(AD_Table_ID)) {
            return false;
        }
        int id = this.get_ID();
        int AD_Client_ID = this.getAD_Client_ID();
        String treeTableName = MTree.getNodeTableName(AD_Table_ID);
        int C_Element_ID = 0;
        if (AD_Table_ID == 188 && (ii = (Integer)this.get_Value("C_Element_ID")) != null) {
            C_Element_ID = ii;
        }
        StringBuffer sb = new StringBuffer("INSERT INTO ").append(treeTableName).append(" (AD_Client_ID,AD_Org_ID, IsActive,Created,CreatedBy,Updated,UpdatedBy, ").append("AD_Tree_ID, Node_ID, Parent_ID, SeqNo) ").append("SELECT t.AD_Client_ID,0, 'Y', SysDate, 0, SysDate, 0,").append("t.AD_Tree_ID, ").append(id).append(", 0, 999 ").append("FROM AD_Tree t ").append("WHERE t.AD_Client_ID=").append(AD_Client_ID).append(" AND t.IsActive='Y'");
        if (C_Element_ID != 0) {
            sb.append(" AND EXISTS (SELECT * FROM C_Element ae WHERE ae.C_Element_ID=").append(C_Element_ID).append(" AND t.AD_Tree_ID=ae.AD_Tree_ID)");
        } else {
            sb.append(" AND t.IsAllNodes='Y' AND t.AD_Table_ID=").append(AD_Table_ID);
        }
        sb.append(" AND NOT EXISTS (SELECT * FROM ").append(treeTableName).append(" e ").append("WHERE e.AD_Tree_ID=t.AD_Tree_ID AND Node_ID=").append(id).append(")");
        int no = DB.executeUpdate(sb.toString(), this.get_TrxName());
        if (no > 0) {
            this.log.fine("#" + no + " - AD_Table_ID=" + AD_Table_ID);
        } else {
            this.log.warning("#" + no + " - AD_Table_ID=" + AD_Table_ID);
        }
        return no > 0;
    }

    private boolean deleteTreeNode() {
        int AD_Table_ID;
        int id = this.get_ID();
        if (id == 0) {
            id = this.get_IDOld();
        }
        if (!MTree.hasTree(AD_Table_ID = this.get_Table_ID())) {
            return false;
        }
        String treeTableName = MTree.getNodeTableName(AD_Table_ID);
        if (treeTableName == null) {
            return false;
        }
        StringBuffer sb = new StringBuffer("DELETE FROM ").append(treeTableName).append(" n WHERE Node_ID=").append(id).append(" AND EXISTS (SELECT * FROM AD_Tree t ").append("WHERE t.AD_Tree_ID=n.AD_Tree_ID AND t.AD_Table_ID=").append(AD_Table_ID).append(")");
        int no = DB.executeUpdate(sb.toString(), this.get_TrxName());
        if (no > 0) {
            this.log.fine("#" + no + " - AD_Table_ID=" + AD_Table_ID);
        } else {
            this.log.warning("#" + no + " - AD_Table_ID=" + AD_Table_ID);
        }
        return no > 0;
    }

    public boolean lock() {
        int index = this.get_ProcessingIndex();
        if (index != -1) {
            boolean success;
            this.m_newValues[index] = Boolean.TRUE;
            String sql = "UPDATE " + this.p_info.getTableName() + " SET Processing='Y' WHERE (Processing='N' OR Processing IS NULL) AND " + this.get_WhereClause(true);
            boolean bl = success = DB.executeUpdate(sql, null) == 1;
            if (success) {
                this.log.fine("success");
            } else {
                this.log.log(Level.WARNING, "failed");
            }
            return success;
        }
        return false;
    }

    private int get_ProcessingIndex() {
        return this.p_info.getColumnIndex("Processing");
    }

    public boolean unlock(String trxName) {
        int index = this.get_ProcessingIndex();
        if (index != -1) {
            boolean success;
            this.m_newValues[index] = Boolean.FALSE;
            String sql = "UPDATE " + this.p_info.getTableName() + " SET Processing='N' WHERE " + this.get_WhereClause(true);
            boolean bl = success = DB.executeUpdate(sql, trxName) == 1;
            if (success) {
                this.log.fine("success" + (trxName == null ? "" : " [" + trxName + "]"));
            } else {
                this.log.log(Level.WARNING, "failed" + (trxName == null ? "" : " [" + trxName + "]"));
            }
            return success;
        }
        return true;
    }

    public void set_TrxName(String trxName) {
        this.m_trxName = trxName;
    }

    public String get_TrxName() {
        return this.m_trxName;
    }

    public MAttachment getAttachment() {
        return this.getAttachment(false);
    }

    public MAttachment getAttachment(boolean requery) {
        if (this.m_attachment == null || requery) {
            this.m_attachment = MAttachment.get(this.getCtx(), this.p_info.getAD_Table_ID(), this.get_ID());
        }
        return this.m_attachment;
    }

    public MAttachment createAttachment() {
        this.getAttachment(false);
        if (this.m_attachment == null) {
            this.m_attachment = new MAttachment(this.getCtx(), this.p_info.getAD_Table_ID(), this.get_ID(), null);
        }
        return this.m_attachment;
    }

    public boolean isAttachment(String extension) {
        this.getAttachment(false);
        if (this.m_attachment == null) {
            return false;
        }
        for (int i = 0; i < this.m_attachment.getEntryCount(); ++i) {
            if (!this.m_attachment.getEntryName(i).endsWith(extension)) continue;
            this.log.fine("#" + i + ": " + this.m_attachment.getEntryName(i));
            return true;
        }
        return false;
    }

    public byte[] getAttachmentData(String extension) {
        this.getAttachment(false);
        if (this.m_attachment == null) {
            return null;
        }
        for (int i = 0; i < this.m_attachment.getEntryCount(); ++i) {
            if (!this.m_attachment.getEntryName(i).endsWith(extension)) continue;
            this.log.fine("#" + i + ": " + this.m_attachment.getEntryName(i));
            return this.m_attachment.getEntryData(i);
        }
        return null;
    }

    public boolean isPdfAttachment() {
        return this.isAttachment(".pdf");
    }

    public byte[] getPdfAttachment() {
        return this.getAttachmentData(".pdf");
    }

    public void dump() {
        if (CLogMgt.isLevelFinest()) {
            this.log.finer(this.get_WhereClause(true));
            for (int i = 0; i < this.get_ColumnCount(); ++i) {
                this.dump(i);
            }
        }
    }

    public void dump(int index) {
        StringBuffer sb = new StringBuffer(" ").append(index);
        if (index < 0 || index >= this.get_ColumnCount()) {
            this.log.finest(sb.append(": invalid").toString());
            return;
        }
        sb.append(": ").append(this.get_ColumnName(index)).append(" = ").append(this.m_oldValues[index]).append(" (").append(this.m_newValues[index]).append(")");
        this.log.finest(sb.toString());
    }

    public static int[] getAllIDs(String TableName, String WhereClause, String trxName) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        StringBuffer sql = new StringBuffer("SELECT ");
        sql.append(TableName).append("_ID FROM ").append(TableName);
        if (WhereClause != null && WhereClause.length() > 0) {
            sql.append(" WHERE ").append(WhereClause);
        }
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), trxName);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new Integer(rs.getInt(1)));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, sql.toString(), e);
            return null;
        }
        int[] retValue = new int[list.size()];
        for (int i = 0; i < retValue.length; ++i) {
            retValue[i] = (Integer)list.get(i);
        }
        return retValue;
    }

    protected static String getFindParameter(String query) {
        if (query == null) {
            return null;
        }
        if (query.length() == 0 || query.equals("%")) {
            return null;
        }
        if (!query.endsWith("%")) {
            query = query + "%";
        }
        return query.toUpperCase();
    }

    private Object get_LOB(Object value) {
        this.log.fine("Value=" + value);
        if (value == null) {
            return null;
        }
        Object retValue = null;
        long length = -99L;
        try {
            if (value instanceof Clob) {
                Clob clob = (Clob)value;
                length = clob.length();
                retValue = clob.getSubString(1L, (int)length);
            } else if (value instanceof Blob) {
                Blob blob = (Blob)value;
                length = blob.length();
                int index = 1;
                if (blob.getClass().getName().equals("oracle.jdbc.rowset.OracleSerialBlob")) {
                    index = 0;
                }
                retValue = blob.getBytes(index, (int)length);
            } else if (value instanceof String) {
                retValue = value;
            } else if (value instanceof byte[]) {
                retValue = value;
            } else {
                this.log.log(Level.SEVERE, "Unknown: " + value);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Length=" + length, e);
        }
        return retValue;
    }

    private void lobReset() {
        this.m_lobInfo = null;
    }

    private void lobAdd(Object value, int index, int displayType) {
        this.log.finest("Value=" + value);
        PO_LOB lob = new PO_LOB(this.p_info.getTableName(), this.get_ColumnName(index), this.get_WhereClause(true), displayType, value);
        if (this.m_lobInfo == null) {
            this.m_lobInfo = new ArrayList();
        }
        this.m_lobInfo.add(lob);
    }

    private boolean lobSave() {
        if (this.m_lobInfo == null) {
            return true;
        }
        boolean retValue = true;
        for (int i = 0; i < this.m_lobInfo.size(); ++i) {
            PO_LOB lob = this.m_lobInfo.get(i);
            if (lob.save(this.get_TrxName())) continue;
            retValue = false;
            break;
        }
        this.lobReset();
        return retValue;
    }

    public StringBuffer get_xmlString(StringBuffer xml) {
        if (xml == null) {
            xml = new StringBuffer();
        } else {
            xml.append(Env.NL);
        }
        try {
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            DOMSource source = new DOMSource(this.get_xmlDocument(xml.length() != 0));
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.transform(source, result);
            StringBuffer newXML = writer.getBuffer();
            if (xml.length() != 0) {
                int tagIndex = newXML.indexOf("?>");
                if (tagIndex != -1) {
                    xml.append(newXML.substring(tagIndex + 2));
                } else {
                    xml.append(newXML);
                }
            } else {
                xml.append(newXML);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", e);
        }
        return xml;
    }

    public Document get_xmlDocument(boolean noComment) {
        Object value;
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            if (!noComment) {
                document.appendChild(document.createComment(Compiere.getSummaryAscii()));
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", e);
        }
        Element root = document.createElement(this.get_TableName());
        root.setAttribute(XML_ATTRIBUTE_AD_Table_ID, String.valueOf(this.get_Table_ID()));
        root.setAttribute(XML_ATTRIBUTE_Record_ID, String.valueOf(this.get_ID()));
        document.appendChild(root);
        int size = this.get_ColumnCount();
        for (int i = 0; i < size; ++i) {
            if (this.p_info.isVirtualColumn(i)) continue;
            Element col = document.createElement(this.p_info.getColumnName(i));
            value = this.get_Value(i);
            int dt = this.p_info.getColumnDisplayType(i);
            Class<?> c = this.p_info.getColumnClass(i);
            if (value != null && !value.equals(Null.NULL)) {
                if (c == Object.class) {
                    col.appendChild(document.createCDATASection(value.toString()));
                } else if (value instanceof Integer || value instanceof BigDecimal) {
                    col.appendChild(document.createTextNode(value.toString()));
                } else if (c == Boolean.class) {
                    boolean bValue = false;
                    bValue = value instanceof Boolean ? ((Boolean)value).booleanValue() : "Y".equals(value);
                    col.appendChild(document.createTextNode(bValue ? "Y" : "N"));
                } else if (value instanceof Timestamp) {
                    col.appendChild(document.createTextNode(value.toString()));
                } else if (c == String.class) {
                    col.appendChild(document.createCDATASection((String)value));
                } else if (DisplayType.isLOB((int)dt)) {
                    col.appendChild(document.createCDATASection(value.toString()));
                } else {
                    col.appendChild(document.createCDATASection(value.toString()));
                }
            }
            root.appendChild(col);
        }
        if (this.m_custom != null) {
            for (String columnName : this.m_custom.keySet()) {
                value = this.m_custom.get(columnName);
                Element col = document.createElement(columnName);
                if (value != null) {
                    col.appendChild(document.createTextNode((String)value));
                }
                root.appendChild(col);
            }
            this.m_custom = null;
        }
        return document;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.log = CLogger.getCLogger(this.getClass());
    }

    protected void setContext(int windowNo, String columnName, String value) {
        if (this.p_changeVO != null) {
            this.p_changeVO.setContext(this.getCtx(), windowNo, columnName, value);
        }
    }

    protected void addError(String message) {
        if (this.p_changeVO != null) {
            this.p_changeVO.addError(message);
        }
    }
}

