/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.framework;

import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MTable;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class PO_Record {
    private static int[] s_parents = new int[]{259, 855};
    private static String[] s_parentNames = new String[]{"C_Order", "CM_Container"};
    private static int[] s_parentChilds = new int[]{260, 860};
    private static String[] s_parentChildNames = new String[]{"C_OrderLine", "CM_Container_Element"};
    private static int[] s_cascades = new int[]{254, 754, 900, 389};
    private static String[] s_cascadeNames = new String[]{"AD_Attachment", "AD_Archive", "K_Index", "AD_Note"};
    private static int[] s_restricts = new int[]{417, 876};
    private static String[] s_restrictNames = new String[]{"R_Request", "CM_Chat"};
    private static CLogger log = CLogger.getCLogger(PO_Record.class);

    static boolean deleteCascade(int AD_Table_ID, int Record_ID, String trxName) {
        for (int i = 0; i < s_cascades.length; ++i) {
            if (s_cascades[i] == AD_Table_ID) continue;
            Object[] params = new Object[]{new Integer(AD_Table_ID), new Integer(Record_ID)};
            StringBuffer sql = new StringBuffer("DELETE FROM ").append(s_cascadeNames[i]).append(" WHERE AD_Table_ID=? AND Record_ID=?");
            int no = DB.executeUpdate(sql.toString(), params, false, trxName);
            if (no > 0) {
                log.config(s_cascadeNames[i] + " (" + AD_Table_ID + "/" + Record_ID + ") #" + no);
                continue;
            }
            if (no >= 0) continue;
            log.severe(s_cascadeNames[i] + " (" + AD_Table_ID + "/" + Record_ID + ") #" + no);
            return false;
        }
        for (int j = 0; j < s_parents.length; ++j) {
            if (s_parents[j] != AD_Table_ID) continue;
            int AD_Table_IDchild = s_parentChilds[j];
            Object[] params = new Object[]{new Integer(AD_Table_IDchild), new Integer(Record_ID)};
            for (int i = 0; i < s_cascades.length; ++i) {
                StringBuffer sql = new StringBuffer("DELETE FROM ").append(s_cascadeNames[i]).append(" WHERE AD_Table_ID=? AND Record_ID IN (SELECT ").append(s_parentChildNames[j]).append("_ID FROM ").append(s_parentChildNames[j]).append(" WHERE ").append(s_parentNames[j]).append("_ID=?)");
                int no = DB.executeUpdate(sql.toString(), params, false, trxName);
                if (no > 0) {
                    log.config(s_cascadeNames[i] + " " + s_parentNames[j] + " (" + AD_Table_ID + "/" + Record_ID + ") #" + no);
                    continue;
                }
                if (no >= 0) continue;
                log.severe(s_cascadeNames[i] + " " + s_parentNames[j] + " (" + AD_Table_ID + "/" + Record_ID + ") #" + no);
                return false;
            }
        }
        return true;
    }

    static String exists(int AD_Table_ID, int Record_ID, String trxName) {
        for (int i = 0; i < s_restricts.length; ++i) {
            StringBuffer sql = new StringBuffer("SELECT COUNT(*) FROM ").append(s_restrictNames[i]).append(" WHERE AD_Table_ID=? AND Record_ID=?");
            int no = DB.getSQLValue(trxName, sql.toString(), AD_Table_ID, Record_ID);
            if (no <= 0) continue;
            return s_restrictNames[i];
        }
        return null;
    }

    static void validate() {
        String sql = "SELECT AD_Table_ID, TableName FROM AD_Table WHERE IsView='N' ORDER BY 2";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                PO_Record.validate(rs.getInt(1), rs.getString(2));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
    }

    static void validate(int AD_Table_ID) {
        MTable table = new MTable(Env.getCtx(), AD_Table_ID, null);
        if (table.isView()) {
            log.warning("Ignored - View " + table.getTableName());
        } else {
            PO_Record.validate(table.getAD_Table_ID(), table.getTableName());
        }
    }

    private static void validate(int AD_Table_ID, String TableName) {
        for (int i = 0; i < s_cascades.length; ++i) {
            StringBuffer sql = new StringBuffer("DELETE FROM ").append(s_cascadeNames[i]).append(" WHERE AD_Table_ID=").append(AD_Table_ID).append(" AND Record_ID NOT IN (SELECT ").append(TableName).append("_ID FROM ").append(TableName).append(")");
            int no = DB.executeUpdate(sql.toString(), null);
            if (no <= 0) continue;
            log.config(s_cascadeNames[i] + " (" + AD_Table_ID + "/" + TableName + ") Invalid #" + no);
        }
    }
}

