/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.logging.Level;
import javax.swing.tree.TreeNode;
import org.compiere.framework.PO;
import org.compiere.model.CTreeNode;
import org.compiere.model.MColumn;
import org.compiere.model.MTree;
import org.compiere.model.X_AD_AssignCriteria;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class MAssignCriteria
extends X_AD_AssignCriteria {
    private MColumn m_column = null;

    public MAssignCriteria(Ctx ctx, int AD_AssignCriteria_ID, String trxName) {
        super(ctx, AD_AssignCriteria_ID, trxName);
    }

    public MAssignCriteria(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MColumn getSourceColumn() {
        if (this.m_column == null || this.m_column.getAD_Column_ID() != this.getAD_SourceColumn_ID()) {
            this.m_column = MColumn.get(this.getCtx(), this.getAD_SourceColumn_ID());
        }
        return this.m_column;
    }

    public boolean isMet(PO po) {
        MColumn column = this.getSourceColumn();
        String columnName = column.getColumnName();
        int index = po.get_ColumnIndex(columnName);
        if (index == -1) {
            throw new IllegalArgumentException(this.toString() + ": AD_Column_ID not found");
        }
        Object value = po.get_Value(index);
        String op = this.getOperation();
        String compareString = this.getValueString();
        if (op.equals("SQ")) {
            compareString = this.getSQLValue();
            op = "==";
        }
        if (value == null) {
            return compareString == null || compareString.length() == 0 || compareString.equalsIgnoreCase("NULL") ? op.equals("==") : !op.equals("==");
        }
        if (this.getRecord_ID() == 0 && (compareString == null || compareString.length() == 0)) {
            return false;
        }
        if (op.equals("~~")) {
            String s = value.toString();
            String cmp = compareString;
            if (cmp.indexOf(37) != -1) {
                this.log.warning(this.toString() + ": SQL LIKE not supported yet");
            }
            return s.toUpperCase().indexOf(cmp.toUpperCase()) != 0;
        }
        try {
            if (value instanceof Integer) {
                Integer ii = (Integer)value;
                Integer cmp = null;
                cmp = this.getRecord_ID() > 0 ? Integer.valueOf(this.getRecord_ID()) : new Integer(compareString);
                Boolean treeOp = this.treeOperation(columnName, cmp, op, ii, po.getAD_Client_ID());
                if (treeOp != null) {
                    return treeOp;
                }
                if (op.equals("==")) {
                    return ii.equals(cmp);
                }
                if (op.equals("!=")) {
                    return !ii.equals(cmp);
                }
                if (op.equals(">>")) {
                    return ii.compareTo(cmp) > 0;
                }
                if (op.equals(">=")) {
                    return ii.compareTo(cmp) >= 0;
                }
                if (op.equals("<<")) {
                    return ii.compareTo(cmp) < 0;
                }
                if (op.equals("<=")) {
                    return ii.compareTo(cmp) <= 0;
                }
            } else if (value instanceof BigDecimal) {
                BigDecimal bd = (BigDecimal)value;
                BigDecimal cmp = new BigDecimal(compareString);
                if (op.equals("==")) {
                    return bd.equals(cmp);
                }
                if (op.equals("!=")) {
                    return !bd.equals(cmp);
                }
                if (op.equals(">>")) {
                    return bd.compareTo(cmp) > 0;
                }
                if (op.equals(">=")) {
                    return bd.compareTo(cmp) >= 0;
                }
                if (op.equals("<<")) {
                    return bd.compareTo(cmp) < 0;
                }
                if (op.equals("<=")) {
                    return bd.compareTo(cmp) <= 0;
                }
            } else if (value instanceof Timestamp) {
                Timestamp ts = (Timestamp)value;
                Timestamp cmp = Timestamp.valueOf(compareString);
                if (op.equals("==")) {
                    return ts.equals(cmp);
                }
                if (op.equals("!=")) {
                    return !ts.equals(cmp);
                }
                if (op.equals(">>")) {
                    return ts.compareTo(cmp) > 0;
                }
                if (op.equals(">=")) {
                    return ts.compareTo(cmp) >= 0;
                }
                if (op.equals("<<")) {
                    return ts.compareTo(cmp) < 0;
                }
                if (op.equals("<=")) {
                    return ts.compareTo(cmp) <= 0;
                }
            } else {
                String s = value.toString();
                String cmp = compareString;
                if (op.equals("==")) {
                    return s.equals(cmp);
                }
                if (op.equals("!=")) {
                    return !s.equals(cmp);
                }
                if (op.equals(">>")) {
                    return s.compareTo(cmp) > 0;
                }
                if (op.equals(">=")) {
                    return s.compareTo(cmp) >= 0;
                }
                if (op.equals("<<")) {
                    return s.compareTo(cmp) < 0;
                }
                if (op.equals("<=")) {
                    return s.compareTo(cmp) <= 0;
                }
            }
        }
        catch (Exception e) {
            this.log.warning(this.toString() + ": " + e);
        }
        return false;
    }

    private String getSQLValue() {
        String sql = this.getValueString();
        String retValue = null;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = rs.getString(1);
                if (rs.next()) {
                    this.log.warning(this.toString() + ": More than one sql value");
                }
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, this.toString(), e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    private Boolean treeOperation(String columnName, int cmp, String op, Integer value, int AD_Client_ID) {
        String tableName = null;
        if (columnName.endsWith("_ID") && (op.equals("==") || op.equals("!="))) {
            String temp = columnName;
            if (temp.endsWith("_ID")) {
                temp = columnName.substring(0, columnName.length() - 3);
            }
            if (MTree.hasTree(temp)) {
                tableName = temp;
            }
        }
        if (tableName == null) {
            return null;
        }
        StringBuffer sql = new StringBuffer("SELECT ").append(columnName).append(" FROM ").append(tableName).append(" WHERE ").append(columnName).append("=? AND IsSummary='Y'");
        int id = DB.getSQLValue(null, sql.toString(), cmp);
        if (id <= 0) {
            return null;
        }
        int AD_Tree_ID = MTree.getDefaultAD_Tree_ID(AD_Client_ID, tableName);
        if (AD_Tree_ID <= 0) {
            return null;
        }
        MTree tree = new MTree(this.getCtx(), AD_Tree_ID, false, true, null);
        CTreeNode node = tree.getRoot().findNode(id);
        this.log.finest("Root=" + node);
        if (node != null && node.isSummary()) {
            Enumeration<TreeNode> en = node.preorderEnumeration();
            while (en.hasMoreElements()) {
                CTreeNode nn = (CTreeNode)en.nextElement();
                if (nn.isSummary()) continue;
                int cmp1 = nn.getNode_ID();
                if (!(op.equals("==") ? value.equals(cmp1) : op.equals("!=") && !value.equals(cmp1))) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MAssignCriteria[").append(this.get_ID()).append("-").append(this.getSeqNo()).append(",AD_SourceColumn_ID=").append(this.getAD_SourceColumn_ID()).append(",Operation=").append(this.getOperation());
        if (this.getRecord_ID() != 0) {
            sb.append(",Record_ID=").append(this.getRecord_ID());
        }
        if (this.getValueString() != null) {
            sb.append(",ValueString=").append(this.getValueString());
        }
        sb.append("]");
        return sb.toString();
    }
}

