/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.framework.PO;
import org.compiere.model.MAssignTarget;
import org.compiere.model.MColumn;
import org.compiere.model.X_AD_AssignSet;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class MAssignSet
extends X_AD_AssignSet {
    private static CLogger s_log = CLogger.getCLogger(MAssignSet.class);
    private static MAssignSet[] s_assignments = null;
    private MAssignTarget[] m_targets = null;

    public static MAssignSet[] getAll(Ctx ctx) {
        ArrayList<MAssignSet> list = new ArrayList<MAssignSet>();
        String sql = "SELECT * FROM AD_AssignSet";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MAssignSet(ctx, rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MAssignSet[] retValue = new MAssignSet[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static boolean execute(PO po, boolean newRecord) {
        if (s_assignments == null) {
            s_assignments = MAssignSet.getAll(po.getCtx());
        }
        boolean modified = false;
        for (int i = 0; i < s_assignments.length; ++i) {
            int indexProcessed;
            MAssignSet set = s_assignments[i];
            if (!set.isActive() || po.get_Table_ID() != set.getAD_Table_ID() || po.getAD_Client_ID() != set.getAD_Client_ID() && set.getAD_Client_ID() != 0) continue;
            String rule = set.getAutoAssignRule();
            if (!newRecord && rule.equals("C") || newRecord && (rule.equals("U") || rule.equals("Q")) || (rule.equals("P") || rule.equals("Q")) && (indexProcessed = po.get_ColumnIndex("Processed")) != -1 && "Y".equals(po.get_Value(indexProcessed)) || !set.executeIt(po)) continue;
            modified = true;
        }
        return modified;
    }

    public MAssignSet(Ctx ctx, int AD_AssignSet_ID, String trxName) {
        super(ctx, AD_AssignSet_ID, trxName);
    }

    public MAssignSet(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MAssignTarget[] getTargets(boolean reload) {
        if (this.m_targets != null && !reload) {
            return this.m_targets;
        }
        String sql = "SELECT * FROM AD_AssignTarget WHERE AD_AssignSet_ID=? ORDER BY SeqNo";
        ArrayList<MAssignTarget> list = new ArrayList<MAssignTarget>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getAD_AssignSet_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MAssignTarget(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_targets = new MAssignTarget[list.size()];
        list.toArray(this.m_targets);
        return this.m_targets;
    }

    public boolean executeIt(PO po) {
        if (this.m_targets == null) {
            this.m_targets = this.getTargets(false);
        }
        boolean modified = false;
        for (int i = 0; i < this.m_targets.length; ++i) {
            MAssignTarget target = this.m_targets[i];
            if (!target.isActive()) continue;
            MColumn tColumn = target.getTargetColumn();
            if (tColumn.getAD_Table_ID() != this.getAD_Table_ID()) {
                throw new IllegalArgumentException(this.toString() + ": AD_Table_ID inconsistent for " + target);
            }
            try {
                modified = target.executeIt(po);
                continue;
            }
            catch (Exception e) {
                this.log.severe(e.toString());
                modified = false;
            }
        }
        return modified;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MAssignSet[").append(this.get_ID()).append("-").append(this.getName()).append(",AD_Table_ID=").append(this.getAD_Table_ID()).append("]");
        return sb.toString();
    }
}

