/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.framework.PO;
import org.compiere.model.MAssignCriteria;
import org.compiere.model.MColumn;
import org.compiere.model.X_AD_AssignTarget;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;

public class MAssignTarget
extends X_AD_AssignTarget {
    private MAssignCriteria[] m_criteria = null;
    private MColumn m_column = null;

    public MAssignTarget(Ctx ctx, int AD_AssignTarget_ID, String trxName) {
        super(ctx, AD_AssignTarget_ID, trxName);
    }

    public MAssignTarget(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MAssignCriteria[] getCriteria(boolean reload) {
        if (this.m_criteria != null && !reload) {
            return this.m_criteria;
        }
        String sql = "SELECT * FROM AD_AssignCriteria WHERE AD_AssignTarget_ID=? ORDER BY SeqNo";
        ArrayList<MAssignCriteria> list = new ArrayList<MAssignCriteria>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getAD_AssignTarget_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MAssignCriteria(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_criteria = new MAssignCriteria[list.size()];
        list.toArray(this.m_criteria);
        return this.m_criteria;
    }

    public MColumn getTargetColumn() {
        if (this.m_column == null || this.m_column.getAD_Column_ID() != this.getAD_TargetColumn_ID()) {
            this.m_column = MColumn.get(this.getCtx(), this.getAD_TargetColumn_ID());
        }
        return this.m_column;
    }

    public boolean executeIt(PO po) {
        MColumn column = this.getTargetColumn();
        String columnName = column.getColumnName();
        int index = po.get_ColumnIndex(columnName);
        if (index == -1) {
            throw new IllegalArgumentException(this.toString() + ": AD_Column_ID not found");
        }
        Object value = po.get_Value(index);
        String assignRule = this.getAssignRule();
        if (value == null && assignRule.equals("X")) {
            return false;
        }
        if (value != null && assignRule.equals("N")) {
            return false;
        }
        if (this.m_criteria == null) {
            this.getCriteria(false);
        }
        boolean modified = false;
        for (int i = 0; i < this.m_criteria.length; ++i) {
            MAssignCriteria criteria = this.m_criteria[i];
            if (!criteria.isMet(po)) continue;
            modified = true;
            break;
        }
        if (!modified) {
            return false;
        }
        String methodName = "set" + columnName;
        Class parameterType = null;
        Object parameter = null;
        int displayType = column.getAD_Reference_ID();
        String valueString = this.getValueString();
        if (DisplayType.isText((int)displayType) || displayType == 17) {
            parameterType = String.class;
            parameter = valueString;
        } else if (DisplayType.isID((int)displayType) || displayType == 11) {
            parameterType = Integer.TYPE;
            if (this.getRecord_ID() != 0) {
                parameter = this.getRecord_ID();
            } else if (valueString != null && valueString.length() > 0) {
                try {
                    parameter = Integer.parseInt(valueString);
                }
                catch (Exception e) {
                    this.log.warning(this.toString() + " " + e);
                    return false;
                }
            }
        } else if (DisplayType.isNumeric((int)displayType)) {
            parameterType = BigDecimal.class;
            if (valueString != null && valueString.length() > 0) {
                try {
                    parameter = new BigDecimal(valueString);
                }
                catch (Exception e) {
                    this.log.warning(this.toString() + " " + e);
                    return false;
                }
            }
        } else if (DisplayType.isDate((int)displayType)) {
            parameterType = Timestamp.class;
            if (valueString != null && valueString.length() > 0) {
                try {
                    parameter = Timestamp.valueOf(valueString);
                }
                catch (Exception e) {
                    this.log.warning(this.toString() + " " + e);
                    return false;
                }
            }
        } else if (displayType == 20) {
            parameterType = Boolean.TYPE;
            parameter = "Y".equals(valueString);
        } else if (displayType == 28) {
            parameterType = String.class;
            parameter = this.getValueString();
        } else if (DisplayType.isLOB((int)displayType)) {
            parameterType = byte[].class;
        }
        try {
            Class<?> clazz = po.getClass();
            Method method = clazz.getMethod(methodName, parameterType);
            method.invoke((Object)po, parameter);
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, this.toString(), e);
            if (parameter instanceof Boolean) {
                po.set_Value(index, (Object)valueString);
            }
            po.set_Value(index, parameter);
        }
        return modified;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MAssignTarget[").append(this.get_ID()).append(",AD_TargetColumn_ID=").append(this.getAD_TargetColumn_ID());
        if (this.getRecord_ID() != 0) {
            sb.append(",Record_ID=").append(this.getRecord_ID());
        }
        if (this.getValueString() != null) {
            sb.append(",ValueString=").append(this.getValueString());
        }
        sb.append("]");
        return sb.toString();
    }
}

