/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.X_AD_ClientInfo;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class MClientInfo
extends X_AD_ClientInfo {
    private static CCache<Integer, MClientInfo> s_cache = new CCache("AD_ClientInfo", 2);
    private static CLogger s_log = CLogger.getCLogger(MClientInfo.class);
    private MAcctSchema m_acctSchema = null;
    private boolean m_createNew = false;

    public static MClientInfo get(Ctx ctx, int AD_Client_ID) {
        return MClientInfo.get(ctx, AD_Client_ID, null);
    }

    public static MClientInfo get(Ctx ctx, int AD_Client_ID, String trxName) {
        Integer key = new Integer(AD_Client_ID);
        MClientInfo info = s_cache.get(key);
        if (info != null) {
            return info;
        }
        String sql = "SELECT * FROM AD_ClientInfo WHERE AD_Client_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, AD_Client_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                info = new MClientInfo(ctx, rs, null);
                if (trxName == null) {
                    s_cache.put(key, info);
                }
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            s_log.log(Level.SEVERE, sql, ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException ex1) {
            // empty catch block
        }
        pstmt = null;
        return info;
    }

    public static MClientInfo get(Ctx ctx) {
        return MClientInfo.get(ctx, ctx.getAD_Client_ID(), null);
    }

    public MClientInfo(Ctx ctx, int AD_Client_ID, String trxName) {
        super(ctx, AD_Client_ID, trxName);
    }

    public MClientInfo(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MClientInfo(MClient client, int AD_Tree_Org_ID, int AD_Tree_BPartner_ID, int AD_Tree_Project_ID, int AD_Tree_SalesRegion_ID, int AD_Tree_Product_ID, int AD_Tree_Campaign_ID, int AD_Tree_Activity_ID, String trxName) {
        super(client.getCtx(), 0, trxName);
        this.setAD_Client_ID(client.getAD_Client_ID());
        this.setAD_Org_ID(0);
        this.setIsDiscountLineAmt(false);
        this.setAD_Tree_Menu_ID(10);
        this.setAD_Tree_Org_ID(AD_Tree_Org_ID);
        this.setAD_Tree_BPartner_ID(AD_Tree_BPartner_ID);
        this.setAD_Tree_Project_ID(AD_Tree_Project_ID);
        this.setAD_Tree_SalesRegion_ID(AD_Tree_SalesRegion_ID);
        this.setAD_Tree_Product_ID(AD_Tree_Product_ID);
        this.setAD_Tree_Campaign_ID(AD_Tree_Campaign_ID);
        this.setAD_Tree_Activity_ID(AD_Tree_Activity_ID);
        this.setMatchRequirementI("N");
        this.setMatchRequirementR("N");
        this.m_createNew = true;
    }

    public MAcctSchema getMAcctSchema1() {
        if (this.m_acctSchema == null && this.getC_AcctSchema1_ID() != 0) {
            this.m_acctSchema = new MAcctSchema(this.getCtx(), this.getC_AcctSchema1_ID(), null);
        }
        return this.m_acctSchema;
    }

    public int getC_Currency_ID() {
        if (this.m_acctSchema == null) {
            this.getMAcctSchema1();
        }
        if (this.m_acctSchema != null) {
            return this.m_acctSchema.getC_Currency_ID();
        }
        return 0;
    }

    public String getMatchRequirementI() {
        String s = super.getMatchRequirementI();
        if (s == null) {
            this.setMatchRequirementI("N");
            return "N";
        }
        return s;
    }

    public String getMatchRequirementR() {
        String s = super.getMatchRequirementR();
        if (s == null) {
            this.setMatchRequirementR("N");
            return "N";
        }
        return s;
    }

    public boolean save() {
        if (this.getAD_Org_ID() != 0) {
            this.setAD_Org_ID(0);
        }
        this.getMatchRequirementI();
        this.getMatchRequirementR();
        if (this.m_createNew) {
            return super.save();
        }
        return this.saveUpdate();
    }
}

