/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import org.compiere.model.MRefTable;
import org.compiere.model.MTable;
import org.compiere.model.M_Element;
import org.compiere.model.X_AD_Column;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MColumn
extends X_AD_Column {
    private static CCache<Integer, MColumn> s_cache = new CCache("AD_Column", 20);
    private static CLogger s_log = CLogger.getCLogger(MColumn.class);
    private M_Element m_element = null;

    public static MColumn get(Ctx ctx, int AD_Column_ID) {
        Integer key = new Integer(AD_Column_ID);
        MColumn retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MColumn(ctx, AD_Column_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public static String getColumnName(Ctx ctx, int AD_Column_ID) {
        MColumn col = MColumn.get(ctx, AD_Column_ID);
        if (col.get_ID() == 0) {
            return null;
        }
        return col.getColumnName();
    }

    public MColumn(Ctx ctx, int AD_Column_ID, String trxName) {
        super(ctx, AD_Column_ID, trxName);
        if (AD_Column_ID == 0) {
            this.setIsAlwaysUpdateable(false);
            this.setIsEncrypted(false);
            this.setIsIdentifier(false);
            this.setIsKey(false);
            this.setIsMandatory(false);
            this.setIsMandatoryUI(false);
            this.setIsParent(false);
            this.setIsSelectionColumn(false);
            this.setIsTranslated(false);
            this.setIsUpdateable(true);
            this.setVersion(Env.ZERO);
            this.setIsSelectionColumn(false);
            this.setIsSummaryColumn(false);
        }
    }

    public MColumn(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MColumn(MTable parent) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setAD_Table_ID(parent.getAD_Table_ID());
        this.setEntityType(parent.getEntityType());
    }

    public boolean isStandardColumn() {
        String columnName = this.getColumnName();
        return columnName.equals("AD_Client_ID") || columnName.equals("AD_Org_ID") || columnName.equals("IsActive") || columnName.startsWith("Created") || columnName.startsWith("Updated");
    }

    public boolean isVirtualColumn() {
        String s = this.getColumnSQL();
        return s != null && s.length() > 0;
    }

    public boolean isEncrypted() {
        String s = this.getIsEncrypted();
        return "Y".equals(s);
    }

    public void setIsEncrypted(boolean IsEncrypted) {
        this.setIsEncrypted(IsEncrypted ? "Y" : "N");
    }

    public M_Element getElement() {
        if (this.m_element == null || this.m_element.getAD_Element_ID() != this.getAD_Element_ID()) {
            this.m_element = new M_Element(this.getCtx(), this.getAD_Element_ID(), this.get_TrxName());
        }
        return this.m_element;
    }

    protected boolean beforeSave(boolean newRecord) {
        int displayType = this.getAD_Reference_ID();
        if (DisplayType.isLOB((int)displayType)) {
            if (this.getFieldLength() != 0) {
                this.setFieldLength(0);
            }
        } else if (this.getFieldLength() == 0) {
            if (DisplayType.isID((int)displayType)) {
                this.setFieldLength(10);
            } else if (DisplayType.isNumeric((int)displayType)) {
                this.setFieldLength(14);
            } else if (DisplayType.isDate((int)displayType)) {
                this.setFieldLength(7);
            } else if (20 == displayType) {
                this.setFieldLength(1);
            } else {
                this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "FieldLength"));
                return false;
            }
        }
        if (this.isVirtualColumn()) {
            if (this.isMandatory()) {
                this.setIsMandatory(false);
            }
            if (this.isMandatoryUI()) {
                this.setIsMandatoryUI(false);
            }
            if (this.isUpdateable()) {
                this.setIsUpdateable(false);
            }
        }
        if (this.isParent() || this.isKey()) {
            this.setIsUpdateable(false);
            this.setIsMandatory(true);
        }
        if (this.isAlwaysUpdateable() && !this.isUpdateable()) {
            this.setIsAlwaysUpdateable(false);
        }
        if (this.isEncrypted()) {
            int dt = this.getAD_Reference_ID();
            if (this.isKey() || this.isParent() || this.isStandardColumn() || this.isVirtualColumn() || this.isIdentifier() || this.isTranslated() || DisplayType.isLookup((int)dt) || DisplayType.isLOB((int)dt) || "DocumentNo".equalsIgnoreCase(this.getColumnName()) || "Value".equalsIgnoreCase(this.getColumnName()) || "Name".equalsIgnoreCase(this.getColumnName())) {
                this.log.warning("Encryption not sensible - " + this.getColumnName());
                this.setIsEncrypted(false);
            }
        }
        if ((newRecord || this.is_ValueChanged("AD_Element_ID")) && this.getAD_Element_ID() != 0) {
            this.m_element = new M_Element(this.getCtx(), this.getAD_Element_ID(), this.get_TrxName());
            this.setColumnName(this.m_element.getColumnName());
            this.setName(this.m_element.getName());
            this.setDescription(this.m_element.getDescription());
            this.setHelp(this.m_element.getHelp());
        }
        if (this.isKey() && (newRecord || this.is_ValueChanged("IsKey"))) {
            this.setConstraintType(null);
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!newRecord) {
            StringBuffer sql = new StringBuffer("UPDATE AD_Field SET Name=").append(DB.TO_STRING(this.getName())).append(", Description=").append(DB.TO_STRING(this.getDescription())).append(", Help=").append(DB.TO_STRING(this.getHelp())).append(" WHERE AD_Column_ID=").append(this.get_ID()).append(" AND IsCentrallyMaintained='Y'");
            int no = DB.executeUpdate(sql.toString(), this.get_TrxName());
            this.log.fine("afterSave - Fields updated #" + no);
        }
        return success;
    }

    public String getSQLAdd(MTable table) {
        if (this.isVirtualColumn()) {
            return null;
        }
        StringBuffer sql = new StringBuffer("ALTER TABLE ").append(table.getTableName()).append(" ADD ").append(this.getSQLDDL());
        return sql.toString();
    }

    public String getSQLDDL() {
        if (this.isVirtualColumn()) {
            return null;
        }
        String columnName = this.getColumnName();
        StringBuffer sql = new StringBuffer(columnName).append(" ").append(this.getSQLDataType());
        String defaultValue = this.getSQLDefaultValue();
        if (defaultValue != null && defaultValue.length() > 0) {
            sql.append(" DEFAULT ").append(defaultValue);
        }
        if (DB.isOracle() && this.getAD_Reference_ID() == 20) {
            sql.append(" CHECK (").append(columnName).append(" IN ('Y','N'))");
        }
        if (this.isMandatory()) {
            sql.append(" NOT NULL");
        }
        return sql.toString();
    }

    public String getSQLModify(MTable table, boolean setNullOption) {
        StringBuffer sql = new StringBuffer();
        StringBuffer sqlBase = new StringBuffer("ALTER TABLE ").append(table.getTableName()).append(" MODIFY ").append(this.getColumnName());
        StringBuffer sqlDefault = new StringBuffer(sqlBase).append(" ").append(this.getSQLDataType()).append(" DEFAULT ");
        String defaultValue = this.getSQLDefaultValue();
        if (defaultValue.length() > 0) {
            sqlDefault.append(defaultValue);
        } else {
            sqlDefault.append(" NULL ");
            defaultValue = null;
        }
        sql.append(sqlDefault);
        if (this.isMandatory() && defaultValue != null && defaultValue.length() > 0) {
            StringBuffer sqlSet = new StringBuffer("UPDATE ").append(table.getTableName()).append(" SET ").append(this.getColumnName()).append("=").append(defaultValue).append(" WHERE ").append(this.getColumnName()).append(" IS NULL");
            sql.append("; ").append(sqlSet);
        }
        if (setNullOption) {
            StringBuffer sqlNull = new StringBuffer(sqlBase);
            if (this.isMandatory()) {
                sqlNull.append(" NOT NULL");
            } else {
                sqlNull.append(" NULL");
            }
            sql.append("; ").append(sqlNull);
        }
        return sql.toString();
    }

    public String getSQLDefaultValue() {
        String defaultValue = this.getDefaultValue();
        String columnName = this.getColumnName();
        int dt = this.getAD_Reference_ID();
        String sql = "";
        if (columnName.equals("CreatedBy") || columnName.equals("UpdatedBy")) {
            sql = "0";
        } else if (columnName.equals("Created") || columnName.equals("Updated")) {
            sql = DB.isOracle() || DB.isPostgreSQL() ? "SYSDATE" : "CURRENT_TIMESTAMP";
        } else if (defaultValue != null && defaultValue.length() > 0) {
            if ((defaultValue = defaultValue.trim()).equals("NULL")) {
                sql = "NULL";
            } else if (!defaultValue.startsWith("@SQL=")) {
                int first = defaultValue.indexOf("@");
                if (first >= 0 && defaultValue.indexOf("@", first + 1) >= 0) {
                    s_log.finer("Get default: (Unresolved Variable) " + defaultValue);
                } else if (defaultValue.equals("-1")) {
                    s_log.finer("Get default: (invalid value) " + defaultValue);
                } else {
                    sql = DisplayType.isText((int)dt) || 17 == dt || 20 == dt || 28 == dt && !columnName.endsWith("_ID") || columnName.equals("EntityType") || columnName.equals("AD_Language") || columnName.equals("DocBaseType") ? DB.TO_STRING(defaultValue) : defaultValue;
                }
            }
        } else if (columnName.equals("IsActive")) {
            sql = "'Y'";
        } else if (dt == 20) {
            sql = "'N'";
        } else if (DisplayType.isNumeric((int)dt) && (this.isMandatory() || this.isMandatoryUI())) {
            sql = "0";
        }
        return sql;
    }

    public String getSQLDataType() {
        String columnName = this.getColumnName();
        int dt = this.getAD_Reference_ID();
        return DisplayType.getSQLDataType(dt, columnName, this.getFieldLength());
    }

    public String getName(String AD_Language) {
        return this.get_Translation(this.getColumnName(), AD_Language);
    }

    public boolean isFK() {
        int dt = this.getAD_Reference_ID();
        if (DisplayType.isID((int)dt) && dt != 13 && !this.isKey() && !this.isVirtualColumn()) {
            return true;
        }
        return dt == 28 && this.getColumnName().endsWith("_ID");
    }

    public boolean isList() {
        int dt = this.getAD_Reference_ID();
        return dt == 17;
    }

    public String getFKColumnName() {
        String keyColumnName = this.getColumnName();
        int displayType = this.getAD_Reference_ID();
        if (displayType == 17) {
            return "Value";
        }
        if (displayType == 25) {
            return "C_ValidCombination_ID";
        }
        if (displayType == 18) {
            int AD_Reference_ID = this.getAD_Reference_Value_ID();
            MRefTable rt = MRefTable.get(this.getCtx(), AD_Reference_ID);
            return rt.getKeyColumnName();
        }
        return keyColumnName;
    }

    public MTable getFKTable() {
        if (!this.isFK()) {
            return null;
        }
        int displayType = this.getAD_Reference_ID();
        if (displayType == 17) {
            return MTable.get(this.getCtx(), 104);
        }
        if (displayType == 25) {
            return MTable.get(this.getCtx(), 176);
        }
        String FKTableName = this.getFKColumnName();
        if (FKTableName.endsWith("_ID")) {
            FKTableName = FKTableName.substring(0, FKTableName.length() - 3);
        }
        return MTable.get(this.getCtx(), FKTableName);
    }

    public boolean isSelectionColumn() {
        if (super.isSelectionColumn()) {
            return true;
        }
        String cn = this.getColumnName();
        return "Value".equals(cn) || "Name".equals(cn) || "Description".equals(cn) || "DocumentNo".equals(cn);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MColumn[");
        sb.append(this.get_ID()).append("-").append(this.getColumnName()).append("]");
        return sb.toString();
    }
}

