/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.framework.PO;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MRefList;
import org.compiere.model.X_M_CostElement;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class MCostElement
extends X_M_CostElement {
    private static CCache<Integer, MCostElement> s_cache = new CCache("M_CostElement", 20);
    private static CLogger s_log = CLogger.getCLogger(MCostElement.class);

    public static MCostElement getMaterialCostElement(PO po, String CostingMethod) {
        if (CostingMethod == null || CostingMethod.length() == 0) {
            s_log.severe("No CostingMethod");
            return null;
        }
        MCostElement retValue = null;
        String sql = "SELECT * FROM M_CostElement WHERE AD_Client_ID=? AND CostingMethod=? ORDER BY AD_Org_ID";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, po.get_TrxName());
            pstmt.setInt(1, po.getAD_Client_ID());
            pstmt.setString(2, CostingMethod);
            ResultSet rs = pstmt.executeQuery();
            boolean n = rs.next();
            if (n) {
                retValue = new MCostElement(po.getCtx(), rs, po.get_TrxName());
            }
            if (n && rs.next()) {
                s_log.warning("More then one Material Cost Element for CostingMethod=" + CostingMethod);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (retValue != null) {
            return retValue;
        }
        retValue = new MCostElement(po.getCtx(), 0, po.get_TrxName());
        retValue.setClientOrg(po.getAD_Client_ID(), 0);
        String name = MRefList.getListName(po.getCtx(), 122, CostingMethod);
        if (name == null || name.length() == 0) {
            name = CostingMethod;
        }
        retValue.setName(name);
        retValue.setCostElementType("M");
        retValue.setCostingMethod(CostingMethod);
        retValue.save();
        return retValue;
    }

    public static MCostElement getMaterialCostElement(Ctx ctx, String CostingMethod) {
        MCostElement retValue = null;
        String sql = "SELECT * FROM M_CostElement WHERE AD_Client_ID=? AND CostingMethod=? ORDER BY AD_Org_ID";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, ctx.getAD_Client_ID());
            pstmt.setString(2, CostingMethod);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MCostElement(ctx, rs, null);
            }
            if (rs.next()) {
                s_log.info("More then one Material Cost Element for CostingMethod=" + CostingMethod);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public static MCostElement[] getCostingMethods(PO po) {
        ArrayList<MCostElement> list = new ArrayList<MCostElement>();
        String sql = "SELECT * FROM M_CostElement WHERE AD_Client_ID=? AND IsActive='Y' AND CostElementType='M' AND CostingMethod IS NOT NULL";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, po.get_TrxName());
            pstmt.setInt(1, po.getAD_Client_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MCostElement(po.getCtx(), rs, po.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MCostElement[] retValue = new MCostElement[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MCostElement get(Ctx ctx, int M_CostElement_ID) {
        Integer key = new Integer(M_CostElement_ID);
        MCostElement retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MCostElement(ctx, M_CostElement_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public MCostElement(Ctx ctx, int M_CostElement_ID, String trxName) {
        super(ctx, M_CostElement_ID, trxName);
        if (M_CostElement_ID == 0) {
            this.setCostElementType("M");
            this.setIsCalculated(false);
        }
    }

    public MCostElement(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    protected boolean beforeSave(boolean newRecord) {
        if ("M".equals(this.getCostElementType()) && (newRecord || this.is_ValueChanged("CostingMethod"))) {
            String sql = "SELECT COALESCE(MAX(M_CostElement_ID),0) FROM M_CostElement WHERE AD_Client_ID=? AND CostingMethod=?";
            int id = DB.getSQLValue(this.get_TrxName(), sql, this.getAD_Client_ID(), this.getCostingMethod());
            if (id > 0 && id != this.get_ID()) {
                this.log.saveError("AlreadyExists", Msg.getElement(this.getCtx(), "CostingMethod"));
                return false;
            }
        }
        if ("M".equals(this.getCostElementType())) {
            String cm = this.getCostingMethod();
            if (cm == null || cm.length() == 0 || "S".equals(cm)) {
                this.setIsCalculated(false);
            } else {
                this.setIsCalculated(true);
            }
        } else {
            if (this.isCalculated()) {
                this.setIsCalculated(false);
            }
            if (this.getCostingMethod() != null) {
                this.setCostingMethod(null);
            }
        }
        if (this.getAD_Org_ID() != 0) {
            this.setAD_Org_ID(0);
        }
        return true;
    }

    protected boolean beforeDelete() {
        String cm = this.getCostingMethod();
        if (cm == null || !"M".equals(this.getCostElementType())) {
            return true;
        }
        MAcctSchema[] ass = MAcctSchema.getClientAcctSchema(this.getCtx(), this.getAD_Client_ID());
        for (int i = 0; i < ass.length; ++i) {
            if (!ass[i].getCostingMethod().equals(this.getCostingMethod())) continue;
            this.log.saveError("CannotDeleteUsed", Msg.getElement(this.getCtx(), "C_AcctSchema_ID") + " - " + ass[i].getName());
            return false;
        }
        String sql = "SELECT M_Product_Category_ID FROM M_Product_Category_Acct WHERE AD_Client_ID=? AND CostingMethod=?";
        int M_Product_Category_ID = 0;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.getAD_Client_ID());
            pstmt.setString(2, this.getCostingMethod());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                M_Product_Category_ID = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (M_Product_Category_ID != 0) {
            this.log.saveError("CannotDeleteUsed", Msg.getElement(this.getCtx(), "M_Product_Category_ID") + " (ID=" + M_Product_Category_ID + ")");
            return false;
        }
        return true;
    }

    public boolean isCostingMethod() {
        return "M".equals(this.getCostElementType()) && this.getCostingMethod() != null;
    }

    public boolean isAverageInvoice() {
        String cm = this.getCostingMethod();
        return cm != null && cm.equals("I") && "M".equals(this.getCostElementType());
    }

    public boolean isAveragePO() {
        String cm = this.getCostingMethod();
        return cm != null && cm.equals("A") && "M".equals(this.getCostElementType());
    }

    public boolean isFifo() {
        String cm = this.getCostingMethod();
        return cm != null && cm.equals("F") && "M".equals(this.getCostElementType());
    }

    public boolean isLastInvoice() {
        String cm = this.getCostingMethod();
        return cm != null && cm.equals("i") && "M".equals(this.getCostElementType());
    }

    public boolean isLastPOPrice() {
        String cm = this.getCostingMethod();
        return cm != null && cm.equals("p") && "M".equals(this.getCostElementType());
    }

    public boolean isLifo() {
        String cm = this.getCostingMethod();
        return cm != null && cm.equals("L") && "M".equals(this.getCostElementType());
    }

    public boolean isStandardCosting() {
        String cm = this.getCostingMethod();
        return cm != null && cm.equals("S") && "M".equals(this.getCostElementType());
    }

    public boolean isUserDefined() {
        String cm = this.getCostingMethod();
        return cm != null && cm.equals("U") && "M".equals(this.getCostElementType());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MCostElement[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append(",Type=").append(this.getCostElementType()).append(",Method=").append(this.getCostingMethod()).append("]");
        return sb.toString();
    }
}

