/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;
import org.compiere.framework.PO;
import org.compiere.model.MClient;
import org.compiere.model.MLanguage;
import org.compiere.model.MRegion;
import org.compiere.model.X_C_Country;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Language;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MCountry
extends X_C_Country
implements Comparator<PO>,
Serializable {
    private static String s_AD_Language = null;
    private static CCache<String, MCountry> s_countries = null;
    private static MCountry s_default = null;
    private static CLogger s_log = CLogger.getCLogger(MCountry.class);
    private static String DISPLAYSEQUENCE = "@C@, @P@";
    private String m_trlName = null;

    public static MCountry get(Ctx ctx, int C_Country_ID) {
        String key;
        MCountry c;
        if (s_countries == null || s_countries.size() == 0) {
            MCountry.loadAllCountries(ctx);
        }
        if ((c = s_countries.get(key = String.valueOf(C_Country_ID))) != null) {
            return c;
        }
        c = new MCountry(ctx, C_Country_ID, null);
        if (c.getC_Country_ID() == C_Country_ID) {
            s_countries.put(key, c);
            return c;
        }
        return null;
    }

    public static MCountry getDefault(Ctx ctx) {
        if (s_countries == null || s_countries.size() == 0) {
            MCountry.loadAllCountries(ctx);
        }
        return s_default;
    }

    public static MCountry[] getCountries(Ctx ctx) {
        if (s_countries == null || s_countries.size() == 0) {
            MCountry.loadAllCountries(ctx);
        }
        MCountry[] retValue = new MCountry[s_countries.size()];
        s_countries.values().toArray(retValue);
        Arrays.sort(retValue, new MCountry(ctx, 0, null));
        return retValue;
    }

    private static void loadAllCountries(Ctx ctx) {
        MClient client = MClient.get(ctx);
        MLanguage lang = MLanguage.get(ctx, client.getAD_Language());
        MCountry usa = null;
        s_countries = new CCache("C_Country", 250);
        String sql = "SELECT * FROM C_Country WHERE IsActive='Y' AND IsSummary='N'";
        try {
            Statement stmt = DB.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                MCountry c = new MCountry(ctx, rs, null);
                s_countries.put(String.valueOf(c.getC_Country_ID()), c);
                if (lang != null && lang.getCountryCode().equals(c.getCountryCode())) {
                    s_default = c;
                }
                if (c.getC_Country_ID() != 100) continue;
                usa = c;
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        if (s_default == null) {
            s_default = usa;
        }
        s_log.fine("#" + s_countries.size() + " - Default=" + s_default);
    }

    public static void setDisplayLanguage(String AD_Language) {
        s_AD_Language = AD_Language;
        if (Language.isBaseLanguage(AD_Language)) {
            s_AD_Language = null;
        }
    }

    public MCountry(Ctx ctx, int C_Country_ID, String trxName) {
        super(ctx, C_Country_ID, trxName);
        if (C_Country_ID == 0) {
            this.setDisplaySequence(DISPLAYSEQUENCE);
            this.setHasRegion(false);
            this.setHasPostal_Add(false);
            this.setIsAddressLinesLocalReverse(false);
            this.setIsAddressLinesReverse(false);
        }
    }

    public MCountry(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public String toString() {
        String nn;
        if (s_AD_Language != null && (nn = this.getTrlName()) != null) {
            return nn;
        }
        return this.getName();
    }

    public String getTrlName() {
        if (this.m_trlName != null && s_AD_Language != null) {
            this.m_trlName = this.get_Translation("Name", s_AD_Language);
            if (this.m_trlName == null) {
                s_AD_Language = null;
            }
        }
        return this.m_trlName;
    }

    @Override
    public String getDisplaySequence() {
        String ds = super.getDisplaySequence();
        if (ds == null || ds.length() == 0) {
            ds = DISPLAYSEQUENCE;
        }
        return ds;
    }

    @Override
    public String getDisplaySequenceLocal() {
        String ds = super.getDisplaySequenceLocal();
        if (ds == null || ds.length() == 0) {
            ds = this.getDisplaySequence();
        }
        return ds;
    }

    @Override
    public int compare(PO o1, PO o2) {
        String s2;
        String s1 = o1.toString();
        if (s1 == null) {
            s1 = "";
        }
        if ((s2 = o2.toString()) == null) {
            s2 = "";
        }
        return s1.compareTo(s2);
    }

    public boolean isValidRegion(int C_Region_ID) {
        if (C_Region_ID == 0 || this.getC_Country_ID() == 0 || !this.isHasRegion()) {
            return false;
        }
        MRegion[] regions = MRegion.getRegions(this.getCtx(), this.getC_Country_ID());
        for (int i = 0; i < regions.length; ++i) {
            if (C_Region_ID != regions[i].getC_Region_ID()) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
    }
}

