/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.compiere.model.X_AD_EntityType;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MEntityType
extends X_AD_EntityType {
    private static MEntityType[] s_entityTypes = null;
    private static CLogger s_log = CLogger.getCLogger(MEntityType.class);

    public static MEntityType getEntityType(Ctx ctx, int adEntityTypeId) {
        String sql = "SELECT * FROM AD_EntityType WHERE IsActive='Y' AND AD_EntityType_ID = " + adEntityTypeId;
        CPreparedStatement pstmt = null;
        MEntityType mEntityType = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                mEntityType = new MEntityType(ctx, rs, null);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return mEntityType;
    }

    public static MEntityType[] getEntityTypes(Ctx ctx, boolean refresh) {
        if (s_entityTypes != null && !refresh) {
            return s_entityTypes;
        }
        ArrayList<MEntityType> list = new ArrayList<MEntityType>();
        String sql = "SELECT * FROM AD_EntityType WHERE IsActive='Y' ORDER BY AD_EntityType_ID";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MEntityType(ctx, rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        s_entityTypes = new MEntityType[list.size()];
        list.toArray(s_entityTypes);
        s_log.finer("# " + s_entityTypes.length);
        return s_entityTypes;
    }

    public static String[] getEntityTypeStrings(Ctx ctx) {
        MEntityType[] entityTypes = MEntityType.getEntityTypes(ctx, false);
        ArrayList<String> list = new ArrayList<String>();
        String[] retValue = new String[entityTypes.length];
        for (int i = 0; i < entityTypes.length; ++i) {
            String s = entityTypes[i].getEntityType().trim();
            list.add(s);
            retValue[i] = s;
        }
        s_log.finer(list.toString());
        return retValue;
    }

    public static String[] getClasspaths(Ctx ctx) {
        boolean forWindows = Env.isWindows();
        MEntityType[] entityTypes = MEntityType.getEntityTypes(ctx, false);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < entityTypes.length; ++i) {
            String classpath = entityTypes[i].getClasspath(forWindows);
            if (classpath == null || classpath.length() == 0) continue;
            StringTokenizer st = new StringTokenizer(classpath, ";:, \t\n\r\f");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                if (token.length() <= 0 || list.contains(token)) continue;
                list.add(token);
            }
        }
        String[] retValue = new String[list.size()];
        list.toArray(retValue);
        s_log.finer(list.toString());
        return retValue;
    }

    public static String[] getModelPackages(Ctx ctx) {
        MEntityType[] entityTypes = MEntityType.getEntityTypes(ctx, false);
        ArrayList<String> list = new ArrayList<String>();
        list.add("compiere.model");
        for (int i = 0; i < entityTypes.length; ++i) {
            String modelPackage = entityTypes[i].getModelPackage();
            if (modelPackage == null || modelPackage.length() == 0) continue;
            StringTokenizer st = new StringTokenizer(modelPackage, ";:, \t\n\r\f");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.length() <= 0 || list.contains(token)) continue;
                list.add(token);
            }
        }
        String[] retValue = new String[list.size()];
        list.toArray(retValue);
        s_log.finer(list.toString());
        return retValue;
    }

    public MEntityType(Ctx ctx, int AD_EntityType_ID, String trxName) {
        super(ctx, AD_EntityType_ID, trxName);
    }

    public MEntityType(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    private void setAD_EntityType_ID() {
        int AD_EntityType_ID = this.getAD_EntityType_ID();
        if (AD_EntityType_ID == 0) {
            String sql = "SELECT NVL(MAX(AD_EntityType_ID), 999999) FROM AD_EntityType WHERE AD_EntityType_ID > 1000";
            AD_EntityType_ID = DB.getSQLValue(this.get_TrxName(), sql);
            this.setAD_EntityType_ID(AD_EntityType_ID + 1);
        }
    }

    public boolean isSystemMaintained() {
        String et = this.getEntityType();
        if (et.length() == 1) {
            return true;
        }
        return et.equals("CUST") || et.equals("XX") || et.equals("EXT");
    }

    public boolean isLicensable() {
        if (this.isSystemMaintained() || !this.isActive()) {
            return false;
        }
        if (!Util.isEmpty(this.getSummary())) {
            return true;
        }
        return !Util.isEmpty(this.getLicenseText());
    }

    public String getClasspath(boolean forWindows) {
        String classPath = super.getClasspath();
        if (classPath == null) {
            return "";
        }
        classPath = Util.replace(classPath, " ", "");
        classPath = forWindows ? Util.replace(classPath, ":", ";") : Util.replace(classPath, ";", ":");
        return classPath;
    }

    protected boolean beforeSave(boolean newRecord) {
        if (!newRecord) {
            boolean systemMaintained;
            int id = this.getAD_EntityType_ID();
            boolean bl = systemMaintained = id == 10 || id == 20;
            if (systemMaintained) {
                this.log.saveError("Error", "You cannot modify a System maintained entity");
                return false;
            }
            systemMaintained = this.is_ValueChanged("EntityType");
            if (systemMaintained) {
                this.log.saveError("Error", "You cannot modify EntityType");
                return false;
            }
            boolean bl2 = systemMaintained = this.isSystemMaintained() && (this.is_ValueChanged("Name") || this.is_ValueChanged("Description") || this.is_ValueChanged("Help") || this.is_ValueChanged("IsActive"));
            if (systemMaintained) {
                this.log.saveError("Error", "You cannot modify Name,Description,Help");
                return false;
            }
        } else {
            String et = this.getEntityType().toUpperCase();
            this.setEntityType(et);
            if (this.getEntityType().trim().length() < 4) {
                this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "EntityType") + " - 4 Characters");
                return false;
            }
            char[] cc = et.toCharArray();
            for (int i = 0; i < cc.length; ++i) {
                char c = cc[i];
                if (Character.isDigit(c) || c >= 'A' && c <= 'Z') continue;
                this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "EntityType") + " - Must be ASCII Letter or Digit");
                return false;
            }
            if (et.startsWith("C")) {
                this.log.saveError("Error", "EntityType starting with C are reserved");
                return false;
            }
            this.setAD_EntityType_ID();
        }
        s_entityTypes = null;
        return true;
    }

    protected boolean beforeDelete() {
        if (this.isSystemMaintained()) {
            this.log.saveError("Error", "You cannot delete a System maintained entity");
            return false;
        }
        s_entityTypes = null;
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MEntityType[");
        sb.append(this.getAD_EntityType_ID()).append("-").append(this.getEntityType()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }
}

