/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.framework.Lookup;
import org.compiere.model.MLocation;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.KeyNamePair;
import org.compiere.util.NamePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MLocationLookup
extends Lookup
implements Serializable {
    public MLocationLookup(Ctx ctx, int WindowNo) {
        super(ctx, WindowNo, 19);
    }

    @Override
    public String getDisplay(Object value) {
        if (value == null) {
            return null;
        }
        MLocation loc = this.getLocation(value, null);
        if (loc == null) {
            return "<" + value.toString() + ">";
        }
        return loc.toString();
    }

    @Override
    public NamePair get(Object value) {
        if (value == null) {
            return null;
        }
        MLocation loc = this.getLocation(value, null);
        if (loc == null) {
            return null;
        }
        return new KeyNamePair(loc.getC_Location_ID(), loc.toString());
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getLocation(key, null) == null;
    }

    public MLocation getLocation(Object key, String trxName) {
        if (key == null) {
            return null;
        }
        int C_Location_ID = 0;
        if (key instanceof Integer) {
            C_Location_ID = (Integer)key;
        } else if (key != null) {
            C_Location_ID = Integer.parseInt(key.toString());
        }
        return this.getLocation(C_Location_ID, trxName);
    }

    public MLocation getLocation(int C_Location_ID, String trxName) {
        return MLocation.get(this.getCtx(), C_Location_ID, trxName);
    }

    @Override
    public String getColumnName() {
        return "C_Location_ID";
    }

    @Override
    public ArrayList<NamePair> getData(boolean mandatory, boolean onlyValidated, boolean onlyActive, boolean temporary) {
        ArrayList<NamePair> list = new ArrayList<NamePair>();
        if (!mandatory) {
            list.add((NamePair)new KeyNamePair(-1, ""));
        }
        StringBuffer sql = new StringBuffer("SELECT C_Location_ID from C_Location WHERE AD_Client_ID = ? AND (AD_Org_ID = 0 OR ? = 0)");
        if (onlyActive) {
            sql.append(" AND IsActive='Y'");
        }
        sql.append(" ORDER BY 1");
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setInt(1, this.getCtx().getAD_Client_ID(this.m_WindowNo));
            pstmt.setInt(2, this.getCtx().getAD_Org_ID(this.m_WindowNo));
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(this.get(rs.getInt(1)));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
        }
        return list;
    }
}

