/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import org.compiere.framework.Lookup;
import org.compiere.model.MLocator;
import org.compiere.model.MRole;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.KeyNamePair;
import org.compiere.util.NamePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MLocatorLookup
extends Lookup
implements Serializable {
    protected int C_Locator_ID;
    private Loader m_loader;
    private int m_only_Warehouse_ID = 0;
    private int m_only_Product_ID = 0;
    private Boolean m_only_Outgoing = null;
    volatile Map<Integer, KeyNamePair> m_lookup = new LinkedHashMap<Integer, KeyNamePair>();
    private static final int s_maxRows = 10000;

    public MLocatorLookup(Ctx ctx, int WindowNo) {
        super(ctx, WindowNo, 19);
        this.m_loader = new Loader();
        this.m_loader.start();
    }

    @Override
    public void dispose() {
        this.log.fine("C_Locator_ID=" + this.C_Locator_ID);
        if (this.m_loader != null) {
            while (this.m_loader.isAlive()) {
                this.m_loader.interrupt();
            }
        }
        this.m_loader = null;
        if (this.m_lookup != null) {
            this.m_lookup.clear();
        }
        this.m_lookup = null;
        super.dispose();
    }

    public void setOnly_Warehouse_ID(int only_Warehouse_ID) {
        this.m_only_Warehouse_ID = only_Warehouse_ID;
    }

    public int getOnly_Warehouse_ID() {
        return this.m_only_Warehouse_ID;
    }

    public void setOnly_Product_ID(int only_Product_ID) {
        this.m_only_Product_ID = only_Product_ID;
    }

    public int getOnly_Product_ID() {
        return this.m_only_Product_ID;
    }

    public void setOnly_Outgoing(Boolean isOutgoing) {
        this.m_only_Outgoing = isOutgoing;
    }

    public Boolean isOnly_Outgoing() {
        return this.m_only_Outgoing;
    }

    @Override
    public void loadComplete() {
        if (this.m_loader != null) {
            try {
                this.m_loader.join();
            }
            catch (InterruptedException ie) {
                this.log.log(Level.SEVERE, "Join interrupted", ie);
            }
        }
    }

    @Override
    public NamePair get(Object key) {
        if (key == null) {
            return null;
        }
        NamePair pp = (NamePair)this.m_lookup.get(key);
        if (pp != null) {
            return pp;
        }
        if (this.m_loader.isAlive()) {
            this.log.fine("Waiting for Loader");
            this.loadComplete();
            pp = (NamePair)this.m_lookup.get(key);
        }
        if (pp != null) {
            return pp;
        }
        return this.getDirect(key, true, null);
    }

    @Override
    public String getDisplay(Object value) {
        if (value == null) {
            return "";
        }
        NamePair display = this.get(value);
        if (display == null) {
            return "<" + value.toString() + ">";
        }
        return display.toString();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.m_lookup.containsKey(key);
    }

    public NamePair getDirect(Object keyValue, boolean saveInCache, String trxName) {
        MLocator loc = this.getMLocator(keyValue, trxName);
        if (loc == null) {
            return null;
        }
        int key = loc.getM_Locator_ID();
        KeyNamePair retValue = new KeyNamePair(key, loc.toString());
        if (saveInCache) {
            this.m_lookup.put(new Integer(key), retValue);
        }
        return retValue;
    }

    public MLocator getMLocator(Object keyValue, String trxName) {
        int M_Locator_ID = -1;
        try {
            M_Locator_ID = Integer.parseInt(keyValue.toString());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (M_Locator_ID == -1) {
            this.log.log(Level.SEVERE, "Invalid key=" + keyValue);
            return null;
        }
        return new MLocator(this.getCtx(), M_Locator_ID, trxName);
    }

    @Override
    public String toString() {
        return "MLocatorLookup[Size=" + this.m_lookup.size() + "]";
    }

    public boolean isValid(Object key) {
        if (key == null) {
            return true;
        }
        KeyNamePair pp = this.m_lookup.get(key);
        return pp != null;
    }

    public Collection<KeyNamePair> getData() {
        if (this.m_loader.isAlive()) {
            this.log.fine("Waiting for Loader");
            try {
                this.m_loader.join();
            }
            catch (InterruptedException ie) {
                this.log.severe("Join interrupted - " + ie.getMessage());
            }
        }
        return this.m_lookup.values();
    }

    @Override
    public ArrayList<NamePair> getData(boolean mandatory, boolean onlyValidated, boolean onlyActive, boolean temporary) {
        Collection<KeyNamePair> collection = this.getData();
        ArrayList<NamePair> list = new ArrayList<NamePair>(collection.size());
        Iterator<KeyNamePair> it = collection.iterator();
        while (it.hasNext()) {
            list.add((NamePair)it.next());
        }
        return list;
    }

    @Override
    public int refresh() {
        this.log.fine("start");
        this.m_loader = new Loader();
        this.m_loader.start();
        try {
            this.m_loader.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.log.info("#" + this.m_lookup.size());
        return this.m_lookup.size();
    }

    @Override
    public String getColumnName() {
        return "M_Locator.M_Locator_ID";
    }

    class Loader
    extends Thread
    implements Serializable {
        public Loader() {
            super("MLocatorLookup");
        }

        public void run() {
            int only_Warehouse_ID = MLocatorLookup.this.getOnly_Warehouse_ID();
            int only_Product_ID = MLocatorLookup.this.getOnly_Product_ID();
            Boolean only_IsSOTrx = MLocatorLookup.this.isOnly_Outgoing();
            StringBuffer sql = new StringBuffer("SELECT * FROM M_Locator ").append(" WHERE IsActive='Y'");
            if (only_Warehouse_ID != 0) {
                sql.append(" AND M_Warehouse_ID=?");
            }
            if (only_Product_ID != 0) {
                sql.append(" AND (IsDefault='Y' ");
                sql.append("OR EXISTS (SELECT * FROM M_Storage s ").append("WHERE s.M_Locator_ID=M_Locator.M_Locator_ID AND s.M_Product_ID=?)");
                if (only_IsSOTrx == null || !only_IsSOTrx.booleanValue()) {
                    sql.append("OR EXISTS (SELECT * FROM M_Product p ").append("WHERE p.M_Locator_ID=M_Locator.M_Locator_ID AND p.M_Product_ID=?)");
                    sql.append("OR EXISTS (SELECT * FROM M_ProductLocator pl ").append("WHERE pl.M_Locator_ID=M_Locator.M_Locator_ID AND pl.M_Product_ID=?)");
                    sql.append("OR 0 = (SELECT COUNT(*) ");
                    sql.append("FROM M_ProductLocator pl");
                    sql.append(" INNER JOIN M_Locator l2 ON (pl.M_Locator_ID=l2.M_Locator_ID) ");
                    sql.append("WHERE pl.M_Product_ID=? AND l2.M_Warehouse_ID=M_Locator.M_Warehouse_ID )");
                }
                sql.append(" ) ");
            }
            String finalSql = MRole.getDefault(MLocatorLookup.this.getCtx(), false).addAccessSQL(sql.toString(), "M_Locator", false, false);
            if (this.isInterrupted()) {
                MLocatorLookup.this.log.log(Level.SEVERE, "Interrupted");
                return;
            }
            MLocatorLookup.this.m_lookup.clear();
            int rows = 0;
            try {
                CPreparedStatement pstmt = DB.prepareStatement(finalSql, null);
                int index = 1;
                if (only_Warehouse_ID != 0) {
                    pstmt.setInt(index++, only_Warehouse_ID);
                }
                if (only_Product_ID != 0) {
                    pstmt.setInt(index++, only_Product_ID);
                    if (only_IsSOTrx == null || !only_IsSOTrx.booleanValue()) {
                        pstmt.setInt(index++, only_Product_ID);
                        pstmt.setInt(index++, only_Product_ID);
                        pstmt.setInt(index++, only_Product_ID);
                    }
                }
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    if (rows++ > 10000) {
                        MLocatorLookup.this.log.warning("Over Max Rows - " + rows);
                        break;
                    }
                    MLocator loc = new MLocator(MLocatorLookup.this.getCtx(), rs, null);
                    int M_Locator_ID = loc.getM_Locator_ID();
                    KeyNamePair pp = new KeyNamePair(M_Locator_ID, loc.toString());
                    MLocatorLookup.this.m_lookup.put(new Integer(M_Locator_ID), pp);
                }
                rs.close();
                pstmt.close();
            }
            catch (SQLException e) {
                MLocatorLookup.this.log.log(Level.SEVERE, finalSql, e);
            }
            MLocatorLookup.this.log.fine("Complete #" + MLocatorLookup.this.m_lookup.size());
            if (MLocatorLookup.this.m_lookup.size() == 0) {
                MLocatorLookup.this.log.finer(finalSql);
            }
        }
    }
}

