/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.util.ArrayList;
import java.util.Map;
import org.compiere.model.MLookupInfo;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.NamePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MLookupCache {
    private static CLogger s_log = CLogger.getCLogger(MLookupCache.class);
    private static CCache<String, Map<Object, NamePair>> s_loadedLookups = new CCache("MLookupCache", 50);

    protected static void loadStart(MLookupInfo info) {
    }

    protected static void loadEnd(MLookupInfo info, Map<Object, NamePair> lookup) {
        if (info.IsValidated && lookup.size() > 0) {
            s_loadedLookups.put(MLookupCache.getKey(info), lookup);
        }
    }

    private static String getKey(MLookupInfo info) {
        if (info == null) {
            return String.valueOf(System.currentTimeMillis());
        }
        StringBuffer sb = new StringBuffer();
        sb.append(info.Column_ID).append(":").append(info.KeyColumn).append(info.AD_Reference_Value_ID).append(info.Query).append(info.ValidationCode);
        return sb.toString();
    }

    protected static boolean loadFromCache(MLookupInfo info, Map<Object, NamePair> lookupTarget) {
        String key = MLookupCache.getKey(info);
        Map<Object, NamePair> cache = s_loadedLookups.get(key);
        if (cache == null) {
            return false;
        }
        if (cache.size() == 0) {
            s_loadedLookups.remove(key);
            return false;
        }
        for (Object cacheKey : cache.keySet()) {
            NamePair cacheData = cache.get(cacheKey);
            lookupTarget.put(cacheKey, cacheData);
        }
        s_log.fine("#" + lookupTarget.size());
        return true;
    }

    public static void cacheReset(int WindowNo) {
        String key = String.valueOf(WindowNo) + ":";
        int startNo = s_loadedLookups.size();
        ArrayList<String> toDelete = new ArrayList<String>();
        for (String info : s_loadedLookups.keySet()) {
            if (info == null || !info.startsWith(key)) continue;
            toDelete.add(info);
        }
        for (int i = 0; i < toDelete.size(); ++i) {
            s_loadedLookups.remove(toDelete.get(i));
        }
        int endNo = s_loadedLookups.size();
        s_log.fine("WindowNo=" + WindowNo + " - " + startNo + " -> " + endNo);
    }

    private MLookupCache() {
    }
}

