/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MOrg;
import org.compiere.model.MWarehouse;
import org.compiere.model.X_AD_OrgInfo;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class MOrgInfo
extends X_AD_OrgInfo {
    private static CLogger s_log = CLogger.getCLogger(MOrgInfo.class);

    public static MOrgInfo get(Ctx ctx, int AD_Org_ID, String trx) {
        MOrgInfo retValue = null;
        String sql = "SELECT * FROM AD_OrgInfo WHERE AD_Org_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trx);
            pstmt.setInt(1, AD_Org_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MOrgInfo(ctx, rs, null);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public MOrgInfo(Ctx ctx, int AD_Org_ID, String trxName) {
        super(ctx, AD_Org_ID, trxName);
    }

    public MOrgInfo(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MOrgInfo(MOrg org) {
        super(org.getCtx(), 0, org.get_TrxName());
        this.setClientOrg(org);
        this.setDUNS("?");
        this.setTaxID("?");
    }

    public int getM_Warehouse_ID() {
        int M_Warehouse_ID = super.getM_Warehouse_ID();
        if (M_Warehouse_ID != 0) {
            return M_Warehouse_ID;
        }
        MWarehouse[] whss = MWarehouse.getForOrg(this.getCtx(), this.getAD_Org_ID());
        if (whss.length > 0) {
            M_Warehouse_ID = whss[0].getM_Warehouse_ID();
            this.setM_Warehouse_ID(M_Warehouse_ID);
            return M_Warehouse_ID;
        }
        this.log.warning("No Warehouse for AD_Org_ID=" + this.getAD_Org_ID());
        return 0;
    }
}

