/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import org.compiere.model.MField;
import org.compiere.model.MWindow;
import org.compiere.model.X_AD_Tab;
import org.compiere.util.CCache;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class MTab
extends X_AD_Tab {
    private static CCache<Integer, MTab> s_cache = new CCache("AD_Tab", 20);
    private MField[] m_fields = null;
    private HashMap<String, Integer> m_columnNameField = null;

    public static MTab get(Ctx ctx, int AD_Tab_ID) {
        Integer key = new Integer(AD_Tab_ID);
        MTab retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MTab(ctx, AD_Tab_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public MTab(Ctx ctx, int AD_Tab_ID, String trxName) {
        super(ctx, AD_Tab_ID, trxName);
        if (AD_Tab_ID == 0) {
            this.setEntityType("U");
            this.setHasTree(false);
            this.setIsReadOnly(false);
            this.setIsSingleRow(false);
            this.setIsSortTab(false);
            this.setIsTranslationTab(false);
            this.setSeqNo(0);
            this.setTabLevel(0);
            this.setIsInsertRecord(true);
            this.setIsAdvancedTab(false);
        }
    }

    public MTab(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MTab(MWindow parent) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setAD_Window_ID(parent.getAD_Window_ID());
        this.setEntityType(parent.getEntityType());
    }

    public MTab(MWindow parent, MTab from) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        MTab.copyValues(from, this);
        this.setClientOrg(parent);
        this.setAD_Window_ID(parent.getAD_Window_ID());
        this.setEntityType(parent.getEntityType());
    }

    public MField[] getFields(boolean reload, String trxName) {
        if (this.m_fields != null && !reload) {
            return this.m_fields;
        }
        String sql = "SELECT * FROM AD_Field WHERE AD_Tab_ID=? ORDER BY SeqNo";
        ArrayList<MField> list = new ArrayList<MField>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, this.getAD_Tab_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MField(this.getCtx(), rs, trxName));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_fields = new MField[list.size()];
        list.toArray(this.m_fields);
        return this.m_fields;
    }

    public MField getField(int AD_Field_ID) {
        if (AD_Field_ID == 0) {
            return null;
        }
        MField[] fields = this.getFields(false, this.get_TrxName());
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].getAD_Field_ID() != AD_Field_ID) continue;
            return fields[i];
        }
        return null;
    }

    public MField getField(String columnName) {
        int AD_Field_ID = this.getAD_Field_ID(columnName);
        return this.getField(AD_Field_ID);
    }

    public int getAD_Field_ID(String columnName) {
        Integer AD_Field_ID;
        if (this.m_columnNameField == null) {
            this.fillColumnNameField();
        }
        if ((AD_Field_ID = this.m_columnNameField.get(columnName)) == null) {
            return 0;
        }
        return AD_Field_ID;
    }

    private void fillColumnNameField() {
        this.m_columnNameField = new HashMap();
        String sql = "SELECT ColumnName, f.AD_Field_ID FROM AD_Field f INNER JOIN AD_Column c ON (f.AD_Column_ID=c.AD_Column_ID) WHERE f.AD_Tab_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.getAD_Tab_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                String columnName = rs.getString(1);
                int AD_Field_ID = rs.getInt(2);
                this.m_columnNameField.put(columnName, AD_Field_ID);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.isReadOnly() && this.isInsertRecord()) {
            this.setIsInsertRecord(false);
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MTab[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }
}

