/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.lang.reflect.Constructor;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import org.compiere.Compiere;
import org.compiere.framework.PO;
import org.compiere.model.MColumn;
import org.compiere.model.MEntityType;
import org.compiere.model.MSequence;
import org.compiere.model.MViewColumn;
import org.compiere.model.MViewComponent;
import org.compiere.model.X_AD_Table;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MTable
extends X_AD_Table {
    private static CCache<Integer, MTable> s_cache = new CCache("AD_Table", 20);
    private static CLogger s_log = CLogger.getCLogger(MTable.class);
    private static String[] s_packages = null;
    private static final String[] s_packagesDefault = new String[]{"compiere.model", "org.compiere.model", "org.compiere.wf", "org.compiere.print", "org.compiere.impexp"};
    private static final String[] s_special = new String[]{"AD_Element", "org.compiere.model.M_Element", "AD_Registration", "org.compiere.model.M_Registration", "AD_Tree", "org.compiere.model.MTree_Base", "R_Category", "org.compiere.model.MRequestCategory", "GL_Category", "org.compiere.model.MGLCategory", "K_Category", "org.compiere.model.MKCategory", "C_ValidCombination", "org.compiere.model.MAccount", "C_Phase", "org.compiere.model.MProjectTypePhase", "C_Task", "org.compiere.model.MProjectTypeTask", "K_Source", "org.compiere.model.X_K_Source"};
    private MColumn[] m_columns = null;
    private MViewComponent[] m_vcs = null;
    private ArrayList<MTable> m_dependents = null;

    public static MTable[] getTables(Ctx ctx, String entityType) {
        return MTable.getTables(ctx, null, entityType);
    }

    public static MTable[] getTables(Ctx ctx, String where, String entityType) {
        CPreparedStatement pstmt = null;
        String sql = "SELECT * FROM AD_Table WHERE IsActive='Y' AND IsView='N'";
        ArrayList<MTable> list = new ArrayList<MTable>();
        if (where != null && where.length() > 0) {
            sql = sql + "AND " + where;
        }
        if (entityType != null) {
            sql = sql + " AND EntityType in (" + entityType + ")";
        }
        sql = sql + " ORDER BY LoadSeq";
        try {
            pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MTable table = new MTable(ctx, rs, null);
                list.add(table);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MTable[] retValue = new MTable[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MTable get(Ctx ctx, int AD_Table_ID) {
        Integer key = new Integer(AD_Table_ID);
        MTable retValue = s_cache.get(key);
        if (retValue == null) {
            return new MTable(ctx, AD_Table_ID, null);
        }
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public static MTable get(Ctx ctx, String tableName) {
        MTable retValue2;
        if (tableName == null) {
            return null;
        }
        for (MTable retValue2 : s_cache.values()) {
            if (!tableName.equalsIgnoreCase(retValue2.getTableName())) continue;
            return retValue2;
        }
        retValue2 = null;
        String sql = "SELECT * FROM AD_Table WHERE UPPER(TableName)=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setString(1, tableName.toUpperCase());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue2 = new MTable(ctx, rs, null);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (retValue2 != null) {
            Integer key = new Integer(retValue2.getAD_Table_ID());
            s_cache.put(key, retValue2);
        }
        return retValue2;
    }

    public static String getTableName(Ctx ctx, int AD_Table_ID) {
        return MTable.get(ctx, AD_Table_ID).getTableName();
    }

    private static String[] getPackages(Ctx ctx) {
        int i;
        if (s_packages != null) {
            return s_packages;
        }
        ArrayList<String> list = new ArrayList<String>();
        String[] classpaths = MEntityType.getClasspaths(ctx);
        for (i = 0; i < classpaths.length; ++i) {
            list.add(classpaths[i]);
        }
        for (i = 0; i < s_packagesDefault.length; ++i) {
            String packageName = s_packagesDefault[i];
            if (list.contains(packageName)) continue;
            list.add(packageName);
        }
        s_packages = new String[list.size()];
        s_packages = list.toArray(s_packages);
        s_log.info("#" + s_packages.length);
        return s_packages;
    }

    public static Class<?> getClass(String tableName) {
        String className;
        int index;
        if (tableName == null || tableName.endsWith("_Trl")) {
            return null;
        }
        if (tableName.startsWith("I_")) {
            Class<?> clazz = MTable.getPOclass("org.compiere.model.X_" + tableName);
            if (clazz != null) {
                return clazz;
            }
            s_log.warning("No class for table: " + tableName);
            return null;
        }
        for (int i = 0; i < s_special.length; ++i) {
            if (!s_special[i++].equals(tableName)) continue;
            Class<?> clazz = MTable.getPOclass(s_special[i]);
            if (clazz == null) break;
            return clazz;
        }
        if ((index = (className = tableName).indexOf(95)) > 0) {
            if (index < 3) {
                className = className.substring(index + 1);
            } else {
                String prefix = className.substring(0, index);
                if (prefix.equals("Fact")) {
                    className = className.substring(index + 1);
                }
            }
        }
        className = Util.replace(className, "_", "");
        String[] packages = MTable.getPackages(Env.getCtx());
        for (int i = 0; i < packages.length; ++i) {
            StringBuffer name = new StringBuffer(packages[i]).append(".M").append(className);
            Class<?> clazz = MTable.getPOclass(name.toString());
            if (clazz == null) continue;
            return clazz;
        }
        Class<?> clazz = MTable.getPOclass("compiere.model.X_" + tableName);
        if (clazz != null) {
            return clazz;
        }
        clazz = MTable.getPOclass("org.compiere.model.X_" + tableName);
        if (clazz != null) {
            return clazz;
        }
        return null;
    }

    private static Class<?> getPOclass(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            for (Class<?> superClazz = clazz.getSuperclass(); superClazz != null; superClazz = superClazz.getSuperclass()) {
                if (superClazz != PO.class) continue;
                s_log.fine("Use: " + className);
                return clazz;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        s_log.finest("Not found: " + className);
        return null;
    }

    public MTable(Ctx ctx, int AD_Table_ID, String trxName) {
        super(ctx, AD_Table_ID, trxName);
        if (AD_Table_ID == 0) {
            this.setAccessLevel("4");
            this.setEntityType("U");
            this.setIsChangeLog(false);
            this.setIsDeleteable(false);
            this.setIsHighVolume(false);
            this.setIsSecurityEnabled(false);
            this.setIsView(false);
            this.setReplicationType("L");
        }
    }

    public MTable(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MColumn[] getColumns(boolean requery) {
        if (this.m_columns != null && !requery) {
            return this.m_columns;
        }
        String sql = "SELECT * FROM AD_Column WHERE AD_Table_ID=? ORDER BY ColumnName";
        ArrayList<MColumn> list = new ArrayList<MColumn>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getAD_Table_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MColumn(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_columns = new MColumn[list.size()];
        list.toArray(this.m_columns);
        return this.m_columns;
    }

    public MColumn getColumn(String columnName) {
        if (columnName == null || columnName.length() == 0) {
            return null;
        }
        this.getColumns(false);
        for (int i = 0; i < this.m_columns.length; ++i) {
            if (!columnName.equalsIgnoreCase(this.m_columns[i].getColumnName())) continue;
            return this.m_columns[i];
        }
        return null;
    }

    public boolean isSingleKey() {
        String[] keys = this.getKeyColumns();
        return keys.length == 1;
    }

    public String[] getKeyColumns() {
        this.getColumns(false);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.m_columns.length; ++i) {
            MColumn column = this.m_columns[i];
            if (column.isKey()) {
                return new String[]{column.getColumnName()};
            }
            if (!column.isParent()) continue;
            list.add(column.getColumnName());
        }
        String[] retValue = new String[list.size()];
        retValue = list.toArray(retValue);
        return retValue;
    }

    public String[] getIdentifierColumns() {
        this.getColumns(false);
        ArrayList<KeyNamePair> list = new ArrayList<KeyNamePair>();
        for (int i = 0; i < this.m_columns.length; ++i) {
            MColumn column = this.m_columns[i];
            if (!column.isIdentifier()) continue;
            int seq = column.getSeqNo();
            String columnName = column.getColumnName();
            KeyNamePair pp = new KeyNamePair(seq, columnName);
            pp.setSortByName(false);
            list.add(pp);
        }
        Collections.sort(list);
        String[] retValue = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            retValue[i] = ((KeyNamePair)list.get(i)).getName();
        }
        return retValue;
    }

    public String getSelectColumns() {
        this.getColumns(false);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.m_columns.length; ++i) {
            MColumn col = this.m_columns[i];
            if (i > 0) {
                sb.append(",");
            }
            if (col.isVirtualColumn()) {
                sb.append(col.getColumnSQL()).append(" AS ");
            }
            sb.append(col.getColumnName());
        }
        return sb.toString();
    }

    public ArrayList<MColumn> getFKs(boolean includeList) {
        this.getColumns(false);
        ArrayList<MColumn> retValue = new ArrayList<MColumn>();
        for (int i = 0; i < this.m_columns.length; ++i) {
            MColumn col = this.m_columns[i];
            if (col.isFK()) {
                retValue.add(col);
                continue;
            }
            if (!includeList || !col.isList()) continue;
            retValue.add(col);
        }
        return retValue;
    }

    public ArrayList<MTable> getDependents() {
        if (this.m_dependents != null) {
            return this.m_dependents;
        }
        String[] keyColumns = this.getKeyColumns();
        if (keyColumns.length == 0) {
            this.log.warning("No Key Columns for " + this.toString());
            return null;
        }
        if (keyColumns.length > 1) {
            this.log.warning("Multiple Key Columns for " + this.toString());
        }
        String keyColumn = keyColumns[0];
        String sql = "SELECT * FROM AD_Table t WHERE IsView='N' AND EXISTS (SELECT * FROM AD_Column c WHERE t.AD_Table_ID=c.AD_Table_ID AND c.ColumnName=?) ORDER BY LoadSeq";
        this.m_dependents = new ArrayList();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setString(1, keyColumn);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MTable table = new MTable(this.getCtx(), rs, null);
                if (table.getTableName().equals(this.getTableName())) continue;
                this.m_dependents.add(table);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return this.m_dependents;
    }

    public PO getPO(Ctx ctx, int Record_ID, String trxName) {
        return this.getPO(ctx, Record_ID, trxName, true);
    }

    public PO getPO(Ctx ctx, int Record_ID, String trxName, boolean newRecord) {
        String tableName = this.getTableName();
        if (Record_ID != 0 && !this.isSingleKey()) {
            this.log.log(Level.WARNING, "(id) - Multi-Key " + tableName);
            return null;
        }
        Class<?> clazz = MTable.getClass(tableName);
        if (clazz == null) {
            this.log.log(Level.WARNING, "(id) - Class not found for " + tableName);
            return null;
        }
        boolean errorLogged = false;
        try {
            Constructor<?> constructor = null;
            try {
                constructor = clazz.getDeclaredConstructor(Ctx.class, Integer.TYPE, String.class);
            }
            catch (Exception e) {
                String msg = e.getMessage();
                if (msg == null) {
                    msg = e.toString();
                }
                this.log.warning("No transaction Constructor for " + clazz + " (" + msg + ")");
            }
            if (constructor != null) {
                PO po = (PO)constructor.newInstance(ctx, new Integer(Record_ID), trxName);
                if (!newRecord && Record_ID == 0) {
                    po.load(trxName);
                }
                if (po != null && po.get_ID() != Record_ID && this.isSingleKey()) {
                    this.log.warning(po.get_TableName() + "_ID=" + po.get_ID() + " <> requested=" + Record_ID);
                    return null;
                }
                return po;
            }
            throw new Exception("No Std Constructor");
        }
        catch (Exception e) {
            if (e.getCause() != null) {
                Throwable t = e.getCause();
                this.log.log(Level.SEVERE, "(id) - Table=" + tableName + ",Class=" + clazz, t);
                errorLogged = true;
                if (t instanceof Exception) {
                    this.log.saveError("Error", (Exception)e.getCause());
                } else {
                    this.log.saveError("Error", "Table=" + tableName + ",Class=" + clazz);
                }
            } else {
                this.log.log(Level.SEVERE, "(id) - Table=" + tableName + ",Class=" + clazz, e);
                errorLogged = true;
                this.log.saveError("Error", "Table=" + tableName + ",Class=" + clazz);
            }
            if (!errorLogged) {
                this.log.log(Level.SEVERE, "(id) - Not found - Table=" + tableName + ", Record_ID=" + Record_ID);
            }
            return null;
        }
    }

    public PO getPO(Ctx ctx, ResultSet rs, String trxName) {
        String tableName = this.getTableName();
        Class<?> clazz = MTable.getClass(tableName);
        if (clazz == null) {
            this.log.log(Level.SEVERE, "(rs) - Class not found for " + tableName);
            return null;
        }
        boolean errorLogged = false;
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(Ctx.class, ResultSet.class, String.class);
            PO po = (PO)constructor.newInstance(ctx, rs, trxName);
            return po;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "(rs) - Table=" + tableName + ",Class=" + clazz, e);
            errorLogged = true;
            this.log.saveError("Error", "Table=" + tableName + ",Class=" + clazz);
            if (!errorLogged) {
                this.log.log(Level.SEVERE, "(rs) - Not found - Table=" + tableName);
            }
            return null;
        }
    }

    public PO getPO(Ctx ctx, Map<String, String> context) {
        String tableName = this.getTableName();
        Class<?> clazz = MTable.getClass(tableName);
        if (clazz == null) {
            this.log.log(Level.WARNING, "(id) - Class not found for " + tableName);
            return null;
        }
        boolean errorLogged = false;
        try {
            Constructor<?> constructor = null;
            try {
                constructor = clazz.getDeclaredConstructor(Ctx.class, Integer.TYPE, String.class);
            }
            catch (Exception e) {
                String msg = e.getMessage();
                if (msg == null) {
                    msg = e.toString();
                }
                this.log.warning("No transaction Constructor for " + clazz + " (" + msg + ")");
            }
            if (constructor != null) {
                PO po = (PO)constructor.newInstance(ctx, new Integer(0), null);
                if (!po.load(context)) {
                    throw new Exception("Could not load PO");
                }
                return po;
            }
            throw new Exception("No Std Constructor");
        }
        catch (Exception e) {
            if (e.getCause() != null) {
                Throwable t = e.getCause();
                this.log.log(Level.SEVERE, "(id) - Table=" + tableName + ",Class=" + clazz, t);
                errorLogged = true;
                if (t instanceof Exception) {
                    this.log.saveError("Error", (Exception)e.getCause());
                } else {
                    this.log.saveError("Error", "Table=" + tableName + ",Class=" + clazz);
                }
            } else {
                this.log.log(Level.SEVERE, "(id) - Table=" + tableName + ",Class=" + clazz, e);
                errorLogged = true;
                this.log.saveError("Error", "Table=" + tableName + ",Class=" + clazz);
            }
            if (!errorLogged) {
                this.log.log(Level.SEVERE, "(id) - Not found - Table=" + tableName);
            }
            return null;
        }
    }

    public PO getPO(Ctx ctx, String whereClause, String trxName) {
        if (whereClause == null || whereClause.length() == 0) {
            return null;
        }
        PO po = null;
        StringBuffer sql = new StringBuffer("SELECT ").append(this.getSelectColumns()).append(" FROM ").append(this.getTableName()).append(" WHERE ").append(whereClause);
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql.toString(), trxName);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                po = this.getPO(ctx, rs, trxName);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
            this.log.saveError("Error", e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (po == null) {
            return this.getPO(ctx, 0, trxName);
        }
        return po;
    }

    public PO[] getPOs(Ctx ctx, String whereClause, String orderClause, String trxName) {
        ArrayList<PO> list = new ArrayList<PO>();
        String sql = "SELECT * FROM " + this.getTableName();
        if (whereClause != null && whereClause.length() > 0) {
            sql = sql + " WHERE " + whereClause;
        }
        if (orderClause != null && orderClause.length() > 0) {
            sql = sql + " ORDER BY " + orderClause;
        }
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                PO po = this.getPO(ctx, rs, trxName);
                list.add(po);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        PO[] retValue = new PO[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.isView() && this.isDeleteable()) {
            this.setIsDeleteable(false);
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord) {
            MSequence.createTableSequence(this.getCtx(), this.getTableName(), this.get_TrxName());
        } else {
            MSequence seq = MSequence.get(this.getCtx(), this.getTableName(), this.get_TrxName());
            if (seq == null || seq.get_ID() == 0) {
                MSequence.createTableSequence(this.getCtx(), this.getTableName(), this.get_TrxName());
            } else if (!seq.getName().equals(this.getTableName())) {
                seq.setName(this.getTableName());
                seq.save();
            }
        }
        return success;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (success) {
            MSequence.deleteTableSequence(this.getCtx(), this.getTableName(), this.get_TrxName());
        }
        return success;
    }

    public String getSQLCreate() {
        return this.getSQLCreate(true);
    }

    public String getSQLCreate(boolean requery) {
        StringBuffer sb = new StringBuffer("CREATE TABLE ").append(this.getTableName()).append(" (");
        boolean hasPK = false;
        boolean hasParents = false;
        StringBuffer constraints = new StringBuffer();
        this.getColumns(requery);
        for (int i = 0; i < this.m_columns.length; ++i) {
            MColumn column = this.m_columns[i];
            if (column.isVirtualColumn()) continue;
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(column.getSQLDDL());
            if (column.isKey()) {
                constraints.append(", CONSTRAINT PK").append(this.getAD_Table_ID()).append(" PRIMARY KEY (").append(column.getColumnName()).append(")");
                hasPK = true;
            }
            if (!column.isParent()) continue;
            hasParents = true;
        }
        if (!hasPK && hasParents) {
            StringBuffer cols = new StringBuffer();
            for (int i = 0; i < this.m_columns.length; ++i) {
                MColumn column = this.m_columns[i];
                if (!column.isParent()) continue;
                if (cols.length() > 0) {
                    cols.append(", ");
                }
                cols.append(column.getColumnName());
            }
            sb.append(", CONSTRAINT PK").append(this.getAD_Table_ID()).append(" PRIMARY KEY (").append(cols).append(")");
        }
        sb.append(constraints).append(")");
        return sb.toString();
    }

    public String getViewDrop() {
        if (!this.isView() || !this.isActive()) {
            return null;
        }
        return new String("DROP VIEW " + this.getTableName());
    }

    public String getViewCreate(boolean requery) {
        if (!this.isView() || !this.isActive()) {
            return null;
        }
        StringBuffer sb = new StringBuffer("CREATE OR REPLACE VIEW ").append(this.getTableName());
        this.getViewComponent(requery);
        if (this.m_vcs == null || this.m_vcs.length == 0) {
            return null;
        }
        MViewColumn[] vCols = null;
        for (int i = 0; i < this.m_vcs.length; ++i) {
            MViewComponent vc = this.m_vcs[i];
            if (i > 0) {
                sb.append(" UNION ");
            } else {
                vCols = vc.getColumns(requery);
                if (vCols == null || vCols.length == 0) {
                    return null;
                }
                boolean right = false;
                for (int j = 0; j < vCols.length && !vCols[j].getColumnName().equals("*"); ++j) {
                    if (j == 0) {
                        sb.append("(");
                        right = true;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(vCols[j].getColumnName());
                }
                if (right) {
                    sb.append(")");
                }
                sb.append(" AS ");
            }
            sb.append(vc.getSelect(false, vCols));
        }
        return sb.toString();
    }

    public MViewComponent[] getViewComponent(boolean reload) {
        if (!this.isView() || !this.isActive()) {
            return null;
        }
        if (this.m_vcs != null && !reload) {
            return this.m_vcs;
        }
        ArrayList<MViewComponent> list = new ArrayList<MViewComponent>();
        String sql = "SELECT * FROM AD_ViewComponent WHERE AD_Table_ID = " + this.getAD_Table_ID() + " AND IsActive = 'Y'";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MViewComponent(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_vcs = new MViewComponent[list.size()];
        list.toArray(this.m_vcs);
        return this.m_vcs;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MTable[");
        sb.append(this.get_ID()).append("-").append(this.getTableName()).append("]");
        return sb.toString();
    }

    public static void main(String[] args) {
        Compiere.startup(true);
        MTable.getTables(Env.getCtx(), null);
    }
}

