/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MTree;
import org.compiere.model.X_AD_TreeNode;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class MTreeNode
extends X_AD_TreeNode {
    private static CLogger s_log = CLogger.getCLogger(MTreeNode.class);

    public static MTreeNode get(MTree tree, int Node_ID) {
        MTreeNode retValue = null;
        String sql = "SELECT * FROM AD_TreeNode WHERE AD_Tree_ID=? AND Node_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, tree.get_TrxName());
            pstmt.setInt(1, tree.getAD_Tree_ID());
            pstmt.setInt(2, Node_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MTreeNode(tree.getCtx(), rs, tree.get_TrxName());
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public MTreeNode(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MTreeNode(MTree tree, int Node_ID) {
        super(tree.getCtx(), 0, tree.get_TrxName());
        this.setClientOrg(tree);
        this.setAD_Tree_ID(tree.getAD_Tree_ID());
        this.setNode_ID(Node_ID);
        this.setParent_ID(0);
        this.setSeqNo(9999);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("CTreeNode[");
        sb.append("AD_Tree_ID=").append(this.getAD_Tree_ID()).append(",Node_ID=").append(this.getNode_ID()).append(",Parent_ID=").append(this.getParent_ID()).append("]");
        return sb.toString();
    }
}

