/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MUser;
import org.compiere.model.X_AD_UserPreference;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class MUserPreference
extends X_AD_UserPreference {
    protected static CLogger s_log = CLogger.getCLogger(MUserPreference.class);

    public static MUserPreference getOfUser(MUser user, boolean createNew) {
        MUserPreference retValue = null;
        String sql = "SELECT * FROM AD_UserPreference WHERE AD_User_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, user.getAD_User_ID());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MUserPreference(user.getCtx(), rs, null);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (retValue == null && createNew) {
            retValue = new MUserPreference(user.getCtx(), 0, null);
            retValue.setClientOrg(user);
            retValue.setAD_User_ID(user.getAD_User_ID());
            retValue.save();
        }
        return retValue;
    }

    public MUserPreference(Ctx ctx, int AD_UserPreference_ID, String trxName) {
        super(ctx, AD_UserPreference_ID, trxName);
        if (AD_UserPreference_ID == 0) {
            this.setIsAutoCommit(true);
            this.setIsShowAcct(false);
            this.setIsShowAdvanced(false);
            this.setIsShowTrl(false);
        }
    }

    public MUserPreference(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void setAD_User_ID(int AD_User_ID) {
        if (AD_User_ID == 0) {
            this.set_ValueNoCheck("AD_User_ID", new Integer(0));
        } else {
            super.setAD_User_ID(AD_User_ID);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MUserPreference[").append(this.get_ID()).append(",AD_User_ID=").append(this.getAD_User_ID()).append(",AutoCommit=").append(this.isAutoCommit()).append(",ShowAcct=").append(this.isShowAcct()).append(",ShowAdv=").append(this.isShowAdvanced()).append(",ShowTrl=").append(this.isShowTrl());
        if (this.getPrinterName() != null) {
            sb.append(",PrinterName=").append(this.getPrinterName());
        }
        if (this.getUITheme() != null) {
            sb.append(",UITheme=").append(this.getUITheme());
        }
        sb.append("]");
        return sb.toString();
    }
}

