/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MMigrationStep;
import org.compiere.model.X_AD_Version;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class MVersion
extends X_AD_Version {
    private static CLogger s_log = CLogger.getCLogger(MVersion.class);
    private MMigrationStep[] m_steps = null;

    public static String executeMigration(Ctx ctx, String EntityType, String fromVersion, String toVersion, String timingType, String DBType) {
        if (fromVersion == null) {
            fromVersion = "";
        }
        if (toVersion == null) {
            return "NO VERSION TO";
        }
        if (timingType == null) {
            return "NO TIMING TYPE";
        }
        String sql = "SELECT * FROM AD_Version WHERE EntityType=? AND Value BETWEEN ? AND ? ORDER BY Value";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setString(1, EntityType);
            pstmt.setString(2, fromVersion);
            pstmt.setString(3, toVersion);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MVersion version = new MVersion(ctx, rs, null);
                version.execute(timingType, DBType);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return "";
    }

    public MVersion(Ctx ctx, int AD_Version_ID, String trxName) {
        super(ctx, AD_Version_ID, trxName);
    }

    public MVersion(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MMigrationStep[] getSteps(boolean reload) {
        if (this.m_steps != null && !reload) {
            return this.m_steps;
        }
        ArrayList<MMigrationStep> list = new ArrayList<MMigrationStep>();
        String sql = "SELECT * FROM AD_MigrationStep WHERE AD_Version_ID=? ORDER BY TimingType, SeqNo";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getAD_Version_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MMigrationStep(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_steps = new MMigrationStep[list.size()];
        list.toArray(this.m_steps);
        return this.m_steps;
    }

    public String execute(String timingType, String DBType) {
        int success = 0;
        int errors = 0;
        int failures = 0;
        MMigrationStep[] steps = this.getSteps(false);
        for (int i = 0; i < steps.length; ++i) {
            MMigrationStep step = steps[i];
            if (!step.getTimingType().equals(timingType)) continue;
            String dbType = step.getDBType();
            try {
                String error = step.execute();
                if (error == null) {
                    ++success;
                    continue;
                }
                ++errors;
                continue;
            }
            catch (Exception e) {
                this.log.warning(e.toString());
                ++failures;
            }
        }
        return "Success=" + success + ", Errors=" + errors + ", Failures=" + failures;
    }
}

