/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MTable;
import org.compiere.model.MViewColumn;
import org.compiere.model.X_AD_ViewColumn;
import org.compiere.model.X_AD_ViewComponent;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class MViewComponent
extends X_AD_ViewComponent {
    private MViewColumn[] m_columns = null;

    public MViewComponent(Ctx ctx, int AD_ViewComponent_ID, String trxName) {
        super(ctx, AD_ViewComponent_ID, trxName);
    }

    public MViewComponent(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MViewComponent(MTable parent) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setAD_Table_ID(parent.getAD_Table_ID());
    }

    public MViewColumn[] getColumns(boolean reload) {
        if (this.m_columns != null && !reload) {
            return this.m_columns;
        }
        String sql = "SELECT * FROM AD_ViewColumn WHERE AD_ViewComponent_ID=? ORDER BY AD_ViewColumn_ID";
        ArrayList<MViewColumn> list = new ArrayList<MViewColumn>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getAD_ViewComponent_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MViewColumn(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_columns = new MViewColumn[list.size()];
        list.toArray(this.m_columns);
        return this.m_columns;
    }

    public String getSelect(boolean requery, MViewColumn[] vCols) {
        this.getColumns(requery);
        if (this.m_columns == null || this.m_columns.length == 0) {
            return null;
        }
        if (vCols == null) {
            vCols = this.m_columns;
        }
        StringBuffer sb = new StringBuffer("SELECT ");
        for (int i = 0; i < vCols.length; ++i) {
            String colSQL;
            String colName = vCols[i].getColumnName();
            X_AD_ViewColumn vc = null;
            for (int j = 0; j < this.m_columns.length; ++j) {
                if (!this.m_columns[j].getColumnName().equals(colName)) continue;
                vc = this.m_columns[j];
                break;
            }
            if (i > 0) {
                sb.append(", ");
            }
            if ((colSQL = vc.getColumnSQL()) == null || colSQL.toUpperCase().equals("NULL")) {
                String dt = vc.getDBDataType();
                if (dt != null) {
                    if (dt.equals("C") || dt.equals("V")) {
                        colSQL = "NULLIF('a','a')";
                    } else if (dt.equals("D") || dt.equals("I") || dt.equals("N")) {
                        colSQL = "NULLIF(1,1)";
                    } else if (dt.equals("T")) {
                        colSQL = "NULL";
                    }
                } else {
                    colSQL = "NULL";
                }
            }
            sb.append(colSQL);
            if (colName.equals("*")) continue;
            sb.append(" AS ").append(colName);
        }
        sb.append(" ").append(this.getFromClause());
        String t = this.getWhereClause();
        if (t != null && t.length() > 0) {
            sb.append(" ").append(t);
        }
        if ((t = this.getOtherClause()) != null && t.length() > 0) {
            sb.append(" ").append(t);
        }
        return sb.toString();
    }
}

