/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MLocator;
import org.compiere.model.MOrg;
import org.compiere.model.X_M_Locator;
import org.compiere.model.X_M_Warehouse;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class MWarehouse
extends X_M_Warehouse {
    private static CCache<Integer, MWarehouse> s_cache = new CCache("M_Warehouse", 5);
    private static CLogger s_log = CLogger.getCLogger(MWarehouse.class);
    private MLocator[] m_locators = null;
    private int m_M_Locator_ID = -1;

    public static MWarehouse get(Ctx ctx, int M_Warehouse_ID) {
        Integer key = new Integer(M_Warehouse_ID);
        MWarehouse retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MWarehouse(ctx, M_Warehouse_ID, null);
        s_cache.put(key, retValue);
        return retValue;
    }

    public static MWarehouse[] getForOrg(Ctx ctx, int AD_Org_ID) {
        ArrayList<MWarehouse> list = new ArrayList<MWarehouse>();
        String sql = "SELECT * FROM M_Warehouse WHERE AD_Org_ID=? ORDER BY Created";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Org_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MWarehouse(ctx, rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MWarehouse[] retValue = new MWarehouse[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MWarehouse(Ctx ctx, int M_Warehouse_ID, String trxName) {
        super(ctx, M_Warehouse_ID, trxName);
        if (M_Warehouse_ID == 0) {
            this.setSeparator("*");
        }
    }

    public MWarehouse(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MWarehouse(MOrg org) {
        this(org.getCtx(), 0, org.get_TrxName());
        this.setClientOrg(org);
        this.setValue(org.getValue());
        this.setName(org.getName());
        if (org.getInfo() != null) {
            this.setC_Location_ID(org.getInfo().getC_Location_ID());
        }
    }

    public MLocator[] getLocators(boolean reload) {
        if (!reload && this.m_locators != null) {
            return this.m_locators;
        }
        String sql = "SELECT * FROM M_Locator WHERE M_Warehouse_ID=? ORDER BY X,Y,Z";
        ArrayList<MLocator> list = new ArrayList<MLocator>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.getM_Warehouse_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MLocator(this.getCtx(), rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_locators = new MLocator[list.size()];
        list.toArray(this.m_locators);
        return this.m_locators;
    }

    public MLocator getDefaultLocator() {
        MLocator[] locators = this.getLocators(false);
        X_M_Locator loc1 = null;
        for (int i = 0; i < locators.length; ++i) {
            MLocator loc = locators[i];
            if (loc.isDefault() && loc.isActive()) {
                return loc;
            }
            if (loc1 != null && loc1.getPriorityNo() <= loc.getPriorityNo()) continue;
            loc1 = loc;
        }
        if (locators.length > 0) {
            this.log.warning("No default Locator for " + this.getName());
            return loc1;
        }
        MLocator loc = new MLocator(this, "Standard");
        loc.setIsDefault(true);
        loc.save();
        this.log.info("Created default locator for " + this.getName());
        return loc;
    }

    public int getDefaultM_Locator_ID() {
        if (this.m_M_Locator_ID <= 0) {
            this.m_M_Locator_ID = this.getDefaultLocator().getM_Locator_ID();
        }
        return this.m_M_Locator_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MWarehouse[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord & success) {
            this.insert_Accounting("M_Warehouse_Acct", "C_AcctSchema_Default", null);
        }
        return success;
    }

    protected boolean beforeDelete() {
        return this.delete_Accounting("M_Warehouse_Acct");
    }
}

