/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.plaf;

import java.awt.Color;
import java.awt.Component;
import javax.swing.UIDefaults;
import javax.swing.border.Border;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import org.compiere.plaf.CompiereBorders;
import org.compiere.plaf.CompiereTheme;
import org.compiere.plaf.CompiereThemeBlueMetal;

public class CompiereLookAndFeel
extends MetalLookAndFeel {
    public static final String NAME = "Compiere";
    private static CompiereTheme s_compiereTheme = new CompiereThemeBlueMetal();
    private static MetalTheme s_theme = s_compiereTheme;
    protected static boolean ROUND = false;

    public String getName() {
        return NAME;
    }

    public String getID() {
        return NAME;
    }

    public String getDescription() {
        return "Compiere Look & Feel - (c) 2001-2005 Jorg Janke";
    }

    public UIDefaults getDefaults() {
        MetalLookAndFeel.setCurrentTheme(s_theme);
        UIDefaults defaults = super.getDefaults();
        return defaults;
    }

    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        this.putDefault(table, "PanelUI");
        this.putDefault(table, "ButtonUI");
        this.putDefault(table, "ToggleButtonUI");
        this.putDefault(table, "TabbedPaneUI");
        this.putDefault(table, "TableHeaderUI");
        this.putDefault(table, "RadioButtonUI");
        this.putDefault(table, "CheckBoxUI");
        this.putDefault(table, "ComboBoxUI");
        this.putDefault(table, "MenuUI");
        this.putDefault(table, "MenuBarUI");
        this.putDefault(table, "MenuItemUI");
        this.putDefault(table, "CheckBoxMenuItemUI");
        this.putDefault(table, "ToolBarUI");
        this.putDefault(table, "RootPaneUI");
        this.putDefault(table, "ViewportUI");
        this.putDefault(table, "SplitPaneUI");
        this.putDefault(table, "ScrollPaneUI");
        this.putDefault(table, "LabelUI");
        this.putDefault(table, "ToolTipUI");
        this.putDefault(table, "TextAreaUI");
    }

    private void putDefault(UIDefaults table, String uiKey) {
        try {
            String className = "org.compiere.plaf.Compiere" + uiKey;
            table.put(uiKey, className);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void initSystemColorDefaults(UIDefaults table) {
        super.initSystemColorDefaults(table);
    }

    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        Color c = table.getColor("TextField.background");
        table.put("ComboBox.background", c);
        table.put("ComboBox.listBackground", c);
        Border textFieldBorder = CompiereBorders.getTextFieldBorder();
        table.put("TextField.border", textFieldBorder);
        table.put("PasswordField.border", textFieldBorder);
        table.put("FormattedTextField.border", textFieldBorder);
        table.put("Spinner.border", textFieldBorder);
        CompiereBorders.MarginBorder marginBorder = new CompiereBorders.MarginBorder();
        table.put("TextArea.border", marginBorder);
        table.put("TextPane.border", marginBorder);
        Border buttonBorder = CompiereBorders.getButtonBorder();
        table.put("Button.border", buttonBorder);
        table.put("CheckBox.icon", new CompiereBorders.CheckBoxIcon());
    }

    protected void createDefaultTheme() {
        CompiereLookAndFeel.setCurrentTheme(s_theme);
    }

    public static void setCurrentTheme(MetalTheme theme) {
        if (theme != null) {
            s_theme = theme;
        }
        MetalLookAndFeel.setCurrentTheme(s_theme);
    }

    public static MetalTheme getCurrentTheme() {
        return s_theme;
    }

    public static CompiereTheme getCompiereTheme() {
        return s_compiereTheme;
    }

    public void provideErrorFeedback(Component component) {
        super.provideErrorFeedback(component);
    }
}

