/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.plaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import org.compiere.plaf.ColorBlind;
import org.compiere.plaf.CompiereLookAndFeel;
import org.compiere.plaf.CompierePLAFFrame;
import org.compiere.plaf.CompiereTheme;
import org.compiere.swing.CButton;
import org.compiere.util.Ini;
import org.compiere.util.ValueNamePair;

public final class CompierePLAF {
    public static final String VERSION = "R1.4.0";
    public static final String BACKGROUND = "CompiereBackground";
    public static final String BACKGROUND_FILL = "CompiereBackgroundFill";
    public static final String TABLEVEL = "CompiereTabLevel";
    private static Logger log = Logger.getLogger(CompierePLAF.class.getName());
    private static ValueNamePair[] s_looks = null;
    private static ValueNamePair s_defaultPLAF = null;
    private static ValueNamePair[] s_themes = null;
    private static ValueNamePair s_vp_compiereTheme = null;
    private static ValueNamePair s_vp_metalTheme = null;
    private static ValueNamePair s_vp_kunststoffTheme = null;
    static ResourceBundle s_res;

    public static Color getFieldBackground_Normal() {
        return ColorBlind.getDichromatColor(UIManager.getColor("text"));
    }

    public static Color getFieldBackground_Error() {
        return ColorBlind.getDichromatColor(CompiereTheme.error);
    }

    public static Color getFieldBackground_Mandatory() {
        return ColorBlind.getDichromatColor(CompiereTheme.mandatory);
    }

    public static Color getFieldBackground_Inactive() {
        return ColorBlind.getDichromatColor(CompiereTheme.inactive);
    }

    public static Color getFormBackground() {
        return ColorBlind.getDichromatColor(UIManager.getColor("control"));
    }

    public static Color getInfoBackground() {
        return ColorBlind.getDichromatColor(CompiereTheme.info);
    }

    public static Color getTextColor_Normal() {
        return ColorBlind.getDichromatColor(UIManager.getColor("textText"));
    }

    public static Color getTextColor_OK() {
        return ColorBlind.getDichromatColor(CompiereTheme.txt_ok);
    }

    public static Color getTextColor_Issue() {
        return ColorBlind.getDichromatColor(CompiereTheme.txt_error);
    }

    public static Color getTextColor_Label() {
        return ColorBlind.getDichromatColor(UIManager.getColor("controlText"));
    }

    public static Color getPrimary1() {
        return ColorBlind.getDichromatColor(CompiereTheme.primary1);
    }

    public static Color getPrimary2() {
        return ColorBlind.getDichromatColor(CompiereTheme.primary2);
    }

    public static Color getPrimary3() {
        return ColorBlind.getDichromatColor(CompiereTheme.primary3);
    }

    public static Color getSecondary1() {
        return ColorBlind.getDichromatColor(CompiereTheme.secondary1);
    }

    public static Color getSecondary2() {
        return ColorBlind.getDichromatColor(CompiereTheme.secondary2);
    }

    public static Color getSecondary3() {
        return ColorBlind.getDichromatColor(CompiereTheme.secondary3);
    }

    public static Font getFont_Header() {
        return CompiereTheme.windowFont;
    }

    public static Font getFont_Field() {
        return CompiereTheme.userFont;
    }

    public static Font getFont_Label() {
        return CompiereTheme.controlFont;
    }

    public static Font getFont_Small() {
        return CompiereTheme.smallFont;
    }

    public static ValueNamePair[] getPLAFs() {
        return s_looks;
    }

    public static ValueNamePair[] getThemes() {
        if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
            return s_themes;
        }
        return new ValueNamePair[0];
    }

    public static void setPLAF(Window win) {
        String look = Ini.getProperty("UILookFeel");
        String lookTheme = Ini.getProperty("UITheme");
        ValueNamePair plaf = null;
        for (int i = 0; i < s_looks.length; ++i) {
            if (!s_looks[i].getName().equals(look)) continue;
            plaf = s_looks[i];
            break;
        }
        ValueNamePair theme = null;
        for (int i = 0; i < s_themes.length; ++i) {
            if (!s_themes[i].getName().equals(lookTheme)) continue;
            theme = s_themes[i];
            break;
        }
        CompierePLAF.setPLAF(plaf == null ? s_defaultPLAF : plaf, theme, win);
    }

    public static void setPLAF(ValueNamePair plaf, ValueNamePair theme, Window win) {
        if (plaf == null) {
            return;
        }
        log.config(plaf + (theme == null ? "" : " - " + theme) + " - " + win);
        try {
            UIManager.setLookAndFeel(plaf.getValue());
        }
        catch (Exception e) {
            log.severe(e.getMessage());
        }
        LookAndFeel laf = UIManager.getLookAndFeel();
        Ini.setProperty("UILookFeel", plaf.getName());
        Ini.setProperty("UITheme", "");
        if (theme == null && laf instanceof MetalLookAndFeel) {
            String className = laf.getClass().getName();
            if (className.equals("javax.swing.plaf.metal.MetalLookAndFeel")) {
                theme = s_vp_metalTheme;
            } else if (className.equals("org.compiere.plaf.CompiereLookAndFeel")) {
                theme = s_vp_compiereTheme;
            } else if (className.equals("com.incors.plaf.kunststoff.KunststoffLookAndFeel")) {
                theme = s_vp_kunststoffTheme;
            }
        }
        if (theme != null && laf instanceof MetalLookAndFeel && theme.getValue().length() > 0) {
            try {
                Class<?> c = Class.forName(theme.getValue());
                MetalTheme t = (MetalTheme)c.newInstance();
                if (t instanceof CompiereTheme) {
                    CompiereTheme.load();
                }
                if (laf instanceof CompiereLookAndFeel) {
                    CompiereLookAndFeel.setCurrentTheme(t);
                } else {
                    MetalLookAndFeel.setCurrentTheme(t);
                }
                boolean flat = Ini.isPropertyBool("UIFlat");
                CompiereTheme.setTheme(t, flat);
                Ini.setProperty("UITheme", theme.getName());
            }
            catch (Exception e) {
                log.severe("Theme - " + e.getMessage());
            }
        }
        CompierePLAF.updateUI();
        log.config(plaf + " - " + theme);
    }

    public static void updateUI() {
        try {
            for (Frame frame : Frame.getFrames()) {
                CompierePLAF.updateUI(frame);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    private static void updateUI(Window window) {
        SwingUtilities.updateComponentTreeUI(window);
        for (Window win : window.getOwnedWindows()) {
            CompierePLAF.updateUI(win);
        }
    }

    public static void reset(Window win) {
        CompiereTheme.reset();
        CompierePLAF.setPLAF(win);
    }

    public static void printPLAFDefaults() {
        System.out.println(UIManager.getLookAndFeel());
        Object[] keys = UIManager.getLookAndFeelDefaults().keySet().toArray();
        Arrays.sort(keys);
        char lastStart = ' ';
        for (int i = 0; i < keys.length; ++i) {
            StringBuffer sb = new StringBuffer();
            sb.append(keys[i]).append(" = ").append(UIManager.get(keys[i]));
            if (keys[i].toString().charAt(0) != lastStart) {
                System.out.println();
                lastStart = keys[i].toString().charAt(0);
            }
            System.out.println(sb);
        }
    }

    public static boolean isActive() {
        return UIManager.getLookAndFeel() instanceof CompiereLookAndFeel;
    }

    public static CButton getOKButton() {
        CButton b = new CButton();
        b.setIcon(new ImageIcon(CompierePLAF.class.getResource("icons/Ok24.gif")));
        b.setMargin(new Insets(0, 10, 0, 10));
        b.setToolTipText(s_res.getString("OK"));
        return b;
    }

    public static CButton getCancelButton() {
        CButton b = new CButton();
        b.setIcon(new ImageIcon(CompierePLAF.class.getResource("icons/Cancel24.gif")));
        b.setMargin(new Insets(0, 10, 0, 10));
        b.setToolTipText(s_res.getString("Cancel"));
        return b;
    }

    public static void showCenterScreen(Window window) {
        window.pack();
        Dimension sSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension wSize = window.getSize();
        window.setLocation((sSize.width - wSize.width) / 2, (sSize.height - wSize.height) / 2);
        window.toFront();
        window.setVisible(true);
    }

    public static void main(String[] args) {
        String jVersion = System.getProperty("java.version");
        if (!jVersion.startsWith("1.5")) {
            JOptionPane.showMessageDialog(null, "Require Java Version 1.5 or up - Not " + jVersion, "CompierePLAF - Version Conflict", 0);
            System.exit(1);
        }
        Ini.loadProperties(true);
        CompiereTheme.load();
        CompierePLAF.setPLAF(null);
        if (args.length == 0) {
            new CompierePLAFFrame();
            return;
        }
        String className = args[0];
        Class<?> startClass = null;
        try {
            startClass = Class.forName(className);
        }
        catch (Exception e) {
            log.severe("Did not find: " + className);
            e.printStackTrace();
            System.exit(1);
        }
        try {
            Method[] methods = startClass.getMethods();
            int i = 0;
            if (i < methods.length) {
                if (Modifier.isStatic(methods[i].getModifiers()) && methods[i].getName().equals("main")) {
                    String[] startArgs = new String[args.length - 1];
                    for (int ii = 1; ii < args.length; ++ii) {
                        startArgs[ii - i] = args[ii];
                    }
                    methods[i].invoke(null, new Object[]{startArgs});
                }
                return;
            }
        }
        catch (Exception ee) {
            log.severe("Problems invoking main");
            ee.printStackTrace();
        }
        try {
            startClass.newInstance();
        }
        catch (Exception e) {
            log.severe("Cannot start: " + className);
            e.printStackTrace();
            System.exit(1);
        }
    }

    static {
        ArrayList<ValueNamePair> plafList = new ArrayList<ValueNamePair>();
        ValueNamePair vp = new ValueNamePair("org.compiere.plaf.CompiereLookAndFeel", "Compiere");
        plafList.add(vp);
        ArrayList<ValueNamePair> themeList = new ArrayList<ValueNamePair>();
        s_vp_compiereTheme = new ValueNamePair("org.compiere.plaf.CompiereThemeBlueMetal", "Compiere Theme");
        themeList.add(s_vp_compiereTheme);
        themeList.add(new ValueNamePair("org.compiere.plaf.CompiereThemeIce", "Compiere Ice"));
        s_vp_metalTheme = new ValueNamePair("javax.swing.plaf.metal.DefaultMetalTheme", "Steel");
        themeList.add(s_vp_metalTheme);
        themeList.add(new ValueNamePair("javax.swing.plaf.metal.OceanTheme", "Ocean"));
        themeList.add(new ValueNamePair("org.compiere.plaf.AquaTheme", "Aqua"));
        themeList.add(new ValueNamePair("org.compiere.plaf.CharcoalTheme", "Charcoal"));
        themeList.add(new ValueNamePair("org.compiere.plaf.ContrastTheme", "Contrast"));
        themeList.add(new ValueNamePair("org.compiere.plaf.EmeraldTheme", "Emerald"));
        themeList.add(new ValueNamePair("org.compiere.plaf.RubyTheme", "Ruby"));
        try {
            Class.forName("com.incors.plaf.kunststoff.KunststoffLookAndFeel");
            vp = new ValueNamePair("com.incors.plaf.kunststoff.KunststoffLookAndFeel", "Kunststoff");
            plafList.add(vp);
            vp = new ValueNamePair("com.incors.plaf.kunststoff.KunststoffTheme", "Kuststoff");
            themeList.add(vp);
            s_vp_kunststoffTheme = vp;
        }
        catch (Exception e) {
            // empty catch block
        }
        for (int i = 0; i < plafList.size(); ++i) {
            vp = (ValueNamePair)plafList.get(i);
            UIManager.installLookAndFeel(vp.getName(), vp.getValue());
        }
        plafList = new ArrayList();
        UIManager.LookAndFeelInfo[] lfInfo = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < lfInfo.length; ++i) {
            vp = new ValueNamePair(lfInfo[i].getClassName(), lfInfo[i].getName());
            plafList.add(vp);
            if (lfInfo[i].getName().equals("Compiere")) {
                s_defaultPLAF = vp;
                log.finest(vp.getName() + " (default)");
                continue;
            }
            log.finest(vp.getName());
        }
        s_looks = new ValueNamePair[plafList.size()];
        plafList.toArray(s_looks);
        s_themes = new ValueNamePair[themeList.size()];
        themeList.toArray(s_themes);
        s_res = ResourceBundle.getBundle("org.compiere.translate.PlafRes");
    }
}

