/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.plaf;

import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import java.util.logging.Logger;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.MetalTheme;
import org.compiere.plaf.ColorBlind;
import org.compiere.plaf.CompiereColor;
import org.compiere.plaf.CompierePanelUI;
import org.compiere.plaf.CompiereThemeBlueMetal;
import org.compiere.util.Ini;
import sun.awt.AppContext;

public class CompiereTheme
extends MetalTheme {
    protected static String s_name;
    protected static Logger log;
    protected static CompiereTheme s_theme;
    protected static ColorUIResource primary0;
    protected static ColorUIResource primary1;
    protected static ColorUIResource primary2;
    protected static ColorUIResource primary3;
    protected final ColorUIResource secondary0 = new ColorUIResource(0, 0, 0);
    protected static ColorUIResource secondary1;
    protected static ColorUIResource secondary2;
    protected static ColorUIResource secondary3;
    protected final ColorUIResource secondary4 = new ColorUIResource(255, 255, 255);
    protected static ColorUIResource black;
    protected static ColorUIResource white;
    protected static ColorUIResource mandatory;
    protected static ColorUIResource error;
    protected static ColorUIResource inactive;
    protected static ColorUIResource info;
    protected static ColorUIResource txt_ok;
    protected static ColorUIResource txt_error;
    protected static FontUIResource controlFont;
    protected static FontUIResource systemFont;
    protected static FontUIResource userFont;
    protected static FontUIResource smallFont;
    protected static FontUIResource windowFont;
    protected static FontUIResource menuFont;
    public static final String FONT_DEFAULT = "Dialog";
    public static final int FONT_SIZE = 12;
    private static final String P_Primary1 = "#ColorPrimary1";
    private static final String P_Primary2 = "#ColorPrimary2";
    private static final String P_Primary3 = "#ColorPrimary3";
    private static final String P_Secondary1 = "#ColorSecondary1";
    private static final String P_Secondary2 = "#ColorSecondary2";
    private static final String P_Secondary3 = "#ColorSecondary3";
    private static final String P_Black = "#ColorBlack";
    private static final String P_White = "#ColorWhite";
    private static final String P_Error = "#ColorError";
    private static final String P_Info = "#ColorInfo";
    private static final String P_Mandatory = "#ColorMandatory";
    private static final String P_Inactive = "#ColorInactive";
    private static final String P_Txt_OK = "#ColorTextOK";
    private static final String P_Txt_Error = "#ColorTextError";
    private static final String P_Control = "#FontControl";
    private static final String P_System = "#FontSystem";
    private static final String P_User = "#FontUser";
    private static final String P_Small = "#FontSmall";
    private static final String P_Window = "#FontWindow";
    private static final String P_Menu = "#FontMenu";
    protected static final String P_CompiereColor = "#CompiereColor";

    public String getName() {
        return s_name;
    }

    public String toString() {
        return s_name;
    }

    protected void setDefault() {
    }

    public static void setTheme() {
        log.fine("");
        AppContext context = AppContext.getAppContext();
        MetalTheme copyFrom = (MetalTheme)context.get("currentMetalTheme");
        boolean flat = Ini.isPropertyBool("UIFlat");
        CompiereTheme.setTheme(copyFrom, flat);
    }

    public static void setTheme(MetalTheme copyFrom, boolean flat) {
        if (copyFrom == null || copyFrom instanceof CompiereTheme) {
            return;
        }
        log.fine(copyFrom.getName() + " - Flat=" + flat);
        primary1 = copyFrom.getPrimaryControlDarkShadow();
        primary2 = copyFrom.getPrimaryControlShadow();
        primary3 = copyFrom.getPrimaryControl();
        secondary1 = copyFrom.getControlDarkShadow();
        secondary2 = copyFrom.getControlShadow();
        secondary3 = copyFrom.getControl();
        CompierePanelUI.setDefaultBackground(new CompiereColor((Color)secondary3, flat));
        white = copyFrom.getPrimaryControlHighlight();
        black = copyFrom.getPrimaryControlInfo();
        controlFont = copyFrom.getControlTextFont();
        systemFont = copyFrom.getSystemTextFont();
        userFont = copyFrom.getUserTextFont();
        smallFont = copyFrom.getSubTextFont();
        menuFont = copyFrom.getMenuTextFont();
        windowFont = copyFrom.getWindowTitleFont();
    }

    public ColorUIResource getPrimary1() {
        return ColorBlind.getDichromatColorUIResource(primary1);
    }

    public ColorUIResource getPrimary2() {
        return ColorBlind.getDichromatColorUIResource(primary2);
    }

    public ColorUIResource getPrimary3() {
        return ColorBlind.getDichromatColorUIResource(primary3);
    }

    public ColorUIResource getSecondary0() {
        return ColorBlind.getDichromatColorUIResource(this.secondary0);
    }

    public ColorUIResource getSecondary1() {
        return ColorBlind.getDichromatColorUIResource(secondary1);
    }

    public ColorUIResource getSecondary2() {
        return ColorBlind.getDichromatColorUIResource(secondary2);
    }

    public ColorUIResource getSecondary3() {
        return ColorBlind.getDichromatColorUIResource(secondary3);
    }

    public ColorUIResource getSecondary4() {
        return ColorBlind.getDichromatColorUIResource(this.secondary4);
    }

    public ColorUIResource getBlack() {
        return ColorBlind.getDichromatColorUIResource(black);
    }

    public ColorUIResource getWhite() {
        return ColorBlind.getDichromatColorUIResource(white);
    }

    protected static FontUIResource _getControlTextFont() {
        if (controlFont == null) {
            try {
                controlFont = new FontUIResource(Font.getFont("swing.plaf.metal.controlFont", new Font(FONT_DEFAULT, 0, 12)));
            }
            catch (Exception e) {
                controlFont = new FontUIResource(FONT_DEFAULT, 0, 12);
            }
        }
        return controlFont;
    }

    public FontUIResource getControlTextFont() {
        return CompiereTheme._getControlTextFont();
    }

    protected static FontUIResource _getSystemTextFont() {
        if (systemFont == null) {
            try {
                systemFont = new FontUIResource(Font.getFont("swing.plaf.metal.systemFont", new Font(FONT_DEFAULT, 0, 12)));
            }
            catch (Exception e) {
                systemFont = new FontUIResource(FONT_DEFAULT, 0, 12);
            }
        }
        return systemFont;
    }

    public FontUIResource getSystemTextFont() {
        return CompiereTheme._getSystemTextFont();
    }

    protected static FontUIResource _getUserTextFont() {
        if (userFont == null) {
            try {
                userFont = new FontUIResource(Font.getFont("swing.plaf.metal.userFont", new Font(FONT_DEFAULT, 0, 12)));
            }
            catch (Exception e) {
                userFont = new FontUIResource(FONT_DEFAULT, 0, 12);
            }
        }
        return userFont;
    }

    public FontUIResource getUserTextFont() {
        return CompiereTheme._getUserTextFont();
    }

    protected static FontUIResource _getMenuTextFont() {
        if (menuFont == null) {
            try {
                menuFont = new FontUIResource(Font.getFont("swing.plaf.metal.menuFont", new Font(FONT_DEFAULT, 0, 12)));
            }
            catch (Exception e) {
                menuFont = new FontUIResource(FONT_DEFAULT, 0, 12);
            }
        }
        return menuFont;
    }

    public FontUIResource getMenuTextFont() {
        return CompiereTheme._getMenuTextFont();
    }

    protected static FontUIResource _getWindowTitleFont() {
        if (windowFont == null) {
            try {
                windowFont = new FontUIResource(Font.getFont("swing.plaf.metal.windowFont", new Font(FONT_DEFAULT, 1, 14)));
            }
            catch (Exception e) {
                windowFont = new FontUIResource(FONT_DEFAULT, 1, 14);
            }
        }
        return windowFont;
    }

    public FontUIResource getWindowTitleFont() {
        return CompiereTheme._getWindowTitleFont();
    }

    protected static FontUIResource _getSubTextFont() {
        if (smallFont == null) {
            try {
                smallFont = new FontUIResource(Font.getFont("swing.plaf.metal.smallFont", new Font(FONT_DEFAULT, 0, 10)));
            }
            catch (Exception e) {
                smallFont = new FontUIResource(FONT_DEFAULT, 0, 10);
            }
        }
        return smallFont;
    }

    public FontUIResource getSubTextFont() {
        return CompiereTheme._getSubTextFont();
    }

    public static void save() {
        log.config(CompiereColor.getDefaultBackground().toString());
        Ini.setProperty(P_Primary1, CompiereTheme.getColorAsString(primary1));
        Ini.setProperty(P_Primary2, CompiereTheme.getColorAsString(primary2));
        Ini.setProperty(P_Primary3, CompiereTheme.getColorAsString(primary3));
        Ini.setProperty(P_Secondary1, CompiereTheme.getColorAsString(secondary1));
        Ini.setProperty(P_Secondary2, CompiereTheme.getColorAsString(secondary2));
        Ini.setProperty(P_Secondary3, CompiereTheme.getColorAsString(secondary3));
        Ini.setProperty(P_Error, CompiereTheme.getColorAsString(error));
        Ini.setProperty(P_Info, CompiereTheme.getColorAsString(info));
        Ini.setProperty(P_Mandatory, CompiereTheme.getColorAsString(mandatory));
        Ini.setProperty(P_Inactive, CompiereTheme.getColorAsString(inactive));
        Ini.setProperty(P_White, CompiereTheme.getColorAsString(white));
        Ini.setProperty(P_Black, CompiereTheme.getColorAsString(black));
        Ini.setProperty(P_Txt_OK, CompiereTheme.getColorAsString(txt_ok));
        Ini.setProperty(P_Txt_Error, CompiereTheme.getColorAsString(txt_error));
        Ini.setProperty(P_Control, controlFont.toString());
        Ini.setProperty(P_System, systemFont.toString());
        Ini.setProperty(P_User, userFont.toString());
        Ini.setProperty(P_Small, smallFont.toString());
        Ini.setProperty(P_Window, windowFont.toString());
        Ini.setProperty(P_Menu, menuFont.toString());
        CompiereColor cc = CompiereColor.getDefaultBackground();
        Ini.setProperty(P_CompiereColor, cc.toString());
    }

    public static String getColorAsString(Color c) {
        if (c == null) {
            c = SystemColor.control;
        }
        StringBuffer sb = new StringBuffer("[r=").append(c.getRed()).append(",g=").append(c.getGreen()).append(",b=").append(c.getBlue()).append(",a=").append(c.getAlpha()).append("]");
        return sb.toString();
    }

    public static void load() {
        primary1 = CompiereTheme.parseColor(Ini.getProperty(P_Primary1), primary1);
        primary2 = CompiereTheme.parseColor(Ini.getProperty(P_Primary2), primary2);
        primary3 = CompiereTheme.parseColor(Ini.getProperty(P_Primary3), primary3);
        secondary1 = CompiereTheme.parseColor(Ini.getProperty(P_Secondary1), secondary1);
        secondary2 = CompiereTheme.parseColor(Ini.getProperty(P_Secondary2), secondary2);
        secondary3 = CompiereTheme.parseColor(Ini.getProperty(P_Secondary3), secondary3);
        error = CompiereTheme.parseColor(Ini.getProperty(P_Error), error);
        info = CompiereTheme.parseColor(Ini.getProperty(P_Info), info);
        mandatory = CompiereTheme.parseColor(Ini.getProperty(P_Mandatory), mandatory);
        inactive = CompiereTheme.parseColor(Ini.getProperty(P_Inactive), inactive);
        white = CompiereTheme.parseColor(Ini.getProperty(P_White), white);
        black = CompiereTheme.parseColor(Ini.getProperty(P_Black), black);
        txt_ok = CompiereTheme.parseColor(Ini.getProperty(P_Txt_OK), txt_ok);
        txt_error = CompiereTheme.parseColor(Ini.getProperty(P_Txt_Error), txt_error);
        controlFont = CompiereTheme.parseFont(Ini.getProperty(P_Control), controlFont);
        systemFont = CompiereTheme.parseFont(Ini.getProperty(P_System), systemFont);
        userFont = CompiereTheme.parseFont(Ini.getProperty(P_User), userFont);
        smallFont = CompiereTheme.parseFont(Ini.getProperty(P_Small), smallFont);
        windowFont = CompiereTheme.parseFont(Ini.getProperty(P_Window), windowFont);
        menuFont = CompiereTheme.parseFont(Ini.getProperty(P_Menu), menuFont);
        CompiereColor cc = CompiereColor.parse(Ini.getProperty(P_CompiereColor));
        CompiereColor.setDefaultBackground(cc);
    }

    public static void reset() {
        Ini.setProperty("UILookFeel", "Compiere");
        Ini.setProperty("UITheme", s_name);
        if (s_theme != null) {
            s_theme.setDefault();
        }
        CompiereColor cc = new CompiereColor((Color)secondary3, false);
        CompiereColor.setDefaultBackground(cc);
        CompiereTheme.save();
    }

    protected static ColorUIResource parseColor(String information, ColorUIResource stdColor) {
        if (information == null || information.length() == 0 || information.trim().length() == 0) {
            return stdColor;
        }
        try {
            int r = Integer.parseInt(information.substring(information.indexOf("r=") + 2, information.indexOf(",g=")));
            int g = Integer.parseInt(information.substring(information.indexOf("g=") + 2, information.indexOf(",b=")));
            int b = 0;
            int a = 255;
            if (information.indexOf("a=") == -1) {
                b = Integer.parseInt(information.substring(information.indexOf("b=") + 2, information.indexOf("]")));
            } else {
                b = Integer.parseInt(information.substring(information.indexOf("b=") + 2, information.indexOf(",a=")));
                a = Integer.parseInt(information.substring(information.indexOf("a=") + 2, information.indexOf("]")));
            }
            ColorUIResource retValue = new ColorUIResource(new Color(r, g, b, a));
            return retValue;
        }
        catch (Exception e) {
            log.config(information + " - cannot parse: " + e.toString());
            return stdColor;
        }
    }

    private static FontUIResource parseFont(String information, FontUIResource stdFont) {
        if (information == null || information.length() == 0 || information.trim().length() == 0) {
            return stdFont;
        }
        try {
            String name = information.substring(information.indexOf("name=") + 5, information.indexOf(",style="));
            String s = information.substring(information.indexOf("style=") + 6, information.indexOf(",size="));
            int style = 0;
            if (s.equals("bold")) {
                style = 1;
            } else if (s.equals("italic")) {
                style = 2;
            } else if (s.equals("bolditalic")) {
                style = 3;
            }
            int size = Integer.parseInt(information.substring(information.indexOf(",size=") + 6, information.lastIndexOf("]")));
            FontUIResource retValue = new FontUIResource(name, style, size);
            return retValue;
        }
        catch (Exception e) {
            log.config(information + " - cannot parse: " + e.toString());
            return stdFont;
        }
    }

    static {
        s_theme = new CompiereThemeBlueMetal();
        s_name = "Compiere Theme";
        log = Logger.getLogger(CompiereTheme.class.getName());
        s_theme = null;
        primary0 = new ColorUIResource(51, 51, 102);
    }
}

