/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.framework.PO;
import org.compiere.util.CLogger;

public abstract class CompiereServer
extends Thread {
    private static ThreadGroup s_threadGroup = new ThreadGroup("CompiereServer");
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private volatile boolean m_working = false;
    private int m_count = 0;
    private int m_pollCount = 0;
    private volatile int m_time = 0;
    private volatile long m_start = 0L;
    private volatile long m_lastStart = 0L;
    private int m_sleepSeconds = 10;
    protected PO p_processor = null;
    private boolean m_canContinue = true;

    public CompiereServer(String name) {
        super(s_threadGroup, name);
    }

    public boolean isWorking() {
        return this.m_working;
    }

    public int getPollCount() {
        return this.m_pollCount;
    }

    public int getWorkCount() {
        return this.m_count;
    }

    public int getWorkTime() {
        return this.m_time;
    }

    public Timestamp getStart() {
        if (this.m_start == 0L) {
            return null;
        }
        return new Timestamp(this.m_start);
    }

    public Timestamp getLastStart() {
        if (this.m_lastStart == 0L) {
            return null;
        }
        return new Timestamp(this.m_lastStart);
    }

    public int getSleepSeconds() {
        return this.m_sleepSeconds;
    }

    public void setSleepSeconds(int sleepSeconds) {
        this.m_sleepSeconds = sleepSeconds;
    }

    public void setProcessor(PO processor) {
        this.p_processor = processor;
        this.setName(this.getProcessorName());
    }

    public String getStatistics() {
        StringBuffer sb = new StringBuffer();
        sb.append("Alive=").append(this.isAlive()).append(", Start=").append(this.getStart()).append(", WorkCount=").append(this.getWorkCount()).append(", WorkTime=").append(this.getWorkTime()).append(", PollCount=").append(this.getPollCount()).append(", Working=").append(this.isWorking()).append(", Last=").append(this.getLastStart());
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("CompiereServer[");
        sb.append(this.getStatistics()).append("]");
        return sb.toString();
    }

    public final void run() {
        if (this.m_start == 0L) {
            this.m_start = System.currentTimeMillis();
        }
        this.m_canContinue = true;
        while (this.m_canContinue) {
            if (this.isInterrupted()) {
                return;
            }
            this.m_lastStart = System.currentTimeMillis();
            this.m_working = true;
            try {
                ++this.m_pollCount;
                if (this.canDoWork()) {
                    this.m_canContinue = this.doWork();
                    ++this.m_count;
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "run", e);
            }
            this.m_working = false;
            long end = System.currentTimeMillis();
            this.m_time = (int)((long)this.m_time + (end - this.m_lastStart));
            if (this.isInterrupted()) {
                return;
            }
            try {
                this.log.fine("sleeping ... " + this.m_sleepSeconds);
                CompiereServer.sleep(this.m_sleepSeconds * 1000);
            }
            catch (InterruptedException e1) {
                this.log.warning("run - " + e1.getLocalizedMessage());
                return;
            }
        }
    }

    public abstract String getProcessorName();

    public abstract boolean canDoWork();

    public abstract boolean doWork();
}

