/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.swing;

import java.awt.Color;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import org.compiere.plaf.CompierePLAF;
import org.compiere.swing.CEditor;

public class CCheckBox
extends JCheckBox
implements CEditor {
    private boolean m_mandatory = false;
    private boolean m_readWrite = true;
    private Object m_value = null;

    public CCheckBox() {
        this.init();
    }

    public CCheckBox(Icon icon) {
        super(icon);
        this.init();
    }

    public CCheckBox(Icon icon, boolean selected) {
        super(icon, selected);
        this.init();
    }

    public CCheckBox(String text) {
        super(text);
        this.init();
    }

    public CCheckBox(Action a) {
        super(a);
        this.init();
    }

    public CCheckBox(String text, boolean selected) {
        super(text, selected);
        this.init();
    }

    public CCheckBox(String text, Icon icon) {
        super(text, icon, false);
        this.init();
    }

    public CCheckBox(String text, Icon icon, boolean selected) {
        super(text, icon, selected);
        this.init();
    }

    private void init() {
        this.setFont(CompierePLAF.getFont_Label());
        this.setForeground(CompierePLAF.getTextColor_Label());
        this.setBackground(false);
    }

    public void setMandatory(boolean mandatory) {
        this.m_mandatory = mandatory;
        this.setBackground(false);
    }

    public boolean isMandatory() {
        return this.m_mandatory;
    }

    public void setReadWrite(boolean rw) {
        if (super.isEnabled() != rw) {
            super.setEnabled(rw);
        }
        this.setBackground(false);
        this.m_readWrite = rw;
    }

    public boolean isReadWrite() {
        return this.m_readWrite;
    }

    public void setBackground(boolean error) {
        if (error) {
            this.setBackground(CompierePLAF.getFieldBackground_Error());
        } else if (!this.isReadWrite()) {
            this.setBackground(CompierePLAF.getFieldBackground_Inactive());
        } else if (this.m_mandatory) {
            this.setBackground(CompierePLAF.getFieldBackground_Mandatory());
        } else {
            this.setBackground(CompierePLAF.getFieldBackground_Normal());
        }
    }

    public void setBackground(Color bg) {
        if (bg.equals(this.getBackground())) {
            return;
        }
        super.setBackground(bg);
    }

    public void setValue(Object value) {
        this.m_value = value;
        boolean sel = false;
        if (value == null) {
            sel = false;
        } else if (value.toString().equals("Y")) {
            sel = true;
        } else if (value.toString().equals("N")) {
            sel = false;
        } else if (value instanceof Boolean) {
            sel = (Boolean)value;
        } else {
            try {
                sel = Boolean.getBoolean(value.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setSelected(sel);
    }

    public Object getValue() {
        if (this.m_value instanceof String) {
            return super.isSelected() ? "Y" : "N";
        }
        return new Boolean(this.isSelected());
    }

    public String getDisplay() {
        if (this.m_value instanceof String) {
            return super.isSelected() ? "Y" : "N";
        }
        return Boolean.toString(super.isSelected());
    }

    public void setText(String mnemonicLabel) {
        super.setText(this.createMnemonic(mnemonicLabel));
    }

    private String createMnemonic(String text) {
        char ch;
        if (text == null) {
            return text;
        }
        int pos = text.indexOf(38);
        if (pos != -1 && (ch = text.charAt(pos + 1)) != ' ') {
            this.setMnemonic(ch);
            return text.substring(0, pos) + text.substring(pos + 1);
        }
        return text;
    }
}

