/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.translate;

import org.compiere.translate.AmtInWords;

public class AmtInWords_ES
implements AmtInWords {
    private static final String[] majorNames = new String[]{"", " MIL", " MILLON", " BILLON", " TRILLON", " CUATRILLON", " QUINTRILLON"};
    private static final String[] tensNames = new String[]{"", " DIEZ", " VEINTE", " TREINTA", " CUARENTA", " CINCUENTA", " SESENTA", " SETENTA", " OCHENTA", " NOVENTA"};
    private static final String[] numNames = new String[]{"", " UNO", " DOS", " TRES", " CUATRO", " CINCO", " SEIS", " SIETE", " OCHO", " NUEVE", " DIEZ", " ONCE", " DOCE", " TRECE", " CATORCE", " QUINCE", " DIECISEIS", " DIECISIETE", " DIECIOCHO", " DIECINUEVE"};

    private String convertLessThanOneThousand(int number) {
        String soFar;
        if (number % 100 < 20) {
            soFar = numNames[number % 100];
            number /= 100;
        } else {
            soFar = numNames[number % 10];
            String s = Integer.toString(number /= 10);
            soFar = s.endsWith("2") && soFar != "" ? " VEINTI" + soFar.trim() : (soFar == "" ? tensNames[number % 10] + soFar : tensNames[number % 10] + " Y" + soFar);
            number /= 10;
        }
        if (number == 0) {
            return soFar;
        }
        if (number > 1) {
            soFar = "S" + soFar;
        }
        if (number == 1 && soFar != "") {
            number = 0;
        }
        return numNames[number] + " CIENTO" + soFar;
    }

    private String convert(int number) {
        if (number == 0) {
            return "CERO";
        }
        String prefix = "";
        if (number < 0) {
            number = -number;
            prefix = "MENOS";
        }
        String soFar = "";
        int place = 0;
        do {
            int n;
            if ((n = number % 1000) != 0) {
                String s = this.convertLessThanOneThousand(n);
                if (s.startsWith("CINCO CIENTOS", 1)) {
                    s = s.replaceFirst("CINCO CIENTOS", "QUINIENTOS");
                }
                if (s.startsWith("SIETE CIENTOS", 1)) {
                    s = s.replaceFirst("SIETE CIENTOS", "SETECIENTOS");
                }
                if (s.startsWith("NUEVE CIENTOS", 1)) {
                    s = s.replaceFirst("NUEVE CIENTOS", "NOVECIENTOS");
                }
                soFar = s == " UNO" ? majorNames[place] + soFar : s + majorNames[place] + soFar;
            }
            ++place;
        } while ((number /= 1000) > 0);
        return (prefix + soFar).trim();
    }

    public String getAmtInWords(String amount) throws Exception {
        if (amount == null) {
            return amount;
        }
        StringBuffer sb = new StringBuffer();
        int pos = amount.lastIndexOf(46);
        int pos2 = amount.lastIndexOf(44);
        if (pos2 > pos) {
            pos = pos2;
        }
        String oldamt = amount;
        amount = amount.replaceAll(",", "");
        int newpos = amount.lastIndexOf(46);
        int pesos = Integer.parseInt(amount.substring(0, newpos));
        sb.append(this.convert(pesos));
        for (int i = 0; i < oldamt.length(); ++i) {
            if (pos != i) continue;
            String cents = oldamt.substring(i + 1);
            sb.append(' ').append(cents).append("/100");
            break;
        }
        return sb.toString();
    }
}

