/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.compiere.util.Ctx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CContext
extends Ctx {
    private Map<Integer, Map<String, String>> m_windows = new HashMap<Integer, Map<String, String>>();

    public CContext() {
    }

    public CContext(Map<String, String> map) {
        super(map);
    }

    public CContext(String stringRepresentation) {
        super(stringRepresentation);
    }

    public CContext(Set<Map.Entry<String, String>> set) {
        super(set);
    }

    public Map<String, String> getMap(int windowNo) {
        return this.getMap(windowNo, false);
    }

    public Map<String, String> getMap(int windowNo, boolean convertNullToEmptyString) {
        Map<String, String> map = this.m_windows.get(windowNo);
        if (!convertNullToEmptyString) {
            return map;
        }
        HashMap<String, String> newMap = new HashMap<String, String>();
        Set<Map.Entry<String, String>> set = map.entrySet();
        for (Map.Entry<String, String> entry : set) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (convertNullToEmptyString && value == null) {
                newMap.put(key, "");
                continue;
            }
            newMap.put(key, value);
        }
        return newMap;
    }

    public void removeWindow(int windowNo) {
        this.m_windows.remove(windowNo);
    }

    public void addWindow(int windowNo, Map map) {
        Set set = map.entrySet();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = entry.getKey().toString();
            int index = key.indexOf(124);
            if (index == -1) continue;
            this.m_map.put(key, entry.getValue());
            it.remove();
        }
        this.m_windows.put(windowNo, map);
    }

    public void clear() {
        super.clear();
        this.m_windows.clear();
    }

    public String[] getEntireContext() {
        Map<String, String> map = this.getMap();
        ArrayList<String> sList = new ArrayList<String>(this.size());
        for (String key : map.keySet()) {
            String s = key + " == " + map.get(key);
            sList.add(s);
        }
        Object[] retValue = new String[sList.size()];
        sList.toArray(retValue);
        Arrays.sort(retValue);
        return retValue;
    }

    public boolean containsKey(String key) {
        if (super.containsKey((Object)key)) {
            return true;
        }
        if (key == null) {
            return false;
        }
        for (Map.Entry<Integer, Map<String, String>> entryWin : this.m_windows.entrySet()) {
            int windowNo = entryWin.getKey();
            if (!key.startsWith(String.valueOf(windowNo))) continue;
            for (Map.Entry<String, String> entry : entryWin.getValue().entrySet()) {
                if (!key.equals(entry.getKey())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsValue(Object value) {
        if (super.containsValue(value)) {
            return true;
        }
        if (value == null) {
            return false;
        }
        for (Map.Entry<Integer, Map<String, String>> entryWin : this.m_windows.entrySet()) {
            for (Map.Entry<String, String> entry : entryWin.getValue().entrySet()) {
                if (!value.equals(entry.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    protected Map<String, String> getMap() {
        HashMap<String, String> map = new HashMap<String, String>(super.getMap());
        for (Map.Entry<Integer, Map<String, String>> entryWin : this.m_windows.entrySet()) {
            int windowNo = entryWin.getKey();
            for (Map.Entry<String, String> entry : entryWin.getValue().entrySet()) {
                map.put(windowNo + "|" + entry.getKey(), entry.getValue());
            }
        }
        return map;
    }

    public Set<Map.Entry<String, String>> entrySet() {
        return this.getMap().entrySet();
    }

    public boolean isEmpty() {
        boolean empty = super.isEmpty();
        if (!empty) {
            return false;
        }
        for (Map.Entry<Integer, Map<String, String>> entryWin : this.m_windows.entrySet()) {
            Set<Map.Entry<String, String>> itEntries = entryWin.getValue().entrySet();
            if (itEntries.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Set<String> keySet() {
        return this.getMap().keySet();
    }

    public Collection<String> values() {
        return this.getMap().values();
    }

    public void setContext(int windowNo, String context, String value) {
        if (context == null) {
            return;
        }
        log.finer("(" + windowNo + "): " + context + "=" + value);
        Map<String, String> map = this.m_windows.get(windowNo);
        if (map == null) {
            map = new HashMap<String, String>();
            this.m_windows.put(windowNo, map);
        }
        if (value == null || value.equals("")) {
            map.put(context, null);
        } else {
            map.put(context, value);
        }
    }

    public String getContext(int windowNo, String context, boolean onlyWindow) {
        if (context == null) {
            throw new IllegalArgumentException("Require Context");
        }
        Map<String, String> map = this.m_windows.get(windowNo);
        if (map != null) {
            String value = map.get(context);
            if (value == null) {
                if (context.startsWith("#") || context.startsWith("$")) {
                    return this.getContext(context);
                }
                if (onlyWindow) {
                    return "";
                }
                return this.getContext("#" + context);
            }
            return value;
        }
        if (context.startsWith("#") || context.startsWith("$")) {
            return this.getContext(context);
        }
        if (!onlyWindow) {
            return this.getContext("#" + context);
        }
        return "";
    }

    public void setContext(int windowNo, Map addContext) {
        if (addContext == null) {
            return;
        }
        Map<String, String> map = this.m_windows.get(windowNo);
        if (map == null) {
            map = new HashMap<String, String>();
            this.m_windows.put(windowNo, map);
        }
        for (String key : addContext.keySet()) {
            String value = (String)addContext.get(key);
            if (value != null && value.length() > 0) {
                map.put(key, value);
                continue;
            }
            map.put(key, null);
        }
    }
}

