/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.Serializable;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.compiere.util.CLogMgt;
import org.compiere.util.CompiereLogger;
import org.compiere.util.ValueNamePair;

public class CLogger
extends Logger
implements CompiereLogger,
Serializable {
    private static CLogger s_logger = null;
    private static ThreadLocal<ValueNamePair> s_lastError = new ThreadLocal<ValueNamePair>(){

        @Override
        protected ValueNamePair initialValue() {
            return null;
        }
    };
    private static ThreadLocal<Exception> s_lastException = new ThreadLocal<Exception>(){

        @Override
        protected Exception initialValue() {
            return null;
        }
    };
    private static ThreadLocal<ValueNamePair> s_lastWarning = new ThreadLocal<ValueNamePair>(){

        @Override
        protected ValueNamePair initialValue() {
            return null;
        }
    };
    private static ThreadLocal<ValueNamePair> s_lastInfo = new ThreadLocal<ValueNamePair>(){

        @Override
        protected ValueNamePair initialValue() {
            return null;
        }
    };

    public static synchronized CLogger getCLogger(String className) {
        Logger result;
        LogManager manager = LogManager.getLogManager();
        if (className == null) {
            className = "";
        }
        if ((result = manager.getLogger(className)) != null && result instanceof CLogger) {
            return (CLogger)result;
        }
        CLogger newLogger = new CLogger(className, null);
        newLogger.setLevel(CLogMgt.getLevel());
        manager.addLogger(newLogger);
        return newLogger;
    }

    public static CLogger getCLogger(Class clazz) {
        if (clazz == null) {
            return CLogger.get();
        }
        return CLogger.getCLogger(clazz.getName());
    }

    public static CLogger get() {
        if (s_logger == null) {
            s_logger = CLogger.getCLogger("org.compiere.default");
        }
        return s_logger;
    }

    private CLogger(String name, String resourceBundleName) {
        super(name, resourceBundleName);
    }

    public boolean saveError(String AD_Message, String message) {
        return this.saveError(AD_Message, message, true);
    }

    public boolean saveError(String AD_Message, Exception ex) {
        s_lastException.set(ex);
        return this.saveError(AD_Message, ex.getLocalizedMessage(), true);
    }

    public boolean saveError(String AD_Message, String message, boolean issueError) {
        s_lastError.set(new ValueNamePair(AD_Message, message));
        if (issueError) {
            this.warning(AD_Message + " - " + message);
        }
        return true;
    }

    public static ValueNamePair retrieveError() {
        ValueNamePair vp = s_lastError.get();
        s_lastError.set(null);
        return vp;
    }

    public static Exception retrieveException() {
        Exception ex = s_lastException.get();
        s_lastException.set(null);
        return ex;
    }

    public boolean saveWarning(String AD_Message, String message) {
        s_lastWarning.set(new ValueNamePair(AD_Message, message));
        this.warning(AD_Message + " - " + message);
        return true;
    }

    public static ValueNamePair retrieveWarning() {
        ValueNamePair vp = s_lastWarning.get();
        s_lastWarning.set(null);
        return vp;
    }

    public boolean saveInfo(String AD_Message, String message) {
        s_lastInfo.set(new ValueNamePair(AD_Message, message));
        return true;
    }

    public static ValueNamePair retrieveInfo() {
        ValueNamePair vp = s_lastInfo.get();
        s_lastInfo.set(null);
        return vp;
    }

    public static void resetLast() {
        s_lastError.set(null);
        s_lastException.set(null);
        s_lastWarning.set(null);
        s_lastInfo.set(null);
    }

    public boolean isLevelFinest() {
        return CLogMgt.isLevelFinest();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("CLogger[");
        sb.append(this.getName()).append(",Level=").append(this.getLevel()).append("]");
        return sb.toString();
    }
}

