/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.db.CConnection;
import org.compiere.interfaces.Server;
import org.compiere.util.CCache;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CacheInterface;
import org.compiere.util.DB;

public class CacheMgt {
    private static CacheMgt s_cache = null;
    private ArrayList<CacheInterface> m_instances = new ArrayList();
    private ArrayList<String> m_tableNames = new ArrayList();
    private static CLogger log = CLogger.getCLogger(CacheMgt.class);

    public static CacheMgt get() {
        if (s_cache == null) {
            s_cache = new CacheMgt();
        }
        return s_cache;
    }

    private CacheMgt() {
    }

    public synchronized boolean register(CacheInterface instance) {
        if (instance == null) {
            return false;
        }
        if (instance instanceof CCache) {
            String tableName = ((CCache)instance).getName();
            this.m_tableNames.add(tableName);
        }
        return this.m_instances.add(instance);
    }

    public boolean unregister(CacheInterface instance) {
        if (instance == null) {
            return false;
        }
        boolean found = false;
        for (int i = this.m_instances.size() - 1; i >= 0; --i) {
            CacheInterface stored = this.m_instances.get(i);
            if (!instance.equals(stored)) continue;
            this.m_instances.remove(i);
            found = true;
        }
        return found;
    }

    public int reset() {
        int counter = 0;
        int total = 0;
        for (int i = 0; i < this.m_instances.size(); ++i) {
            CacheInterface stored = this.m_instances.get(i);
            if (stored == null || stored.size() <= 0) continue;
            log.fine(stored.toString());
            total += stored.reset();
            ++counter;
        }
        log.info("#" + counter + " (" + total + ")");
        return total;
    }

    public int reset(String tableName) {
        return this.reset(tableName, 0);
    }

    public int reset(String tableName, int Record_ID) {
        if (tableName == null) {
            return this.reset();
        }
        if (!this.m_tableNames.contains(tableName)) {
            return 0;
        }
        int counter = 0;
        int total = 0;
        for (int i = 0; i < this.m_instances.size(); ++i) {
            CCache cc;
            CacheInterface stored = this.m_instances.get(i);
            if (stored == null || !(stored instanceof CCache) || !(cc = (CCache)stored).getName().startsWith(tableName)) continue;
            log.fine("(all) - " + stored);
            total += stored.reset();
            ++counter;
        }
        log.info(tableName + ": #" + counter + " (" + total + ")");
        if (DB.isRemoteObjects()) {
            Server server = CConnection.get().getServer();
            try {
                if (server != null) {
                    int serverTotal = server.cacheReset(tableName, 0);
                    if (CLogMgt.isLevelFinest()) {
                        log.fine("Server => " + serverTotal);
                    }
                }
            }
            catch (RemoteException ex) {
                log.log(Level.SEVERE, "AppsServer error", ex);
            }
        }
        return total;
    }

    public int getElementCount() {
        int total = 0;
        for (int i = 0; i < this.m_instances.size(); ++i) {
            CacheInterface stored = this.m_instances.get(i);
            if (stored == null || stored.size() <= 0) continue;
            log.fine(stored.toString());
            if (stored instanceof CCache) {
                total += ((CCache)stored).sizeNoExpire();
                continue;
            }
            total += stored.size();
        }
        return total;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("CacheMgt[");
        sb.append("Instances=").append(this.m_instances.size()).append("]");
        return sb.toString();
    }

    public String toStringX() {
        StringBuffer sb = new StringBuffer("CacheMgt[");
        sb.append("Instances=").append(this.m_instances.size()).append(", Elements=").append(this.getElementCount()).append("]");
        return sb.toString();
    }
}

