/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import org.compiere.interfaces.Status;
import org.compiere.interfaces.StatusHome;

public class ConnectTest {
    public ConnectTest(String serverName) {
        System.out.println("ConnectTest: " + serverName);
        System.out.println();
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
        env.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
        env.put("java.naming.provider.url", serverName);
        System.out.println("Creating context ...");
        System.out.println("  " + env);
        InitialContext context = null;
        try {
            context = new InitialContext(env);
        }
        catch (Exception e) {
            System.err.println("ERROR: Could not create context: " + e);
            return;
        }
        this.testJNP(serverName, context);
        this.testEJB(serverName, context);
    }

    private void testJNP(String serverName, InitialContext context) {
        System.out.println();
        System.out.println("Connecting to MBean ...");
        System.out.println();
        System.out.println(" Examining context ....");
        try {
            System.out.println("  Namespace=" + context.getNameInNamespace());
            System.out.println("  Environment=" + context.getEnvironment());
            System.out.println("  Context '/':");
            NamingEnumeration<NameClassPair> ne = context.list("/");
            while (ne.hasMore()) {
                System.out.println("  - " + ne.nextElement());
            }
            System.out.println("  Context 'ejb':");
            ne = context.list("ejb");
            while (ne.hasMore()) {
                System.out.println("  - " + ne.nextElement());
            }
            System.out.println("  Context 'ejb/compiere':");
            ne = context.list("ejb/compiere");
            while (ne.hasMore()) {
                System.out.println("  - " + ne.nextElement());
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: Could not examine context: " + e);
            return;
        }
    }

    private void testEJB(String serverName, InitialContext context) {
        System.out.println();
        System.out.println("Connecting to EJB server ...");
        try {
            System.out.println("  Name=compiere/Status");
            StatusHome staHome = (StatusHome)context.lookup("compiere/Status");
            System.out.println("  .. home created");
            Status sta = staHome.create();
            System.out.println("  .. bean created");
            System.out.println("  ServerVersion=" + sta.getMainVersion() + " " + sta.getDateVersion());
            sta.remove();
            System.out.println("  .. bean removed");
        }
        catch (Exception e) {
            System.err.println("ERROR: Could not connect: " + e);
            return;
        }
        System.out.println();
        System.out.println("SUCCESS !!");
    }

    public static void main(String[] args) {
        String serverName = null;
        if (args.length > 0) {
            serverName = args[0];
        }
        if (serverName == null || serverName.length() == 0) {
            try {
                serverName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException ex) {
                ex.printStackTrace();
            }
        }
        ConnectTest ct = new ConnectTest(serverName);
    }
}

