/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.compiere.Compiere;
import org.compiere.common.constants.EnvConstants;
import org.compiere.db.CConnection;
import org.compiere.model.MClient;
import org.compiere.model.MLookupCache;
import org.compiere.model.MRole;
import org.compiere.model.MSession;
import org.compiere.swing.CFrame;
import org.compiere.util.CContext;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.CacheMgt;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Ini;
import org.compiere.util.Language;

public final class Env
implements EnvConstants {
    private static CLogger s_log = CLogger.getCLogger(Env.class);
    private static String[] UNIX_BROWSERS = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
    public static String GOOGLE_MAPS_URL_PREFIX = "http://local.google.com/maps?q=";
    private static CContext s_ctx = new CContext();
    public static final String LANGUAGE = "#AD_Language";
    private static ArrayList<Container> s_windows = new ArrayList(20);
    private static ArrayList<CFrame> s_hiddenWindows = new ArrayList();
    private static boolean s_closingWindows = false;
    public static final BigDecimal ZERO = new BigDecimal(0.0);
    public static final BigDecimal ONE = new BigDecimal(1.0);
    public static final BigDecimal ONEHUNDRED = new BigDecimal(100.0);
    public static final String NL = System.getProperty("line.separator");

    public static void exitEnv(int status) {
        MSession session = MSession.get(Env.getCtx(), false);
        if (session != null) {
            session.logout();
        }
        Env.reset(true);
        s_log.info("");
        CLogMgt.shutdown();
        if (Ini.isClient()) {
            System.exit(status);
        }
    }

    public static void reset(boolean finalCall) {
        s_log.info("finalCall=" + finalCall);
        Env.closeWindows();
        s_windows.clear();
        if (finalCall) {
            s_ctx.clear();
        } else {
            Object[] keys = s_ctx.keySet().toArray();
            for (int i = 0; i < keys.length; ++i) {
                String tag = keys[i].toString();
                if (!Character.isDigit(tag.charAt(0))) continue;
                s_ctx.remove(keys[i]);
            }
        }
        CacheMgt.get().reset();
        DB.closeTarget();
        if (!finalCall) {
            DB.setDBTarget(CConnection.get());
            MRole defaultRole = MRole.getDefault(s_ctx, false);
            if (defaultRole != null) {
                defaultRole.loadAccess(true);
            }
        }
    }

    public static final Ctx getCtx() {
        return s_ctx;
    }

    public static String getPreference(Ctx ctx, int AD_Window_ID, String context, boolean system) {
        if (ctx == null || context == null) {
            throw new IllegalArgumentException("Require Context");
        }
        String retValue = null;
        if (!system) {
            retValue = ctx.getContext("P" + AD_Window_ID + "|" + context);
            if (retValue.length() == 0) {
                retValue = ctx.getContext("P|" + context);
            }
        } else {
            retValue = ctx.getContext("#" + context);
            if (retValue.length() == 0) {
                retValue = ctx.getContext("$" + context);
            }
        }
        return retValue == null ? "" : retValue;
    }

    public static boolean isBaseLanguage(Ctx ctx, String tableName) {
        return Language.isBaseLanguage(Env.getAD_Language(ctx));
    }

    public static boolean isBaseLanguage(String AD_Language, String tableName) {
        return Language.isBaseLanguage(AD_Language);
    }

    public static boolean isBaseLanguage(Language language, String tableName) {
        return language.isBaseLanguage();
    }

    public static boolean isBaseTranslation(String tableName) {
        return tableName.startsWith("AD") || tableName.equals("C_Country_Trl");
    }

    public static boolean isMultiLingualDocument(Ctx ctx) {
        return MClient.get(ctx).isMultiLingualDocument();
    }

    public static String getAD_Language(Ctx ctx) {
        String lang;
        if (ctx != null && ((lang = ctx.getContext(LANGUAGE)) != null || lang.length() > 0)) {
            return lang;
        }
        return Language.getBaseAD_Language();
    }

    public static Language getLanguage(Ctx ctx) {
        String lang;
        if (ctx != null && ((lang = ctx.getContext(LANGUAGE)) != null || lang.length() > 0)) {
            return Language.getLanguage(lang);
        }
        return Language.getBaseLanguage();
    }

    public static Language getLoginLanguage(Ctx ctx) {
        return Language.getLoginLanguage();
    }

    public static Language verifyLanguage(Ctx ctx, Language language) {
        if (language.isBaseLanguage()) {
            return language;
        }
        boolean isSystemLanguage = false;
        ArrayList<String> AD_Languages = new ArrayList<String>();
        String sql = "SELECT DISTINCT AD_Language FROM AD_Message_Trl";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                String AD_Language = rs.getString(1);
                if (AD_Language.equals(language.getAD_Language())) {
                    isSystemLanguage = true;
                    break;
                }
                AD_Languages.add(AD_Language);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, "", e);
        }
        if (isSystemLanguage) {
            return language;
        }
        if (AD_Languages.size() == 0) {
            s_log.warning("NO System Language - Set to Base " + Language.getBaseAD_Language());
            return Language.getBaseLanguage();
        }
        for (int i = 0; i < AD_Languages.size(); ++i) {
            String langCompare;
            String AD_Language = (String)AD_Languages.get(i);
            String lang = AD_Language.substring(0, 2);
            if (!lang.equals(langCompare = language.getAD_Language().substring(0, 2))) continue;
            s_log.fine("Found similar Language " + AD_Language);
            return Language.getLanguage(AD_Language);
        }
        s_log.warning("Not System Language=" + language + " - Set to Base Language " + Language.getBaseAD_Language());
        return Language.getBaseLanguage();
    }

    public static String getHeader(Ctx ctx, int WindowNo) {
        StringBuffer sb = new StringBuffer();
        if (WindowNo > 0) {
            sb.append(ctx.getContext(WindowNo, "WindowName", false)).append("  ");
        }
        sb.append(ctx.getContext("##AD_User_Name")).append("@").append(ctx.getContext("#AD_Org_Name")).append(".").append(ctx.getContext("#AD_Client_Name")).append(" [").append(CConnection.get().toString()).append("]");
        return sb.toString();
    }

    public static void clearWinContext(Ctx ctx, int WindowNo) {
        if (ctx == null) {
            throw new IllegalArgumentException("Require Context");
        }
        Object[] keys = ctx.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            String tag = keys[i].toString();
            if (!tag.startsWith(WindowNo + "|")) continue;
            ctx.remove(keys[i]);
        }
        MLookupCache.cacheReset(WindowNo);
        Env.removeWindow(WindowNo);
    }

    public static void clearContext(Ctx ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("Require Context");
        }
        ctx.clear();
    }

    public static String parseContext(Ctx ctx, int WindowNo, String value, boolean onlyWindow, boolean ignoreUnparsable) {
        if (value == null || value.length() == 0) {
            return "";
        }
        String inStr = new String(value);
        StringBuffer outStr = new StringBuffer();
        int i = inStr.indexOf(64);
        while (i != -1 && i != inStr.lastIndexOf("@")) {
            outStr.append(inStr.substring(0, i));
            inStr = inStr.substring(i + 1, inStr.length());
            int j = inStr.indexOf(64);
            if (j < 0) {
                s_log.log(Level.SEVERE, "No second tag: " + inStr);
                return "";
            }
            String token = inStr.substring(0, j);
            String ctxInfo = ctx.getContext(WindowNo, token, onlyWindow);
            if (ctxInfo.length() == 0 && (token.startsWith("#") || token.startsWith("$"))) {
                ctxInfo = ctx.getContext(token);
            }
            if (ctxInfo.length() == 0) {
                s_log.config("No Context Win=" + WindowNo + " for: " + token);
                if (!ignoreUnparsable) {
                    return "";
                }
            } else {
                outStr.append(ctxInfo);
            }
            inStr = inStr.substring(j + 1, inStr.length());
            i = inStr.indexOf(64);
        }
        outStr.append(inStr);
        return outStr.toString();
    }

    public static String parseContext(Ctx ctx, int WindowNo, String value, boolean onlyWindow) {
        return Env.parseContext(ctx, WindowNo, value, onlyWindow, false);
    }

    public static int createWindowNo(Container win) {
        int retValue = s_windows.size();
        s_windows.add(win);
        return retValue;
    }

    public static int getWindowNo(Container container) {
        if (container == null) {
            return 0;
        }
        JFrame winFrame = Env.getFrame(container);
        if (winFrame == null) {
            return 0;
        }
        for (int i = 0; i < s_windows.size(); ++i) {
            JFrame cmpFrame;
            Container cmp = s_windows.get(i);
            if (cmp == null || !winFrame.equals(cmpFrame = Env.getFrame(cmp))) continue;
            return i;
        }
        return 0;
    }

    public static JFrame getWindow(int WindowNo) {
        JFrame retValue = null;
        try {
            retValue = Env.getFrame(s_windows.get(WindowNo));
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, e.toString());
        }
        return retValue;
    }

    private static void removeWindow(int WindowNo) {
        if (WindowNo < s_windows.size()) {
            s_windows.set(WindowNo, null);
        }
    }

    public static void clearWinContext(int WindowNo) {
        Env.clearWinContext(s_ctx, WindowNo);
    }

    public static void clearContext() {
        s_ctx.clear();
    }

    public static JFrame getFrame(Container container) {
        for (Container element = container; element != null; element = element.getParent()) {
            if (!(element instanceof JFrame)) continue;
            return (JFrame)element;
        }
        return null;
    }

    public static Graphics getGraphics(Container container) {
        for (Container element = container; element != null; element = element.getParent()) {
            Graphics g = element.getGraphics();
            if (g == null) continue;
            return g;
        }
        return null;
    }

    public static Window getParent(Container container) {
        for (Container element = container; element != null; element = element.getParent()) {
            if (element instanceof JDialog || element instanceof JFrame) {
                return (Window)element;
            }
            if (!(element instanceof Window)) continue;
            return (Window)element;
        }
        return null;
    }

    public static Image getImage(String fileNameInImageDir) {
        URL url = Compiere.class.getResource("images/" + fileNameInImageDir);
        if (url == null) {
            s_log.log(Level.SEVERE, "Not found: " + fileNameInImageDir);
            return null;
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        return tk.getImage(url);
    }

    public static ImageIcon getImageIcon(String fileNameInImageDir) {
        URL png_url;
        String png;
        ImageIcon icon = null;
        if (icon == null && fileNameInImageDir.endsWith("24.gif")) {
            png = fileNameInImageDir.substring(0, fileNameInImageDir.length() - 6) + "32.png";
            png_url = Compiere.class.getResource("images/" + png);
            if (png_url != null) {
                icon = new ImageIcon(png_url);
            }
        }
        if (icon == null && fileNameInImageDir.endsWith("10.gif")) {
            png = fileNameInImageDir.substring(0, fileNameInImageDir.length() - 6) + "12.png";
            png_url = Compiere.class.getResource("images/" + png);
            if (png_url != null) {
                icon = new ImageIcon(png_url);
            }
        }
        if (icon == null && fileNameInImageDir.endsWith(".gif")) {
            png = fileNameInImageDir.substring(0, fileNameInImageDir.length() - 4) + ".png";
            png_url = Compiere.class.getResource("images/" + png);
            if (png_url != null) {
                icon = new ImageIcon(png_url);
            }
        }
        if (icon == null) {
            URL url = Compiere.class.getResource("images/" + fileNameInImageDir);
            if (url != null) {
                icon = new ImageIcon(url);
            } else {
                s_log.log(Level.WARNING, "Not found: " + fileNameInImageDir);
            }
        }
        return icon;
    }

    public static void startBrowser(String url) {
        s_log.info(url);
        try {
            String osName = System.getProperty("os.name").toLowerCase();
            if (osName.startsWith("mac")) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            } else if (osName.startsWith("windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else {
                String browser = null;
                String[] which = new String[]{"which", null};
                for (int count = 0; count < UNIX_BROWSERS.length && browser == null; ++count) {
                    which[1] = UNIX_BROWSERS[count];
                    if (Runtime.getRuntime().exec(which).waitFor() != 0) continue;
                    browser = UNIX_BROWSERS[count];
                }
                if (browser == null) {
                    throw new Exception("Could not find web browser");
                }
                Runtime.getRuntime().exec(new String[]{browser, url});
            }
        }
        catch (Exception e) {
            s_log.severe("Can't locate browser: " + e.getLocalizedMessage());
        }
    }

    public static boolean isMac() {
        String osName = System.getProperty("os.name");
        return (osName = osName.toLowerCase()).indexOf("mac") != -1;
    }

    public static boolean isWindows() {
        String osName = System.getProperty("os.name");
        return (osName = osName.toLowerCase()).indexOf("windows") != -1;
    }

    public static boolean hideWindow(CFrame window) {
        if (!Ini.isCacheWindow() || s_closingWindows) {
            return false;
        }
        for (int i = 0; i < s_hiddenWindows.size(); ++i) {
            CFrame hidden = s_hiddenWindows.get(i);
            s_log.info(i + ": " + hidden);
            if (hidden.getAD_Window_ID() != window.getAD_Window_ID()) continue;
            return false;
        }
        if (window.getAD_Window_ID() != 0 && s_hiddenWindows.add(window)) {
            window.setVisible(false);
            s_log.info(window.toString());
            if (s_hiddenWindows.size() > 10) {
                s_hiddenWindows.remove(0);
            }
            return true;
        }
        return false;
    }

    public static boolean showWindow(int AD_Window_ID) {
        for (int i = 0; i < s_hiddenWindows.size(); ++i) {
            CFrame hidden = s_hiddenWindows.get(i);
            if (hidden.getAD_Window_ID() != AD_Window_ID) continue;
            s_hiddenWindows.remove(i);
            s_log.info(hidden.toString());
            hidden.setVisible(true);
            hidden.toFront();
            return true;
        }
        return false;
    }

    static void closeWindows() {
        s_closingWindows = true;
        for (int i = 0; i < s_hiddenWindows.size(); ++i) {
            CFrame hidden = s_hiddenWindows.get(i);
            hidden.dispose();
        }
        s_hiddenWindows.clear();
        s_closingWindows = false;
    }

    public static void sleep(int sec) {
        s_log.info("Start - Seconds=" + sec);
        try {
            Thread.sleep(sec * 1000);
        }
        catch (Exception e) {
            s_log.log(Level.WARNING, "", e);
        }
        s_log.info("End");
    }

    static {
        s_ctx.put(LANGUAGE, Language.getBaseAD_Language());
    }
}

