/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.File;
import java.io.FileWriter;
import java.util.logging.Level;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.SecureEngine;
import org.compiere.util.Util;

public class SecureUtil {
    private static CLogger log = CLogger.getCLogger(SecureUtil.class);
    private static final String classFileName = "/lib/CompiereSecure.dat";
    private SecretKey m_key = null;
    private StringBuffer m_cc = null;

    public static boolean createNewKey(String compiereHome) {
        SecureUtil util = new SecureUtil();
        if (!util.createKey()) {
            return false;
        }
        if (!util.createClassCode()) {
            return false;
        }
        if (!util.saveClassCode(compiereHome)) {
            return false;
        }
        return SecureUtil.installKey(compiereHome);
    }

    public static boolean installKey(String compiereHome) {
        File keyFile = SecureUtil.getKeyFile(compiereHome);
        if (!keyFile.exists()) {
            log.info("File not found");
            return SecureUtil.createNewKey(compiereHome);
        }
        SecureEngine.reset();
        return true;
    }

    public static File getKeyFile(String compiereHome) {
        return new File(compiereHome + classFileName);
    }

    private SecureUtil() {
    }

    private boolean createKey() {
        try {
            KeyGenerator keygen = KeyGenerator.getInstance("DES");
            this.m_key = keygen.generateKey();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
            this.m_key = null;
            return false;
        }
        byte[] keys = this.m_key.getEncoded();
        StringBuffer sb = new StringBuffer("Key ").append(this.m_key.getAlgorithm()).append("(").append(keys.length).append(")= ");
        for (int i = 0; i < keys.length; ++i) {
            sb.append(keys[i]).append(",");
        }
        log.info(sb.toString());
        return true;
    }

    private boolean createClassCode() {
        this.m_cc = new StringBuffer().append("package org.compiere.util; ").append("import javax.crypto.*; ").append("import javax.crypto.spec.*; ").append("public class SecureKey{").append("static protected SecretKey key = new SecretKeySpec ").append("(new byte[]{");
        byte[] keys = this.m_key.getEncoded();
        for (int i = 0; i < keys.length; ++i) {
            if (i != 0) {
                this.m_cc.append(",");
            }
            this.m_cc.append(keys[i]);
        }
        this.m_cc.append("},\"DES\");}");
        log.finest(this.m_cc.toString());
        log.fine("(#" + this.m_cc.length() + ")");
        return this.m_cc.length() > 0;
    }

    private boolean saveClassCode(String compiereHome) {
        File file = SecureUtil.getKeyFile(compiereHome);
        String phase = "deleteFile";
        try {
            if (file.exists()) {
                file.delete();
            }
            phase = "createNewFile";
            file.createNewFile();
            phase = "createWriter";
            FileWriter fw = new FileWriter(file);
            phase = "writeFile";
            fw.write(this.m_cc.toString());
            phase = "closeFile";
            fw.flush();
            fw.close();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, phase, e);
            return false;
        }
        File backup = Util.createBackup(file);
        if (backup == null) {
            return false;
        }
        log.fine(file.getAbsolutePath() + " (#" + file.length() + ") - " + backup.getAbsolutePath() + " (#" + backup.length() + ")");
        return true;
    }

    public static void main(String[] args) {
        CLogMgt.initialize(true);
        CLogMgt.setLevel(Level.FINEST);
        SecureUtil.installKey("C:\\Compiere2");
    }
}

