/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Attributes;
import au.id.jericho.lib.html.EndTag;
import au.id.jericho.lib.html.FormControl;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StartTag;
import au.id.jericho.lib.html.Tag;

public final class Element
extends Segment {
    private StartTag startTag;
    private EndTag endTag = null;

    Element(Source source, StartTag startTag, EndTag endTag) {
        super(source, startTag.begin, endTag == null ? startTag.end : endTag.end);
        this.startTag = startTag;
        this.endTag = endTag == null || endTag.length() == 0 ? null : endTag;
    }

    public String getContentText() {
        return this.isEmpty() ? null : ((Object)this.source.subSequence(this.startTag.end, this.getContentEnd())).toString();
    }

    public Segment getContent() {
        return new Segment(this.source, this.startTag.end, this.getContentEnd());
    }

    public StartTag getStartTag() {
        return this.startTag;
    }

    public EndTag getEndTag() {
        return this.endTag;
    }

    public String getName() {
        return this.startTag.getName();
    }

    public boolean isEmpty() {
        return this.startTag.end == this.getContentEnd();
    }

    public boolean isEmptyElementTag() {
        return this.startTag.isEmptyElementTag();
    }

    public static boolean isBlock(String string) {
        return Tag.isBlock(string);
    }

    public static boolean isInline(String string) {
        return Tag.isInline(string);
    }

    public Attributes getAttributes() {
        return this.getStartTag().getAttributes();
    }

    public FormControl getFormControl() {
        return FormControl.construct(this);
    }

    public String getDebugInfo() {
        return "Element " + super.getDebugInfo() + ": " + this.startTag.getDebugInfo() + "-" + (this.endTag == null ? "(no end tag)" : this.endTag.getDebugInfo());
    }

    protected int getContentEnd() {
        return this.endTag != null ? this.endTag.begin : this.end;
    }
}

