/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.sql.RowSetInternal;
import javax.sql.RowSetReader;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.rowset.OracleCachedRowSet;

public class OracleCachedRowSetReader
implements RowSetReader,
Serializable {
    static final transient int SETUNICODESTREAM_INTLENGTH = 1;
    static final transient int SETBINARYSTREAM_INTLENGTH = 2;
    static final transient int SETASCIISTREAM_INTLENGTH = 3;
    static final transient int SETCHARACTERSTREAM_INTLENGTH = 4;
    static final transient int TWO_PARAMETERS = 2;
    static final transient int THREE_PARAMETERS = 3;
    private static transient boolean driverManagerInitialized = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Oct_30_03:26:32_PDT_2007";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    Connection getConnection(RowSetInternal rowSetInternal) throws SQLException {
        Connection connection;
        block13: {
            connection = null;
            Connection connection2 = rowSetInternal.getConnection();
            if (connection2 != null && !connection2.isClosed()) {
                connection = connection2;
            } else if (((RowSet)((Object)rowSetInternal)).getDataSourceName() != null) {
                try {
                    Object object;
                    InitialContext initialContext = null;
                    try {
                        object = System.getProperties();
                        initialContext = new InitialContext((Hashtable<?, ?>)object);
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    if (initialContext == null) {
                        initialContext = new InitialContext();
                    }
                    object = (DataSource)initialContext.lookup(((RowSet)((Object)rowSetInternal)).getDataSourceName());
                    String string = ((RowSet)((Object)rowSetInternal)).getUsername();
                    String string2 = ((RowSet)((Object)rowSetInternal)).getPassword();
                    if (string == null && string2 == null) {
                        connection = object.getConnection();
                        break block13;
                    }
                    connection = object.getConnection(string, string2);
                }
                catch (NamingException namingException) {
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 300, namingException.getMessage());
                }
            } else if (((RowSet)((Object)rowSetInternal)).getUrl() != null) {
                if (!driverManagerInitialized) {
                    DriverManager.registerDriver(new OracleDriver());
                    driverManagerInitialized = true;
                }
                String string = ((RowSet)((Object)rowSetInternal)).getUrl();
                String string3 = ((RowSet)((Object)rowSetInternal)).getUsername();
                String string4 = ((RowSet)((Object)rowSetInternal)).getPassword();
                if (string.equals("") || string3.equals("") || string4.equals("")) {
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 301);
                }
                connection = DriverManager.getConnection(string, string3, string4);
            }
        }
        return connection;
    }

    private void setParams(Object[] objectArray, PreparedStatement preparedStatement) throws SQLException {
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            int n2 = 0;
            try {
                n2 = Array.getLength(objectArray[i2]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                preparedStatement.setObject(i2 + 1, objectArray[i2]);
                continue;
            }
            Object[] objectArray2 = (Object[])objectArray[i2];
            if (n2 == 2) {
                if (objectArray2[0] == null) {
                    preparedStatement.setNull(i2 + 1, (Integer)objectArray2[1]);
                    continue;
                }
                if (objectArray2[0] instanceof Date || objectArray2[0] instanceof Time || objectArray2[0] instanceof Timestamp) {
                    if (objectArray2[1] instanceof Calendar) {
                        preparedStatement.setDate(i2 + 1, (Date)objectArray2[0], (Calendar)objectArray2[1]);
                        continue;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 323);
                    continue;
                }
                if (!(objectArray2[1] instanceof Integer)) continue;
                preparedStatement.setObject(i2 + 1, objectArray2[0], (Integer)objectArray2[1]);
                continue;
            }
            if (n2 != 3) continue;
            if (objectArray2[0] == null) {
                preparedStatement.setNull(i2 + 1, (Integer)objectArray2[1], (String)objectArray2[2]);
                continue;
            }
            if (objectArray2[0] instanceof Reader) {
                switch ((Integer)objectArray2[2]) {
                    case 4: {
                        preparedStatement.setCharacterStream(i2 + 1, (Reader)objectArray2[0], (Integer)objectArray2[1]);
                        break;
                    }
                    default: {
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 323);
                        break;
                    }
                }
                continue;
            }
            if (objectArray2[0] instanceof InputStream) {
                switch ((Integer)objectArray2[2]) {
                    case 1: {
                        preparedStatement.setUnicodeStream(i2 + 1, (InputStream)objectArray2[0], (Integer)objectArray2[1]);
                        break;
                    }
                    case 2: {
                        preparedStatement.setBinaryStream(i2 + 1, (InputStream)objectArray2[0], (Integer)objectArray2[1]);
                        break;
                    }
                    case 3: {
                        preparedStatement.setAsciiStream(i2 + 1, (InputStream)objectArray2[0], (Integer)objectArray2[1]);
                        break;
                    }
                    default: {
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 323);
                        break;
                    }
                }
                continue;
            }
            if (objectArray2[1] instanceof Integer && objectArray2[2] instanceof Integer) {
                preparedStatement.setObject(i2 + 1, objectArray2[0], (Integer)objectArray2[1], (int)((Integer)objectArray2[2]));
                continue;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 323);
        }
    }

    public synchronized void readData(RowSetInternal rowSetInternal) throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = (OracleCachedRowSet)rowSetInternal;
        Connection connection = this.getConnection(rowSetInternal);
        if (connection == null || oracleCachedRowSet.getCommand() == null) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 342);
        }
        try {
            connection.setTransactionIsolation(oracleCachedRowSet.getTransactionIsolation());
        }
        catch (Exception exception) {
            // empty catch block
        }
        PreparedStatement preparedStatement = connection.prepareStatement(oracleCachedRowSet.getCommand());
        this.setParams(rowSetInternal.getParams(), preparedStatement);
        try {
            preparedStatement.setMaxRows(oracleCachedRowSet.getMaxRows());
            preparedStatement.setMaxFieldSize(oracleCachedRowSet.getMaxFieldSize());
            preparedStatement.setEscapeProcessing(oracleCachedRowSet.getEscapeProcessing());
            preparedStatement.setQueryTimeout(oracleCachedRowSet.getQueryTimeout());
        }
        catch (Exception exception) {
            // empty catch block
        }
        ResultSet resultSet = preparedStatement.executeQuery();
        oracleCachedRowSet.populate(resultSet);
        resultSet.close();
        preparedStatement.close();
        try {
            connection.commit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (!oracleCachedRowSet.isConnectionStayingOpen()) {
            connection.close();
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

