/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.rowset.WebRowSet;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.rowset.OracleCachedRowSet;
import oracle.jdbc.rowset.OracleWebRowSetXmlReader;
import oracle.jdbc.rowset.OracleWebRowSetXmlReaderImpl;
import oracle.jdbc.rowset.OracleWebRowSetXmlWriter;
import oracle.jdbc.rowset.OracleWebRowSetXmlWriterImpl;

public class OracleWebRowSet
extends OracleCachedRowSet
implements WebRowSet {
    private transient OracleWebRowSetXmlReader xmlReader = new OracleWebRowSetXmlReaderImpl();
    private transient OracleWebRowSetXmlWriter xmlWriter = new OracleWebRowSetXmlWriterImpl();
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Oct_30_03:26:33_PDT_2007";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    public OracleWebRowSet() throws SQLException {
        this.setReadOnly(false);
    }

    public void readXml(Reader reader) throws SQLException {
        if (this.xmlReader != null) {
            this.xmlReader.readXML(this, reader);
        } else {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 355);
        }
    }

    public void writeXml(Writer writer) throws SQLException {
        if (this.xmlWriter != null) {
            this.xmlWriter.writeXML(this, writer);
        } else {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 356);
        }
    }

    public void writeXml(ResultSet resultSet, Writer writer) throws SQLException {
        this.populate(resultSet);
        this.writeXml(writer);
    }

    public void readXml(InputStream inputStream) throws SQLException {
        this.readXml(new InputStreamReader(inputStream));
    }

    public void writeXml(OutputStream outputStream) throws SQLException {
        this.writeXml(new OutputStreamWriter(outputStream));
    }

    public void writeXml(ResultSet resultSet, OutputStream outputStream) throws SQLException {
        this.writeXml(resultSet, new OutputStreamWriter(outputStream));
    }
}

