/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.scout.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.EmailAddress;
import javax.xml.registry.infomodel.ExternalIdentifier;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.PostalAddress;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import javax.xml.registry.infomodel.Slot;
import javax.xml.registry.infomodel.SpecificationLink;
import javax.xml.registry.infomodel.TelephoneNumber;
import javax.xml.registry.infomodel.User;
import org.apache.juddi.datatype.Address;
import org.apache.juddi.datatype.AddressLine;
import org.apache.juddi.datatype.Description;
import org.apache.juddi.datatype.DiscoveryURL;
import org.apache.juddi.datatype.Email;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.Name;
import org.apache.juddi.datatype.PersonName;
import org.apache.juddi.datatype.Phone;
import org.apache.juddi.datatype.assertion.PublisherAssertion;
import org.apache.juddi.datatype.binding.AccessPoint;
import org.apache.juddi.datatype.binding.BindingTemplate;
import org.apache.juddi.datatype.binding.HostingRedirector;
import org.apache.juddi.datatype.binding.TModelInstanceDetails;
import org.apache.juddi.datatype.binding.TModelInstanceInfo;
import org.apache.juddi.datatype.business.BusinessEntity;
import org.apache.juddi.datatype.business.Contact;
import org.apache.juddi.datatype.business.Contacts;
import org.apache.juddi.datatype.service.BusinessService;
import org.apache.juddi.datatype.service.BusinessServices;
import org.apache.juddi.datatype.tmodel.TModel;
import org.apache.ws.scout.registry.infomodel.InternationalStringImpl;

public class ScoutJaxrUddiHelper {
    public static Address getAddress(PostalAddress post) throws JAXRException {
        Address address = new Address();
        Vector<AddressLine> addvect = new Vector<AddressLine>();
        String stnum = post.getStreetNumber();
        String st = post.getStreet();
        String city = post.getCity();
        String country = post.getCountry();
        String code = post.getPostalCode();
        String state = post.getStateOrProvince();
        AddressLine stnumAL = new AddressLine();
        stnumAL.setKeyName("STREET_NUMBER");
        stnumAL.setKeyValue(stnum);
        AddressLine stAL = new AddressLine();
        stAL.setKeyName("STREET");
        stAL.setKeyValue(st);
        AddressLine cityAL = new AddressLine();
        cityAL.setKeyName("CITY");
        cityAL.setKeyValue(city);
        AddressLine countryAL = new AddressLine();
        countryAL.setKeyName("COUNTRY");
        countryAL.setKeyValue(country);
        AddressLine codeAL = new AddressLine();
        codeAL.setKeyName("POSTALCODE");
        codeAL.setKeyValue(code);
        AddressLine stateAL = new AddressLine();
        stateAL.setKeyName("STATE");
        stateAL.setKeyValue(state);
        addvect.add(stnumAL);
        addvect.add(stAL);
        addvect.add(cityAL);
        addvect.add(countryAL);
        addvect.add(codeAL);
        addvect.add(stateAL);
        address.setAddressLineVector(addvect);
        return address;
    }

    public static BindingTemplate getBindingTemplateFromJAXRSB(ServiceBinding serve) throws JAXRException {
        BindingTemplate bt = new BindingTemplate();
        try {
            Service svc;
            ServiceBinding sb;
            String accessuri = serve.getAccessURI();
            if (accessuri != null) {
                AccessPoint ap = new AccessPoint();
                ap.setURL(accessuri);
                bt.setAccessPoint(ap);
            }
            if ((sb = serve.getTargetBinding()) != null) {
                HostingRedirector red = new HostingRedirector();
                Key key = sb.getKey();
                if (key != null) {
                    red.setBindingKey(key.getId());
                }
                bt.setHostingRedirector(red);
            }
            if ((svc = serve.getService()) != null) {
                bt.setServiceKey(svc.getKey().getId());
            }
            bt.addDescription(new Description(serve.getDescription().getValue()));
            Collection slcol = serve.getSpecificationLinks();
            TModelInstanceDetails tid = new TModelInstanceDetails();
            if (slcol != null && slcol.isEmpty()) {
                Iterator iter = slcol.iterator();
                while (iter.hasNext()) {
                    SpecificationLink slink = (SpecificationLink)iter.next();
                    TModelInstanceInfo tinfo = new TModelInstanceInfo();
                    tinfo.setTModelKey(slink.getSpecificationObject().getKey().getId());
                    tid.addTModelInstanceInfo(tinfo);
                }
                bt.setTModelInstanceDetails(tid);
            }
            System.out.println("BindingTemplate=" + bt.toString());
        }
        catch (Exception ud) {
            throw new JAXRException("Apache JAXR Impl:", (Throwable)ud);
        }
        return bt;
    }

    public static PublisherAssertion getPubAssertionFromJAXRAssociation(Association assc) throws JAXRException {
        PublisherAssertion pa = new PublisherAssertion();
        try {
            pa.setFromKey(assc.getSourceObject().getKey().getId());
            pa.setToKey(assc.getTargetObject().getKey().getId());
            Concept c = assc.getAssociationType();
            String v = c.getValue();
            KeyedReference kr = new KeyedReference();
            Key key = c.getKey();
            if (key != null) {
                kr.setTModelKey(c.getKey().getId());
            }
            kr.setKeyName("Concept");
            kr.setKeyValue(v);
            pa.setKeyedReference(kr);
        }
        catch (Exception ud) {
            throw new JAXRException("Apache JAXR Impl:", (Throwable)ud);
        }
        return pa;
    }

    public static PublisherAssertion getPubAssertionFromJAXRAssociationKey(String key) throws JAXRException {
        PublisherAssertion pa = new PublisherAssertion();
        try {
            StringTokenizer token = new StringTokenizer(key, ":");
            if (token.hasMoreTokens()) {
                pa.setFromKey(ScoutJaxrUddiHelper.getToken(token.nextToken()));
                pa.setToKey(ScoutJaxrUddiHelper.getToken(token.nextToken()));
                KeyedReference kr = new KeyedReference();
                kr.setTModelKey(ScoutJaxrUddiHelper.getToken(token.nextToken()));
                kr.setKeyName(ScoutJaxrUddiHelper.getToken(token.nextToken()));
                kr.setKeyValue(ScoutJaxrUddiHelper.getToken(token.nextToken()));
                pa.setKeyedReference(kr);
            }
        }
        catch (Exception ud) {
            throw new JAXRException("Apache JAXR Impl:", (Throwable)ud);
        }
        return pa;
    }

    public static BusinessService getBusinessServiceFromJAXRService(Service serve) throws JAXRException {
        BusinessService bs = new BusinessService();
        try {
            InternationalStringImpl iname = (InternationalStringImpl)serve.getName();
            String name = iname.getValue();
            bs.addName(new Name(name, Locale.getDefault().getLanguage()));
            bs.addDescription(new Description(serve.getDescription().getValue()));
            Organization o = serve.getProvidingOrganization();
            if (o != null) {
                Key k = o.getKey();
                if (k != null) {
                    bs.setBusinessKey(k.getId());
                }
            } else {
                throw new JAXRException("Service has no associated organization");
            }
            if (serve.getKey() != null) {
                bs.setServiceKey(serve.getKey().getId());
            }
            System.out.println("BusinessService=" + bs.toString());
        }
        catch (Exception ud) {
            throw new JAXRException("Apache JAXR Impl:", (Throwable)ud);
        }
        return bs;
    }

    public static TModel getTModelFromJAXRClassificationScheme(ClassificationScheme scheme) throws JAXRException {
        TModel tm = new TModel();
        try {
            Slot s;
            Key k = scheme.getKey();
            if (k != null) {
                tm.setTModelKey(k.getId());
            }
            if ((s = scheme.getSlot("authorizedName")) != null) {
                tm.setAuthorizedName(s.getName());
            }
            if ((s = scheme.getSlot("operator")) != null) {
                tm.setOperator(s.getName());
            }
            InternationalStringImpl iname = (InternationalStringImpl)scheme.getName();
            String name = iname.getValue();
            tm.setName(new Name(name, Locale.getDefault().getLanguage()));
            tm.addDescription(new Description(scheme.getDescription().getValue()));
        }
        catch (Exception ud) {
            throw new JAXRException("Apache JAXR Impl:", (Throwable)ud);
        }
        return tm;
    }

    public static TModel getTModelFromJAXRConcept(Concept scheme) throws JAXRException {
        TModel tm = new TModel();
        if (scheme == null) {
            return null;
        }
        try {
            Slot sl2;
            Slot sl1;
            Key key = scheme.getKey();
            if (key != null) {
                tm.setTModelKey(key.getId());
            }
            if ((sl1 = scheme.getSlot("authorizedName")) != null) {
                tm.setAuthorizedName(sl1.getName());
            }
            if ((sl2 = scheme.getSlot("operator")) != null) {
                tm.setOperator(sl2.getName());
            }
            InternationalStringImpl iname = (InternationalStringImpl)scheme.getName();
            String name = iname.getValue();
            tm.setName(new Name(name, Locale.getDefault().getLanguage()));
            tm.addDescription(new Description(scheme.getDescription().getValue()));
        }
        catch (Exception ud) {
            throw new JAXRException("Apache JAXR Impl:", (Throwable)ud);
        }
        return tm;
    }

    public static BusinessEntity getBusinessEntityFromJAXROrg(Organization org) throws JAXRException {
        BusinessEntity biz = new BusinessEntity();
        BusinessServices bss = new BusinessServices();
        Vector<BusinessService> bvect = new Vector<BusinessService>();
        try {
            Key key = org.getKey();
            if (key != null) {
                biz.setBusinessKey(key.getId());
            }
            String language = Locale.getDefault().getLanguage();
            biz.addName(new Name(org.getName().getValue(), language));
            biz.addDescription(new Description(org.getDescription().getValue()));
            if (org.getPrimaryContact() != null) {
                biz.setAuthorizedName(org.getPrimaryContact().getPersonName().getFullName());
            }
            Collection s = org.getServices();
            System.out.println("?Org has services=" + s.isEmpty());
            Iterator iter = s.iterator();
            while (iter.hasNext()) {
                BusinessService bs = ScoutJaxrUddiHelper.getBusinessServiceFromJAXRService((Service)iter.next());
                bvect.add(bs);
            }
            Contacts cts = new Contacts();
            Vector<Contact> cvect = new Vector<Contact>();
            User primaryContact = org.getPrimaryContact();
            Collection users = org.getUsers();
            System.out.println("?Org has users=" + users.isEmpty());
            if (primaryContact != null) {
                Contact ct = ScoutJaxrUddiHelper.getContactFromJAXRUser(primaryContact);
                cvect.add(ct);
            }
            Iterator it = users.iterator();
            while (it.hasNext()) {
                User u = (User)it.next();
                if (u == primaryContact) continue;
                Contact ct = ScoutJaxrUddiHelper.getContactFromJAXRUser(u);
                cvect.add(ct);
            }
            bss.setBusinessServiceVector(bvect);
            cts.setContactVector(cvect);
            biz.setContacts(cts);
            biz.setBusinessServices(bss);
            Iterator exiter = org.getExternalLinks().iterator();
            while (exiter.hasNext()) {
                ExternalLink link = (ExternalLink)exiter.next();
                biz.addDiscoveryURL(new DiscoveryURL("businessEntityExt", link.getExternalURI()));
            }
            Collection exid = org.getExternalIdentifiers();
            Iterator exiditer = exid.iterator();
            while (exiditer.hasNext()) {
                ExternalIdentifier ei = (ExternalIdentifier)exiditer.next();
                KeyedReference keyr = new KeyedReference();
                Key ekey = ei.getKey();
                if (ekey != null) {
                    keyr.setTModelKey(ekey.getId());
                }
                keyr.setKeyValue(ei.getValue());
                keyr.setKeyName(ei.getName().getValue());
                biz.addIdentifier(keyr);
            }
        }
        catch (Exception ud) {
            throw new JAXRException("Apache JAXR Impl:", (Throwable)ud);
        }
        return biz;
    }

    public static Contact getContactFromJAXRUser(User user) throws JAXRException {
        Contact ct = new Contact();
        if (user == null) {
            return ct;
        }
        Vector<Address> addvect = new Vector<Address>();
        Vector<Phone> phonevect = new Vector<Phone>();
        Vector<Email> emailvect = new Vector<Email>();
        try {
            ct.setPersonName(new PersonName(user.getPersonName().getFullName()));
            ct.setUseType(user.getType());
            Collection postc = user.getPostalAddresses();
            Iterator iterator = postc.iterator();
            while (iterator.hasNext()) {
                PostalAddress post = (PostalAddress)iterator.next();
                addvect.add(ScoutJaxrUddiHelper.getAddress(post));
            }
            Collection ph = user.getTelephoneNumbers(null);
            Iterator it = ph.iterator();
            while (it.hasNext()) {
                TelephoneNumber t = (TelephoneNumber)it.next();
                Phone phone = new Phone();
                String str = t.getNumber();
                System.out.println("Telephone=" + str);
                phone.setValue(str);
                phonevect.add(phone);
            }
            Collection ec = user.getEmailAddresses();
            Iterator iter = ec.iterator();
            while (iter.hasNext()) {
                EmailAddress ea = (EmailAddress)iter.next();
                Email email = new Email();
                email.setValue(ea.getAddress());
                email.setUseType(ea.getType());
                emailvect.add(email);
            }
            ct.setAddressVector(addvect);
            ct.setPhoneVector(phonevect);
            ct.setEmailVector(emailvect);
        }
        catch (Exception ud) {
            throw new JAXRException("Apache JAXR Impl:", (Throwable)ud);
        }
        return ct;
    }

    private static String getToken(String tokenstr) {
        if (tokenstr.equals("NULL")) {
            tokenstr = "";
        }
        return tokenstr;
    }
}

