/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.openqa.selenium.server.CommandQueue;
import org.openqa.selenium.server.DefaultRemoteCommand;
import org.openqa.selenium.server.FrameAddress;
import org.openqa.selenium.server.RemoteCommand;
import org.openqa.selenium.server.RemoteCommandException;
import org.openqa.selenium.server.SeleniumServer;
import org.openqa.selenium.server.WindowClosedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameGroupCommandQueueSet {
    static Log log = LogFactory.getLog(FrameGroupCommandQueueSet.class);
    private String currentLocalFrameAddress;
    private String currentSeleniumWindowName;
    private FrameAddress currentFrameAddress = null;
    private String currentUniqueId = null;
    private Map<String, CommandQueue> uniqueIdToCommandQueue = new ConcurrentHashMap<String, CommandQueue>();
    private static final Map<String, FrameGroupCommandQueueSet> queueSets = new ConcurrentHashMap<String, FrameGroupCommandQueueSet>();
    private Map<String, Boolean> frameAddressToJustLoaded = new ConcurrentHashMap<String, Boolean>();
    private static Lock dataLock = new ReentrantLock();
    private static Condition resultArrivedOnAnyQueue = dataLock.newCondition();
    private int pageLoadTimeoutInMilliseconds = 30000;
    private final String sessionId;
    private Set<CommandQueue> orphanedQueues = new HashSet<CommandQueue>();
    public static final String DEFAULT_LOCAL_FRAME_ADDRESS = "top";
    public static final String DEFAULT_SELENIUM_WINDOW_NAME = "";
    private boolean dead = false;

    public FrameGroupCommandQueueSet(String sessionId) {
        this.sessionId = sessionId;
    }

    private String selectWindow(String seleniumWindowName) {
        String match;
        if (!SeleniumServer.isProxyInjectionMode()) {
            return this.doCommand("selectWindow", seleniumWindowName, DEFAULT_SELENIUM_WINDOW_NAME);
        }
        if ("null".equals(seleniumWindowName)) {
            this.currentSeleniumWindowName = DEFAULT_SELENIUM_WINDOW_NAME;
        }
        if ((match = this.findMatchingFrameAddress(this.uniqueIdToCommandQueue.keySet(), seleniumWindowName, DEFAULT_LOCAL_FRAME_ADDRESS)) == null) {
            boolean windowFound = false;
            for (String uniqueId : this.uniqueIdToCommandQueue.keySet()) {
                String windowName;
                CommandQueue commandQueue = this.uniqueIdToCommandQueue.get(uniqueId);
                try {
                    windowName = this.getRemoteWindowTitle(commandQueue);
                }
                catch (WindowClosedException e) {
                    continue;
                }
                if (!windowName.equals(seleniumWindowName)) continue;
                windowFound = true;
                match = uniqueId;
                break;
            }
            if (!windowFound) {
                return "ERROR: could not find window " + seleniumWindowName;
            }
        }
        this.setCurrentFrameAddress(match);
        return "OK";
    }

    public CommandQueue getCommandQueue() {
        return this.getCommandQueue(this.currentUniqueId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FrameGroupCommandQueueSet getQueueSet(String sessionId) {
        dataLock.lock();
        try {
            FrameGroupCommandQueueSet queueSet = queueSets.get(sessionId);
            if (queueSet == null) {
                throw new RuntimeException("sessionId " + sessionId + " doesn't exist");
            }
            FrameGroupCommandQueueSet frameGroupCommandQueueSet = queueSet;
            return frameGroupCommandQueueSet;
        }
        finally {
            dataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FrameGroupCommandQueueSet makeQueueSet(String sessionId) {
        dataLock.lock();
        try {
            FrameGroupCommandQueueSet queueSet = queueSets.get(sessionId);
            if (queueSet != null) {
                throw new RuntimeException("sessionId " + sessionId + " already exists");
            }
            queueSet = new FrameGroupCommandQueueSet(sessionId);
            queueSets.put(sessionId, queueSet);
            FrameGroupCommandQueueSet frameGroupCommandQueueSet = queueSet;
            return frameGroupCommandQueueSet;
        }
        finally {
            dataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearQueueSet(String sessionId) {
        dataLock.lock();
        try {
            FrameGroupCommandQueueSet queue = queueSets.get(sessionId);
            queue.endOfLife();
            queueSets.remove(sessionId);
        }
        finally {
            dataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandQueue getCommandQueue(String uniqueId) {
        dataLock.lock();
        try {
            CommandQueue q = this.uniqueIdToCommandQueue.get(uniqueId);
            if (q == null) {
                if (log.isDebugEnabled()) {
                    log.debug("---------allocating new CommandQueue for " + uniqueId);
                }
                q = new CommandQueue(this.sessionId, uniqueId, dataLock);
                this.uniqueIdToCommandQueue.put(uniqueId, q);
            } else if (log.isDebugEnabled()) {
                log.debug("---------retrieving CommandQueue for " + uniqueId);
            }
            CommandQueue commandQueue = this.uniqueIdToCommandQueue.get(uniqueId);
            return commandQueue;
        }
        finally {
            dataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doCommand(String command, String arg, String value) {
        dataLock.lock();
        try {
            if (SeleniumServer.isProxyInjectionMode()) {
                String t;
                if (command.equals("selectFrame")) {
                    if (DEFAULT_SELENIUM_WINDOW_NAME.equals(arg)) {
                        arg = DEFAULT_LOCAL_FRAME_ADDRESS;
                    }
                    boolean newFrameFound = false;
                    Set<String> idSet = this.uniqueIdToCommandQueue.keySet();
                    Object[] ids = idSet.toArray(new String[0]);
                    Arrays.sort(ids);
                    for (Object uniqueId : ids) {
                        FrameAddress frameAddress;
                        CommandQueue frameQ = this.uniqueIdToCommandQueue.get(uniqueId);
                        if (frameQ.isClosed() || !(frameAddress = frameQ.getFrameAddress()).getWindowName().equals(this.currentSeleniumWindowName) || !this.queueMatchesFrameAddress(frameQ, this.currentLocalFrameAddress, arg)) continue;
                        this.setCurrentFrameAddress((String)uniqueId);
                        newFrameFound = true;
                        break;
                    }
                    if (!newFrameFound) {
                        String string = "ERROR: starting from frame " + this.currentFrameAddress + ", could not find frame " + arg;
                        return string;
                    }
                    String string = "OK";
                    return string;
                }
                if (command.equals("selectWindow")) {
                    String newFrameFound = this.selectWindow(arg);
                    return newFrameFound;
                }
                if (command.equals("waitForPopUp")) {
                    String string;
                    String waitingForThisWindowName = arg;
                    long timeoutInMilliseconds = Long.parseLong(value);
                    try {
                        string = this.waitForLoad(waitingForThisWindowName, DEFAULT_LOCAL_FRAME_ADDRESS, (int)(timeoutInMilliseconds / 1000L));
                    }
                    catch (RemoteCommandException ex) {
                        String i$ = ex.getResult();
                        dataLock.unlock();
                        return i$;
                    }
                    this.setCurrentFrameAddress(string);
                    String ex = "OK";
                    return ex;
                }
                if (command.equals("waitForPageToLoad")) {
                    String waitingForThisWindowName = this.waitForLoad(arg);
                    return waitingForThisWindowName;
                }
                if (command.equals("waitForFrameToLoad")) {
                    String result;
                    String waitingForThisFrameName = arg;
                    long timeoutInMilliseconds = Long.parseLong(value);
                    String string = this.getCommandQueue().getFrameAddress().getWindowName();
                    try {
                        result = this.waitForLoad(string, waitingForThisFrameName, (int)(timeoutInMilliseconds / 1000L));
                    }
                    catch (RemoteCommandException e) {
                        String string2 = e.getMessage();
                        dataLock.unlock();
                        return string2;
                    }
                    this.setCurrentFrameAddress(result);
                    String string3 = "OK";
                    return string3;
                }
                if (command.equals("setTimeout")) {
                    try {
                        this.pageLoadTimeoutInMilliseconds = Integer.parseInt(arg);
                    }
                    catch (NumberFormatException e) {
                        String timeoutInMilliseconds = "ERROR: setTimeout arg is not a number: " + arg;
                        dataLock.unlock();
                        return timeoutInMilliseconds;
                    }
                    String e = "OK";
                    return e;
                }
                if (command.equals("getAllWindowNames")) {
                    String e = this.getAllWindowNames();
                    return e;
                }
                CommandQueue queue = this.getCommandQueue();
                if (queue.isClosed()) {
                    try {
                        String uniqueId = this.waitForLoad(this.currentSeleniumWindowName, this.currentLocalFrameAddress, 1);
                        this.setCurrentFrameAddress(uniqueId);
                    }
                    catch (RemoteCommandException e) {
                        String string = "Current window or frame is closed!";
                        dataLock.unlock();
                        return string;
                    }
                }
                if (command.equals("open")) {
                    this.markWhetherJustLoaded(this.currentUniqueId, false);
                    t = this.getCommandQueue().doCommand(command, arg, value);
                    if (!"OK".equals(t)) {
                        String string = t;
                        return string;
                    }
                    String string = this.waitForLoad(this.pageLoadTimeoutInMilliseconds);
                    return string;
                }
                if (command.endsWith("AndWait")) {
                    this.markWhetherJustLoaded(this.currentUniqueId, false);
                    command = command.substring(0, command.length() - "AndWait".length());
                    t = this.getCommandQueue().doCommand(command, arg, value);
                    if (!t.startsWith("OK")) {
                        String string = t;
                        return string;
                    }
                    String string = this.waitForLoad(this.pageLoadTimeoutInMilliseconds);
                    return string;
                }
            }
            this.markWhetherJustLoaded(this.currentUniqueId, false);
            String string = this.getCommandQueue().doCommand(command, arg, value);
            return string;
        }
        finally {
            dataLock.unlock();
        }
    }

    private void handleInvalidQueue() {
    }

    public String getStringArrayAccessorCSV(String[] stringArray) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            String str = stringArray[i];
            str = str.replaceAll("\\\\", "\\\\\\\\");
            str = str.replaceAll(",", "\\\\,");
            sb.append(str);
            if (i + 1 >= stringArray.length) continue;
            sb.append('\\');
            sb.append(',');
            sb.append(" ");
        }
        return sb.toString();
    }

    private String getAllWindowNames() {
        if (!SeleniumServer.isProxyInjectionMode()) {
            return this.doCommand("getAllWindowNames", DEFAULT_SELENIUM_WINDOW_NAME, DEFAULT_SELENIUM_WINDOW_NAME);
        }
        Set<String> frameAddressSet = this.uniqueIdToCommandQueue.keySet();
        ArrayList<String> windowNames = new ArrayList<String>();
        for (String uniqueId : frameAddressSet) {
            FrameAddress frameAddress = this.uniqueIdToCommandQueue.get(uniqueId).getFrameAddress();
            String windowName = frameAddress.getWindowName();
            if (windowNames.contains(windowName)) continue;
            windowNames.add(windowName);
        }
        String frameAddressCSV = this.getStringArrayAccessorCSV(windowNames.toArray(new String[0]));
        return "OK," + frameAddressCSV;
    }

    private String getRemoteWindowTitle(CommandQueue queue) throws WindowClosedException {
        String cmdResult = queue.doCommand("getTitle", DEFAULT_SELENIUM_WINDOW_NAME, DEFAULT_SELENIUM_WINDOW_NAME);
        if (cmdResult == null) {
            cmdResult = DEFAULT_SELENIUM_WINDOW_NAME;
        }
        if (cmdResult.startsWith("OK,")) {
            cmdResult = cmdResult.substring(3);
            return cmdResult;
        }
        if ("Current window or frame is closed!".equals(cmdResult)) {
            throw new WindowClosedException();
        }
        throw new RuntimeException("unexpected browser error from getTitle: " + cmdResult);
    }

    public String waitForLoad(long timeoutInMilliseconds) {
        int timeoutInSeconds = (int)(timeoutInMilliseconds / 1000L);
        if (timeoutInSeconds == 0) {
            timeoutInSeconds = 1;
        }
        try {
            String uniqueId = this.waitForLoad(this.currentSeleniumWindowName, this.currentLocalFrameAddress, timeoutInSeconds);
            this.setCurrentFrameAddress(uniqueId);
            if (uniqueId == null) {
                throw new RuntimeException("uniqueId is null in waitForLoad...this should not happen.");
            }
            return "OK";
        }
        catch (RemoteCommandException se) {
            return se.getMessage();
        }
    }

    private String waitForLoad(String timeoutInMilliseconds) {
        return this.waitForLoad(Long.parseLong(timeoutInMilliseconds));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String waitForLoad(String waitingForThisWindowName, String waitingForThisLocalFrame, int timeoutInSeconds) throws RemoteCommandException {
        String matchingFrameAddress = null;
        while (timeoutInSeconds >= 0) {
            dataLock.lock();
            try {
                if (this.dead) break;
                log.debug("waiting for window \"" + waitingForThisWindowName + "\"" + " local frame \"" + waitingForThisLocalFrame + "\" for " + timeoutInSeconds + " more secs");
                matchingFrameAddress = this.findMatchingFrameAddress(this.frameAddressToJustLoaded.keySet(), waitingForThisWindowName, waitingForThisLocalFrame);
                if (matchingFrameAddress != null) {
                    log.debug("wait is over: window \"" + waitingForThisWindowName + "\" was seen at last (" + matchingFrameAddress + ")");
                    this.markWhetherJustLoaded(matchingFrameAddress, false);
                    String string = matchingFrameAddress;
                    return string;
                }
                try {
                    resultArrivedOnAnyQueue.await(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            finally {
                dataLock.unlock();
            }
            --timeoutInSeconds;
        }
        String result = "timed out waiting for window \"" + waitingForThisWindowName + "\" to appear";
        throw new RemoteCommandException(result, result);
    }

    private String findMatchingFrameAddress(Set<String> uniqueIds, String windowName, String localFrame) {
        for (String uniqueId : uniqueIds) {
            if (!this.matchesFrameAddress(uniqueId, windowName, localFrame)) continue;
            return uniqueId;
        }
        return null;
    }

    private boolean matchesFrameAddress(String uniqueId, String windowName, String localFrame) {
        String actualWindowName;
        CommandQueue queue;
        if (windowName == null || windowName.equals("null")) {
            windowName = DEFAULT_SELENIUM_WINDOW_NAME;
        }
        if (localFrame == null) {
            localFrame = DEFAULT_LOCAL_FRAME_ADDRESS;
        }
        if ((queue = this.uniqueIdToCommandQueue.get(uniqueId)).isClosed()) {
            return false;
        }
        boolean windowJustLoaded = this.justLoaded(uniqueId);
        FrameAddress frameAddress = queue.getFrameAddress();
        if (!frameAddress.getLocalFrameAddress().equals(localFrame)) {
            return false;
        }
        if (windowJustLoaded) {
            String title;
            try {
                title = this.getRemoteWindowTitle(queue);
            }
            catch (WindowClosedException e) {
                return false;
            }
            this.markWhetherJustLoaded(uniqueId, true);
            if (title.equals(windowName)) {
                return true;
            }
        }
        if (windowName.equals(actualWindowName = frameAddress.getWindowName())) {
            return true;
        }
        if (windowName.equals("_blank") && actualWindowName.startsWith("selenium_blank")) {
            return true;
        }
        return this.uniqueIdToCommandQueue.get(uniqueId).isWindowPointedToByJsVariable(windowName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteCommand handleCommandResult(String commandResult, FrameAddress incomingFrameAddress, String uniqueId, boolean justLoaded, List jsWindowNameVars) {
        dataLock.lock();
        try {
            RemoteCommand remoteCommand;
            CommandQueue queue = this.getCommandQueue(uniqueId);
            queue.setFrameAddress(incomingFrameAddress);
            if (jsWindowNameVars != null) {
                for (Object jsWindowNameVar : jsWindowNameVars) {
                    queue.addJsWindowNameVar((String)jsWindowNameVar);
                }
            }
            if (justLoaded) {
                this.markWhetherJustLoaded(uniqueId, true);
                commandResult = null;
            }
            if ("Current window or frame is closed!".equals(commandResult)) {
                queue.declareClosed();
                remoteCommand = new DefaultRemoteCommand("testComplete", DEFAULT_SELENIUM_WINDOW_NAME, DEFAULT_SELENIUM_WINDOW_NAME);
                return remoteCommand;
            }
            remoteCommand = queue.handleCommandResult(commandResult);
            return remoteCommand;
        }
        finally {
            dataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endOfLife() {
        dataLock.lock();
        this.dead = true;
        try {
            for (CommandQueue frameQ : this.uniqueIdToCommandQueue.values()) {
                frameQ.endOfLife();
            }
        }
        finally {
            dataLock.unlock();
        }
    }

    private boolean justLoaded(String uniqueId) {
        return this.frameAddressToJustLoaded.containsKey(uniqueId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markWhetherJustLoaded(String frameAddress, boolean justLoaded) {
        boolean oldState = this.justLoaded(frameAddress);
        if (oldState != justLoaded) {
            dataLock.lock();
            try {
                if (justLoaded) {
                    if (log.isDebugEnabled()) {
                        log.debug(frameAddress + " marked as just loaded");
                    }
                    this.frameAddressToJustLoaded.put(frameAddress, true);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug(frameAddress + " marked as NOT just loaded");
                    }
                    this.frameAddressToJustLoaded.remove(frameAddress);
                }
                resultArrivedOnAnyQueue.signalAll();
            }
            finally {
                dataLock.unlock();
            }
        }
    }

    private void setCurrentFrameAddress(String uniqueId) {
        assert (uniqueId != null);
        FrameAddress frameAddress = this.uniqueIdToCommandQueue.get(uniqueId).getFrameAddress();
        this.currentUniqueId = uniqueId;
        this.currentFrameAddress = frameAddress;
        this.currentSeleniumWindowName = frameAddress.getWindowName();
        this.currentLocalFrameAddress = frameAddress.getLocalFrameAddress();
        this.markWhetherJustLoaded(uniqueId, false);
        if (log.isDebugEnabled()) {
            log.debug("Current uniqueId set to " + uniqueId + ", frameAddress = " + frameAddress);
        }
    }

    public static FrameAddress makeFrameAddress(String seleniumWindowName, String localFrameAddress) {
        if (seleniumWindowName == null) {
            seleniumWindowName = DEFAULT_SELENIUM_WINDOW_NAME;
        }
        return FrameAddress.make(seleniumWindowName, localFrameAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        dataLock.lock();
        try {
            if (SeleniumServer.isProxyInjectionMode()) {
                LinkedList<FrameAddress> newOrphans = new LinkedList<FrameAddress>();
                for (String uniqueId : this.uniqueIdToCommandQueue.keySet()) {
                    CommandQueue q = this.getCommandQueue(uniqueId);
                    FrameAddress frameAddress = q.getFrameAddress();
                    if (frameAddress.getLocalFrameAddress().equals(DEFAULT_LOCAL_FRAME_ADDRESS) && frameAddress.getWindowName().equals(DEFAULT_SELENIUM_WINDOW_NAME)) continue;
                    if (frameAddress.getLocalFrameAddress().equals(DEFAULT_LOCAL_FRAME_ADDRESS)) {
                        if (log.isDebugEnabled()) {
                            log.debug("Trying to close " + frameAddress);
                        }
                        try {
                            q.doCommandWithoutWaitingForAResponse("close", DEFAULT_SELENIUM_WINDOW_NAME, DEFAULT_SELENIUM_WINDOW_NAME);
                        }
                        catch (WindowClosedException e) {
                            log.debug("Window was already closed");
                        }
                    }
                    this.orphanedQueues.add(q);
                    newOrphans.add(frameAddress);
                }
                for (FrameAddress frameAddress : newOrphans) {
                    this.uniqueIdToCommandQueue.remove(frameAddress);
                }
            }
            this.selectWindow(DEFAULT_SELENIUM_WINDOW_NAME);
            String defaultUrl = "http://localhost:" + SeleniumServer.getPortDriversShouldContact() + "/selenium-server/core/InjectedRemoteRunner.html";
            this.doCommand("open", defaultUrl, DEFAULT_SELENIUM_WINDOW_NAME);
        }
        finally {
            dataLock.unlock();
        }
    }

    private boolean queueMatchesFrameAddress(CommandQueue queue, String currentLocalFrameAddress, String newFrameAddressExpression) {
        boolean result;
        try {
            result = this.doBooleanCommand(queue, "getWhetherThisFrameMatchFrameExpression", currentLocalFrameAddress, newFrameAddressExpression);
        }
        catch (WindowClosedException e) {
            return false;
        }
        return result;
    }

    private boolean doBooleanCommand(CommandQueue queue, String command, String arg1, String arg2) throws WindowClosedException {
        boolean result;
        String booleanResult = queue.doCommand(command, arg1, arg2);
        if ("OK,true".equals(booleanResult)) {
            result = true;
        } else if ("OK,false".equals(booleanResult)) {
            result = false;
        } else {
            if ("Current window or frame is closed!".equals(booleanResult)) {
                throw new WindowClosedException();
            }
            throw new RuntimeException("unexpected return " + booleanResult + " from boolean command " + command);
        }
        CommandQueue.log.debug("doBooleancommand(" + command + "(" + arg1 + ", " + arg2 + ") -> " + result);
        return result;
    }
}

